/* $Id: Scrollbar2.h,v 1.3 1999/04/30 22:47:59 falk Rel $
 *
 * This widget adds a bit of functionality to the Athena scrollbar2.
 *
 * Copyright 1999 by Edward A. Falk.  This widget may be used freely in any
 * software.  Source code is freely distributable provided that my name
 * is not removed from it.
 *
 * The X Consortium, and any party obtaining a copy of these files
 * from the X Consortium, directly or indirectly, is granted, free of
 * charge, a full and unrestricted irrevocable, world-wide, paid up,
 * royalty-free, nonexclusive right and license to deal in this
 * software and documentation files (the "Software"), including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and sell copies of the Software, and to
 * permit persons who receive copies from any such party to do so.
 */

#ifndef _Scrollbar2_h
#define _Scrollbar2_h

/****************************************************************
 *
 * Scrollbar2 Widget
 *
 ****************************************************************/

#include <X11/Xmu/Converters.h>

/* Scrollbar2 resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 arrowJump	     ArrowJump		float		10 pixels
 scroll2Proc	     Scroll2Proc	XtCallbackList	NULL



  This widget handles callbacks differently from the Athena Scrollbar.

  The XtNscrollProc and XtNthumbProc are never called.

  XtNjumpProc is called whenever there is a change to the scrollbar, no
  matter what the reason.  Call_data is a pointer to float, same as for
  Athena Scrollbar.

  XtNscroll2Proc is called with a pointer to to a Scrollbar2Rep structure.
  This callback is called whenever scrolling begins or ends, but not
  during continuous scroll.

*/


#define XtNarrowJump "arrowJump"
#define XtCArrowJump "ArrowJump"


typedef struct _Scrollbar2Rec	  *Scrollbar2Widget;
typedef struct _Scrollbar2ClassRec *Scrollbar2WidgetClass;

extern WidgetClass scrollbar2WidgetClass;


/* A pointer to this structure is passed to the XtNcallback procedure
 * under the conditions listed below.  This structure will be freed once
 * all callbacks are called, so callback procecedures must copy the
 * data if they want to keep it.
 */

typedef	struct {
	  enum scrollWhat {SC_JUMP, SC_START, SC_DONE} what;
	  float		top ;		/* thumb position, [0. 1.] */
	  float		shown ;		/* size of thumb */
	} Scrollbar2Rep ;

/* The 'what' field has the following meanings:
 *
 *  SC_JUMP	scrollbar has moved as a result of a keypress or mouse wheel
 *
 *  SC_START	scrollbar has begun scrolling as a result of a mouse press.
 *		Application need not respond, until SC_DONE is received.
 *
 *		Application may choose to respond to XtNjumpProc if it wishes
 *		to update display while scroll is in progress.
 *
 *  SC_DONE	User has released the mouse button.  Application should now
 *		update the display.
 */

_XFUNCPROTOBEGIN

extern	void	Scrollbar2Callback(
#if NeedFunctionPrototypes
    Widget scrollbar, XtPointer client, XtPointer call_data
#endif
) ;

extern	void	Scrollbar2SetArrow(
#if NeedFunctionPrototypes
    Widget scrollbar, double arrowJump
#endif
) ;

_XFUNCPROTOEND

#endif /* _Scrollbar2_h */
