/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_MISC_H
#define A_MISC_H	1

#include "a.h"

#ifndef ABS
# define ABS(x)		(((x) < 0)?-(x):(x))
#endif

#define PTR_XY(Ptr,Width,PosX,PosY)	((Ptr)[(PosY) * (Width) + (PosX)])

typedef struct		s_assoc
{
  VOID_PTR		left;
  VOID_PTR		right;
} t_assoc;

#define STATUS(expr)	{int status; if ((status = (expr)) < 0) return status;}

typedef struct		s_buf
{
  char			*buf;
  int			len;
} t_buf;

typedef t_status	(*t_msg_proc) P((int msg,
					 VOID_PTR arg1,
					 VOID_PTR arg2));

/* WARNING, MACROS ARE NOT PROTECTED */
#define ARG1(Type,Inst) Type Inst = (Type)arg1
#define ARG2(Type,Inst) Type Inst = (Type)arg2

#define MSG_CLASS	1
#define MSG_CLASS_ARGS(Unused,ClassNameBridledStr)	\
	ARG1(VOID_PTR,Unused);\
	ARG2(t_bridled_str *,ClassNameBridledStr)

#define RAND(Num)	(rand() % (Num))

#ifdef DEBUG
extern t_boolean	more_verbose;
#endif

/* PROTO a_misc.c */
/* a_misc.c */
int ipow P((int x, int n));
int ilog P((int x, int y));
t_status int_to_str P((int num, char *str, int max_len));
t_status uint_to_str P((unsigned int num, char *str, int max_len));
t_boolean atobooleanfalse P((char *str));
t_boolean atobooleantrue P((char *str));
void *pool_alloc P((t_vec *pool, t_alloc_proc alloc_proc, size_t size, char *comment, t_free_proc free_proc, t_status *status));
char *strdup_alloc P((char *str, t_alloc_proc alloc_proc, char *comment1, char *comment2, t_status *status));
t_assoc *assoc_str_ptr_from_left P((t_assoc *assoc, char *left));
t_assoc *assoc_str_int_from_right P((t_assoc *assoc, int right));
t_boolean uint_match P((char *str));
char *str_skip P((char *str, char *chars));
char *str_find P((char *str, char *chars));
char *bindex P((char *buf, int len, int c));
int indexcount P((char *str, int c));
int xdigit_value P((int xdigit));
t_status xdata_to_buf P((char *xdata, char *buf, int *len, int max_len));
t_status buf_to_xdata_str P((char *buf, int len, int br, char *br_str, char *spc_str, char *str, int max_len));
t_status ascii_vec_default P((t_vec *vec));
t_status buf_to_printable_str P((char *buf, int len, int br, char *br_str, char *spc_str, char *nonprint_str, t_vec *ascii_vec, char *str, int max_len));
t_status buf_to_cooked_str_i P((int off, unsigned char *b, int l, int br, char *br_str, char *spc_str, char *big_spc_str, char *nonprint_str, t_vec *ascii_vec, char *str, int max_len));
t_status buf_to_cooked_str P((char *buf, int len, int br, char *br_str, char *spc_str, char *big_spc_str, char *nonprint_str, t_vec *ascii_vec, char *str, int max_len));
void str_lower P((char *str));
void a_debug_init P((void));
void bff P((char *buf, int len));
#endif
