/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef ID_H
#define ID_H	1

#include "a.h"

typedef struct			s_id
{
  t_vec				*ht;
} t_id;

typedef t_status		(*t_id_walk_proc) P((t_hash_elt *he,
						     VOID_PTR data));

/*
** You have to delete "value" before/after calling id_rm()
*/

/* PROTO a_id.c */
/* a_id.c */
t_id *id_new P((int base, int list_base, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
void id_destroy_elt P((t_hash_elt *he, void *data));
void id_destroy P((t_id *id));
void id_delete P((t_id *id));
int id_cmp P((void *key1, void *key2));
t_hash_elt *id_get P((t_id *id, void *key));
t_status id_add P((t_id *id, void *key, void *value));
t_status id_add_unique P((t_id *id, void *base_key, void *value));
t_status id_override P((t_id *id, void *key, void *value));
t_status id_rm P((t_id *id, void *key));
t_boolean id_is_empty P((t_id *id));
int id_count P((t_id *id));
t_status id_walk P((t_id *id, t_id_walk_proc proc, void *data));
t_status id_to_vec_hash_elt P((t_id *id, t_vec *vec));
t_status id_walk_sorted_cmp P((t_id *id, t_id_walk_proc walk_proc, t_vec_cmp_proc cmp_proc, void *data));
int id_walk_sorted_cmpproc P((void **p1, void **p2));
t_status id_walk_sorted P((t_id *id, t_id_walk_proc proc, void *data));
t_status cb_id_show P((t_hash_elt *he));
void id_show P((t_id *id));
#endif
