/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef DICT_STR_H
#define DICT_STR_H	1

#include "a.h"

typedef struct		s_dict_str_data
{
  t_dict		*dict;
  char			*str;
} t_dict_str_data;

/* PROTO a_dict_str.c */
/* a_dict_str.c */
t_status dict_str_override P((t_dict *dict, char *key, char *value));
t_status dict_str_add P((t_dict *dict, char *key, char *value));
t_status dict_str_rm P((t_dict *dict, char *key));
void dict_str_destroy_elt P((t_hash_elt *he, t_dict *dict));
void dict_str_delete P((t_dict *dict));
char *dict_str_get P((t_dict *dict, char *key));
int dict_str_copy_override_walk P((t_hash_elt *he, t_dict *dst));
int dict_str_copy_override P((t_dict *src, t_dict *dst));
int dict_str_copy_silently_walk P((t_hash_elt *he, t_dict *dst));
int dict_str_copy_silently P((t_dict *src, t_dict *dst));
t_status dict_str_copy_override_suffix_walk P((t_hash_elt *he, t_dict_str_data *dsd));
t_status dict_str_copy_override_suffix P((t_dict *src, t_dict *dst, char *suffix));
t_status dict_str_get_sub_prefix_walk P((t_hash_elt *he, t_dict_str_data *dsd));
t_status dict_str_get_sub_prefix P((t_dict *src, t_dict *dst, char *prefix));
t_status dict_str_split P((t_dict *dict, char *str, int sep));
t_status dict_str_show_walk P((t_hash_elt *he));
void dict_str_show P((t_dict *dict));
#endif
