/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef A_ARR_H
#define A_ARR_H	1

#include "a.h"

#define ARR_BASE		32

typedef struct			s_arr
{
  size_t			eltsize;
  int				base;
  int				count;
  int				allocated;
  VOID_PTR			*elts;
  t_alloc_algorithm_proc	alloc_algorithm_proc;
  t_alloc_proc			alloc_proc;
  t_realloc_proc		realloc_proc;
  t_free_proc			free_proc;
  char				*comment;
} t_arr;

#define ARR_EMPTY(arr)		((arr)->count = 0)
#define ARR_COUNT(arr)		((arr)->count)

/* PROTO a_arr.c */
/* a_arr.c */
t_status arr_alloc P((t_arr *arr, int n));
t_arr *arr_new P((size_t eltsize, int base, t_boolean now, t_alloc_algorithm_proc alloc_algorithm_proc, t_alloc_proc alloc_proc, t_realloc_proc realloc_proc, t_free_proc free_proc, char *comment, t_status *status));
void arr_destroy P((t_arr *arr));
void arr_delete P((t_arr *arr));
void *arr_next P((t_arr *arr, t_status *status));
void arr_rm P((t_arr *arr, int idx));
void arr_show P((t_arr *arr));
#endif
