/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

VOID_FUNC		timeval_from_str(str,tv)
char			*str;
struct timeval		*tv;
{
  char			*ptr;

  if (ptr = index(str,':'))
    *ptr++ = 0;
  else
    if (ptr = index(str,'.'))
      *ptr++ = 0;
    else
      ptr = "0";
  tv->tv_sec = atoi(str);
  tv->tv_usec = atoi(ptr);
}

VOID_FUNC		timeval_print(tv)
struct timeval		*tv;
{
  fprintf(stderr,"%d:%d\n",tv->tv_sec,tv->tv_usec);
}

int			timeval_diff(after,before,diff)
struct timeval		*after;
struct timeval		*before;
struct timeval		*diff;
{
  int			carry;

  if ((diff->tv_usec = after->tv_usec - before->tv_usec) < 0)
    {
      diff->tv_usec = 1000000 - diff->tv_usec;
      carry = 1;
    }
  else
    carry = 0;
  if ((diff->tv_sec = after->tv_sec - before->tv_sec) < 0)
    {
      diff->tv_sec += carry;
      return (-1);
    }
  else
    {
      diff->tv_sec -= carry;
      return (1);
    }
}
