/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <ctype.h>
#include "a.h"

int		ipow(x,n)
int		x;
int		n;
{
  int		result;

  result = 1;
  while (n--)
    {
      result *= x;
    }
  return (result);
}

int		ilog(x,y)
int		x;
int		y;
{
  int		result;

  if (y == 1)
    return (0);
  result = 1;
  while (y > x)
    {
      y /= x;
      result++;
    }
  return (result);
}

t_status	int_to_str(num,str,max_len)
int		num;
char		*str;
int		max_len;
{
  t_status	status;
  char		tmp[STR_BUFSIZ];
  char		*p;
  
  if (num < 0)
    {
      if ((status = str_cat_char(str,max_len,'-')) < 0)
	return (status);
      num = -num;
    }
  p = tmp + sizeof (tmp) - 1;
  tmp[sizeof (tmp) - 1] = '\0';
  do 
    {
      *--p = num % 10 + '0';
    } while ((num /= 10) != 0);
  while (*p)
    {
      if ((status = str_cat_char(str,max_len,*p++)) < 0)
	return (status);
    }
  return (0);
}

t_status	uint_to_str(num,str,max_len)
unsigned int	num;
char		*str;
int		max_len;
{
  t_status	status;
  char		tmp[STR_BUFSIZ];
  char		*p;

  p = tmp + sizeof (tmp) - 1;
  tmp[sizeof (tmp) - 1] = '\0';
  do 
    {
      *--p = num % 10 + '0';
    } while ((num /= 10) != 0);
  while (*p)
    {
      if ((status = str_cat_char(str,max_len,*p++)) < 0)
	return (status);
    }
  return (0);
}

t_boolean	atobooleanfalse(str)
char		*str;
{
  if (!strcasecmp(str,"true"))
    return (TRUE);
  return (FALSE);
}

t_boolean	atobooleantrue(str)
char		*str;
{
  if (!strcasecmp(str,"false"))
    return (FALSE);
  return (TRUE);
}

VOID_PTR	pool_alloc(pool,alloc_proc,size,comment,free_proc,status)
t_vec		*pool;
t_alloc_proc	alloc_proc;
size_t		size;
char		*comment;
t_free_proc	free_proc;
t_status	*status;
{
  VOID_PTR	ptr;

  if ((ptr = alloc_proc(size,
			comment,
			"pool_alloc:ptr",
			status)) == NULL)
    return (NULL);
  if (((*status) = vec_add(pool,ptr)) < 0)
    {
      free_proc(ptr,
		comment,
		"pool_alloc:ptr");
      return (NULL);
    }
}

char		*strdup_alloc(str,alloc_proc,comment1,comment2,status)
char		*str;
t_alloc_proc	alloc_proc;
char		*comment1;
char		*comment2;
t_status	*status;
{
  char		*nstr;
  int		len;

  len = strlen(str);
  if ((nstr = alloc_proc((len + 1) * sizeof (char),
			 comment1,
			 comment2,
			 status)) == NULL)
    return (NULL);
  strcpy(nstr,str);
  return (nstr);
}

t_assoc		*assoc_str_ptr_from_left(assoc,left)
t_assoc		*assoc;
char		*left;
{
  while (assoc->left)
    {
      if (!strcmp(assoc->left,left))
	return (assoc);
      assoc++;
    }
  return (NULL);
}

t_assoc		*assoc_str_int_from_right(assoc,right)
t_assoc		*assoc;
int		right;
{
  while (assoc->left)
    {
      if ((int)(assoc->right) == right)
	return (assoc);
      assoc++;
    }
  return (NULL);
}

t_boolean		uint_match(str)
char			*str;
{
  if (!(*str))
    return (FALSE);
  while (*str)
    {
      if (!isdigit(*str))
        return (FALSE);
      str++;
    }
  return (TRUE);
}

char		*str_skip(str,chars)
char		*str;
char		*chars;
{
  while (*str)
    {
      if (!index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

char		*str_find(str,chars)
char		*str;
char		*chars;
{
  while (*str)
    {
      if (index(chars,*str))
        return (str);
      str++;
    }
  return (NULL);
}

char			*bindex(buf,len,c)
char			*buf;
int			len;
int			c;
{
  int			i;

  i = 0;
  while (i < len)
    {
      if (buf[i] == c)
	return (buf + i);
      i++;
    }
  return (NULL);
}

int			indexcount(str,c)
char			*str;
int			c;
{
  int			count;

  count = 0;
  while (*str)
    {
      if ((*str) == c)
	count++;
      str++;
    }
  return (count);
}

int		xdigit_value(xdigit)
int		xdigit;
{
  if (isdigit(xdigit))
    return (xdigit - '0');
  if (isupper(xdigit))
    return (10 + xdigit - 'A');
  return (10 + xdigit - 'a');
}

t_status	xdata_to_buf(xdata,buf,len,max_len)
char		*xdata;
char		*buf;
int		*len;
int		max_len;
{
  int		i;
  int		val;
  t_boolean	first;
  int		xdata_len;
  
  xdata_len = strlen(xdata);
  (*len) = 0;
  first = FALSE;
  val = 0;
  i = 0;
  while (i < xdata_len)
    {
      if (isxdigit(xdata[i]))
        {
          if (first)
            {
              val += xdigit_value(xdata[i]);
              if ((*len) < max_len)
                {
                  buf[(*len)++] = val;
                  val = 0;
                }
              else
		return (-ERR_BO);
	      first = FALSE;
            }
          else
            {
              val = 16 * xdigit_value(xdata[i]);
              first = TRUE;
            }
        }
      else
        if (!isspace(xdata[i]))
          return (-ERR_SYNTAX);
      i++;
    }
  return (0);
}

t_status	buf_to_xdata_str(buf,len,br,br_str,spc_str,str,max_len)
char		*buf;
int		len;
int		br;
char		*br_str;
char		*spc_str;
char		*str;
int		max_len;
{
  t_status	status;
  int		i;

  i = 0;
  while (i < len)
    {
      if ((status = str_cat_fmt_va_unlimited(str,
					     max_len,
					     "%02x",
					     (unsigned char)buf[i])) < 0)
	return (status);
      if (((i + 1) % br) == 0)
	{
	  if ((status = str_cat_str(str,
				    max_len,
				    br_str)) < 0)
	    return (status);
	}
      else
	{
	  if ((status = str_cat_str(str,
				    max_len,
				    spc_str)) < 0)
	    return (status);
	}
      i++;
    }
  return (0);
}

t_status	buf_to_printable_str(buf,
				     len,
				     br,
				     br_str,
				     spc_str,
				     nonprint_str,
				     ascii_vec,
				     str,
				     max_len)
char		*buf;
int		len;
int		br;
char		*br_str;
char		*spc_str;
char		*nonprint_str;
t_vec		*ascii_vec;
char		*str;
int		max_len;
{
  t_status	status;
  int		i;

  i = 0;
  while (i < len)
    {
      if (isprint(buf[i]))
	{
	  if (ascii_vec)
	    {
	      if ((status = str_cat_str(str,
					max_len,
					(char *)(VEC_AT(ascii_vec,
							(int)(buf[i]))))) < 0)
		return (status);
	    }
	  else
	    {
	      if ((status = str_cat_char(str,
					 max_len,
					 buf[i])) < 0)
		return (status);
	    }
	}
      else
	{
	  if ((status = str_cat_str(str,
				    max_len,
				    nonprint_str)) < 0)
	    return (status);
	}
      if (((i + 1) % br) == 0)
	{
	  if ((status = str_cat_str(str,
				    max_len,
				    br_str)) < 0)
	    return (status);
	}
      else
	{
	  if ((status = str_cat_str(str,
				    max_len,
				    spc_str)) < 0)
	    return (status);
	}
      i++;
    }
  return (0);
}

t_status	buf_to_cooked_str_i(off,
				    b,
				    l,
				    br,
				    br_str,
				    spc_str,
				    big_spc_str,
				    nonprint_str,
				    ascii_vec,
				    str,
				    max_len)
int		off;
unsigned char	*b;
int		l;
int		br;
char		*br_str;
char		*spc_str;
char		*big_spc_str;
char		*nonprint_str;
t_vec		*ascii_vec;
char		*str;
int		max_len;
{
   int		i;
   t_status	status;

   if ((status = str_cat_fmt_va_unlimited(str,
					  max_len,
					  "%08x%s",
					  off - l,
					  big_spc_str)) < 0)
     return (status);
   i = 0;
   while (i < br)
     {
       if (i < l)
	 {
	   if ((status = str_cat_fmt_va_unlimited(str,
						  max_len,
						  "%02x",
						  b[i])) < 0)
	     return (status);
	 }
       else
	 {
	   if ((status = str_cat_str(str,
				     max_len,
				     spc_str)) < 0)
	     return (status);
	   if ((status = str_cat_str(str,
				     max_len,
				     spc_str)) < 0)
	     return (status);
	 }
       if ((status = str_cat_str(str,
				 max_len,
				 spc_str)) < 0)
	 return (status);
       i++;
     }
   if ((status = str_cat_str(str,
			     max_len,
			     big_spc_str)) < 0)
     return (status);
   i = 0;
   while (i < l)
     {
       if (isprint(b[i]))
	 {
	   if (ascii_vec)
	     {
	       if ((status = str_cat_str(str,
					 max_len,
					 (char *)(VEC_AT(ascii_vec,
							 (int)(b[i]))))) < 0)
		 return (status);
	     }
	   else
	     {
	       if ((status = str_cat_char(str,
					  max_len,
					  b[i])) < 0)
		 return (status);
	     }
	 }
       else
	 {
	   if ((status = str_cat_str(str,
				     max_len,
				     nonprint_str)) < 0)
	     return (status);
	 }
       i++;
     }
   if ((status = str_cat_str(str,
			     max_len,
			     br_str)) < 0)
     return (status);
   return (0);
}

t_status	buf_to_cooked_str(buf,
				  len,
				  br,
				  br_str,
				  spc_str,
				  big_spc_str,
				  nonprint_str,
				  ascii_vec,
				  str,
				  max_len)
char		*buf;
int		len;
int		br;
char		*br_str;
char		*spc_str;
char		*big_spc_str;
char		*nonprint_str;
t_vec		*ascii_vec;
char		*str;
int		max_len;
{
  unsigned char	b[BUFSIZ];
  int		i;
  int		l;
  t_status	status;

  if (br >= BUFSIZ)
    return (-ERR_INVAL);
  if (ascii_vec)
    if (VEC_COUNT(ascii_vec) != 256)
      return (-ERR_BADVEC);
  l = 0;
  i = 0;
  while (i < len)
    {
      if (l < br)
	b[l++] = buf[i];
      else
	{
	  if ((status = buf_to_cooked_str_i(i,
					    b,
					    br,
					    br,
					    br_str,
					    spc_str,
					    big_spc_str,
					    nonprint_str,
					    ascii_vec,
					    str,
					    max_len)) < 0)
	    return (status);
	  l = 0;
	  b[l++] = buf[i];
	}
      i++;
    }
  if (l > 0)
    if ((status = buf_to_cooked_str_i(i,
				      b,
				      l,
				      br,
				      br_str,
				      spc_str,
				      big_spc_str,
				      nonprint_str,
				      ascii_vec,
				      str,
				      max_len)) < 0)
      return (status);
  return (0);
}

VOID_FUNC		str_lower(str)
char			*str;
{
  while (*str)
    {
      if (isupper(*str))
	*str = tolower(*str);
      str++;
    }
}

#ifdef DEBUG
t_boolean	more_verbose = FALSE;

VOID_FUNC	a_debug_init(VOID_DECL)
{
  char		*str;

  if (str = getenv("MORE_VERBOSE"))
    {
      more_verbose = atobooleanfalse(str);
    }
}

VOID_FUNC	bff(buf,len)
char		*buf;
int		len;
{
  int		i;

  i = 0;
  while (i < len)
    {
      buf[i] = 0xff;
      i++;
    }
}
#endif
