/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

t_id			*id_new(base,
				list_base,
				alloc_algorithm_proc,
				alloc_proc,
				realloc_proc,
				free_proc,
				comment,
				status)
int			base;
int			list_base;
t_alloc_algorithm_proc	alloc_algorithm_proc;
t_alloc_proc		alloc_proc;
t_realloc_proc		realloc_proc;
t_free_proc		free_proc;
char			*comment;
t_status		*status;
{
  t_id			*id;
  
  if ((id = alloc_proc(sizeof (t_id),
		       comment,
		       "id_new:id",
		       status)) == NULL)
    return (NULL);
  if ((id->ht = hash_new(base,
			 list_base,
			 alloc_algorithm_proc,
			 alloc_proc,
			 realloc_proc,
			 free_proc,
			 comment,
			 status)) == NULL)
    {
      free_proc(id,
		comment,
		"id_new:id");
      return (NULL);
    } 
  return (id);
}

VOID_FUNC		id_destroy_elt(he,data)
t_hash_elt		*he;
VOID_PTR		data;
{
  /* NOP */
}

VOID_FUNC		id_destroy(id)
t_id			*id;
{
  hash_destroy(id->ht,
	       id_destroy_elt,
	       NULL);
}

VOID_FUNC		id_delete(id)
t_id			*id;
{
  t_free_proc		free_proc;
  char			*comment;

  free_proc = id->ht->free_proc;
  comment = id->ht->comment;
  hash_delete(id->ht,
	      id_destroy_elt,
	      NULL);
  free_proc(id,
	    comment,
	    "*:id");
}

int			id_cmp(key1,key2)
VOID_PTR		key1;
VOID_PTR		key2;
{
  return ((char *)key2 - (char *)key1);
}

t_hash_elt		*id_get(id,key)
t_id			*id;
VOID_PTR		key;
{
  return (hash_get(id->ht,
		   (t_hash_code)key,
		   (t_hash_cmp_proc)id_cmp,
		   key));
}

t_status		id_add(id,key,value)
t_id			*id;
VOID_PTR		key;
VOID_PTR		value;
{
  t_status		status;

  if (id_get(id,key))
    return (-ERR_EXIST);
  else
    {
      if ((status = hash_add(id->ht,
			     (t_hash_code)key,
			     key,
			     value)) < 0)
	return (status);
    }
  return (0);
}

t_status		id_add_unique(id,base_key,value)
t_id			*id;
VOID_PTR		base_key;
VOID_PTR		value;
{
  t_status		status;

  while (id_get(id,base_key))
    base_key = (char *)base_key + 1;
  if ((status = hash_add(id->ht,
			 (t_hash_code)base_key,
			 base_key,
			 value)) < 0)
    return (status);
  return (0);
}

t_status		id_override(id,key,value)
t_id			*id;
VOID_PTR		key;
VOID_PTR		value;
{
  t_hash_elt		*he;
  
  if (he = id_get(id,key))
    {
      he->value = value;
      return (0);
    }
  else
    return (id_add(id,key,value));
}
  
t_status		id_rm(id,key)
t_id			*id;
VOID_PTR		key;
{
  return (hash_rm(id->ht,
		  (t_hash_code)key,
		  (t_hash_cmp_proc)id_cmp,
		  key,
		  (t_hash_destroy_proc)id_destroy_elt,
		  id));
}

t_boolean		id_is_empty(id)
t_id			*id;
{
  VEC_FOR(id->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  if (TRUE) /* AVOID WARNING */
	    return (FALSE);
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (TRUE);
}

int			id_count(id)
t_id			*id;
{
  int			count;

  count = 0;
  VEC_FOR(id->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  count++;
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (count);
}

t_status		id_walk(id,proc,data)
t_id			*id;
t_id_walk_proc		proc;
VOID_PTR		data;
{
  VEC_FOR(id->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  t_status	status;

	  if ((status = proc(he,data)) < 0)
	    {
	      return (status);
	    }
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (0);
}	

t_status		id_to_vec_hash_elt(id,vec)
t_id			*id;
t_vec			*vec;
{
  VEC_FOR(id->ht,t_vec *hl)
    {
      VEC_FOR(hl,t_hash_elt *he)
	{
	  t_status	status;

	  if ((status = vec_add(vec,he)) < 0)
	    return (status);
	}
      VEC_ENDFOR;
    }
  VEC_ENDFOR;
  return (0);
}

t_status		id_walk_sorted_cmp(id,walk_proc,cmp_proc,data)
t_id			*id;
t_id_walk_proc		walk_proc;
t_vec_cmp_proc		cmp_proc;
VOID_PTR		data;
{
  t_status		status;
  t_vec			*vec;

  status = 0;
  if ((vec = vec_new(VEC_BASE,
		     FALSE,
		     id->ht->alloc_algorithm_proc,
		     id->ht->alloc_proc,
		     id->ht->realloc_proc,
		     id->ht->free_proc,
		     id->ht->comment,
		     &status)) == NULL)
    return (status);
  if (id_to_vec_hash_elt(id,vec) < 0)
    {
      status = -ERR_NOMEM;
      goto bad;
    }
  vec_sort(vec,(t_vec_cmp_proc)cmp_proc);
  VEC_FOR(vec,t_hash_elt *sorted_he)
    {
      if ((status = walk_proc(sorted_he,data)) < 0)
	goto bad;
    }
  VEC_ENDFOR;
bad:
  vec_delete(vec);
  return (status);
}	

int			id_walk_sorted_cmpproc(p1,p2)
VOID_PTR		*p1;
VOID_PTR		*p2;
{
  t_hash_elt		*he1;
  t_hash_elt		*he2;

  he1 = (t_hash_elt *)(*p1);
  he2 = (t_hash_elt *)(*p2);
  return (id_cmp(he1->key,he2->key));
}

t_status		id_walk_sorted(id,proc,data)
t_id			*id;
t_id_walk_proc		proc;
VOID_PTR		data;
{
  return (id_walk_sorted_cmp(id,
			     proc,
			     (t_vec_cmp_proc)id_walk_sorted_cmpproc,
			     data));
}	

#ifdef DEBUG
t_status		cb_id_show(he)
t_hash_elt		*he;
{
  fprintf(stderr,"key=`%x' value=0x%x\n",he->key,he->value);
  return (0);
}

VOID_FUNC		id_show(id)
t_id			*id;
{
  id_walk(id,(t_id_walk_proc)cb_id_show,NULL);
}
#endif
