/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

t_status		dict_str_override(dict,key,value)
t_dict			*dict;
char			*key;
char			*value;
{
  t_hash_elt		*he;
  char			*nvalue;
  t_status		status;
  
  if ((nvalue = strdup_alloc(value,
			     dict->ht->alloc_proc,
			     dict->ht->comment,
			     "dict_str_override:value",
			     &status)) == NULL)
    return (status);
  if (he = dict_get(dict,key))
    {
      dict->ht->free_proc(he->value,
			  dict->ht->comment,
			  "*:value");
      he->value = nvalue;
      return (0);
    }
  else
    if ((status = dict_add(dict,key,nvalue)) < 0)
      {
	dict->ht->free_proc(nvalue,
			    dict->ht->comment,
			    "dict_str_override:value");
	return (status);
      }
  return (0);
}

t_status		dict_str_add(dict,key,value)
t_dict			*dict;
char			*key;
char			*value;
{
  t_hash_elt		*he;
  t_status		status;
  
  if (he = dict_get(dict,key))
    return (-ERR_EXIST);
  else
    {
      char	*nvalue;
      
      if ((nvalue = strdup_alloc(value,
				 dict->ht->alloc_proc,
				 dict->ht->comment,
				 "dict_str_add:value",
				 &status)) == NULL)
	return (status);
      if ((status = dict_add(dict,key,nvalue)) < 0)
	{
	  dict->ht->free_proc(nvalue,
			      dict->ht->comment,
			      "dict_str_add:value");
	  return (status);
	}
    }
  return (0);
}

t_status		dict_str_rm(dict,key)
t_dict			*dict;
char			*key;
{
  t_hash_elt		*he;

  if ((he = dict_get(dict,key)) == NULL)
    return (-ERR_NOENT);
  dict->ht->free_proc(he->value,
		      dict->ht->comment,
		      "*:value");
  return (dict_rm(dict,key));
}

VOID_FUNC		dict_str_destroy_elt(he,dict)
t_hash_elt		*he;
t_dict			*dict;
{
  dict->ht->free_proc(he->key,
		      dict->ht->comment,
		      "*:key");
  dict->ht->free_proc(he->value,
		      dict->ht->comment,
		      "*:value");
}

VOID_FUNC		dict_str_delete(dict)
t_dict			*dict;
{
  t_free_proc		free_proc;
  char			*comment;

  free_proc = dict->ht->free_proc;
  comment = dict->ht->comment;
  hash_delete(dict->ht,
	      (t_hash_destroy_proc)dict_str_destroy_elt,
	      dict);
  free_proc(dict,
	    comment,
	    "*:dict");
}

char			*dict_str_get(dict,key)
t_dict			*dict;
char			*key;
{
  t_hash_elt		*he;

  if ((he = dict_get(dict,key)) == NULL)
    return (NULL);
  return (he->value);
}

int			dict_str_copy_override_walk(he,dst)
t_hash_elt		*he;
t_dict			*dst;
{
  return (dict_str_override(dst,he->key,he->value));
}

int			dict_str_copy_override(src,dst)
t_dict			*src;
t_dict			*dst;
{
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_copy_override_walk,
		    dst));
}

int			dict_str_copy_silently_walk(he,dst)
t_hash_elt		*he;
t_dict			*dst;
{
  t_status		status;

  if ((status = dict_str_add(dst,he->key,he->value)) < 0)
    {
      if (status == -ERR_EXIST)
	return (0);
      else
	return (status);
    }
}

int			dict_str_copy_silently(src,dst)
t_dict			*src;
t_dict			*dst;
{
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_copy_silently_walk,
		    dst));
}

t_status		dict_str_copy_override_suffix_walk(he,dsd)
t_hash_elt		*he;
t_dict_str_data		*dsd;
{
  t_status		status;
  char			*new_key;
  int			size;
  int			suffix_len;

  suffix_len = strlen(dsd->str);
  size = suffix_len + strlen(he->key) + 1;
  if ((new_key = dsd->dict->ht->alloc_proc(size,
					   dsd->dict->ht->comment,
				    "dict_str_copy_override_suffix_walk:key",
					   &status)) == NULL)
    return (status);
  strcpy(new_key,dsd->str);
  strcpy(new_key + suffix_len,he->key);
  status = dict_str_override(dsd->dict,new_key,he->value);
  dsd->dict->ht->free_proc(new_key,
			   dsd->dict->ht->comment,
			   "dict_str_copy_override_suffix_walk:key");
  return (status);
}

t_status		dict_str_copy_override_suffix(src,dst,suffix)
t_dict			*src;
t_dict			*dst;
char			*suffix;
{
  t_dict_str_data	dsd;

  dsd.dict = dst;
  dsd.str = suffix;
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_copy_override_suffix_walk,
		    &dsd));
}

t_status		dict_str_get_sub_prefix_walk(he,dsd)
t_hash_elt		*he;
t_dict_str_data		*dsd;
{
  t_status		status;
  char			*new_key;
  int			size;
  int			prefix_len;

  prefix_len = strlen(dsd->str);
  if (!strncmp(he->key,dsd->str,prefix_len))
    {
      size = strlen(he->key) - prefix_len + 1;
      if ((new_key = dsd->dict->ht->alloc_proc(size,
					       dsd->dict->ht->comment,
					  "dict_str_get_sub_prefix_walk:key",
					       &status)) == NULL)
	return (status);
      strcpy(new_key,((char *)(he->key)) + prefix_len);
      status = dict_str_override(dsd->dict,new_key,he->value);
      dsd->dict->ht->free_proc(new_key,
			       dsd->dict->ht->comment,
			       "dict_str_get_sub_prefix_walk:key");
      return (status);
    }
  return (0);
}

t_status		dict_str_get_sub_prefix(src,dst,prefix)
t_dict			*src;
t_dict			*dst;
char			*prefix;
{
  t_dict_str_data	dsd;

  dsd.dict = dst;
  dsd.str = prefix;
  return (dict_walk(src,
		    (t_dict_walk_proc)dict_str_get_sub_prefix_walk,
		    &dsd));
}

t_status		dict_str_split(dict,str,sep)
t_dict			*dict;
char			*str;
int			sep;
{
  t_vec			*vec_str;
  t_status		status;

  if ((vec_str = vec_new(VEC_BASE,
			 FALSE,
			 dict->ht->alloc_algorithm_proc,
			 dict->ht->alloc_proc,
			 dict->ht->realloc_proc,
			 dict->ht->free_proc,
			 dict->ht->comment,
			 &status)) == NULL)
    return (status);
  if ((status = vec_str_split(vec_str,str,sep)) < 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  VEC_FOR(vec_str,char *str)
    {
      char		*value;

      if ((value = index(str,'=')) == NULL)
	value = "";
      else
	*value++ = 0;
      if ((status = dict_str_override(dict,str,value)) < 0)
	{
	  vec_str_delete(vec_str);
	  return (status);
	}
    }
  VEC_ENDFOR;
  vec_str_delete(vec_str);
  return (0);
}

#ifdef DEBUG
t_status		dict_str_show_walk(he)
t_hash_elt		*he;
{
  fprintf(stderr,"`%s' `%s'\n",he->key,he->value);
  return (0);
}

VOID_FUNC		dict_str_show(dict)
t_dict			*dict;
{
  dict_walk(dict,
	    (t_dict_walk_proc)dict_str_show_walk,
	    NULL);
}
#endif

