/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "a.h"

int			dict_int_walk_sorted_cmpproc(p1,p2)
VOID_PTR		*p1;
VOID_PTR		*p2;
{
  t_hash_elt		*he1;
  t_hash_elt		*he2;
  
  he1 = (t_hash_elt *)(*p1);
  he2 = (t_hash_elt *)(*p2);
  return ((int)(he1->value) - (int)(he2->value));
}

int			dict_int_walk_sorted(dict,proc,data)
t_dict			*dict;
t_dict_walk_proc	proc;
VOID_PTR		data;
{
  return (dict_walk_sorted_cmp(dict,
			       proc,
			       (t_vec_cmp_proc)dict_int_walk_sorted_cmpproc,
			       data));
}

int			dict_int_enum(dict,str,sep)
t_dict			*dict;
char			*str;
int			sep;
{
  t_vec			*vec_str;
  VOID_PTR		value;
  t_status		status;

  value = NULL;
  if ((vec_str = vec_new(VEC_BASE,
			 FALSE,
			 dict->ht->alloc_algorithm_proc,
			 dict->ht->alloc_proc,
			 dict->ht->realloc_proc,
			 dict->ht->free_proc,
			 dict->ht->comment,
			 &status)) == NULL)
    return (status);
  if ((status = vec_str_split(vec_str,str,sep)) < 0)
    {
      vec_str_delete(vec_str);
      return (status);
    }
  VEC_FOR(vec_str,char *str)
    {
      char		*s;

      if (s = index(str,'='))
	{
	  *s++ = 0;
	  value = (VOID_PTR)atoi(s);
	}
      if ((status = dict_override(dict,str,value)) < 0)
	{
	  vec_str_delete(vec_str);
	  return (status);
	}
      value = (char *)value + 1;
    }
  VEC_ENDFOR;
  vec_str_delete(vec_str);
  return (0);
}
