/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include "xearth_i.h"

#ifdef DEBUG
t_mask			xearth_verb_level;

t_mask_def		xearth_verb_level_defs[] = 
{
  {"mapscan",		VERB_MAPSCAN},
  {"maprender",		VERB_MAPRENDER},
  {"mapdither",		VERB_MAPDITHER},
  {"widget",		VERB_WIDGET},
  {"all",		~0L},
  {NULL,		0}
};

VOID_FUNC		xearth_debug_init(VOID_DECL)
{
  char			*str;

  if (str = getenv("XEARTH_VERB_LEVEL"))
    {
      t_vec		*vec;
      t_status		status;

      vec = vec_new(VEC_BASE,
		    FALSE,
		    alloc_algorithm_factor2,
		    alloc_malloc,
		    realloc_realloc,
		    free_free,
		    "xearth_debug",
		    &status);
      assert(vec);
      if ((status = vec_str_split(vec,str,'|')) < 0)
	{
	  err_print(-status,"xearth_debug_init");
	  abort();
	}
      if ((status = mask_from_vec_str(xearth_verb_level_defs,
				      vec,
				      &xearth_verb_level)) < 0)
	{
	  err_print(-status,"xearth_debug_init");
	  abort();
	}
      vec_str_delete(vec);
    }
}
#endif
