/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef SUNPOS_H
#define SUNPOS_H	1

#include "earthmisc.h"

/* PROTO sunpos.c */
/* sunpos.c */
double solve_keplers_equation P((double M));
double sun_ecliptic_longitude P((time_t ssue));
void ecliptic_to_equatorial P((double lambda, double beta, double *alpha, double *delta));
double julian_date P((int y, int m, int d));
double GST P((time_t ssue));
void sun_position P((time_t ssue, double *lat, double *lon));
#endif
