/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * earthmisc.h
 * kirk johnson
 * july 1993
 *
 * RCS $Id: xearth.h,v 1.28 1995/09/29 18:12:30 tuna Exp $
 *
 * Copyright (C) 1989, 1990, 1993, 1994, 1995 Kirk Lauritz Johnson
 *
 * Parts of the source code (as marked) are:
 *   Copyright (C) 1989, 1990, 1991 by Jim Frost
 *   Copyright (C) 1992 by Jamie Zawinski <jwz@lucid.com>
 *
 * Permission to use, copy, modify and freely distribute xearth for
 * non-commercial and not-for-profit purposes is hereby granted
 * without fee, provided that both the above copyright notice and this
 * permission notice appear in all copies and in supporting
 * documentation.
 *
 * Unisys Corporation holds worldwide patent rights on the Lempel Zev
 * Welch (LZW) compression technique employed in the CompuServe GIF
 * image file format as well as in other formats. Unisys has made it
 * clear, however, that it does not require licensing or fees to be
 * paid for freely distributed, non-commercial applications (such as
 * xearth) that employ LZW/GIF technology. Those wishing further
 * information about licensing the LZW patent should contact Unisys
 * directly at (lzw_info@unisys.com) or by writing to
 *
 *   Unisys Corporation
 *   Welch Licensing Department
 *   M/S-C1SW19
 *   P.O. Box 500
 *   Blue Bell, PA 19424
 *
 * The author makes no representations about the suitability of this
 * software for any purpose. It is provided "as is" without express or
 * implied warranty.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT
 * OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef EARTHMISC_H
#define EARTHMISC_H

#include <X11/Xos.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <assert.h>
#include <time.h>
#include "a.h"

#define VersionString	"1.0w"

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif /* !M_PI */

/* a particularly large number
 */
#define BigNumber (1e6)

/* rotational period of the earth (seconds)
 */
#define EarthPeriod (86400)

/* types of pixels
 */
#define PixTypeSpace     (0)
#define PixTypeLand      (1)
#define PixTypeWater     (2)
#define PixTypeStar      (3)
#define PixTypeGridLand  (4)
#define PixTypeGridWater (5)

/* types of dots
 */
#define DotTypeStar (0)
#define DotTypeGrid (1)

typedef enum		_ProjType
{
  ProjTypeOrthographic,
  ProjTypeMercator
} ProjType;

typedef enum		_ViewPosType
{
  ViewPosTypeFixed,
  ViewPosTypeSunRel,
  ViewPosTypeOrbit
} ViewPosType;

/* vector rotation
 */
#define XFORM_ROTATE(p,vpi)             \
 do {                                   \
  double _p0_, _p1_, _p2_;              \
  double _c_, _s_, _t_;                 \
  _p0_ = p[0];                          \
  _p1_ = p[1];                          \
  _p2_ = p[2];                          \
  _c_  = vpi.cos_lon;                   \
  _s_  = vpi.sin_lon;                   \
  _t_  = (_c_ * _p0_) - (_s_ * _p2_);   \
  _p2_ = (_s_ * _p0_) + (_c_ * _p2_);   \
  _p0_ = _t_;                           \
  _c_  = vpi.cos_lat;                   \
  _s_  = vpi.sin_lat;                   \
  _t_  = (_c_ * _p1_) - (_s_ * _p2_);   \
  _p2_ = (_s_ * _p1_) + (_c_ * _p2_);   \
  _p1_ = _t_;                           \
  _c_  = vpi.cos_rot;                   \
  _s_  = vpi.sin_rot;                   \
  _t_  = (_c_ * _p0_) - (_s_ * _p1_);   \
  _p1_ = (_s_ * _p0_) + (_c_ * _p1_);   \
  _p0_ = _t_;                           \
  p[0] = _p0_;                          \
  p[1] = _p1_;                          \
  p[2] = _p2_;                          \
 } while (0)

/* mercator projection (xyz->xy)
 */
#define MERCATOR_X(x, z)  (atan2((x), (z)))
#define MERCATOR_Y(y)     (((y) >= 1) ? (BigNumber)      \
			   : (((y) <= -1) ? (-BigNumber) \
			      : log(tan((asin(y)/2) + (M_PI/4)))))
#define INV_MERCATOR_Y(y) (sin(2 * (atan(exp(y)) - (M_PI/4))))

typedef struct
{
  double cos_lat, sin_lat;	/* cos/sin of view_lat */
  double cos_lon, sin_lon;	/* cos/sin of view_lon */
  double cos_rot, sin_rot;	/* cos/sin of view_rot */
} ViewPosInfo;

typedef struct
{
  short y;
  short lo_x;
  short hi_x;
  short val;
} ScanBit;

typedef struct
{
  short  x;
  short  y;
  u_char type;
} ScanDot;

#ifdef USE_EXACT_SQRT

#define SQRT(x) (((x) <= 0.0) ? (0.0) : (sqrt(x)))

#else

/*
 * brute force approximation for sqrt() over [0,1]
 *  - two quadratic regions
 *  - returns zero for args less than zero
 */
#define SQRT(x)                                             \
  (((x) > 0.13)                                             \
   ? ((((-0.3751672414*(x))+1.153263483)*(x))+0.2219037586) \
   : (((x) > 0.0)                                           \
      ? ((((-9.637346154*(x))+3.56143)*(x))+0.065372935)    \
      : (0.0)))

#endif /* USE_EXACT_SQRT */

#endif
