/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#ifndef EARTHP_H
#define EARTHP_H	1

#include "Earth.h"
#include "mapscan.h"
#include "mapdither.h"
#include "maprender.h"
#include "earthpos.h"

typedef struct		_EarthClassPart 
{
  int			ignore;
} EarthClassPart;

typedef struct		_EarthClassRec 
{
  CoreClassPart		core_class;
  CompositeClassPart	composite_class;
  ConstraintClassPart	constraint_class;
  EarthClassPart	earth_class;
} EarthClassRec;

extern EarthClassRec	earthClassRec;

typedef struct 
{
  /* public */
  ProjType		projType;
  ViewPosType		viewPosType;
  float			viewLat;
  float			viewLon;
  float			period;
  float			inclin;
  float			viewRot;
  float			viewMag;
  float			starFreq;
  int			bigStars;
  int			day;
  int			night;
  int			terminator;
  Boolean		mono;
  int			numColors;
  float			xGamma;
  int			time;
  int			shiftX;
  int			shiftY;
  Boolean		computeSunPos;
  Boolean		doShade;
  Boolean		doStars;
  Boolean		doGrid;
  int			gridBig;
  int			gridSmall;
  /* private */
  GC			gc;
  t_map_scan_input	msi;
  t_map_scan_output	mso;
  t_map_dither_output	mdo;
  t_map_render_input	mri;
  t_map_render_output	mro;
  t_earth_pos_input	epi;
  t_earth_pos_output	epo;
  Pixel			*pels;
  t_u32			*dith;
  u_char		*xbuf;
  XImage		*xim;
  int			idx;
  int			render_type;
} EarthPart;

typedef struct		_EarthRec 
{
  CorePart		core;
  CompositePart		composite;
  ConstraintPart	constraint;
  EarthPart		earth;
} EarthRec;

/*
 * structure attached to all children
 */
typedef struct		_EarthConstraintsPart 
{
  /* public */
  float			latitude;
  float			longitude;
  /* private */
  Boolean		mapped;
} EarthConstraintsPart;

typedef struct		_EarthConstraintsRec 
{
  EarthConstraintsPart	earth;
} EarthConstraintsRec, *EarthConstraints;

#define CORE		(((EarthWidget)(self))->core)
#define COMPOSITE	(((EarthWidget)(self))->composite)
#define EARTH		(((EarthWidget)(self))->earth)

#define EARTH_I(inst)	(((EarthWidget)(inst))->earth)

#define EARTH_I_C(inst) (((EarthConstraints)((inst)->core.constraints))->earth)

#endif
