@class XearthSat (Core) @file=Sat @nodoc

@imports
@incl "a.h"
@incl "Earth.h"

@public

@var int				timeout = 100
@var int				margin = 2
@var float				latitude = 0
@var float				longitude = 0
@var <Callback> XtCallbackList		posChangedCallback = NULL
@var Boolean				move = False
@var float				incr = 1.0
@var <FontStruct> XFontStruct		*font = <String> "fixed"
@var Pixel				foreground = <String> "black"

@private

@var XtIntervalId			interval_id
@var GC					gc
@var Boolean				selected
@var Position				old_x
@var Position				old_y
@var char				buf[STR_BUFSIZ];

@translations
@trans Ctrl<Btn1Down>:			down()
@trans Ctrl<Btn3Down>:			up()
@trans <Btn1Down>:			left()
@trans <Btn3Down>:			right()
@trans <Key>Z:				zero()

@actions
@proc	left
{
  $longitude -= $incr;
  pos_changed($);
}

@proc	right
{
  $longitude += $incr;
  pos_changed($);
}

@proc	up
{
  $latitude += $incr;
  pos_changed($);
}

@proc	down
{
  $latitude -= $incr;
  pos_changed($);
}

@proc	zero
{
  $latitude = $longitude = 0.0;
  pos_changed($);
}

@utilities
@proc void				recompute($)
{
  XtGeometryResult			result;
  Dimension				width;
  Dimension				height;
  Dimension				width_ret;
  Dimension				height_ret;
  t_status				status;

  $buf[0] = 0;
  sprintf($buf, /* SECURITY */
	  "%s %.2f,%.2f",
	  XtName($),
	  $latitude,
	  $longitude);
  width = XTextWidth($font,
		     $buf,
		     strlen($buf)) + 2 * $margin;
  height = $font->ascent + $font->descent + 2 * $margin;
  result = XtMakeResizeRequest($,
			       width,
			       height,
			       &width_ret,
			       &height_ret);
  switch (result)
    {
    case XtGeometryDone:
      break ;
    case XtGeometryAlmost:
      XtMakeResizeRequest($,
			  width_ret,
			  height_ret,
			  NULL,
			  NULL);
      break ;
    default:
      XtResizeWidget($,
		     width,
		     height,
		     $border_width);
      XtResizeWindow($);
      break ;
    }
  if (XtIsRealized($))
    {
      XClearArea(XtDisplay($),
		 XtWindow($),
		 0,
		 0,
		 $width,
		 $height,
		 True);
    }
}

@proc void				pos_changed($)
{
  XearthSatCallbackStruct		cbs;
  
  recompute($);
  cbs.lat = $latitude;
  cbs.lon = $longitude;
  XtCallCallbackList($,$posChangedCallback,&cbs);
}

@proc void				timer($)
{
  $latitude += 0;
  $longitude += 1;
  if ($latitude > 90)
    $latitude = -90;
  if ($longitude > 180)
    $longitude = -180;
  pos_changed($);
  $interval_id = XtAppAddTimeOut(XtWidgetToApplicationContext($),
				 $timeout,
				 (XtTimerCallbackProc)timer,
				 $);
}

@methods
@proc		initialize
{
  XGCValues	xgcv;

  xgcv.foreground = $foreground;
  xgcv.font = $font->fid;
  xgcv.function = GXcopy;
  $gc = XtGetGC($,GCForeground|GCFunction|GCFont,&xgcv);
  $selected = False;
  if ($move)
    timer($);
  $width = 2 * $margin;
  $height = 2 * $margin;
  recompute($);
  pos_changed($);
}

@proc		set_values
{
}

@proc		resize
{
}

@proc		destroy
{
  XtReleaseGC($,$gc);
  if ($move)
    XtRemoveTimeOut($interval_id);
}

@proc		expose
{
  XDrawString(XtDisplay($),
	      XtWindow($),
	      $gc,
	      $margin,
	      $margin + $font->ascent,
	      $buf,
	      strlen($buf));
}

@exports
@type XearthSatCallbackStruct = struct {
  float		lat;
  float		lon;
};

@proc void		XsatGetCoords($,float *latret,float *lonret)
{
  (*latret) = $latitude;
  (*lonret) = $longitude;
}
