/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/* Generated by wbuild from "Sat.w"
** (generator version $Revision: 2.5 $ of $Date: 94/07/29 15:31:49 $)
*/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#line 4 "Sat.w"
#include "a.h"
#line 5 "Sat.w"
#include "Earth.h"
#include <Xearth/SatP.h>
#line 36 "Sat.w"
static void left(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 42 "Sat.w"
static void right(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 48 "Sat.w"
static void up(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 54 "Sat.w"
static void down(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);
#line 60 "Sat.w"
static void zero(
#if NeedFunctionPrototypes
Widget,XEvent*,String*,Cardinal*
#endif
);

static XtActionsRec actionsList[] = {
{"left", left},
{"right", right},
{"up", up},
{"down", down},
{"zero", zero},
};

static char defaultTranslations[] = "\
Ctrl<Btn1Down>: down() \n\
Ctrl<Btn3Down>: up() \n\
<Btn1Down>: left() \n\
<Btn3Down>: right() \n\
<Key>Z: zero() \n\
";
static void _resolve_inheritance(
#if NeedFunctionPrototypes
WidgetClass
#endif
);
#line 148 "Sat.w"
static void initialize(
#if NeedFunctionPrototypes
Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 165 "Sat.w"
static Boolean  set_values(
#if NeedFunctionPrototypes
Widget ,Widget ,Widget,ArgList ,Cardinal *
#endif
);
#line 169 "Sat.w"
static void resize(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 173 "Sat.w"
static void destroy(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 180 "Sat.w"
static void expose(
#if NeedFunctionPrototypes
Widget,XEvent *,Region 
#endif
);
#line 67 "Sat.w"
static void  recompute(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 122 "Sat.w"
static void  pos_changed(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 132 "Sat.w"
static void  timer(
#if NeedFunctionPrototypes
Widget
#endif
);
#line 67 "Sat.w"
/*ARGSUSED*/static void  recompute(self)Widget self;
{
  XtGeometryResult			result;
  Dimension				width;
  Dimension				height;
  Dimension				width_ret;
  Dimension				height_ret;
  t_status				status;

  ((XearthSatWidget)self)->xearthSat.buf[0] = 0;
  sprintf(((XearthSatWidget)self)->xearthSat.buf, /* SECURITY */
	  "%s %.2f,%.2f",
	  XtName(self),
	  ((XearthSatWidget)self)->xearthSat.latitude,
	  ((XearthSatWidget)self)->xearthSat.longitude);
  width = XTextWidth(((XearthSatWidget)self)->xearthSat.font,
		     ((XearthSatWidget)self)->xearthSat.buf,
		     strlen(((XearthSatWidget)self)->xearthSat.buf)) + 2 * ((XearthSatWidget)self)->xearthSat.margin;
  height = ((XearthSatWidget)self)->xearthSat.font->ascent + ((XearthSatWidget)self)->xearthSat.font->descent + 2 * ((XearthSatWidget)self)->xearthSat.margin;
  result = XtMakeResizeRequest(self,
			       width,
			       height,
			       &width_ret,
			       &height_ret);
  switch (result)
    {
    case XtGeometryDone:
      break ;
    case XtGeometryAlmost:
      XtMakeResizeRequest(self,
			  width_ret,
			  height_ret,
			  NULL,
			  NULL);
      break ;
    default:
      XtResizeWidget(self,
		     width,
		     height,
		     ((XearthSatWidget)self)->core.border_width);
      XtResizeWindow(self);
      break ;
    }
  if (XtIsRealized(self))
    {
      XClearArea(XtDisplay(self),
		 XtWindow(self),
		 0,
		 0,
		 ((XearthSatWidget)self)->core.width,
		 ((XearthSatWidget)self)->core.height,
		 True);
    }
}
#line 122 "Sat.w"
/*ARGSUSED*/static void  pos_changed(self)Widget self;
{
  XearthSatCallbackStruct		cbs;
  
  recompute(self);
  cbs.lat = ((XearthSatWidget)self)->xearthSat.latitude;
  cbs.lon = ((XearthSatWidget)self)->xearthSat.longitude;
  XtCallCallbackList(self,((XearthSatWidget)self)->xearthSat.posChangedCallback,&cbs);
}
#line 132 "Sat.w"
/*ARGSUSED*/static void  timer(self)Widget self;
{
  ((XearthSatWidget)self)->xearthSat.latitude += 0;
  ((XearthSatWidget)self)->xearthSat.longitude += 1;
  if (((XearthSatWidget)self)->xearthSat.latitude > 90)
    ((XearthSatWidget)self)->xearthSat.latitude = -90;
  if (((XearthSatWidget)self)->xearthSat.longitude > 180)
    ((XearthSatWidget)self)->xearthSat.longitude = -180;
  pos_changed(self);
  ((XearthSatWidget)self)->xearthSat.interval_id = XtAppAddTimeOut(XtWidgetToApplicationContext(self),
				 ((XearthSatWidget)self)->xearthSat.timeout,
				 (XtTimerCallbackProc)timer,
				 self);
}

static XtResource resources[] = {
#line 9 "Sat.w"
{XtNtimeout,XtCTimeout,XtRInt,sizeof(((XearthSatRec*)NULL)->xearthSat.timeout),XtOffsetOf(XearthSatRec,xearthSat.timeout),XtRImmediate,(XtPointer)100 },
#line 10 "Sat.w"
{XtNmargin,XtCMargin,XtRInt,sizeof(((XearthSatRec*)NULL)->xearthSat.margin),XtOffsetOf(XearthSatRec,xearthSat.margin),XtRImmediate,(XtPointer)2 },
#line 11 "Sat.w"
{XtNlatitude,XtCLatitude,XtRFloat,sizeof(((XearthSatRec*)NULL)->xearthSat.latitude),XtOffsetOf(XearthSatRec,xearthSat.latitude),XtRImmediate,(XtPointer)0 },
#line 12 "Sat.w"
{XtNlongitude,XtCLongitude,XtRFloat,sizeof(((XearthSatRec*)NULL)->xearthSat.longitude),XtOffsetOf(XearthSatRec,xearthSat.longitude),XtRImmediate,(XtPointer)0 },
#line 13 "Sat.w"
{XtNposChangedCallback,XtCPosChangedCallback,XtRCallback,sizeof(((XearthSatRec*)NULL)->xearthSat.posChangedCallback),XtOffsetOf(XearthSatRec,xearthSat.posChangedCallback),XtRImmediate,(XtPointer)NULL },
#line 14 "Sat.w"
{XtNmove,XtCMove,XtRBoolean,sizeof(((XearthSatRec*)NULL)->xearthSat.move),XtOffsetOf(XearthSatRec,xearthSat.move),XtRImmediate,(XtPointer)False },
#line 15 "Sat.w"
{XtNincr,XtCIncr,XtRFloat,sizeof(((XearthSatRec*)NULL)->xearthSat.incr),XtOffsetOf(XearthSatRec,xearthSat.incr),XtRImmediate,(XtPointer)1.0 },
#line 16 "Sat.w"
{XtNfont,XtCFont,XtRFontStruct,sizeof(((XearthSatRec*)NULL)->xearthSat.font),XtOffsetOf(XearthSatRec,xearthSat.font),XtRString,(XtPointer)"fixed"},
#line 17 "Sat.w"
{XtNforeground,XtCForeground,XtRPixel,sizeof(((XearthSatRec*)NULL)->xearthSat.foreground),XtOffsetOf(XearthSatRec,xearthSat.foreground),XtRString,(XtPointer)"black"},
};

XearthSatClassRec xearthSatClassRec = {
{ /* core_class part */
(WidgetClass) &coreClassRec,
"XearthSat",
sizeof(XearthSatRec),
NULL,
_resolve_inheritance,
FALSE,
initialize,
NULL,
XtInheritRealize,
actionsList,
5,
resources,
9,
NULLQUARK,
False ,
FALSE ,
False ,
False ,
destroy,
resize,
expose,
set_values,
NULL,
XtInheritSetValuesAlmost,
NULL,
XtInheritAcceptFocus,
XtVersion,
NULL,
defaultTranslations,
XtInheritQueryGeometry,
XtInheritDisplayAccelerator,
NULL 
},
{ /* XearthSat_class part */
0
},
};
WidgetClass xearthSatWidgetClass = (WidgetClass) &xearthSatClassRec;
/*ARGSUSED*/
#line 36 "Sat.w"
static void left(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
  ((XearthSatWidget)self)->xearthSat.longitude -= ((XearthSatWidget)self)->xearthSat.incr;
  pos_changed(self);
}

/*ARGSUSED*/
#line 42 "Sat.w"
static void right(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
  ((XearthSatWidget)self)->xearthSat.longitude += ((XearthSatWidget)self)->xearthSat.incr;
  pos_changed(self);
}

/*ARGSUSED*/
#line 48 "Sat.w"
static void up(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
  ((XearthSatWidget)self)->xearthSat.latitude += ((XearthSatWidget)self)->xearthSat.incr;
  pos_changed(self);
}

/*ARGSUSED*/
#line 54 "Sat.w"
static void down(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
  ((XearthSatWidget)self)->xearthSat.latitude -= ((XearthSatWidget)self)->xearthSat.incr;
  pos_changed(self);
}

/*ARGSUSED*/
#line 60 "Sat.w"
static void zero(self,event,params,num_params)Widget self;XEvent*event;String*params;Cardinal*num_params;
{
  ((XearthSatWidget)self)->xearthSat.latitude = ((XearthSatWidget)self)->xearthSat.longitude = 0.0;
  pos_changed(self);
}

static void _resolve_inheritance(class)
WidgetClass class;
{
  XearthSatWidgetClass c = (XearthSatWidgetClass) class;
  XearthSatWidgetClass super;
  if (class == xearthSatWidgetClass) return;
  super = (XearthSatWidgetClass)class->core_class.superclass;
}
#line 148 "Sat.w"
/*ARGSUSED*/static void initialize(request,self,args,num_args)Widget  request;Widget self;ArgList  args;Cardinal * num_args;
{
  XGCValues	xgcv;

  xgcv.foreground = ((XearthSatWidget)self)->xearthSat.foreground;
  xgcv.font = ((XearthSatWidget)self)->xearthSat.font->fid;
  xgcv.function = GXcopy;
  ((XearthSatWidget)self)->xearthSat.gc = XtGetGC(self,GCForeground|GCFunction|GCFont,&xgcv);
  ((XearthSatWidget)self)->xearthSat.selected = False;
  if (((XearthSatWidget)self)->xearthSat.move)
    timer(self);
  ((XearthSatWidget)self)->core.width = 2 * ((XearthSatWidget)self)->xearthSat.margin;
  ((XearthSatWidget)self)->core.height = 2 * ((XearthSatWidget)self)->xearthSat.margin;
  recompute(self);
  pos_changed(self);
}
#line 165 "Sat.w"
/*ARGSUSED*/static Boolean  set_values(old,request,self,args,num_args)Widget  old;Widget  request;Widget self;ArgList  args;Cardinal * num_args;
{
}
#line 169 "Sat.w"
/*ARGSUSED*/static void resize(self)Widget self;
{
}
#line 173 "Sat.w"
/*ARGSUSED*/static void destroy(self)Widget self;
{
  XtReleaseGC(self,((XearthSatWidget)self)->xearthSat.gc);
  if (((XearthSatWidget)self)->xearthSat.move)
    XtRemoveTimeOut(((XearthSatWidget)self)->xearthSat.interval_id);
}
#line 180 "Sat.w"
/*ARGSUSED*/static void expose(self,event,region)Widget self;XEvent * event;Region  region;
{
  XDrawString(XtDisplay(self),
	      XtWindow(self),
	      ((XearthSatWidget)self)->xearthSat.gc,
	      ((XearthSatWidget)self)->xearthSat.margin,
	      ((XearthSatWidget)self)->xearthSat.margin + ((XearthSatWidget)self)->xearthSat.font->ascent,
	      ((XearthSatWidget)self)->xearthSat.buf,
	      strlen(((XearthSatWidget)self)->xearthSat.buf));
}
#line 192 "Sat.w"
#line 197 "Sat.w"
/*ARGSUSED*/void  XsatGetCoords(self,latret,lonret)Widget self;float * latret;float * lonret;
{
  (*latret) = ((XearthSatWidget)self)->xearthSat.latitude;
  (*lonret) = ((XearthSatWidget)self)->xearthSat.longitude;
}
