/*
 * This file is a part of the mg project.
 * Copyright (C) 1998 Martin Gall
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 *
 */

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/Paned.h>
#include <X11/Xaw/Scrollbar.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/Toggle.h>
#include <X11/Xaw/Tree.h>
#include <X11/Xaw/Panner.h>
#include <X11/Xaw/Porthole.h>
#include "Earth.h"
#include "Xearth/Sat.h"
#include "Xearth/Root.h"
#include "xearth_i.h"

#define MIN_TIME	0.1	
#define MAX_TIME	23.59
#define TIME_RES	3600

#define MIN_VIEW_MAG	0.2
#define MAX_VIEW_MAG	50.0

#define MIN_VIEW_ROT	-179.0
#define MAX_VIEW_ROT	359.0

#define MIN_VIEW_LAT	-89.0
#define MAX_VIEW_LAT	89.0

#define MIN_VIEW_LON	-179.0
#define MAX_VIEW_LON	179.0

#define MIN_SHIFT	-1000.0
#define MAX_SHIFT	1000.0
#define SHIFT_RES	1

#define LINE_INCR	0.1

t_boolean		verbose = FALSE;
t_boolean		help = FALSE;
int			timeout = 1000;
int			time_incr = 1800;
char			*regexp = NULL;

XtAppContext		app_context;
Widget			toplevel;
Widget			earthwidget;
GC			gc;
int			sat_id = 1;
t_parse_lines_context	plc;
t_boolean		debug_malloc = FALSE;
t_boolean		debug_malloc_verbose = FALSE;

t_opt			main_opts[] = 
{
  {"-v",	(t_opt_proc)opt_true,		(t_off)&verbose,
   NULL,"turn on verbose mode",0},
  {"-t",	(t_opt_proc)opt_int,		(t_off)&timeout,
   "timeout",NULL,0},
  {"-ti",	(t_opt_proc)opt_int,		(t_off)&time_incr,
   "time_incr",NULL,0},
  {"-r",	(t_opt_proc)opt_str,		(t_off)&regexp,
   "regexp",NULL,0},
  {"-dm",	(t_opt_proc)opt_true,		(t_off)&debug_malloc,
   NULL,"debug_malloc",0},
  {"-dmv",	(t_opt_proc)opt_true,		(t_off)&debug_malloc_verbose,
   NULL,"debug_malloc_verbose",0},
};

char			*fallback[] = 
{
  "*Scrollbar.width:	200",
  "*Scrollbar.height:	10",
  "*XearthSat.font:	-adobe-times-medium-r-normal-*-12-*-*-*-*-*-*-*",
  "*XearthSat.background: lightyellow",
  "*background:		gray",
  NULL
};

VOID_FUNC		usage(VOID_DECL)
{
  opt_usage(stderr,main_opts,ARRAY_COUNT(main_opts),TRUE);
  exit(1);
}

int			check_options(VOID_DECL)
{
  if (verbose)
    {
      fprintf(stderr,"options:\n");
      fprintf(stderr,"\t%s %s %s\n",PRODUCT,VERSION,VENDOR);
#ifdef DEBUG
      fprintf(stderr,"\tcompiled with DEBUG\n");
#endif
    }
  return (0);
}

VOID_FUNC		command_quit(w,closure,cbs)
Widget			w;
XtPointer		closure;
XtPointer		cbs;
{
#ifdef DEBUG_MALLOC
  if (debug_malloc)
    gdm_status();
#endif
  exit(0);
}

VOID_FUNC		command_destroy(w,closure,cbs)
Widget			w;
XtPointer		closure;
XtPointer		cbs;
{
  XtDestroyWidget(earthwidget);
}

VOID_FUNC		command_new_earth(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  Widget		shell;

  shell = XtVaCreatePopupShell("shell",
			       shellWidgetClass,
			       toplevel,
			       NULL);
  earthwidget = XtVaCreateManagedWidget("earth",
					earthWidgetClass,
					shell,
					NULL);
  XtPopup(shell,XtGrabNone);
}

VOID_FUNC		sat_pos_changed(w,closure,cbs)
Widget			w;
XtPointer		closure;
XearthSatCallbackStruct	*cbs;
{
  XearthChildSetLatitude(w,cbs->lat);
  XearthChildSetLongitude(w,cbs->lon);
}

VOID_FUNC		command_new_sat(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  char			buf[STR_BUFSIZ];
  t_status		status;
  Widget		sat;	

  buf[0] = 0;
  if ((status = str_cat_fmt_va(buf,
			       sizeof (buf),
			       "sat%d:",
			       sat_id++)) < 0)
    {
      err_print(-status,"int_to_str");
      exit(1);
    }
  sat = XtVaCreateManagedWidget(buf,
				xearthSatWidgetClass,
				earthwidget,
				XtNmove,	True,
				NULL);
  XtAddCallback(sat,
		XtNposChangedCallback,
		(XtCallbackProc)sat_pos_changed,
		NULL);
}

VOID_FUNC		rotate(VOID_DECL)
{
  int			t;

  XtVaGetValues(earthwidget,
		XtNtime,	&t,
		NULL);
  t += time_incr;
  XtVaSetValues(earthwidget,
		XtNtime,	t,
		NULL);
  XtAppAddTimeOut(app_context,
		  timeout,
		  (XtTimerCallbackProc)rotate,
		  NULL);
}

VOID_FUNC		command_rotate(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  rotate();
}

VOID_FUNC		time_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_TIME - MIN_TIME) + MIN_TIME;
#ifdef NOTDEF
   fprintf(stderr,"%f\n",top);
#endif
   r = (int)((double)TIME_RES * top);
   XtVaSetValues(earthwidget,
                 XtNtime, r,
                 NULL);
}

VOID_FUNC		view_mag_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_MAG - MIN_VIEW_MAG) + MIN_VIEW_MAG;
   XearthSetViewMag(earthwidget,(float)top);
}

VOID_FUNC		view_rot_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_ROT - MIN_VIEW_ROT) + MIN_VIEW_ROT;
   XearthSetViewRot(earthwidget,(float)top);
}

VOID_FUNC		view_lon_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_LON - MIN_VIEW_LON) + MIN_VIEW_LON;
   XearthSetViewLon(earthwidget,(float)top);
}

VOID_FUNC		view_lat_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
   float                per;
   double               top;
   int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_VIEW_LAT - MIN_VIEW_LAT) + MIN_VIEW_LAT;
   XearthSetViewLat(earthwidget,(float)top);
}

VOID_FUNC		shift_x_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  float                per;
  double               top;
  int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_SHIFT - MIN_SHIFT) + MIN_SHIFT;
#ifdef NOTDEF
   fprintf(stderr,"%f\n",top);
#endif
   r = (int)((double)SHIFT_RES * top);
   XtVaSetValues(earthwidget,
                 XtNshiftX, r,
                 NULL);
}

VOID_FUNC		shift_y_scrollbar_jump(w,closure,ptr)
Widget			w;
XtPointer		closure;
XtPointer		ptr;
{
  float                per;
  double               top;
  int                  r;

   per = *(float *)ptr;
   top = (double)per;
   top = top * (MAX_SHIFT - MIN_SHIFT) + MIN_SHIFT;
#ifdef NOTDEF
   fprintf(stderr,"%f\n",top);
#endif
   r = (int)((double)SHIFT_RES * top);
   XtVaSetValues(earthwidget,
                 XtNshiftY, r,
                 NULL);
}

VOID_FUNC		doit(argc,argv)
int			argc;
char			**argv;
{
  t_status		status;
  Widget		box;
  Widget		shell;
  Widget		command;
  Widget		scrollbar;
  XGCValues		xgcv;
  char			wordbuf[STR_BUFSIZ];
  int			fd;
  time_t		t;

  if (check_options() < 0)
    exit(1);
  toplevel = XtVaAppInitialize(&app_context,
			       "EarthT",
			       NULL,
			       0,
			       &argc,
			       argv,
			       fallback,
			       NULL);
  xgcv.background = BlackPixel(XtDisplay(toplevel),
			       DefaultScreen(XtDisplay(toplevel)));
  xgcv.foreground = WhitePixel(XtDisplay(toplevel),
			     DefaultScreen(XtDisplay(toplevel)));
  xgcv.function = GXcopy;
  gc = XCreateGC(XtDisplay(toplevel),
		 DefaultRootWindow(XtDisplay(toplevel)),
		 GCForeground|GCFunction,
		 &xgcv);
  box = XtVaCreateManagedWidget("box",
				boxWidgetClass,
				toplevel,
				NULL);
  command = XtVaCreateManagedWidget("quit",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_quit,
		NULL);
  command = XtVaCreateManagedWidget("destroy",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_destroy,
		NULL);
  command = XtVaCreateManagedWidget("new_earth",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_new_earth,
		NULL);
  command = XtVaCreateManagedWidget("new_sat",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_new_sat,
		NULL);
  command = XtVaCreateManagedWidget("rotate",
				    commandWidgetClass,
				    box,
				    NULL);
  XtAddCallback(command,
		XtNcallback,
		command_rotate,
		NULL);
  XtVaCreateManagedWidget("time:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("time_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		time_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewMag:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_mag_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_mag_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewRot:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_rot_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_rot_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewLat:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_lat_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_lat_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("viewLon:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("view_lon_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		view_lon_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("shiftX:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("shift_x_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		shift_x_scrollbar_jump,
		NULL);
  XtVaCreateManagedWidget("shiftY:",
			  labelWidgetClass,
			  box,
			  NULL);
  scrollbar = XtVaCreateManagedWidget("shift_y_scrollbar",
				      scrollbarWidgetClass,
				      box,
				      XtNorientation,XtorientHorizontal,
				      NULL);
  XtAddCallback(scrollbar,
		XtNjumpProc,
		shift_y_scrollbar_jump,
		NULL);
  shell = XtVaCreatePopupShell("shell",
			       shellWidgetClass,
			       toplevel,
			       NULL);
  time(&t);
  earthwidget = XtVaCreateManagedWidget("earth",
					earthWidgetClass,
					shell,
					XtNtime,	t,
					NULL);
  XtPopup(shell,XtGrabNone);
  XtRealizeWidget(toplevel);
  XtAppMainLoop(app_context);
  exit(0);
}

int			main(argc,argv)
int			argc;
char			**argv;
{
  t_opt_context		oc;
  t_boolean		trargsbuf[256];
  t_boolean		troptsbuf[256];
  t_status              status;

#ifdef DEBUG
  a_debug_init();
  xearth_debug_init();
#endif
  assert(opt_check(main_opts,ARRAY_COUNT(main_opts)) == 0);
  oc.tr_args = trargsbuf;
  oc.nb_tr_args = sizeof (trargsbuf);
  oc.tr_opts = troptsbuf;
  oc.nb_tr_opts = sizeof (troptsbuf);
  oc.argc = &argc;
  oc.argv = argv;
  oc.opts = main_opts;
  oc.nb_opts = ARRAY_COUNT(main_opts);
  oc.base_addr = NULL;
  if ((status = opt_get(&oc)) < 0)
    {
      err_print(-status,"couldn't get options");
      usage();
    }
  if (help)
    usage();
#ifdef DEBUG_MALLOC
  if (debug_malloc)
    {
      gdm_init();
      global_debug_malloc = TRUE;
      gdm.verbose = debug_malloc_verbose;
      gdm.go_on = FALSE;
      gdm.regexp = regexp;
    }
#endif
  doit(argc,argv);
}
