/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 ***                                                           ***
 ***          Initialize the widget Library                    ***
 ***                                                           ***
 *****************************************************************/
#define _EZ_WIDGET_INIT_C_

#include "EZ_Widget.h"
/*****************************************************************
 *
 *     Function implemented in this file.
 */
void EZ_InitializeXrm MY_ANSIARGS((char *className, XrmOptionDescRec *optsTable,
				   int noptions, int *argc, char **argv,
				   char *fbkresrc,int initgl));
void    EZ_Initialize MY_ANSIARGS((int ac, char **av, int flag));
Display *EZ_GetDisplay MY_ANSIARGS((void));
Visual  *EZ_GetVisual MY_ANSIARGS((void));
Colormap EZ_GetColormap MY_ANSIARGS((void));
int      EZ_GetDepth  MY_ANSIARGS((void));
Window   EZ_GetWidgetWindow MY_ANSIARGS((EZ_Widget *widget));
Window  EZ_GetCommunicationWindow MY_ANSIARGS((void));
int     EZ_GetScreen MY_ANSIARGS((void));
void    EZ_GetDisplayInfo MY_ANSIARGS((Display **dpy, int *scrn, Visual **vis, int *depth));
void    EZ_GetDisplaySize MY_ANSIARGS((int *w, int *h));
void    EZ_DisableHighlight MY_ANSIARGS((void));
void    EZ_EnableHighlight MY_ANSIARGS((void));
void    EZ_DisableLabelOffset MY_ANSIARGS((void));
void    EZ_EnableLabelOffset MY_ANSIARGS((void));
void    EZ_DisableSliderDepression MY_ANSIARGS((void));
void    EZ_EnableSliderDepression MY_ANSIARGS((void));
void    EZ_Shutdown MY_ANSIARGS((void));
void    EZ_ShutdownA MY_ANSIARGS((void));
void    EZ_DisableImageDithering MY_ANSIARGS((void));
void    EZ_EnableImageDithering MY_ANSIARGS((void));
void    EZ_EnableBubbleHelp MY_ANSIARGS((void));
void    EZ_DisableBubbleHelp MY_ANSIARGS((void));

void    EZ_StartAsIcon  MY_ANSIARGS((int));
/******************************************************************************/
void    EZ_FlashWidgetWindowBorder MY_ANSIARGS((EZ_Widget *widget, Drawable drawable,
						int x, int y, int w,int h));
void    EZ_FlashWidgetBorder MY_ANSIARGS((EZ_Widget *widget));
char    *EZ_LibraryVersion MY_ANSIARGS((void));
EZ_Widget *EZ_GetBubbleHelp MY_ANSIARGS((void));
/******************************************************************************/

void  EZ_ResetGlobalVariables MY_ANSIARGS((void));
void  EZ_SetClientMessageHandler MY_ANSIARGS(( EZ_EventHandler handler, void *data));
void  EZ_UpdateBgGCs MY_ANSIARGS((void));
void  EZ_UpdateFgGCs MY_ANSIARGS((void));
/*******************************************************************
 *  This is the default event handle. It only uses the common part
 *  of the widget union. Private data are never used.
 */
void   EZ_ComputeWidgetUnknownSize MY_ANSIARGS((EZ_Widget *widget, int *w, int *h));
void   EZ_UnkownEventHandle MY_ANSIARGS((EZ_Widget *widget, XEvent *event));
void   EZ_DrawWidgetUnknown MY_ANSIARGS((EZ_Widget *widget));
void   EZ_FreeUnknownData  MY_ANSIARGS((EZ_Widget *widget));

/****************** default handle for items ***************/
void   EZ_ComputeItemUnknownSize MY_ANSIARGS((EZ_Item *item, int *w, int *h)); 
void   EZ_DrawItemUnknown MY_ANSIARGS((EZ_Widget *widget,
				       Drawable  drawable,
				       int       x0, int y0,
				       EZ_Item   *item,
				       int       Rx, int Ry, int Rw, int Rh));
void   EZ_UpdateItemUnknown MY_ANSIARGS((EZ_Widget *widget,
					 Drawable  drawable,
					 EZ_Item   *item,
					 int       Rx, int Ry, int Rw, int Rh));
void   EZ_HighlightItemUnknown MY_ANSIARGS((EZ_Widget *widget,
					    Drawable  drawable,
					    EZ_Item   *item,
					    unsigned long fg, unsigned long bg,
					    int       Rx, int Ry, int Rw, int Rh));       
void   EZ_UnknownItemData  MY_ANSIARGS((EZ_Item *item));
int    EZ_UnknownItemPick   MY_ANSIARGS((EZ_Item *item, int x, int y));


/****************************************************************/
static void flashBDTimerCallback MY_ANSIARGS((EZ_Timer *timer, void *data));
static void InitEZWGL2  MY_ANSIARGS((void));
/****************************************************************/

static EZ_WidgetHandle EZ_DefaultHandle =
{ 
  EZ_ComputeWidgetUnknownSize,
  EZ_DrawWidgetUnknown,
  EZ_FreeUnknownData,
  EZ_UnkownEventHandle,
};

static EZ_DpyItemHandle EZ_DefaultItemHandle =
{
  EZ_ComputeItemUnknownSize,
  EZ_DrawItemUnknown,
  EZ_UpdateItemUnknown,
  EZ_HighlightItemUnknown,
  EZ_UnknownItemData,
  EZ_UnknownItemPick
};

/*****************************************************************
 *
 *     Global Variables;
 */

Atom     EZ_WM_DELETE_WINDOW_ATOM;
Atom     EZ_WM_PROTOCOLS_ATOM;
Atom     EZ_DND_DRAG_START_ATOM;
Atom     EZ_DND_DRAG_FINISH_ATOM;
Atom     EZ_DND_DROP_START_ATOM;
Atom     EZ_DND_DROP_FINISH_ATOM;
Atom     EZ_MESSAGE_ATOM;

XSInfo           XServerInfo;
EZ_WidgetHandle  *EZ_WidgetHandlingFunctions[EZ_TOTAL_NUMBER_OF_WIDGETS];
EZ_Widget        *EZ_BubbleHelp = (EZ_Widget *)NULL;
EZ_Widget        *EZ_CurrentFlashWidget = (EZ_Widget *)NULL;
EZ_BitmapHTEntry *EZ_SnapShotBitmap = (EZ_Bitmap *)NULL;
Time             EZ_LastButton1ClickTime = 0;
EZ_DnDInfoStruct EZ_DnDInfo;
EZ_EventHandlerStruct *EZ_NoWidgetEventHandlers = NULL;

char              EZ_HighlightEnabled = 1;
char              EZ_OffsetEnabled    = 1;
char              EZ_DepresionDisabled = 0;
char              EZ_BubbleHelpOn = 1;
char              EZ_DitherImageOn = 1;
char              EZ_PointerGrabed = 0;
char              EZ_LabelFontIsBold = 1;
char              EZ_TopWinState = 1; /* NormalState */

int               EZ_ServerGrabed = 0;
int               EZ_CounterUT = 0;

EZ_Widget         *EZ_LastDropSite = (EZ_Widget *) NULL;

unsigned long     EZ_ApplicationSetupTime = 0;
unsigned long     EZ_KbdFocusHighlightColor = 0;
/*****************************************************************/
EZ_EventHandlerStruct EZ_ClientMessageHandler;
/*****************************************************************
 *
 *     Local Variables
 */
static int  EZ_WidgetLibHasBeenInitialized = 0;
/*******************************************************************
 ***                                                             ***
 ***            Initialize the widget library.                   ***
 ***                                                             ***
 *******************************************************************/
void EZ_InitializeXrm(className, optsTable, noptions,argc,argv,fbkresrc,initgl)
     char *className;
     XrmOptionDescRec *optsTable;
     int              noptions;
     int              *argc;
     char             **argv;
     char             *fbkresrc;
     int              initgl;
{
  if(EZ_WidgetLibHasBeenInitialized) return;
  
#if defined(EZ_MEM_DEBUG) || defined(EZ_DEBUG)
  {
    extern  void initialize_mem_debug_data();
    (void)initialize_mem_debug_data();
  }
#endif
  /*------------------------------
   * Initialize X11. This must be
   * the first thing to do!
   *-----------------------------*/
  EZ_InitXrmAndX11(className, 
		   optsTable, noptions,
		   argc, argv, 
		   fbkresrc,
		   initgl);
  InitEZWGL2();
}
/****************************************************************/
void  EZ_Initialize(ac,av,initgl)
     int ac; char **av;
     int initgl;
{
  if(EZ_WidgetLibHasBeenInitialized) return;

#if defined(EZ_MEM_DEBUG) || defined(EZ_DEBUG)
  {
    extern  void initialize_mem_debug_data();
    (void)initialize_mem_debug_data();
  }
#endif

  /*------------------------------
   * Initialize X11. This must be
   * the first thing to do!
   *-----------------------------*/
  /* 3-22-98: EZ_InitXrmAndX11 modifies av and ac.
   * This is not compatibale with the behavior of
   * old versions of EZWGL. Make a local copy
   * of args and pass them to EZ_InitXrmAndX11
   */
  {
    int i, length = 0;
    char *ptr, *data, **argv;

    for(i = 0; i < ac; i++) length += strlen(av[i]) + 2;
    data = (char *)my_malloc( (length)* sizeof(char), _MISC_DATA_);
    argv = (char **) my_malloc( (ac + 1) * sizeof(char *), _MISC_DATA_);
    ptr = data;
    for(i = 0; i < ac; i++)
      {
	argv[i] = ptr;
	(void)strcpy(ptr, av[i]);
	ptr += strlen(av[i])+1;
      }
    EZ_InitXrmAndX11(NULL, 
		     NULL, 0,
		     &ac, argv, 
		     NULL,
		     initgl);
    (void)my_free(data);
    (void)my_free(argv);
  }
  InitEZWGL2();
}
/*********************************************************************/

static void InitEZWGL2()
{
  /*------------------------------
   * We initialize GL anyway, to
   * save the user the trouble of
   * core dumps.  So the only 
   * difference between initgl or
   * not is the # of colors 
   * allocated.
   *-----------------------------*/
  /* if(initgl) */  
  EZ_InitializeGL();

  /*---------------------------------
   * Device Buttons.
   *--------------------------------*/
  EZ_Btn1 = Button1;
  EZ_Btn2 = Button2;
  EZ_Btn3 = Button3;

  /*---------------------------------
   * Create the GC's to be used.
   * check if we need to alter the
   * default fonts.
   *------------------------------*/
  EZ_InitializeWidgetGC();
  EZ_SetDefaultAttributesFromResources(); /* fonts + global flags */
  /*---------------------------------
   * Initialize the widget hash table
   *--------------------------------*/
  EZ_InitializeWidgetHT();

  /*---------------------------------
   * Initialize the event hash table
   *--------------------------------*/
  EZ_InitializeEventHT();

  /*---------------------------------
   * Initialize the text property ht
   *--------------------------------*/
  EZ_InitializeTxetPropertyHashTable();

  /*---------------------------------
   * Clear Widget Handling Functions
   *--------------------------------*/
  {
    int i;
    for(i = 0; i < EZ_TOTAL_NUMBER_OF_WIDGETS; i++)
      EZ_WidgetHandlingFunctions[i] = (EZ_WidgetHandle *) &EZ_DefaultHandle;

    /* display item handle */
    for(i = 0; i < EZ_TOTAL_NUMBER_OF_ITEMS; i++)
      EZ_DpyItemHandlers[i] = (EZ_DpyItemHandle *) &EZ_DefaultItemHandle;
  }
  
  /*---------------------------------
   * Defint two cursors to be used.
   *--------------------------------*/
  EZ_InitializeCursors();

  /*---------------------------------
   * Initialize timers
   *--------------------------------*/
  EZ_InitializeTimers();
  EZ_InitializeInputIdList();
  EZ_InitGarbageList();
  EZ_InitializeMessageHandlers();

  /*--------------------------------------
   * Create a few Atoms for internal use
   *-------------------------------------*/
  EZ_APPLICATION_ATOM = XInternAtom(EZ_Display,"EZWGL_APPLICATION", False);
  EZ_WLIST_ATOM = XInternAtom(EZ_Display,"EZWGL_WLIST", False);
  EZ_EMBEDING_MESSAGE_ATOM = XInternAtom(EZ_Display,"EZWGL_EMBEDING_MSG", False);

  EZ_DND_DRAG_START_ATOM = XInternAtom(EZ_Display,"EZ_DND_DRAG_START", False);
  EZ_DND_DRAG_FINISH_ATOM = XInternAtom(EZ_Display,"EZ_DND_DRAG_FINISH", False);
  EZ_DND_DROP_START_ATOM = XInternAtom(EZ_Display,"EZ_DND_DROP_START", False);
  EZ_DND_DROP_FINISH_ATOM = XInternAtom(EZ_Display,"EZ_DND_DROP_FINISH", False);

  /* WM protocol. Thanks to: Tomi Sarvela <orava@nether.tky.hut.fi> */
  EZ_WM_DELETE_WINDOW_ATOM = XInternAtom(EZ_Display, "WM_DELETE_WINDOW", False);
  EZ_WM_PROTOCOLS_ATOM =  XInternAtom(EZ_Display, "WM_PROTOCOLS", False);

  EZ_MESSAGE_ATOM =  XInternAtom(EZ_Display, "EZ_MESSAGE", False);
  /*---------------------------------
   * Must be set here !!! 
   * the rest of the code need it.
   *--------------------------------*/  
  EZ_WidgetLibHasBeenInitialized = 1;

  /*---------------------------------
   * something for Drag and Drop
   *--------------------------------*/
  EZ_InitializeDnD();
  /*---------------------------------
   * register this application
   *--------------------------------*/
  EZ_RegisterApplication();

  /*---------------------------------
   * ClientMessage handler
   *--------------------------------*/ 
  memset(&EZ_ClientMessageHandler, 0, sizeof(EZ_EventHandlerStruct));

  (void)EZ_CreateTimer(0,765432,-1, (EZ_CallBack)flashBDTimerCallback, NULL, 0);

  /*---------------------------------
   * Bubble help
   *--------------------------------*/  
  EZ_BubbleHelp = EZ_CreateFreeLabel(NULL,"Bubble Help");
  EZ_SetWidgetCINames(EZ_BubbleHelp, "Bubble","bubble");
  EZ_WidgetBorderWidth(EZ_BubbleHelp) = 1;
  EZ_WidgetBorderStyle(EZ_BubbleHelp) = EZ_BORDER_FLAT;
  EZ_SetWidgetTransientFlag(EZ_BubbleHelp);
  {
    unsigned long pixel = EZ_ColorArray[YELLOW];
    EZ_WidgetBackground(EZ_BubbleHelp) = pixel;
    EZ_WidgetJustification(EZ_BubbleHelp)= EZ_CENTER;
    if(EZ_Visual->class != TrueColor && EZ_Visual->class != DirectColor)
      EZ_DarkColor[pixel].pixel = EZ_ColorArray[DARKRED];
  }
  EZ_GetAndUseWidgetResources(EZ_BubbleHelp); /* set options from resources */
  EZ_CreateWindowForWidget(EZ_BubbleHelp, 0);
}


Display *EZ_GetDisplay()
{
  return(EZ_Display);
}

int EZ_GetScreen()
{
  return(EZ_ScreenNum);
}

Visual *EZ_GetVisual()
{
  return(EZ_Visual);
}

Colormap EZ_GetColormap()
{
  return(EZ_Colormap);
}

int EZ_GetDepth()
{
  return(EZ_Depth);
}

Window EZ_GetWidgetWindow(widget)
     EZ_Widget *widget;
{
  if(widget) return(EZ_WidgetWindow(widget));
  return((Window)NULL);
}
Window  EZ_GetCommunicationWindow()
{
  return(EZ_DummyWindow);
}
/***************************************************************/


void  EZ_GetDisplayInfo(dpy, scrn, visual, depth)
     Display **dpy;
     int     *scrn, *depth;
     Visual  **visual;
{
  *dpy = EZ_Display;
  *scrn = EZ_ScreenNum;
  *visual = EZ_Visual;
  *depth = (int)EZ_Depth;
}

/*******************************************************************/
void EZ_UpdateBgGCs()
{
  if(EZ_WidgetLibHasBeenInitialized)
    {
      int i;
      unsigned long valuemask = GCForeground;
      XGCValues values;

      for(i = 1; i <= 7; i++)
	{
	  if(i != 3)
	    {
	      values.foreground = EZ_ColorArray[i];
	      XChangeGC(EZ_Display,EZ_GCList[i],valuemask, &values);
	    }
	}
    }
}
void EZ_UpdateFgGCs()
{
  if(EZ_WidgetLibHasBeenInitialized)
    {
      int i;
      unsigned long valuemask = GCForeground;
      XGCValues values;
      values.foreground = EZ_DefaultForeground;
      for(i = 1; i <= 4; i++)
	XChangeGC(EZ_Display,EZ_GCList[i+DARKRED],valuemask, &values);
    }
}
/*******************************************************************/
void EZ_SetKbdHighlightColor(color)
     char *color;
{
  EZ_KbdFocusHighlightColor = EZ_AllocateColorFromName(color);
}
void EZ_SetKbdHighlightColorRGB(r,g,b)
     int r,g,b;
{
  EZ_KbdFocusHighlightColor =  EZ_AllocateColorFromRGB(r,g,b);
}
/*******************************************************************/
void    EZ_DisableHighlight()
{
  EZ_HighlightEnabled = 0;
}
void    EZ_EnableHighlight()
{
  EZ_HighlightEnabled = 1;
}
void    EZ_DisableLabelOffset()
{
  EZ_OffsetEnabled = 0;
}
void    EZ_EnableLabelOffset()
{
  EZ_OffsetEnabled = 1;
}
void    EZ_TurnOnBubbleHelp() 
{
  EZ_BubbleHelpOn = 1;
}
void    EZ_TurnOffBubbleHelp() 
{
  EZ_BubbleHelpOn = 0;
}
void    EZ_EnableBubbleHelp() 
{
  EZ_BubbleHelpOn = 1;
}
void    EZ_DisableBubbleHelp() 
{
  EZ_BubbleHelpOn = 0;
}
void  EZ_DisableSliderDepression()
{
  EZ_DepresionDisabled = 1;
}
void  EZ_EnableSliderDepression()
{
  EZ_DepresionDisabled = 0;
}
/*******************************************************************/
extern void    EZ_DestroyWidgetGCsandFonts();
extern void    EZ_DestroyAllWidgets();
extern void    EZ_RemoveAllGlobalKeyEvents();
extern void    EZ_ClearTextKillBuffers();
extern void    EZ_DestroyAllBitmaps();
extern void    EZ_DestroyAllTimers();
extern void    EZ_ClearFocusRecord();

void EZ_ShutdownA()
{
  XSync(EZ_Display, True);
  EZ_DestroyAllWidgets();
  XDestroyWindow(EZ_Display,EZ_DummyWindow);
  EZ_DummyWindow = (Window) NULL;
  EZ_DestroyWidgetGCsandFonts();
  EZ_RemoveAllGlobalKeyEvents();
  EZ_ClearTextKillBuffers();
  EZ_ClearTextPropHT();
  EZ_DestroyAllBitmaps();
  EZ_DestroyAllTimers();
  EZ_DestroyInputIdList();
  EZ_DestroyDnDList();
  EZ_ClearFocusRecord();
  EZ_FreeAllCursors();
  EZ_DeleteAllUDFWidgetHandles();
  EZ_DestroyXrmDB();
  /* delete all NoWidget event handlers */
  EZ_RemoveAllCallBacksWork((EZ_CallBackStruct **)&EZ_NoWidgetEventHandlers);
  
  EZ_GLExit();
}

void EZ_Shutdown()
{
  if(EZ_WidgetLibHasBeenInitialized == 0) return;;
  EZ_ShutdownA();
  XCloseDisplay(EZ_Display);

#if defined(EZ_MEM_DEBUG) || defined(EZ_DEBUG)  
  {
    extern void  EZ_DumpAndClearMemoryRecords();
    EZ_DumpAndClearMemoryRecords();
  }
#endif
  /* 
   * Bug found by: Arno Dabekaussen <piemail!arnodab@relay.NL.net> 08-01-97
   * Need to reset all "global" variables to their default values.
   */
  EZ_ResetGlobalVariables();
  EZ_WidgetLibHasBeenInitialized = 0;
}

/***********************************************************************
 *
 * widget handle for widget unknown...
 */

void EZ_ComputeWidgetUnknownSize(widget, w,h)
     EZ_Widget *widget;
     int       *w, *h;
{
  int cw, ch, tmp;

  EZ_SetWidgetSizeComputedFlag(widget);
  tmp = EZ_WidgetBorderWidth(widget);
  cw = EZ_WidgetPadX(widget) + tmp;
  ch = EZ_WidgetPadY(widget) + tmp;

  *w = cw + cw;
  *h = ch + ch;
}
/*******************************************************************/
void EZ_FreeUnknownData(widget)
     EZ_Widget *widget;
{
}
/*******************************************************************/

void  EZ_DrawWidgetUnknown(wptr)
     EZ_Widget *wptr;
{
  int             w, h;
  Pixmap          pixmap;
  Window          win;
  GC              gc;
  unsigned long   bgpv;

  win = EZ_WidgetWindow(wptr);
  w   = EZ_WidgetWidth(wptr);
  h   = EZ_WidgetHeight(wptr);
  
  pixmap = XCreatePixmap(EZ_Display, win, w, h, EZ_Depth); 
  EZ_GetBackgroundGC(wptr, &gc,&bgpv, 0, 0);
  XFillRectangle(EZ_Display, pixmap, gc, 0,0, w, h); 
  
  EZ_DrawRectBorder(wptr, pixmap); 
  XCopyArea(EZ_Display,pixmap,win, EZ_WRITABLEGC,0,0,w,h,0,0); 
  XFreePixmap(EZ_Display, pixmap); 
}

/*******************************************************************/
void EZ_UnkownEventHandle(widget, event)
     EZ_Widget *widget;
     XEvent *event;
{
  if(event->type == Expose)  EZ_DrawWidget(widget);      
}

/*********************************************************************/
void EZ_EnableImageDithering()
{
  EZ_DitherImageOn = 1;
}
/*********************************************************************/
void EZ_DisableImageDithering()
{
  if(EZ_Visual->class == PseudoColor || EZ_Visual->class == GrayScale)
    EZ_DitherImageOn = 0;
}
/*********************************************************************/
void  EZ_SetClientMessageHandler(handler, data)
     EZ_EventHandler handler;
     void *data;
{
  EZ_ClientMessageHandler.handler = handler;
  EZ_ClientMessageHandler.data = data;
  EZ_ClientMessageHandler.internal = 0;
  EZ_ClientMessageHandler.next = NULL;
}
/*********************************************************************/
extern EZ_Widget *EZ_GrabedWidget;
/*
 * 1-15-97
 */
void  EZ_ResetGlobalVariables()
{
  { /* from this file */
    EZ_LastButton1ClickTime = 0;

    EZ_HighlightEnabled = 1;
    EZ_OffsetEnabled    = 1;
    EZ_DepresionDisabled = 0;
    EZ_BubbleHelp = (EZ_Widget *)NULL;
    EZ_GrabedWidget = (EZ_Widget *)NULL;
    EZ_CurrentFlashWidget = (EZ_Widget *)NULL;
    EZ_LastDropSite = (EZ_Widget *)NULL;
    EZ_SnapShotBitmap = (EZ_Bitmap *)NULL;
    EZ_BubbleHelpOn = 1;
    EZ_DitherImageOn = 1;
    EZ_PointerGrabed = 0;
    EZ_ServerGrabed = 0;
    EZ_CounterUT = 0;
    EZ_LabelFontIsBold = 1;

    EZ_TopWinState = 1;

    EZ_ApplicationSetupTime = 0;
    EZ_KbdFocusHighlightColor = 0;

    memset(&EZ_ClientMessageHandler, 0, sizeof(EZ_EventHandlerStruct));
    EZ_NoWidgetEventHandlers = NULL;
  }

  {
    extern void EZ_ResetGVDnDC MY_ANSIARGS((void));
    EZ_ResetGVDnDC();
  }

  {
    extern void EZ_ResetGVColorC MY_ANSIARGS((void));
    EZ_ResetGVColorC();
  }

  {
    extern void EZ_ResetGVX11InitC MY_ANSIARGS((void));
    EZ_ResetGVX11InitC();
  }

  {
    extern void EZ_ResetGVPopupC MY_ANSIARGS((void));
    EZ_ResetGVPopupC();
  }

  {
    extern void EZ_RestGVFocusC MY_ANSIARGS((void));
    EZ_RestGVFocusC();
  }

  {
    extern void EZ_ResetGVTreeDirC MY_ANSIARGS((void));
    EZ_ResetGVTreeDirC();
  }

  {
    extern void EZ_ResetGVButtonRC MY_ANSIARGS((void));
    EZ_ResetGVButtonRC();
  }
  {
    extern void EZ_ResetGarbageList MY_ANSIARGS((void));     
    EZ_ResetGarbageList();
  }

  {
    extern void EZ_ResetMessageHandlers();
    EZ_ResetMessageHandlers();
  }

  EZ_ClearFocusRecord();
}

/*********************************************************************/
void EZ_ComputeItemUnknownSize(item, w,h)
     EZ_Item *item; int *w, *h;
{ }
  
void EZ_DrawItemUnknown(widget, drawable, x0,y0, item, Rx,Ry,Rw,Rh)
     EZ_Widget *widget;
     Drawable  drawable;
     EZ_Item   *item;
     int       x0,  y0;
     int       Rx,  Ry,  Rw,  Rh;
{ }
void EZ_UpdateItemUnknown(widget, drawable, item,Rx,Ry,Rw,Rh)
     EZ_Widget *widget;
     Drawable  drawable;
     EZ_Item   *item;
     int       Rx,  Ry,  Rw,  Rh;
{ }
void EZ_HighlightItemUnknown(widget, drawable, item, fg,bg,Rx,Ry,Rw,Rh)
     EZ_Widget *widget;
     Drawable  drawable;
     EZ_Item   *item;
     unsigned long fg, bg;
     int       Rx,  Ry,  Rw,  Rh;
{ }

void EZ_UnknownItemData(item)
     EZ_Item *item;
{ }
int  EZ_UnknownItemPick(item, x, y)
     EZ_Item *item; int x, y;
{ return(0); }
/*********************************************************************/
static void flashBDTimerCallback(timer, data)
     EZ_Timer *timer; void *data;
{
  EZ_Widget *widget = EZ_CurrentFlashWidget;
  if(widget && EZ_LookupWidgetFromAllHT(widget) == widget)
    {
      if(EZ_WidgetMapped(widget))
	{
	  Window win = EZ_WidgetWindow(widget);  
	  EZ_FlashWidgetWindowBorder(widget, win, 0, 0,
				     EZ_WidgetWidth(widget)-1,
				     EZ_WidgetHeight(widget)-1);
	}
    }
  else EZ_CurrentFlashWidget = NULL;
}
void EZ_FlashWidgetWindowBorder(widget, drawable, x,y,w,h)
     EZ_Widget *widget;
     Drawable drawable;
     int x,y,w,h;
{
  XPoint points[5];
  GC gc;
  EZ_GetMovingDashedLineGC(&gc);
  points[0].x = x;     points[0].y = y;
  points[1].x = x+w;   points[1].y = y;
  points[2].x = x+w;   points[2].y = y+h;
  points[3].x = x;     points[3].y = y+h;
  points[4].x = x;     points[4].y = y;
  XDrawLines(EZ_Display, drawable, gc, points, 5, CoordModeOrigin);
}

void EZ_FlashWidgetBorder(widget)
     EZ_Widget *widget;
{
  EZ_Widget *tmp = EZ_CurrentFlashWidget;

  EZ_CurrentFlashWidget = widget;  
  if(tmp && EZ_LookupWidgetFromAllHT(tmp) == tmp && EZ_WidgetMapped(tmp))
    EZ_DrawWidget(tmp);
  if(widget && EZ_LookupWidgetFromAllHT(widget) == widget)
    {
      if(EZ_WidgetMapped(widget)) EZ_DrawWidget(widget);
    }
  else  EZ_CurrentFlashWidget = NULL;
}
/*************************************************************************/
void EZ_GetDisplaySize(w_ret, h_ret) int *w_ret, *h_ret;
{
  if(w_ret) *w_ret = EZ_XDisplayWidth;
  if(h_ret) *h_ret = EZ_XDisplayHeight;
}
/*************************************************************************/

char *EZ_LibraryVersion()
{
static char  version[] =
#include "VERSION"
;
return(version);
}

EZ_Widget *EZ_GetBubbleHelp() { return(EZ_BubbleHelp);}
void EZ_StartAsIcon(v) 
{  EZ_TopWinState = (v != 0 ? IconicState: NormalState); }
/*************************************************************************/
#undef _EZ_WIDGET_INIT_C_
