/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
 /**********************************************************************
  *
  * list of all X cursors fonts
  *
  *********************************************************************/

#ifndef EZ_C_NUM_GLYPHS
#include <X11/cursorfont.h>
#define EZ_C_NUM_GLYPHS            XC_num_glyphs
#define EZ_TOTAL_NUM_OF_CURSORS    (EZ_C_NUM_GLYPHS+EZ_C_NUM_GLYPHS)

#define EZ_C_X_CURSOR              XC_X_cursor
#define EZ_C_ARROW                 XC_arrow
#define EZ_C_BASED_ARROW_DOWN      XC_based_arrow_down
#define EZ_C_BASED_ARROW_UP        XC_based_arrow_up
#define EZ_C_BOAT                  XC_boat
#define EZ_C_BOGOSITY              XC_bogosity
#define EZ_C_BOTTOM_LEFT_CORNER    XC_bottom_left_corner
#define EZ_C_BOTTOM_RIGHT_CORNER   XC_bottom_right_corner
#define EZ_C_BOTTOM_SIDE           XC_bottom_side
#define EZ_C_BOTTOM_TEE            XC_bottom_tee
#define EZ_C_BOX_SPIRAL            XC_box_spiral
#define EZ_C_CENTER_PTR            XC_center_ptr
#define EZ_C_CIRCLE                XC_circle
#define EZ_C_CLOCK                 XC_clock
#define EZ_C_COFFEE_MUG            XC_coffee_mug
#define EZ_C_CROSS                 XC_cross
#define EZ_C_CROSS_REVERSE         XC_cross_reverse
#define EZ_C_CROSSHAIR             XC_crosshair
#define EZ_C_DIAMOND_CROSS         XC_diamond_cross
#define EZ_C_DOT                   XC_dot
#define EZ_C_DOTBOX                XC_dotbox
#define EZ_C_DOUBLE_ARROW          XC_double_arrow
#define EZ_C_DRAFT_LARGE           XC_draft_large
#define EZ_C_DRAFT_SMALL           XC_draft_small
#define EZ_C_DRAPED_BOX            XC_draped_box
#define EZ_C_EXCHANGE              XC_exchange
#define EZ_C_FLEUR                 XC_fleur
#define EZ_C_GOBBLER               XC_gobbler
#define EZ_C_GUMBY                 XC_gumby
#define EZ_C_HAND1                 XC_hand1
#define EZ_C_HAND2                 XC_hand2
#define EZ_C_HEART                 XC_heart
#define EZ_C_ICON                  XC_icon
#define EZ_C_IRON_CROSS            XC_iron_cross
#define EZ_C_LEFT_PTR              XC_left_ptr
#define EZ_C_LEFT_SIDE             XC_left_side
#define EZ_C_LEFT_TEE              XC_left_tee
#define EZ_C_LEFTBUTTON            XC_leftbutton
#define EZ_C_LL_ANGLE              XC_ll_angle
#define EZ_C_LR_ANGLE              XC_lr_angle
#define EZ_C_MAN                   XC_man
#define EZ_C_MIDDLEBUTTON          XC_middlebutton
#define EZ_C_MOUSE                 XC_mouse
#define EZ_C_PENCIL                XC_pencil
#define EZ_C_PIRATE                XC_pirate
#define EZ_C_PLUS                  XC_plus
#define EZ_C_QUESTION_ARROW        XC_question_arrow
#define EZ_C_RIGHT_PTR             XC_right_ptr
#define EZ_C_RIGHT_SIDE            XC_right_side
#define EZ_C_RIGHT_TEE             XC_right_tee
#define EZ_C_RIGHTBUTTON           XC_rightbutton
#define EZ_C_RTL_LOGO              XC_rtl_logo
#define EZ_C_SAILBOAT              XC_sailboat
#define EZ_C_SB_DOWN_ARROW         XC_sb_down_arrow
#define EZ_C_SB_H_DOUBLE_ARROW     XC_sb_h_double_arrow
#define EZ_C_SB_LEFT_ARROW         XC_sb_left_arrow
#define EZ_C_SB_RIGHT_ARROW        XC_sb_right_arrow
#define EZ_C_SB_UP_ARROW           XC_sb_up_arrow
#define EZ_C_SB_V_DOUBLE_ARROW     XC_sb_v_double_arrow
#define EZ_C_SHUTTLE               XC_shuttle
#define EZ_C_SIZING                XC_sizing
#define EZ_C_SPIDER                XC_spider
#define EZ_C_SPRAYCAN              XC_spraycan
#define EZ_C_STAR                  XC_star
#define EZ_C_TARGET                XC_target
#define EZ_C_TCROSS                XC_tcross
#define EZ_C_TOP_LEFT_ARROW        XC_top_left_arrow
#define EZ_C_TOP_LEFT_CORNER       XC_top_left_corner
#define EZ_C_TOP_RIGHT_CORNER      XC_top_right_corner
#define EZ_C_TOP_SIDE              XC_top_side
#define EZ_C_TOP_TEE               XC_top_tee
#define EZ_C_TREK                  XC_trek
#define EZ_C_UL_ANGLE              XC_ul_angle
#define EZ_C_UMBRELLA              XC_umbrella
#define EZ_C_UR_ANGLE              XC_ur_angle
#define EZ_C_WATCH                 XC_watch
#define EZ_C_XTERM                 XC_xterm                      
#endif
/*********************************************************/
#ifndef _EZ_CURSOR_H_
#define _EZ_CURSOR_H_
#ifdef _EZ_RESOURCE_C_
XrmQuark   EZ_XCQNames[EZ_TOTAL_NUM_OF_CURSORS];
#else
extern XrmQuark  EZ_XCQNames[];
#endif
#endif
/*********************************************************/
#ifdef EZ_CursorIDNamePair
EZ_CursorIDNamePair(EZ_C_X_CURSOR,              "XC_X_cursor")
EZ_CursorIDNamePair(EZ_C_ARROW,                 "XC_arrow")
EZ_CursorIDNamePair(EZ_C_BASED_ARROW_DOWN,      "XC_based_arrow_down")
EZ_CursorIDNamePair(EZ_C_BASED_ARROW_UP,        "XC_based_arrow_up")
EZ_CursorIDNamePair(EZ_C_BOAT,                  "XC_boat")
EZ_CursorIDNamePair(EZ_C_BOGOSITY,              "XC_bogosity")
EZ_CursorIDNamePair(EZ_C_BOTTOM_LEFT_CORNER,    "XC_bottom_left_corner")
EZ_CursorIDNamePair(EZ_C_BOTTOM_RIGHT_CORNER,   "XC_bottom_right_corner")
EZ_CursorIDNamePair(EZ_C_BOTTOM_SIDE,           "XC_bottom_side")
EZ_CursorIDNamePair(EZ_C_BOTTOM_TEE,            "XC_bottom_tee")
EZ_CursorIDNamePair(EZ_C_BOX_SPIRAL,            "XC_box_spiral")
EZ_CursorIDNamePair(EZ_C_CENTER_PTR,            "XC_center_ptr")
EZ_CursorIDNamePair(EZ_C_CIRCLE,                "XC_circle")
EZ_CursorIDNamePair(EZ_C_CLOCK,                 "XC_clock")
EZ_CursorIDNamePair(EZ_C_COFFEE_MUG,            "XC_coffee_mug")
EZ_CursorIDNamePair(EZ_C_CROSS,                 "XC_cross")
EZ_CursorIDNamePair(EZ_C_CROSS_REVERSE,         "XC_cross_reverse")
EZ_CursorIDNamePair(EZ_C_CROSSHAIR,             "XC_crosshair")
EZ_CursorIDNamePair(EZ_C_DIAMOND_CROSS,         "XC_diamond_cross")
EZ_CursorIDNamePair(EZ_C_DOT,                   "XC_dot")
EZ_CursorIDNamePair(EZ_C_DOTBOX,                "XC_dotbox")
EZ_CursorIDNamePair(EZ_C_DOUBLE_ARROW,          "XC_double_arrow")
EZ_CursorIDNamePair(EZ_C_DRAFT_LARGE,           "XC_draft_large")
EZ_CursorIDNamePair(EZ_C_DRAFT_SMALL,           "XC_draft_small")
EZ_CursorIDNamePair(EZ_C_DRAPED_BOX,            "XC_draped_box")
EZ_CursorIDNamePair(EZ_C_EXCHANGE,              "XC_exchange")
EZ_CursorIDNamePair(EZ_C_FLEUR,                 "XC_fleur")
EZ_CursorIDNamePair(EZ_C_GOBBLER,               "XC_gobbler")
EZ_CursorIDNamePair(EZ_C_GUMBY,                 "XC_gumby")
EZ_CursorIDNamePair(EZ_C_HAND1,                 "XC_hand1")
EZ_CursorIDNamePair(EZ_C_HAND2,                 "XC_hand2")
EZ_CursorIDNamePair(EZ_C_HEART,                 "XC_heart")
EZ_CursorIDNamePair(EZ_C_ICON,                  "XC_icon")
EZ_CursorIDNamePair(EZ_C_IRON_CROSS,            "XC_iron_cross")
EZ_CursorIDNamePair(EZ_C_LEFT_PTR,              "XC_left_ptr")
EZ_CursorIDNamePair(EZ_C_LEFT_SIDE,             "XC_left_side")
EZ_CursorIDNamePair(EZ_C_LEFT_TEE,              "XC_left_tee")
EZ_CursorIDNamePair(EZ_C_LEFTBUTTON,            "XC_leftbutton")
EZ_CursorIDNamePair(EZ_C_LL_ANGLE,              "XC_ll_angle")
EZ_CursorIDNamePair(EZ_C_LR_ANGLE,              "XC_lr_angle")
EZ_CursorIDNamePair(EZ_C_MAN,                   "XC_man")
EZ_CursorIDNamePair(EZ_C_MIDDLEBUTTON,          "XC_middlebutton")
EZ_CursorIDNamePair(EZ_C_MOUSE,                 "XC_mouse")
EZ_CursorIDNamePair(EZ_C_PENCIL,                "XC_pencil")
EZ_CursorIDNamePair(EZ_C_PIRATE,                "XC_pirate")
EZ_CursorIDNamePair(EZ_C_PLUS,                  "XC_plus")
EZ_CursorIDNamePair(EZ_C_QUESTION_ARROW,        "XC_question_arrow")
EZ_CursorIDNamePair(EZ_C_RIGHT_PTR,             "XC_right_ptr")
EZ_CursorIDNamePair(EZ_C_RIGHT_SIDE,            "XC_right_side")
EZ_CursorIDNamePair(EZ_C_RIGHT_TEE,             "XC_right_tee")
EZ_CursorIDNamePair(EZ_C_RIGHTBUTTON,           "XC_rightbutton")
EZ_CursorIDNamePair(EZ_C_RTL_LOGO,              "XC_rtl_logo")
EZ_CursorIDNamePair(EZ_C_SAILBOAT,              "XC_sailboat")
EZ_CursorIDNamePair(EZ_C_SB_DOWN_ARROW,         "XC_sb_down_arrow")
EZ_CursorIDNamePair(EZ_C_SB_H_DOUBLE_ARROW,     "XC_sb_h_double_arrow")
EZ_CursorIDNamePair(EZ_C_SB_LEFT_ARROW,         "XC_sb_left_arrow")
EZ_CursorIDNamePair(EZ_C_SB_RIGHT_ARROW,        "XC_sb_right_arrow")
EZ_CursorIDNamePair(EZ_C_SB_UP_ARROW,           "XC_sb_up_arrow")
EZ_CursorIDNamePair(EZ_C_SB_V_DOUBLE_ARROW,     "XC_sb_v_double_arrow")
EZ_CursorIDNamePair(EZ_C_SHUTTLE,               "XC_shuttle")
EZ_CursorIDNamePair(EZ_C_SIZING,                "XC_sizing")
EZ_CursorIDNamePair(EZ_C_SPIDER,                "XC_spider")
EZ_CursorIDNamePair(EZ_C_SPRAYCAN,              "XC_spraycan")
EZ_CursorIDNamePair(EZ_C_STAR,                  "XC_star")
EZ_CursorIDNamePair(EZ_C_TARGET,                "XC_target")
EZ_CursorIDNamePair(EZ_C_TCROSS,                "XC_tcross")
EZ_CursorIDNamePair(EZ_C_TOP_LEFT_ARROW,        "XC_top_left_arrow")
EZ_CursorIDNamePair(EZ_C_TOP_LEFT_CORNER,       "XC_top_left_corner")
EZ_CursorIDNamePair(EZ_C_TOP_RIGHT_CORNER,      "XC_top_right_corner")
EZ_CursorIDNamePair(EZ_C_TOP_SIDE,              "XC_top_side")
EZ_CursorIDNamePair(EZ_C_TOP_TEE,               "XC_top_tee")
EZ_CursorIDNamePair(EZ_C_TREK,                  "XC_trek")
EZ_CursorIDNamePair(EZ_C_UL_ANGLE,              "XC_ul_angle")
EZ_CursorIDNamePair(EZ_C_UMBRELLA,              "XC_umbrella")
EZ_CursorIDNamePair(EZ_C_UR_ANGLE,              "XC_ur_angle")
EZ_CursorIDNamePair(EZ_C_WATCH,                 "XC_watch")
EZ_CursorIDNamePair(EZ_C_XTERM,                 "XC_xterm")              
#endif
