/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.2
 *  November 1997.  Release Version 1.3
 */
/*****************************************************************
 *
 *  Display items
 *
 *****************************************************************/
#define _EZ_CREATE_ITEM_C_

#include "EZ_Widget.h"
#include "EZ_WidgetConfig.h"
#include  <ctype.h>


/*****************************************************************
 *
 * public functions
 */
EZ_Item *EZ_CreateItem MY_VARARGS(int,  the_args)
     MY_VARARGS_DECL
{
  va_list         ap;
  EZ_Item         *item = NULL;
  int              type;

  type = (int)( MY_VARARGS_START(int, the_args, ap));

  switch(type)
    {
    case EZ_LABEL_ITEM:
      item = EZ_CreateLabelItem(NULL, NULL);
      break;
    case EZ_WIDGET_ITEM:
      item = EZ_CreateWidgetItem(NULL);
      break;
    default:
      break;
    }

  {
#include "EZ_ItemAttr.h"
  }
  
  return(item);
}
#undef _EZ_CREATE_ITEM_C_
