/************************** Example 9 ***********************/
#include "EZ.h"

void yesCallBack(EZ_Widget *widget, void *data)
{
  EZ_Shutdown();
  exit(0);
}

void noCallBack(EZ_Widget *widget, void *data)
{
  if(widget)
    {
      EZ_Widget *toplevel = (EZ_Widget *)data;

      EZ_HideWidget(toplevel); 
      EZ_ReleaseGrab();
    }
}

void buttonCallBack(EZ_Widget *widget, void *data)
{
  static EZ_Widget *dialogue = NULL;

  if(dialogue == NULL)
    {
      EZ_Widget *yes, *no;

      dialogue = EZ_CreateWidget(EZ_WIDGET_FRAME, NULL,
                                 EZ_LABEL_STRING, "Want to Quit?",
                                 EZ_TRANSIENT, 1, 0);
      yes = EZ_CreateWidget(EZ_WIDGET_NORMAL_BUTTON, dialogue,
                            EZ_LABEL_STRING, "Yes", 0);
      no  = EZ_CreateWidget(EZ_WIDGET_NORMAL_BUTTON, dialogue,
                            EZ_LABEL_STRING, "No", 0);
      EZ_AddWidgetCallBack(yes, EZ_CALLBACK, yesCallBack, NULL, 0);
      EZ_AddWidgetCallBack(no, EZ_CALLBACK, noCallBack, dialogue, 0);
      EZ_SetWidgetPtrData(dialogue, no);  /* rember 'no' button */
    }
  EZ_DisplayWidget(dialogue);
  EZ_SetGrab(dialogue); 
  EZ_SetFocusTo((EZ_Widget *)EZ_GetWidgetPtrData(dialogue));
}

main(int argc, char **argv)
{
  EZ_Widget *tmp,*frame, *button, *buttonA;

  EZ_Initialize(argc,argv,0); 
  
  tmp = EZ_CreateWidget(EZ_WIDGET_FRAME,NULL, 
                        EZ_FILL_MODE, EZ_FILL_BOTH, 0); 
  frame = EZ_CreateWidget(EZ_WIDGET_FRAME,tmp, 0);
  button  = EZ_CreateWidget(EZ_WIDGET_NORMAL_BUTTON, frame, 
                            EZ_LABEL_STRING, "Press me", 
                            EZ_UNDERLINE,0,
                            0);
  EZ_AddWidgetCallBack(button, EZ_CALLBACK, buttonCallBack, NULL,0);
  buttonA = EZ_CreateWidget(EZ_WIDGET_NORMAL_BUTTON, frame,
                            EZ_LABEL_STRING, "A Button",
                            0);
  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}
/************************** Example 9 ***********************/

