/****************************************************************
 ***                                                          ***
 ***     tlistbox.c                                           ***
 ***          TextWidget serves as a ListBox                  ***
 ***                                                          ***
 ***************************************************************/

#include "EZ.h"

/*************************************************************************/
static void listbox_callback(); 

static char *colors[] = {
#include "rgb.txt"
};

static EZ_TextProperty *TProp[754];

static char msg[] = "Double click on an item sets\n\
the foreground color of this Label.";

EZ_Widget *label;
/************************************************************************
 *
 *  fslistbox callback
 */
static void listbox_callback(widget)
     EZ_Widget *widget; /* is a text widget */
{
  char *str;
  int pos = EZ_TextGetPosition(widget);
  EZ_FreezeWidget(widget);
  EZ_TextBeginningOfLine(widget);
  EZ_TextSetMarker(widget);
  EZ_TextEndOfLine(widget);
  str = EZ_TextGetRegionString(widget);
  EZ_TextGotoPosition(widget, pos);
  EZ_UnFreezeWidget(widget);  
  EZ_ConfigureWidget(label, EZ_FOREGROUND, str, 0);
}    
/**************************************************************************/

main(ac,av) int ac; char **av;
{
  EZ_Widget *frame, *listbox;

  EZ_Initialize(ac,av,0);

  frame = EZ_CreateFrame(NULL, "A listbox");
  EZ_ConfigureWidget(frame,  EZ_STACKING, EZ_VERTICAL, 
		     EZ_WIDTH,300,EZ_HEIGHT,500,
		     EZ_FILL_MODE, EZ_FILL_BOTH,0);  
  label = EZ_CreateLabel(frame,msg);
  EZ_ConfigureWidget(label, EZ_HEIGHT, 0,
		     EZ_FONT_NAME, "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",
		     0);
  listbox = EZ_CreateTextWidget(frame,0,1,1); 
  EZ_ConfigureWidget(listbox,  EZ_CALL_BACK, listbox_callback, NULL,
		     EZ_BACKGROUND, "bisque4",
		     EZ_IPADX, 10, EZ_IPADY, 10, 0);		     
  {
    int i;

    for(i = 0; i < 753; i++)
      {
	TProp[i] = EZ_GetTextProperty(EZ_FOREGROUND, colors[i], 0);
	EZ_TextInsertStringWithProperty(listbox, colors[i],TProp[i]);
	EZ_TextInsertStringWithProperty(listbox, "\n",NULL);
      }
  }
  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}

/************************************************************************/
