/******************************************************************************
 *
 *  EZ GL Example 1.
 */
#include "EZ.h"

static void timer_callback(EZ_Timer *timer, void *ptr);
static void event_handle(EZ_Widget *, void *,int, XEvent *);  /* event handle   */
static void draw(EZ_Widget *canvas);                        /* repaint func   */
static float light_position[] = {10.0, 10.0, 10.0, 0.0};    /* light position */
static float specular[] = {1.0,1.0,1.0,1.0};
static float shininess[] = {4.0};

EZ_Widget *canvas;
main(int argc, char **argv)
{
  EZ_Initialize(argc, argv, 1);
  /*
   * Create a 3DCanvas, configure it and display it.
   * This must be done before invoking any routines
   * from the EZ graphics library.
   */

  canvas = EZ_Create3DCanvas(NULL);
  EZ_ConfigureWidget(canvas, EZ_WIDTH, 100, EZ_HEIGHT, 100, 
		     EZ_EVENT_HANDLE, event_handle, NULL,0);
  EZ_DisplayWidget(canvas);
  
  /*
   * setup display mode. GL calls must be after a canvas has been displayed.
   */
  EZ_AutoSelectBackBuffer();                          /* select a back buffer */
  EZ_RGBMode();                                       /* select color mode    */
  EZ_ShadeModel(EZ_SMOOTH);                           /* select shading model */
  EZ_Enable(EZ_CULL_FACE);                            /* enable backface cull */
  EZ_Enable(EZ_DEPTH_TEST);                           /* enable zbuffer       */
  EZ_Enable(EZ_LIGHTING);                             /* enable lighting      */
  EZ_Enable(EZ_LIGHT0);                               /* enable one light src */
  EZ_Lightfv(EZ_LIGHT0, EZ_POSITION, light_position); /* set light src pos    */
  EZ_DrawBuffer(EZ_BACK);                             /* draw into the backbuf*/
  EZ_MatrixMode(EZ_PROJECTION);           /* setup a fixed projection matrix  */
  EZ_Perspective(60.0, 1.0, 2.0, 30.0);   /* a perspective view, ...          */
  EZ_MatrixMode(EZ_MODELVIEW);            /* set matrix mode to model view    */
  EZ_LookAt(0.0,0.0,15.0, 0.0,0.0,0.0,    /* and set up a look at view        */
	    0.0,1.0, 0.0);                /* view up vector                   */
  EZ_Materialfv(EZ_FRONT,EZ_SPECULAR,specular);/* set material for front face */
  EZ_Materialfv(EZ_FRONT,EZ_SHININESS,shininess);
  EZ_CreateTimer(0,10000,-1,timer_callback, 0, 0);
  EZ_EventMainLoop();                     /* turn control to EZWGL            */
}

static float rotX = 0.0, rotY = 0.0, rotZ = 0.0;      /* rotation angles      */
static float scale = 1.0;                             /* zooming factor       */
static float yellow[] = {1.0, 1.0, 0.0, 0.0};         /* material color       */
static float red[] = {1.0, 0.1, 0.0, 0.0};            /* material color       */

static void draw(EZ_Widget *canvas)
{
  /* 
   * since we only have one 3DCanvas, which is always
   * active, we actually don't need the argument.
   */
  EZ_Clear(EZ_COLOR_BUFFER_BIT |                    /* clear the frame buffer */
	   EZ_DEPTH_BUFFER_BIT);                    /* and the zbuffer        */
  EZ_PushMatrix();                       /* save the current MODELVIEW matrix */
  EZ_Scale(scale,scale,scale);                      /* a uniform scale        */
  EZ_Rotate(rotX, 1.0, 0.0, 0.0 );                  /* rotate about X, Y & Z  */
  EZ_Rotate(rotY, 0.0, 1.0, 0.0 );
  EZ_Rotate(rotZ, 0.0, 0.0, 1.0 );
  EZ_PushMatrix();                       /* render a yellow tetrahedron       */
  EZ_Translate( -3.0, 0.0, 0.0 );
  EZ_Materialfv(EZ_FRONT,EZ_DIFFUSE, yellow);
  EZ_Tetrahedron(0.0,0.0,0.0,2.4);
  EZ_PopMatrix();
  EZ_PushMatrix();
  EZ_Translate(3.0,0.0,0.0);                        /* and a red sphere       */      
  EZ_Materialfv(EZ_FRONT,EZ_DIFFUSE, red);
  EZ_Sphere(EZ_SPHERE_QUAD, 4,0.0,0.0,0.0,2.0); 
  EZ_PopMatrix();
  EZ_PopMatrix();
  EZ_SwapBuffers();                                 /* copy backbuf to front  */
}

static void event_handle(EZ_Widget *canvas, void *ddd, int eventType, XEvent *xev)
{
  switch(eventType) {
  case EZ_REDRAW:
  case EZ_RESIZE:
    draw(canvas);
    break;
  case EZ_KEY_PRESS:
    switch(EZ_PressedKey) {
    case EZ_DOWN_KEY:   rotX += 5.0; draw(canvas); break;
    case EZ_UP_KEY:     rotX -= 5.0; draw(canvas); break;
    case EZ_RIGHT_KEY:  rotY += 5.0; draw(canvas); break;
    case EZ_LEFT_KEY:   rotY -= 5.0; draw(canvas); break;
    case 'j':           rotZ += 5.0; draw(canvas); break;
    case 'k':           rotZ -= 5.0; draw(canvas); break;
    case 'e':           scale *= 1.1;draw(canvas); break;
    case 'r':           scale *= 0.9;draw(canvas); break;
    case EZ_ESCAPE_KEY: 
      EZ_DestroyWidget(canvas);
      EZ_Shutdown();
      exit(0);          
      break;
    default:  
      break;
    }
    EZ_GLResetEvents(NULL); /* clear the event queue, too many keypresses */
    break;
  default:
    break;
  }
}
/***************************************************************/
static void timer_callback(EZ_Timer *timer, void *ptr)
{
  rotY += 5.0; draw(canvas);
}
