/****************************************************************
 ***                                                          ***
 ***     timer.c                                              ***
 ***          testing timer                                   ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

static EZ_Widget *label;

static void rtimer_callback(timer, pdata, idata)
     EZ_Timer *timer; void *pdata; int idata;
{
  long delay_sec, delay_usec; 
  int  n_calls_remaining;
  char str[256];

  EZ_GetTimerState(timer, &delay_sec, &delay_usec, &n_calls_remaining);
  if(n_calls_remaining == 0) exit(0);
  sprintf(str,"%.1f seconds remaining before destruction",
	  (float) (delay_usec * n_calls_remaining)/1000000.0);
  EZ_ConfigureWidget(label, EZ_LABEL_STRING, str, 0);
}

/**************************************************************************/

main(ac,av) int ac; char **av;
{
  EZ_Widget *frame;
  EZ_Timer  *RTimer;

  EZ_Initialize(ac,av,0);
  frame = EZ_CreateFrame(NULL,"Test Timers");
  label = EZ_CreateButton(frame,NULL,-1);
  EZ_ConfigureWidget(label, EZ_BACKGROUND,"bisque2",
		     EZ_FOREGROUND, "red", 
		     EZ_PROPAGATE, 0,
		     EZ_LABEL_STRING, "20.0 seconds remaining before destruction",
		     EZ_LABEL_JUSTIFICATION, EZ_CENTER,
		     0);

  RTimer = EZ_CreateTimer(0, 100000, 200, rtimer_callback, label, 0);
  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}
/************************************************************************/
int _test_=0;
