/****************************************************************
 ***                                                          ***
 ***     sliders.c                                            ***
 ***          Horizontal and Vertical Sliders                 ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *button;
static void eventHandler();
/************************************************************************
 *
 *  slider callback
 */
EZ_Widget *hslider, *vslider;

static void vslider_callback(widget, vd)
     EZ_Widget *widget; void *vd;
{
  int h = (int) EZ_GetSliderValue(widget);

  EZ_ConfigureWidget(button, EZ_HEIGHT, h, 0);
} 

static void hslider_callback(widget, vd)
     EZ_Widget *widget; void *vd;
{
  int w = (int) EZ_GetSliderValue(widget);

  EZ_ConfigureWidget(button, EZ_WIDTH, w, 0);
} 

void my_exit()
{
  EZ_Shutdown();
  exit(0);
}
/**************************************************************************/

main(ac, av)
     int ac; char **av;
{
  EZ_Widget *toplevel, *frame1, *frame2;
  int        i;

  EZ_Initialize(ac,av,1);
  EZ_DisableSliderDepression();

  toplevel = EZ_CreateFrame(NULL,"Sliders");
  EZ_ConfigureWidget(toplevel,  EZ_STACKING, EZ_VERTICAL,
		     EZ_FILL_MODE, EZ_FILL_BOTH,  
		     EZ_WIDTH, 450, EZ_HEIGHT, 300,0);
  frame1 = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(frame1,/* EZ_EXPAND, True, */
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  frame2 = EZ_CreateFrame(frame1, NULL);  
  EZ_ConfigureWidget(frame2, EZ_BORDER_TYPE, EZ_BORDER_DOWN,
		     EZ_PROPAGATE, 0,
		     EZ_BORDER_WIDTH,2, 0);
  button = EZ_CreateButton(frame2,"Exit", 0);
  EZ_ConfigureWidget(button, EZ_BACKGROUND, "bisque", EZ_FOREGROUND, "red",
		     EZ_CALL_BACK, my_exit, NULL, 0);
  vslider = EZ_CreateSlider(frame1, "Button Height", 20.0, 160.0, 20.0, EZ_VERTICAL_SLIDER);
  EZ_ConfigureWidget(vslider, 
		     EZ_SLIDER_BORDER_WIDTH,2,
		     EZ_EVENT_HANDLE, eventHandler, NULL,
		     EZ_SLIDER_RESOLUTION, 1.0,
                     EZ_BUBBLE_HELP, "change the vertical dimension of the EXIT button",
		     EZ_CALL_BACK, vslider_callback, NULL, 0);

  hslider = EZ_CreateSlider(toplevel, "Button Width", 70.0, 260.0, 70.0, EZ_HORIZONTAL_SLIDER); 
  EZ_ConfigureWidget(hslider,
		     EZ_SLIDER_RESOLUTION, 1.0,
		     EZ_SLIDER_DISPLAY_VALUE, 1,
		     EZ_SLIDER_BORDER_WIDTH,2,
		     EZ_CALL_BACK, hslider_callback, NULL,
		     0);

  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************************************************************/
static char *eventTypes[] = {
"0", /* not used */
"1", /* not used */
"KeyPress", /* 2 */ 
"KeyRelease", /* 3 */ 
"ButtonPress", /* 4 */ 
"ButtonRelease", /* 5 */ 
"MotionNotify", /* 6 */ 
"EnterNotify", /* 7 */ 
"LeaveNotify", /* 8 */ 
"FocusIn", /* 9 */ 
"FocusOut", /* 10 */ 
"KeymapNotify", /* 11 */ 
"Expose", /* 12 */ 
"GraphicsExpose", /* 13 */ 
"NoExpose", /* 14 */ 
"VisibilityNotify", /* 15 */ 
"CreateNotify", /* 16 */ 
"DestroyNotify", /* 17 */ 
"UnmapNotify", /* 18 */ 
"MapNotify", /* 19 */ 
"MapRequest", /* 20 */ 
"ReparentNotify", /* 21 */ 
"ConfigureNotify", /* 22 */ 
"ConfigureRequest", /* 23 */ 
"GravityNotify", /* 24 */ 
"ResizeRequest", /* 25 */ 
"CirculateNotify", /* 26 */ 
"CirculateRequest", /* 27 */ 
"PropertyNotify", /* 28 */ 
"SelectionClear", /* 29 */ 
"SelectionRequest", /* 30 */ 
"SelectionNotify", /* 31 */ 
"ColormapNotify", /* 32 */ 
"ClientMessage", /* 33 */ 
"MappingNotify", /* 34 */ 
"Notused", /* 35 */ 
};


static void eventHandler(widget, vd, itype, event)
     EZ_Widget *widget; void *vd;
     int itype;
     XEvent *event;
{
  int type = event->type;
  static int motionCount = 0;
  if(type == MotionNotify) motionCount++;
  else 
    {
      if(motionCount> 0)
	{
	  printf("MotionNotify: ===> count = %d \n",motionCount);
	  motionCount = 0;
	}
      if(type == ButtonPress || type == ButtonRelease)
	printf("%s==> %d\n",eventTypes[type], event->xbutton.button);
      else
	printf("%s\n",eventTypes[type]);
    }
}





