/****************************************************************
 ***                                                          ***
 ***     listbox.c                                            ***
 ***          Demonstrate listbox callback                    ***
 ***                                                          ***
 ***************************************************************/

#include "EZ.h"

/*************************************************************************/
static void listbox_callback(); 

static char *colors[] = {
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "gainsboro   fd af d  f  d a   fd sa f  fdsa   fdsaf  fdsa ",
  "PapayaWhip",
  "PeachPuff",
  "SkyBlue",
  "LawnGreen",
  "YellowGreen",
  "goldenrod",
  "greenyellow",
  "RosyBrown",
  "DarkOrange",
  "violet",
  "bisque1",
  "honeydew3",
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "gainsboro   fd af d  f  d a   fd sa f  fdsa   fdsaf  fdsa ",
  "PapayaWhip",
  "PeachPuff",
  "SkyBlue",
  "LawnGreen",
  "YellowGreen",
  "goldenrod",
  "greenyellow",
  "RosyBrown",
  "DarkOrange",
  "violet",
  "bisque1",
  "honeydew3",
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "gainsboro   fd af d  f  d a   fd sa f  fdsa   fdsaf  fdsa ",
  "PapayaWhip",
  "PeachPuff",
  "SkyBlue",
  "LawnGreen",
  "YellowGreen",
  "goldenrod",
  "greenyellow",
  "RosyBrown",
  "DarkOrange",
  "violet",
  "bisque1",
  "honeydew3",
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "gainsboro   fd af d  f  d a   fd sa f  fdsa   fdsaf  fdsa ",
  "PapayaWhip",
  "PeachPuff",
  "SkyBlue",
  "LawnGreen",
  "YellowGreen",
  "goldenrod",
  "greenyellow",
  "RosyBrown",
  "DarkOrange",
  "violet",
  "bisque1",
  "honeydew3",
  NULL,
};

static char msg[] = "Double click on an item sets\n\
the foreground color of the list box.";

/************************************************************************
 *
 *  fslistbox callback
 */
static void listbox_callback(widget, dd)
     EZ_Widget *widget; void *dd;
{
  char *str = EZ_GetListBoxSelectedItem(widget);
  int i = EZ_GetListBoxSelectionLineNumber(widget);
  EZ_ConfigureWidget(widget, EZ_FOREGROUND, str, 0);
  /* insert the selected item at the end. have to insert first 'cause
   * once deleted, str can no longer be referenced 
   *
  {
    int jj = (rand() >> 5) % 10;
    EZ_InsertListBoxItem(widget, str, jj);
    EZ_DeleteListBoxItem(widget, 0);
  }
  */
}    
/**************************************************************************/

main(ac, av) int ac; char **av;
{
  EZ_Widget *frame, *label, *listbox;

  EZ_Initialize(ac,av,0);
  EZ_SetKbdHighlightColor("green");
  srand(getpid());
  frame = EZ_CreateFrame(NULL, "A listbox");
  EZ_ConfigureWidget(frame,  EZ_STACKING, EZ_VERTICAL, 
		     EZ_WIDTH,300,EZ_HEIGHT,300, 
		     EZ_FILL_MODE, EZ_FILL_BOTH,0);  
  label = EZ_CreateLabel(frame,msg);
  EZ_ConfigureWidget(label, EZ_HEIGHT, 0,
                  0);
  listbox = EZ_CreateListBox(frame,1,1); 
  EZ_ConfigureWidget(listbox,  EZ_CALL_BACK, listbox_callback, NULL,
		     EZ_IMAGE_FILE, "cloth.gif",  /* background tile */
                     EZ_PADX,10, EZ_PADY,10, EZ_BORDER_WIDTH, 1,
		     EZ_SELECTION_BACKGROUND, "#00afaf",
		     EZ_IPADX, 10, EZ_IPADY, 10, 0);		     
  EZ_SetListBoxItems(listbox,colors, 60);
  EZ_ListBoxSelectItem(listbox,colors[15]);
  /*listbox = EZ_CreateListBox(frame,1,1); 
  EZ_ConfigureWidget(listbox,  EZ_CALL_BACK, listbox_callback, NULL,
		     EZ_IMAGE_FILE, "cloth.gif",
                     EZ_PADX,10, EZ_PADY,10, EZ_BORDER_WIDTH, 1,
		     EZ_SELECTION_BACKGROUND, "#00afaf",
		     EZ_IPADX, 10, EZ_IPADY, 10, 0);		     
  EZ_SetListBoxItems(listbox,colors, 20);
  EZ_ListBoxSelectItem(listbox,colors[15]);
  */
  EZ_DisplayWidget(frame);
  EZ_EventMainLoop();
}

/************************************************************************/
