/****************************************************************
 ***                                                          ***
 ***     Labels.c                                             ***
 ***          Different kinds of labels                       ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

void test_eventhandler(EZ_Widget *, void *, int, XEvent *);

main(int ac, char **av)
{
  EZ_Widget *frame1, *frame2, *tmp;

  EZ_Initialize(ac,av,1);
  frame1 = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_VERTICAL, 0);

  tmp = EZ_CreateLabel(frame1, "EZWGL supports textual label,\
bitmap label and image label.");
  EZ_ConfigureWidget(tmp, EZ_FONT_NAME, 
		      "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*",
		     EZ_FOREGROUND, "blue", 0);

  frame2 = EZ_CreateFrame(frame1, NULL);
  tmp = EZ_CreateLabel(frame2, "A Textual Label");
  tmp = EZ_CreateLabel(frame2, "A Textual Label with Border");
  EZ_ConfigureWidget(tmp, EZ_BORDER_TYPE, EZ_BORDER_DOWN, EZ_BORDER_WIDTH, 2, 0);

  frame2 = EZ_CreateFrame(frame1, NULL);
  EZ_ConfigureWidget(frame2, EZ_IPADX, 10, 0);
  tmp = EZ_CreateLabel(frame2, "A Bitmap Label");
  EZ_ConfigureWidget(tmp, EZ_BITMAP_FILE, "flagup", 0);

  tmp = EZ_CreateLabel(frame2, "A Image Label");
  EZ_ConfigureWidget(tmp, EZ_IMAGE_FILE, "brick.jpg", EZ_WIDTH, 0, EZ_HEIGHT, 0,
		     EZ_PADX, 0, EZ_PADY, 0,
		     EZ_BORDER_TYPE, EZ_BORDER_FRAMED_UP, EZ_BORDER_WIDTH, 2,
		     EZ_EVENT_HANDLE, test_eventhandler, NULL, 0);

  EZ_DisplayWidget(frame1);
  EZ_EventMainLoop();
}
/************************************************************************/

void test_eventhandler(widget, dd, event_type, xevent)
     EZ_Widget *widget; void *dd;
     int event_type;
     XEvent *xevent;
{
  
  switch(event_type)
    {
    case EZ_LEFT_BUTTON_PRESS:
      printf("B1 Press: [%d %d]\n", EZ_MouseX, EZ_MouseY);
      break;
    case EZ_LEFT_BUTTON_RELEASE:
      printf("B1 Release: [%d %d]\n", EZ_MouseX, EZ_MouseY);
      break;
    default:
      break;
    }
}

