/****************************************************************
 ***                                                          ***
 ***     menu.c                                               ***
 ***          popup and pulldown menus                        ***
 ***                                                          ***
 ***************************************************************/
#include "EZ.h"

void my_exit()
{
  EZ_Shutdown();
  exit(0);
}

/*************************************************************************/
static char *colors[] = {
  "red",
  "green",
  "blue",
  "yellow",
  "cyan",
  "magenta",
  "white",
  "grey62",
};
#define REDC     0
#define GREENC   1
#define BLUEC    2
#define YELLOWC  3
#define CYANC    4
#define MAGENTAC 5
#define WHITEC   6
#define GRAYC    7

static char msg[] = "Push a button to change the\n\
foreground or background color of this label.";

static EZ_Widget *label;
/************************************************************************
 *
 *  Button call backs
 */
void buttonEventHandler(EZ_Widget *widget, void *data,
			int eType, XEvent *xev) 
{
  if(widget && eType == EZ_LEFT_BUTTON_PRESS) EZ_SetFocusTo(widget);
}


static void button_callbackF(widget)
     EZ_Widget *widget;
{
  char *str = (char *) EZ_GetWidgetPtrData(widget);
  EZ_ConfigureWidget(label, EZ_FOREGROUND, str, 0);
  
}    
static void button_callbackB(widget)
     EZ_Widget *widget;
{
  char *str = (char *) EZ_GetWidgetPtrData(widget);
  EZ_ConfigureWidget(label, EZ_BACKGROUND, str, 0);
}    
/**************************************************************************/

static EZ_Widget *create_normal_button_box(parent,label_str)
     EZ_Widget *parent; 
     char      *label_str;
{
  EZ_Widget *frame1, *frame2, *tmp;
  int       i;

  frame1 = EZ_CreateFrame(NULL,NULL);
/*
  EZ_ConfigureWidget(frame1,  EZ_PADX,0,EZ_PADY,0,EZ_IPADX,0,EZ_IPADY,0,
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  frame1 = EZ_CreateFrame(frame1,NULL);
*/
  EZ_ConfigureWidget(frame1,  EZ_STACKING, EZ_VERTICAL, 0);
  
  label = EZ_CreateLabel(frame1, msg);
  EZ_ConfigureWidget(label, EZ_FONT_NAME, 
		      "-Adobe-Times-Bold-R-Normal--*-180-*-*-*-*-*-*",  0);
  frame2 = EZ_CreateFrame(frame1, NULL);
  EZ_ConfigureWidget(frame2, EZ_IPADX, 6, 0);  
  tmp = EZ_CreateButton(frame2, "Bitmap Label", -1);
  EZ_SetWidgetPtrData(tmp,colors[GRAYC]);  
  EZ_ConfigureWidget(tmp, EZ_BITMAP_FILE, "flagup", EZ_CALLBACK, button_callbackB,NULL,
		     EZ_SHORTCUT_KEY,"C-F",
		     EZ_BACKGROUND, "bisque2",     0);
  tmp = frame2;
  for(i = REDC; i <= BLUEC; i++)  /* a stack of buttons */
    {
      tmp = EZ_CreateButton(tmp, NULL, -1);
      EZ_ConfigureWidget(tmp, EZ_BACKGROUND, colors[i],
			 EZ_SHORTCUT_KEY, "C-G",
			 EZ_CALLBACK,/* button_callbackB,*/my_exit, 0, 0);
      EZ_SetWidgetPtrData(tmp,colors[i]);
    }
  tmp = EZ_CreateButton(frame2, "Image Label", -1);
  EZ_SetWidgetPtrData(tmp,colors[WHITEC]);
  EZ_ConfigureWidget(tmp, EZ_IMAGE_FILE, "cat0.ppm", EZ_CALLBACK, button_callbackB,0,0);
  tmp=EZ_CreatePaneHandle(frame1);
  frame2 = EZ_CreateFrame(frame1, NULL);
  EZ_ConfigureWidget(frame2, EZ_IPADX, 6, 0);
  for(i = REDC; i <= MAGENTAC; i++)  /* a stack of buttons */
    {
      tmp = EZ_CreateButton(frame2, colors[i], -1);
      EZ_ConfigureWidget(tmp, EZ_FOREGROUND, colors[i],
			 EZ_SHORTCUT_KEY, "C-H",
			 EZ_EVENT_HANDLER, buttonEventHandler, NULL,
			 EZ_CALLBACK, button_callbackF, NULL, 0);
      EZ_SetWidgetPtrData(tmp,colors[i]);
    }  
  return(frame1);
}
/************************************************************************/
#ifdef  EZ_MAIN
main(ac,av)
     int ac; char **av;
{
  EZ_Initialize(ac,av,0);
  EZ_DisplayWidget(create_normal_button_box(NULL, NULL));
  EZ_EventMainLoop();
}
#endif
