/************************** Example H *********************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *Label;
static int c_orien = EZ_HORIZONTAL;

static char theLabel[] = {"This is a rather long label. Some of the \nline breaks\n\
are hardcoded while others are inserted by EZWGL"};

static int LabPos[] = { 
  EZ_CENTER, EZ_LEFT, EZ_RIGHT, EZ_TOP, EZ_BOTTOM, EZ_TOP_LEFT,
  EZ_TOP_RIGHT, EZ_BOTTOM_LEFT, EZ_BOTTOM_RIGHT};

static char *LabPosNames[] = { 
  "CENTER", "LEFT", "RIGHT", "TOP", "BOTTOM", "TOP_LEFT",
  "TOP_RIGHT", "BOTTOM_LEFT", "BOTTOM_RIGHT"};

static int LabJusts[] = { 
  EZ_CENTER, EZ_LEFT, EZ_RIGHT};

static char *LabJustNames[] = { 
  "CENTER", "LEFT", "RIGHT"};

static void rbuttons_callback(EZ_Widget *widget, void *data)
{
  int mode = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_ConfigureWidget(Label, EZ_LABEL_POSITION, mode, 0);
} 

static void rbuttonsA_callback(EZ_Widget *widget, void *data)
{
  int mode = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_ConfigureWidget(Label, EZ_LABEL_JUSTIFICATION, mode, 0);
}

main(int ac, char **av)
{
  EZ_Widget *toplevel, *frame1, *frame2, *frame3, *tmp;
  int        i;
  char       str[128];

  EZ_Initialize(ac,av,0);

  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel, EZ_ORIENTATION, EZ_VERTICAL,0);

  tmp = EZ_CreateLabel(toplevel, "Test Label Position and Label Justification");
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", 
		     EZ_TEXT_LINE_LENGTH, 80,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     0);

  toplevel = EZ_CreateFrame(toplevel,NULL);

  Label = EZ_CreateLabel(toplevel, theLabel);
  EZ_ConfigureWidget(Label, EZ_WIDTH, 300, EZ_HEIGHT, 300, 
		     EZ_FOREGROUND, "red",
		     EZ_BORDER_TYPE, EZ_BORDER_RAISED, 
		     EZ_BORDER_WIDTH, 2, 0);

  frame2 = EZ_CreateFrame(toplevel, "Label Position");  
  EZ_ConfigureWidget(frame2, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_SIDE, EZ_LEFT, 0);
  
  frame3 = EZ_CreateFrame(toplevel, "Label Justification");  
  EZ_ConfigureWidget(frame3, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_SIDE, EZ_LEFT, 0);

  for(i = 0; i < 9; i++)
    {
      tmp = EZ_CreateRadioButton(frame2, LabPosNames[i], -1, 0, 
				 LabPos[i]);
      EZ_SetWidgetCallBack(tmp, rbuttons_callback, NULL);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_CENTER);
  
  for(i = 0; i < 3; i++)
    {
      tmp = EZ_CreateRadioButton(frame3, LabJustNames[i], -1, 1, 
				 LabJusts[i]);
      EZ_SetWidgetCallBack(tmp, rbuttonsA_callback, NULL);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_LEFT);
  
  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************** Example H *********************************/



