/************************** Example F *********************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *Frame, *AButtons[8];
static c_orien = EZ_HORIZONTAL, c_align =EZ_CENTER;

static int Orientations[] = { 
  EZ_VERTICAL, EZ_VERTICAL_TOP, EZ_VERTICAL_BOTTOM, EZ_VERTICAL_CENTER,
  EZ_HORIZONTAL, EZ_HORIZONTAL_LEFT, EZ_HORIZONTAL_RIGHT, EZ_HORIZONTAL_CENTER};

static char *OrientationNames[] = { 
  "V", "V_TOP", "V_BOTTOM", "V_CENTER",
  "H", "H_LEFT", "H_RIGHT", "H_CENTER" };

static int Alignment[] = {
  EZ_LEFT, EZ_RIGHT, EZ_CENTER, EZ_TOP, EZ_BOTTOM };
static char *AlignmentNames[] = {
  "LEFT", "RIGHT", "CENTER", "TOP", "BOTTOM" };  


static void rbuttons_callback(EZ_Widget *widget, void *data)
{
  int i, j;
  c_orien = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_ConfigureWidget(Frame, EZ_ORIENTATION, c_orien, 0);
  switch(c_orien)
    {
    case EZ_HORIZONTAL:
    case EZ_HORIZONTAL_LEFT:
    case EZ_HORIZONTAL_RIGHT:
    case EZ_HORIZONTAL_CENTER:
      for(i = 0; i < 5; i++)
	{
	  j = EZ_GetWidgetIntData(AButtons[i]);
	  if(j == EZ_LEFT || j == EZ_RIGHT)
	    EZ_DisableWidget(AButtons[i]);
	  else 
	    EZ_EnableWidget(AButtons[i]);
	}
      if(c_align == EZ_LEFT || c_align == EZ_RIGHT)
	{
	  EZ_SetRadioButtonGroupVariableValue(AButtons[0], EZ_CENTER);
	  EZ_ConfigureWidget(Frame, EZ_SIDE, c_align, 0);
	}
      break;
    case EZ_VERTICAL:
    case EZ_VERTICAL_TOP:
    case EZ_VERTICAL_BOTTOM:
    case EZ_VERTICAL_CENTER:
      for(i = 0; i < 5; i++)
	{
	  j = EZ_GetWidgetIntData(AButtons[i]);
	  if(j == EZ_TOP || j == EZ_BOTTOM)
	    EZ_DisableWidget(AButtons[i]);
	  else 
	    EZ_EnableWidget(AButtons[i]);
	}
      if(c_align == EZ_TOP || c_align == EZ_BOTTOM)
	{
	  EZ_SetRadioButtonGroupVariableValue(AButtons[0], EZ_CENTER);
	  EZ_ConfigureWidget(Frame, EZ_SIDE, c_align, 0);
	}
      break;
    default:
      break;
    }
} 

static void rbuttonsA_callback(EZ_Widget *widget, void *data)
{
  c_align = EZ_GetRadioButtonGroupVariableValue(widget);
  EZ_ConfigureWidget(Frame, EZ_SIDE, c_align, 0);
} 


main(int ac, char **av)
{
  EZ_Widget *toplevel, *frame1, *frame2, *frame3, *tmp;
  int        i;
  char       str[128];

  EZ_Initialize(ac,av,0);

  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel, 
		     EZ_ORIENTATION, EZ_VERTICAL, 0);

  tmp = EZ_CreateLabel(toplevel, "Test EZ_ORIENTATION and EZ_SIDE");
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", 
		     EZ_TEXT_LINE_LENGTH, 80, EZ_HEIGHT, 0,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     0);

  toplevel = EZ_CreateFrame(toplevel,NULL);
  Frame = frame1 = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(frame1, 
		     EZ_WIDTH, 500, EZ_HEIGHT, 400, 
		     EZ_BORDER_TYPE, EZ_BORDER_SUNKEN, 
		     EZ_BORDER_WIDTH, 2, 0);

  for(i = 0; i < 4; i++)
    {
      sprintf(str, "Button %d", (1 <<(i*i*2)));
      if(i%2 == 0) strcat(str, "\nLine 2");
      tmp = EZ_CreateButton(frame1, str,-1);
      if(i == 0) EZ_ConfigureWidget(tmp,EZ_BITMAP_FILE, "woman",0);
      else if(i == 2) EZ_ConfigureWidget(tmp,EZ_BITMAP_FILE,"xterm.xpm",0);
    }

  frame2 = EZ_CreateFrame(toplevel, "EZ_ORIENTATION");  
  EZ_ConfigureWidget(frame2, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_SIDE, EZ_LEFT, 0);

  frame3 = EZ_CreateFrame(toplevel, "EZ_SIDE");  
  EZ_ConfigureWidget(frame3, EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_SIDE, EZ_LEFT, 0);

  for(i = 0; i < 8; i++)
    {
      tmp = EZ_CreateRadioButton(frame2, OrientationNames[i], -1, 0, 
				 Orientations[i]);
      EZ_SetWidgetCallBack(tmp, rbuttons_callback, NULL);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_HORIZONTAL);


  for(i = 0; i < 5; i++)
    {
      AButtons[i] = tmp = EZ_CreateRadioButton(frame3, AlignmentNames[i], -1,
					      1,  Alignment[i]);
      EZ_SetWidgetCallBack(tmp, rbuttonsA_callback, NULL);
      EZ_SetWidgetIntData(tmp,  Alignment[i]);
      if(i < 2) EZ_DisableWidget(tmp);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_CENTER);


  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************** Example F *********************************/
