/************************** Example D *********************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *Frame, *FrameA, *FrameB;

static void vslider_callback(EZ_Widget *widget, void *data)
{
  EZ_ConfigureWidget(FrameA,
		     EZ_IPADY,(int) EZ_GetSliderValue(widget), 0);
  EZ_ConfigureWidget(FrameB,
		     EZ_IPADY,(int) EZ_GetSliderValue(widget), 0);
} 
static void hslider_callback(EZ_Widget *widget, void *data)
{
  EZ_ConfigureWidget(Frame,
		     EZ_IPADX,(int) EZ_GetSliderValue(widget), 0);
} 
/**************************************************************************/

main(int ac, char **av)
{
  EZ_Widget *toplevel, *frame1, *frame2,  *hslider, *vslider, *tmp, *ff;
  int        i;

  EZ_Initialize(ac,av,0);

  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel,  EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_WIDTH,320,EZ_HEIGHT,300,
		     EZ_FILL_MODE, EZ_FILL_BOTH,  0);
  tmp = EZ_CreateLabel(toplevel,"Watch how the space between \nwidgets changes as you slide the sliders");

  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red",  EZ_HEIGHT, 0,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     0);

  ff = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(ff, EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  frame1 = Frame =  EZ_CreateFrame(ff, NULL);
  EZ_ConfigureWidget(frame1, EZ_ORIENTATION, EZ_HORIZONTAL_CENTER,
		     EZ_BORDER_TYPE, EZ_BORDER_DOWN,
		     EZ_PROPAGATE, 0,
		     EZ_BORDER_WIDTH, 2, 0);

  FrameA = EZ_CreateFrame(frame1, NULL);  
  EZ_ConfigureWidget(FrameA,  EZ_ORIENTATION, EZ_VERTICAL,
		     EZ_PADX, 0, 0);
  tmp = EZ_CreateButton(FrameA, "Button 1", 0);
  tmp = EZ_CreateButton(FrameA, "Button 2", 1);
  FrameB = EZ_CreateFrame(frame1, NULL);  
  EZ_ConfigureWidget(FrameB,  EZ_ORIENTATION, EZ_VERTICAL, 
		     EZ_PADX, 0, 0);
  tmp = EZ_CreateButton(FrameB, "Button 3", 2);
  tmp = EZ_CreateButton(FrameB, "Button 4", 4);


  vslider = EZ_CreateSlider(ff, "IPADY", 
			    0.0, 40.0, 4.0, EZ_VERTICAL_SLIDER);
  EZ_ConfigureWidget(vslider, 
		     EZ_SLIDER_BORDER_WIDTH,2, EZ_SLIDER_RESOLUTION,1.0,
		     EZ_CALL_BACK, vslider_callback, NULL, 0);

  hslider = EZ_CreateSlider(toplevel, "IPADX",
    0.0, 40.0, 4.0, EZ_HORIZONTAL_SLIDER);
  EZ_ConfigureWidget(hslider,
		     EZ_SLIDER_BORDER_WIDTH,2, EZ_SLIDER_RESOLUTION,1.0,
		     EZ_CALL_BACK, hslider_callback, NULL, 0);

  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************** Example D *********************************/

