/************************** Example B *********************************/
#include "EZ.h"

extern void exit();
static EZ_Widget *button;

static int border_types[6] = {  EZ_BORDER_RAISED, EZ_BORDER_SUNKEN,
  EZ_BORDER_RIDGE, EZ_BORDER_GROOVE, EZ_BORDER_FLAT, EZ_BORDER_NONE};

static char *border_names[] = {  "RAISED", "SUNKEN",
  "RIDGE", "GROOVE", "FLAT", "NONE"};

static void vslider_callback(EZ_Widget *widget, void *data)
{
  EZ_ConfigureWidget(button, 
		     EZ_BORDER_WIDTH,(int)EZ_GetSliderValue(widget), 0);
} 

static void rbuttons_callback(EZ_Widget *widget, void *data)
{
  EZ_ConfigureWidget(button, 
		     EZ_BORDER_TYPE,
		     EZ_GetRadioButtonGroupVariableValue(widget), 0);
} 

static char *msg = "Test Border Width";

main(int ac, char **av)
{
  EZ_Widget *toplevel, *frame1, *frame2, *frame3, *vslider, *tmp;
  int        i;

  EZ_Initialize(ac,av,0);

  toplevel = EZ_CreateFrame(NULL,NULL);
  EZ_ConfigureWidget(toplevel,  EZ_STACKING, EZ_VERTICAL,
		     EZ_FILL_MODE, EZ_FILL_BOTH,  0);

  tmp = EZ_CreateLabel(toplevel, msg);
  EZ_ConfigureWidget(tmp, EZ_FOREGROUND, "red", 
		     EZ_TEXT_LINE_LENGTH, 80, EZ_HEIGHT, 0,
		     EZ_FONT_NAME,  "-Adobe-Times-Bold-I-Normal--*-180-*-*-*-*-*-*",   
		     0);

  frame1 = EZ_CreateFrame(toplevel, NULL);
  EZ_ConfigureWidget(frame1, EZ_EXPAND, True, 
		     EZ_FILL_MODE, EZ_FILL_BOTH, 0);
  frame2 = EZ_CreateFrame(frame1, NULL);  
  EZ_ConfigureWidget(frame2, EZ_BORDER_TYPE, EZ_BORDER_DOWN,
		     EZ_PROPAGATE, 0,
		     EZ_BORDER_WIDTH,2, 0);
  button = EZ_CreateLabel(frame2,"Watch how the border\nchanges");
  vslider = EZ_CreateSlider(frame1, "BD width", 
			    0.0, 30.0, 2.0, EZ_VERTICAL_SLIDER);
  EZ_ConfigureWidget(vslider, 
		     EZ_SLIDER_BORDER_WIDTH,2,
		     EZ_SLIDER_RESOLUTION,1.0,
		     EZ_CALL_BACK, vslider_callback, 0);

  frame3 = EZ_CreateFrame(toplevel, "Border Types");
  EZ_ConfigureWidget(frame3, EZ_WIDTH, 0, EZ_HEIGHT, 0, 0);

  for(i = 0; i < 6; i++)
    {
      tmp = EZ_CreateRadioButton(frame3, border_names[i], -1, 0, 
				 border_types[i]);
      EZ_SetWidgetCallBack(tmp, rbuttons_callback, NULL);
    }
  EZ_SetRadioButtonGroupVariableValue(tmp, EZ_BORDER_NONE);

  EZ_DisplayWidget(toplevel);
  EZ_EventMainLoop();
}
/************************** Example B *********************************/
