/*********************************************************************
 *
 *         EZWGL, the EZ Widget and Graphics Library
 *
 *             Copyright (C) 1996, 1997  Maorong Zou
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 **********************************************************************/
/*
 *  June 1996.  Beta Release.
 *  Sept 1996.  Release Version 1.0
 *  Dec 1996.  Release Version 1.1 Beta
 *  April 1997.  Release Version 1.1
 *  May 1997. Handling of raw rgb images added by Arno Dabekaussen.
 */
{
  option = va_arg(ap, int);

  while(!done)
    {
      i1=i2=i3=i4=0;
      ul1 = ul2 = 0L;
      p1 = p2 = NULL;
      f1 = f2 = 0.0;

      switch(option)
	{
	case  EZ_DND_BUBBLE_HELP:
	case EZ_SELECTION_BACKGROUND:
	case EZ_SELECTION_FOREGROUND:
	case EZ_INDICATOR_COLOR:
	case EZ_FOREGROUND:
	case EZ_TEXT_BACKGROUND:
	case EZ_BACKGROUND:
	case EZ_BITMAP_FILE:
	case EZ_IMAGE_FILE:
	case EZ_FONT_NAME:
	case EZ_BUTTON_SHORTCUT:
	case EZ_BUBBLE_HELP:
	case EZ_LABEL_STRING:
        case EZ_GLOB_PATTERN:
	case EZ_ENTRY_STRING:
	case EZ_NAME:
	  p1  = (void *)va_arg(ap, char *);
	  break;
	case  EZ_DND_DRAG_CURSOR:
	  ul1 = (unsigned long) va_arg(ap, Cursor);
	  break;
	case EZ_ATTACH_PTR_DATA:
	case EZ_LABEL_PIXMAP:
	  p1 =  va_arg(ap, void *);
	  break;
	case EZ_X:
	case EZ_Y:
	case EZ_SHAPED_WINDOW:
	case EZ_WIDTH:
	case EZ_WIDTH_HINT:
	case EZ_HEIGHT:
	case EZ_HEIGHT_HINT:
	case EZ_INDICATOR_TYPE:
	case EZ_EMBEDER:
	case EZ_BORDER_WIDTH:
	case EZ_BORDER_TYPE:
	case EZ_PADX:
	case EZ_PADY:
	case EZ_IPADX:
	case EZ_IPADY:
	case EZ_STACKING:
	case EZ_SIDE:
	case EZ_LABEL_POSITION:
	case EZ_JUSTIFICATION:
	case EZ_FILL_MODE:
	case EZ_TEXT_SPACING:
	case EZ_FONT_ID:
	case EZ_SLIDER_DISPLAY_VALUE:
	case EZ_SLIDER_LENGTH:
	case EZ_SLIDER_WIDTH:
	case EZ_SLIDER_BORDER_WIDTH:
	case EZ_TEXT_LINE_LENGTH:
	case EZ_INDICATOR_SIZE_ADJUST:
	case EZ_FREELABEL_MOVABLE:
	case EZ_RESERVE_MENU_BUTTON:
	case EZ_BACKING_STORE:
	case EZ_EXPAND:
	case EZ_TRANSIENT:
	case EZ_SCROLLBAR_WIDTH:
	case EZ_SCROLLBAR_BORDER_WIDTH:
	case EZ_PROPAGATE:
	case EZ_ATTACH_INT_DATA:
	case EZ_UNDERLINE:
	case EZ_CHECK_BUTTON_ON_VALUE:
	case EZ_CHECK_BUTTON_OFF_VALUE:
	case EZ_CHECK_BUTTON_ON_OFF:
	case EZ_RADIO_BUTTON_GROUP:
	case EZ_RADIO_BUTTON_VALUE:
	case EZ_OPTIONAL_HSCROLLBAR:
	case EZ_OPTIONAL_VSCROLLBAR:
	case EZ_FANCY_LIST_BOX_TYPE:
	case EZ_FANCY_LIST_BOX_COLUMNS:
	case EZ_TEXT_WIDGET_EDITABLE:
	case EZ_RETURN_VALUE:
	case EZ_OPTIONAL_ENTRY_EDITABLE:
	case EZ_MENU_TEAR_OFF:
	case EZ_OPTIONAL_ENTRY_REMEMBER_HISTORY:
	case EZ_PADB:
	  i1 = va_arg(ap, int);
	  break;
	case EZ_BITMAP_DATA:
	case EZ_RAW_RGB_DATA:
	  p1 = (void *)  va_arg(ap, char *);
	  i1 = va_arg(ap, int);
	  i2 = va_arg(ap, int);
	  break;
	case EZ_PIXMAP_DATA:
	  p1 = (void *)va_arg(ap, char **);
	  break;
	case EZ_X_PIXMAP:
	  ul1 = (unsigned long)va_arg(ap,Pixmap);
	  i1 = va_arg(ap,int);
	  i2 = va_arg(ap,int);
	  i3 = va_arg(ap,int);
	  i4 = va_arg(ap, int);
	  break;
	case EZ_GRID_CELL_GEOMETRY:
	  i1 = va_arg(ap,int);
	  i2 = va_arg(ap,int);
	  i3 = va_arg(ap,int);
	  i4 = va_arg(ap, int);
	  break;
	case EZ_GRID_CELL_PLACEMENT:
	case EZ_LOCATION:
	case EZ_SIZE:
	case EZ_SIZE_HINT:
	  i1 = va_arg(ap,int);
	  i2 = va_arg(ap,int);
	  break;
	case EZ_GRID_CONSTRAINS:
	  ul1 = (unsigned long)va_arg(ap,int);   /* EZ_ROW or EZ_COLUMN */
	  i1 = va_arg(ap,int);                   /* index */
	  i2 = va_arg(ap,int);                   /* minsize */
	  i3 = va_arg(ap,int);                   /* weight */
	  i4 = va_arg(ap, int);                  /* pad    */
	  break;
	case EZ_GRID_ROW_CONSTRAINS:
	case EZ_GRID_COLUMN_CONSTRAINS:
	case EZ_GEOMETRY:
	  i1 = va_arg(ap,int);                   /* index */
	  i2 = va_arg(ap,int);                   /* minsize */
	  i3 = va_arg(ap,int);                   /* weight */
	  i4 = va_arg(ap, int);                  /* pad    */
	  break;
	case EZ_SLIDER_RESOLUTION: 
	case EZ_SLIDER_INIT_VALUE:
	  {
	    double dvalue =  va_arg(ap, double);
	    f1 = (float)dvalue;
	  }
	  break;
	case EZ_SLIDER_RANGE: 
	  {
	    double from, to;
	    from = va_arg(ap, double);
	    to =  va_arg(ap, double);
	    f1 = (float)from;
	    f2 = (float)to;
	  }
	  break;
	case EZ_CALL_BACK:
	case EZ_MOTION_CALLBACK:
	case EZ_DESTROY_CALLBACK:
	  p1 = (void *)va_arg(ap, EZ_CallBack);
	  p2 = (void *)va_arg(ap, void *);
	  break;
	case EZ_EVENT_HANDLE:
	  p1 = (void *)va_arg(ap, EZ_EventHandler);
	  p2 = va_arg(ap, void *);
	  break;
	case 0:
	  done = 1;
	  break;
	default:
	  EZ_ConfigureError(widget,option, "Unknown configuration option.");
	  done = 1;
	  break;
	}
      if(!done) 
	{
	  size_changed += EZ_SetWidgetAttributes(widget,option,
						 i1,i2, p1,p2,ul1,ul2,f1,f2, i3,i4);
	  option = va_arg(ap, int);
	}
    }
  va_end(ap);
}
