/*
**  FILE:   Posix.1 Header <pwd.h>
**  IDENT:  X-7
**
*****************************************************************************
**									    *
**  Copyright  Digital Equipment Corporation, 1990, 1991, 1992, 1993	    *
**  All Rights Reserved.  Unpublished rights reserved under  the  copyright *
**  laws of the United States.						    *
**									    *
**  The software contained on this media is proprietary to and embodies the *
**  confidential  technology of Digital Equipment Corporation.  Possession, *
**  use,  duplication  or  dissemination  of  the  software  and  media  is *
**  authorized  only  pursuant  to  a  valid  written  license from Digital *
**  Equipment Corporation.						    *
**									    *
**  RESTRICTED RIGHTS LEGEND   Use, duplication, or disclosure by the  U.S. *
**  Government  is  subject  to  restrictions  as set forth in Subparagraph *
**  (c)(1)(ii) of DFARS 252.227-7013, or in FAR 52.227-19, as applicable.   *
**									    *
*****************************************************************************
*/
 
# ifndef __PWD_LOADED
# define __PWD_LOADED 1

# ifdef __cplusplus
extern "C" {
# endif

# if __DECC || __DECCXX
#   pragma __nostandard
#   pragma __member_alignment __save
#   pragma __nomember_alignment
# elif VAXC
#   pragma nostandard
# endif

# if !defined __SIGSET_T && !defined _SIGSET_T_
# define __SIGSET_T 1
# define _SIGSET_T_ 1
typedef struct {unsigned long	_set[2]; }	sigset_t;
# endif
# ifndef CADDR_T
# define CADDR_T 1
typedef char *		caddr_t;
# endif
# ifndef __POSIX_TYPES_DEFINED
# define __POSIX_TYPES_DEFINED 1
typedef long		pid_t;
typedef long		off_t;
typedef long		ssize_t;
typedef unsigned long	uid_t;
typedef unsigned long	gid_t;
typedef unsigned long	dev_t;
typedef unsigned long	ino_t;
typedef unsigned long	mode_t;
typedef unsigned long	nlink_t;
typedef unsigned long	key_t;
typedef unsigned long	evtset_t;
# endif

# undef  NULL
# define NULL	((void*)0)

struct passwd
{
    char *	pw_name;
    uid_t	pw_uid;
    gid_t	pw_gid;
    char *	pw_dir;
    char *	pw_shell;
} ;

struct passwd * getpwuid (uid_t __uid);
struct passwd * getpwnam (const char * __name);

/*
**  The following definitions come from P1003.4a/D6, but haven't yet been
**  standardized. They may change in a future version of Posix for OpenVMS,
**  when P1003.4a is eventually approved as a standard.
*/

struct passwd * getpwuid_r (uid_t __uid, struct passwd * __result,
			    char * __buffer, int __buflen);
struct passwd * getpwnam_r (const char * __name, struct passwd * __result,
			    char * __buffer, int __buflen);

# if __DECC || __DECCXX
#   pragma __member_alignment __restore
#   pragma __standard
# elif VAXC
#   pragma standard
# endif

# ifdef __cplusplus
}
# endif

# endif		/* __PWD_LOADED  */

