/* vtoc.c
 *
 * A short program for converting .v files into a .c file containing
 * an array of strings corresponding to the lines in the .v file.
 */
#include "net3d.h"

int main(int argc, char **argv)
{
int i;

if (argc == 1) {
	printf("you must give a filename(s) to convert\n");
	exit(1);
	}

for(i=1; i<argc; i++) {
	FILE *fp;
	char combuf[100];
	char *dot;
	char *name;


	/* pipe through cpp */
	sprintf(combuf,"%s %s",CPPPATH,argv[i]);
	fp=popen(combuf,"r");

	/* skip leading dots */
	for(name=argv[i]; *name=='.' || *name=='/'; name++)
		;

	/* get rid of dot */
	dot = strchr(name,'.');
	if (dot)
		*dot = '\0';

	printf("char *%s[] = {\n",name);

	/* read a line at a time from the file */
	while(!feof(fp)) {
		char buf[600];
		fgets(buf,600,fp);
		if (feof(fp))
			break;
		if (buf[0] != '#') {
			int j;
			printf("\"");
			for(j=0; j<strlen(buf)-1; j++) {
				if (buf[j] == '\"')
					printf("\\\"");
				else
					putchar(buf[j]);
				}
			printf("\",\n");
			}
		}
	printf("(char *)0,\n");
	printf("};\n");
	pclose(fp);
	}
   return(0);
}

