/* protos.h
 *
 * Functions prototypes from everywhere
 */

#ifndef protos_h
#define protos_h

/* from matrix.c */
#if (!defined(__GNUC__) || USEINLINES != 1)
void mmult(struct point *, float [3][3], struct point *);
float cmult(struct point *, float [3]);
#endif
float dotprod(struct point *, struct point *);
void smult(float, struct point *);
void normalise(struct point *);

/* from view.c */
void init3d(struct map *, struct view *);
void initmightsaves(struct object *);
void render(struct view *, struct object *, struct vehicle *, int, 
 struct map *);
void worldtoview(struct view *, struct object *, struct vehicle *, int);
struct object *depthsort(struct object *, struct view *);
void initX(struct map *, int, char **);
long sqr(long);
void cyclefire(double);
void drawextras(struct vehicle *, bool);
void drawradar(struct vehicle *, struct vehicle *);
void drawinfo(struct vehicle *);
void drawvmode(int, struct vehicle *);
void fadecolour(int, int, int, int, int, int, int, XColor *);
void readicons(void);
void drawbuildicons(void);
void drawstars(struct map *, struct view *);

/* from file.c */
void fileerror(char *, char *, int);
void ntoken(int, char *);
void *dupe(void *, int);
char *strdupe(char *);
void readfile(struct object **, struct vehicle **, int, struct map *);
void readpoints(struct object *, int);
void readface(struct object *, int);
void copyvehicle(struct vehicle *, struct vehicle *, struct object **);
struct vehicle *findbycode(struct vehicle *, char *);
void readrotate(struct object *, int);
void readscale(struct object *, int);
void readspin(struct vehicle *, int);
int pipethrough(char *, char *);
void readmax(struct vehicle *, int);
void createstars(struct map *, int);
void readvehiclescale(struct vehicle *, int);

/* from object.c */
void worldinfo(struct vehicle *, struct object *);
void dumpvehicles(struct vehicle *);
void movevehicle(struct vehicle *, double, struct map *);
void movevehicles(struct vehicle **, struct object **, struct map *, double);
void rotatey(struct object *, double);
void rotatex(struct object *, double);
void rotatez(struct object *, double);
void multpoints(struct object *, float [3][3]);
double gametime(void);
void makemap(struct object **, struct map *);
struct object *addobject(struct object **, struct point, struct point,
 struct vehicle *, int, int, struct point *, struct polygon *);
float calcmap(int, int, struct map *);
void explode(struct vehicle **, struct object **, struct vehicle *);
void freevehicle(struct vehicle *, struct vehicle **, struct object **);
void calcbbox(struct vehicle *);
void calcbboxes(struct vehicle *);
void shiftvehicle(struct vehicle *, float, float, float);
void fire(struct vehicle **, struct object **, struct vehicle *);
double dabs(double);
double sinsq(double);
double sinhalf(double);
void readextravehicles(void);
void eject(struct vehicle **, struct object **, struct vehicle *);
bool enteredvehicle(struct vehicle *, struct vehicle *);
void rotatevehicle(struct vehicle *, double);
float vehicledist(struct vehicle *, struct vehicle *);
double heightdiff(struct vehicle *, struct vehicle *);

/* from game.c */
void createcamera(struct vehicle *, struct view *, int, struct map *,
 struct vehicle *);
void readkeys(int *, struct vehicle *, struct vehicle *, double);
void printcontrols(void);
double readnet(struct vehicle **, struct object **, bool *, int *);
void controlvehicles(struct vehicle **, struct object **);
double vehicleangle(struct vehicle *, struct vehicle *);
void readkeyfile(FILE *);
char *keyname(int);
bool possibletarget(struct vehicle *, struct vehicle *);
void growtrees(struct vehicle **, struct object **);
void build(struct vehicle **, struct object **, struct vehicle *, int);
bool boring(struct vehicle *);
void termhandler(int);
int xerrorhandler(Display *);
void deadloop(void);

/* from command.c */
void waitforclients(int [], int);
void processnet(int [], int, int);

/* for util.c */
struct vehicle *collide(struct vehicle *, struct vehicle *);
struct vehicle *findbyvid(struct vehicle *, int);
void initcaches(void);
double jsin(double);
#define jcos(x) jsin((x)+dtor(90))
struct object *findturret(struct vehicle *);
void addpts(struct point, struct point, struct point *);
#ifdef NO_STRERROR
char *strerror(int);
#endif

/* from brain.c */
void readbrain(struct vehicle *, int);
void think(struct vehicle *, struct vehicle **, struct object **);

#endif

