/* --------------------------------- otarget.c ------------------------------ */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* object: target.
*/

#include "fly.h"


static SHAPE shape_target = {
	0,
	0,
	SH_BEHIT,
	100*1000L,	/* weight */
	0		/* drag */
};

static int FAR
init_target (BODY *b)
{
	if (shape_read (&shape_target, "target"))
		return (1);
	return (0);
}

static void FAR
term_target (BODY *b)
{
	shape_free (shape_target.v);
}

static int FAR
create_target (OBJECT *p)
{
	p->color = st.green;
	p->time = FOREVER;
	p->flags |= F_VISIBLE|F_EXPORTED;
	p->damage = 1;
	p->damaging = 1;
	p->R[X] = (Frand () % 6000 - 3000)*(long)VONE;
	p->R[Y] = (Frand () % 6000 - 3000)*(long)VONE;
	p->R[Z] = (Frand () % 3000       )*(long)VONE + 500*VONE;
	p->da[Z] = (Frand () % VD90  - VD90)*4;
	Mident (p->T);
	return (0);
}

BODY BoTarget = {
	0,
	0,
	"TARGET",
	&shape_target,
	init_target,
	term_target,
	create_target,
	body_delete,
	body_dynamics,
	body_hit
};
