/* --------------------------------- colors.h ------------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* colors definition.
*/
#ifndef FLY8_COLORS
#define FLY8_COLORS

#define RGB(r,g,b)	(((0x0ffL&(b))<<16)+((0x0ffL&(g))<<8)+(0x0ffL&(r)))
 
#define C_BLACK		RGB (0x00, 0x00, 0x00)

#define C_RED		RGB (0xff, 0x00, 0x00)
#define C_GREEN		RGB (0x00, 0xff, 0x00)
#define C_BLUE		RGB (0x00, 0x00, 0xff)

#define C_CYAN		RGB (0x00, 0xff, 0xff)
#define C_MAGENTA	RGB (0xff, 0x00, 0xff)
#define C_YELLOW	RGB (0xff, 0xff, 0x00)

#define C_WHITE		RGB (0xff, 0xff, 0xff)
#define C_LIGHTGRAY	RGB (0xa0, 0xa0, 0xa0)
#define C_GRAY		RGB (0x60, 0x60, 0x60)

#define C_LIGHTRED	RGB (0xc0, 0x60, 0x60)
#define C_LIGHTGREEN	RGB (0x80, 0xff, 0x80)
#define C_LIGHTBLUE	RGB (0x80, 0x80, 0xff)

#define C_LIGHTCYAN	RGB (0x80, 0xff, 0xff)
#define C_LIGHTMAGENTA	RGB (0xff, 0x80, 0xff)

#define C_LYELLOW	RGB (0x80, 0x80, 0x00)
#define C_SKYBLUE	RGB (0x00, 0x00, 0x80)

#define C_BROWN		RGB (0x80, 0x40, 0x00)


/* These are the portable color names.
*/

#define CC_DEFAULT	-1
#define CC_BLACK	0
#define CC_WHITE	1
#define CC_RED		2
#define CC_GREEN	3
#define CC_BLUE		4
#define CC_BROWN	5
#define CC_MAGENTA	6
#define CC_GRAY		7
#define CC_HUDLOW	8
#define CC_HUDHIGH	9
#define CC_SKYBLUE	10
#define CC_LRED		11
#define CC_LGRAY	12
#define CC_GROUND	13
#define CC_LBLUE	14

#endif
