/* tkmorph-init.c */
#include <tcl.h>
#include <tk.h>


#include "tkImgTGA.h"
#include "image_tcl.h"
#include "mesh_tcl.h"
#include "warp_tcl.h"

#include "tkmorph-init.h"




/* ------------------------------------------------- */




/* mjgCmd: just a test command for my TCL learning.
**
*/
int mjgCmd(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
  static int iteration=0;
  int client_int = (int) clientData;
  int ai;

  sprintf(interp->result, "mjg: client %i iteration %i", client_int, iteration);

  printf("mjgCmd: argc = %i\n", argc);
  for(ai=0; ai < argc; ai++) {
    printf("mjgCmd: argv[%i] = '%s'\n", ai, argv[ai]);
  }

  iteration++;

  return TCL_OK;
}




/* tkMorphInit: called from Tcl_AppInit to set up TCL commands
*/
int
tkMorphInit(Tcl_Interp *interp)
{
        /*
        ** Register application-specific commands.
        */
        Tcl_CreateCommand(interp, "imageLoad", imageLoadCmd,
                        (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

        Tcl_CreateCommand(interp, "imageConvert", imageConvertCmd,
                        (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

        Tcl_CreateCommand(interp, "meshLoad", meshLoadCmd,
                        (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

        Tcl_CreateCommand(interp, "warp", warpCmd,
                        (ClientData)NULL, (Tcl_CmdDeleteProc *)NULL);

        Tcl_CreateCommand(interp, "mjg", mjgCmd,
                        (ClientData)1, (Tcl_CmdDeleteProc *)NULL);

        Tcl_CreateCommand(interp, "mike", mjgCmd,
                        (ClientData)2, (Tcl_CmdDeleteProc *)NULL);


        /* Add TGA Photo Image Format handler */
        createTGAImageFormat();

        return TCL_OK;
}
