 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %                  W   W  IIIII  DDDD    GGGG  EEEEE  TTTTT                   % O %                  W   W    I    D   D  G      E        T                     % O %                  W W W    I    D   D  G  GG  EEE      T                     % O %                  WW WW    I    D   D  G   G  E        T                     % O %                  W   W  IIIII  DDDD    GGGG  EEEEE    T                     % O %                                                                             % O %                X11 User Interface Routines for ImageMagick.                 % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                              September 1993                                 % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"    /*   Define declarations. */, #define AreaIsActive(matte_info,position)  \>   ((position.y >= (matte_info.y-matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width)))- #define MatteIsActive(matte_info,position)  \ =   ((position.x >= (matte_info.x-matte_info.bevel_width)) && \ >    (position.y >= (matte_info.y-matte_info.bevel_width)) &&  \N    (position.x < (matte_info.x+matte_info.width+matte_info.bevel_width)) &&  \J    (position.y < (matte_info.y+matte_info.height+matte_info.bevel_width)))/ #define WindowIsActive(window_info,position)  \ /   ((position.x >= 0) && (position.y >= 0) &&  \ I    (position.x < window_info.width) && (position.y < window_info.height))  /*   State declarations.  */ #define ControlState  0x0001 #define DefaultState  0x0000 #define ExitState  0x0002 # #define InactiveWidgetState  0x0004  #define JumpListState  0x0008 6 #define MaxTextWidth  (80*XTextWidth(font_info,"_",1))6 #define MinTextWidth  (26*XTextWidth(font_info,"_",1)): #define QuantumMargin  Max(font_info->max_bounds.width,12)! #define RedrawActionState  0x0010  #define RedrawListState  0x0020 ! #define RedrawWidgetState  0x0040 ( #define UpdateConfigurationState  0x0080 #define UpdateListState  0x0100    /*   Variable declarations. */ static XWidgetInfo   monitor_info =   { *     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,/     (char *) NULL, (char *) NULL, (char *) NULL    },   submenu_info =   { *     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,/     (char *) NULL, (char *) NULL, (char *) NULL    },   toggle_info =    { *     0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,/     (char *) NULL, (char *) NULL, (char *) NULL    };   /*   Function prototypes. */ static void @   XDrawMatte(Display *,const XWindowInfo *,const XWidgetInfo *),C   XSetBevelColor(Display *,const XWindowInfo *,const unsigned int), C   XSetMatteColor(Display *,const XWindowInfo *,const unsigned int), B   XSetTextColor(Display *,const XWindowInfo *,const unsigned int);   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawBevel "sets off" an area with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % , %  The format of the XDrawBevel function is: % 1 %      XDrawBevel(display,window_info,bevel_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o bevel_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the bevel.  %  %  */G static void XDrawBevel(Display *display,const XWindowInfo *window_info,    XWidgetInfo *bevel_info) {    int      x1,      x2,      y1,      y2;      unsigned int     bevel_width;     XPoint     points[6];     /*'     Draw upper and left beveled border.    */   x1=bevel_info->x; &   y1=bevel_info->y+bevel_info->height;%   x2=bevel_info->x+bevel_info->width;    y2=bevel_info->y; &   bevel_width=bevel_info->bevel_width;   points[0].x=x1;    points[0].y=y1;    points[1].x=x1;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x1-bevel_width;    points[4].y=y2-bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; 9   XSetBevelColor(display,window_info,bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin);    /*(     Draw lower and right beveled border.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y1;    points[2].x=x2;    points[2].y=y2;    points[3].x=x2+bevel_width;    points[3].y=y2-bevel_width;    points[4].x=x2+bevel_width;    points[4].y=y1+bevel_width;    points[5].x=x1-bevel_width;    points[5].y=y1+bevel_width; I   XSetBevelColor(display,window_info,(unsigned int) !bevel_info->raised); L   XFillPolygon(display,window_info->id,window_info->widget_context,points,6,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d B u t t o n                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XDrawBeveledButton draws a button with a highlighted upper andH %  left bevel and a shadowed lower and right bevel.  The highlighted and' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawBeveledButton function is: % : %      XDrawBeveledButton(display,window_info,button_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o button_info: Specifies a pointer to a XWidgetInfo structure.  It * %      contains the extents of the button. %  %  */O static void XDrawBeveledButton(Display *display,const XWindowInfo *window_info,    XWidgetInfo *button_info)  {    int      x,     y;     unsigned int
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Draw matte.    */.   XDrawBevel(display,window_info,button_info);:   XSetMatteColor(display,window_info,button_info->raised);E   XFillRectangle(display,window_info->id,window_info->widget_context, J     button_info->x,button_info->y,button_info->width,button_info->height);.   x=button_info->x-button_info->bevel_width-1;.   y=button_info->y-button_info->bevel_width-1;5   XSetForeground(display,window_info->widget_context, 1     window_info->pixel_info->trough_color.pixel); 7   if (button_info->raised || (window_info->depth == 1)) K     XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, O       button_info->width+(button_info->bevel_width << 1)+1,button_info->height+ )       (button_info->bevel_width << 1)+1); )   if (button_info->text == (char *) NULL)      return;    /*     Set cropping region.   */%   crop_info.width=button_info->width; '   crop_info.height=button_info->height;    crop_info.x=button_info->x;    crop_info.y=button_info->y;    /*     Draw text.   */#   font_info=window_info->font_info; J   width=XTextWidth(font_info,button_info->text,Extent(button_info->text));(   x=button_info->x+(QuantumMargin >> 1);   if (button_info->center)<     x=button_info->x+(button_info->width >> 1)-(width >> 1);)   y=button_info->y+((button_info->height- D     (font_info->ascent+font_info->descent)) >> 1)+font_info->ascent;1   if (button_info->width == (QuantumMargin >> 1))      {        /*7         Option button-- write label to right of button.        */.       XSetTextColor(display,window_info,True);C       x=button_info->x+button_info->width+button_info->bevel_width+          (QuantumMargin >> 1); J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         button_info->text,Extent(button_info->text)); 
       return;      } J   XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,     Unsorted);9   XSetTextColor(display,window_info,button_info->raised); F   XDrawString(display,window_info->id,window_info->widget_context,x,y,1     button_info->text,Extent(button_info->text)); 9   XSetClipMask(display,window_info->widget_context,None);    if (!button_info->raised) %     XDelay(display,SuspendTime << 2);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w B e v e l e d M a t t e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawBeveledMatte draws a matte with a shadowed upper and K %  left bevel and a highlighted lower and right bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawBeveledMatte function is:  % 8 %      XDrawBeveledMatte(display,window_info,matte_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */N static void XDrawBeveledMatte(Display *display,const XWindowInfo *window_info,   XWidgetInfo *matte_info) {    /*     Draw matte.    */-   XDrawBevel(display,window_info,matte_info); -   XDrawMatte(display,window_info,matte_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Function XDrawMatte fills a rectangular area with the matte color.  % , %  The format of the XDrawMatte function is: % 1 %      XDrawMatte(display,window_info,matte_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % F %    o matte_info: Specifies a pointer to a XWidgetInfo structure.  It) %      contains the extents of the matte.  %  %  */G static void XDrawMatte(Display *display,const XWindowInfo *window_info,     const XWidgetInfo *matte_info) {    /*     Draw matte.    */7   if (!matte_info->trough || (window_info->depth == 1)) J     XFillRectangle(display,window_info->id,window_info->highlight_context,H       matte_info->x,matte_info->y,matte_info->width,matte_info->height);   else     { 9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->trough_color.pixel); I       XFillRectangle(display,window_info->id,window_info->widget_context, J         matte_info->x,matte_info->y,matte_info->width,matte_info->height);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w M a t t e T e x t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDrawMatteText draws a matte with text.  If the text exceeds theG %  extents of the text, a portion of the text relative to the cursor is 
 %  displayed.  % 0 %  The format of the XDrawMatteText function is: % 4 %      XDrawMatteText(display,window_info,text_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. %  %  */K static void XDrawMatteText(Display *display,const XWindowInfo *window_info,    XWidgetInfo *text_info)  {    char
     *text;     int      n,     x,     y;     register int     i;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   */,   XSetMatteColor(display,window_info,False);E   XFillRectangle(display,window_info->id,window_info->widget_context, B     text_info->x,text_info->y,text_info->width,text_info->height);'   if (text_info->text == (char *) NULL)      return; :   XSetTextColor(display,window_info,text_info->highlight);#   font_info=window_info->font_info; &   x=text_info->x+(QuantumMargin >> 2);<   y=text_info->y+font_info->ascent+(text_info->height >> 2);.   width=text_info->width-(QuantumMargin >> 1);.   height=font_info->ascent+font_info->descent;   if (*text_info->text == '\0')      {        /*#         No text-- just draw cursor.        */L       XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,         x,y-height+3);
       return;      }    /*     Set cropping region.   */#   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*,     Determine beginning of the visible text.   */,   if (text_info->cursor < text_info->marker)(     text_info->marker=text_info->cursor;   else     {        text=text_info->marker; L       if (XTextWidth(font_info,text,(int) (text_info->cursor-text)) > width)	         {            text=text_info->text; *           for (i=0; i < Extent(text); i++)           { L             n=XTextWidth(font_info,text+i,(int) (text_info->cursor-text-i));             if (n <= width)                break;           } #           text_info->marker=text+i; 	         }      }    /*     Draw text and cursor.    */   if (!text_info->highlight)     { N       XSetClipRectangles(display,window_info->widget_context,0,0,&crop_info,1,         Unsorted);J       XDrawString(display,window_info->id,window_info->widget_context,x,y,5         text_info->marker,Extent(text_info->marker)); =       XSetClipMask(display,window_info->widget_context,None);      }    else     { N       XSetClipRectangles(display,window_info->annotate_context,0,0,&crop_info,         1,Unsorted);N       width=XTextWidth(font_info,text_info->marker,Extent(text_info->marker));M       XFillRectangle(display,window_info->id,window_info->annotate_context,x, *         y-font_info->ascent,width,height);?       XSetClipMask(display,window_info->annotate_context,None); O       XSetClipRectangles(display,window_info->highlight_context,0,0,&crop_info,          1,Unsorted);M       XDrawString(display,window_info->id,window_info->highlight_context,x,y, 5         text_info->marker,Extent(text_info->marker)); @       XSetClipMask(display,window_info->highlight_context,None);     } 1   x+=XTextWidth(font_info,text_info->marker,(int) +     (text_info->cursor-text_info->marker)); H   XDrawLine(display,window_info->id,window_info->annotate_context,x,y+3,     x,y-height+3); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e E a s t                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XDrawTriangleEast draws a triangle with a highlighted leftC %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 3 %  The format of the XDrawTriangleEast function is:  % ; %      XDrawTriangleEast(display,window_info,triangle_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */N static void XDrawTriangleEast(Display *display,const XWindowInfo *window_info,   XWidgetInfo *triangle_info)  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;  
   XFontStruct      *font_info;      XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;+   x2=triangle_info->x+triangle_info->width; 3   y2=triangle_info->y+(triangle_info->height >> 1);    x3=triangle_info->x;,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw bottom bevel.   */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3-bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2+bevel_width;    points[3].y=y2; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw Left bevel.   */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width+1;    points[2].y=y1-bevel_width;    points[3].x=x3-bevel_width+1;    points[3].y=y3+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2+bevel_width;    points[2].y=y2;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid); +   if (triangle_info->text == (char *) NULL)      return;    /*%     Write label to right of triangle.    */#   font_info=window_info->font_info; *   XSetTextColor(display,window_info,True);F   x1=triangle_info->x+triangle_info->width+triangle_info->bevel_width+     (QuantumMargin >> 1); .   y1=triangle_info->y+((triangle_info->height-D     (font_info->ascent+font_info->descent)) >> 1)+font_info->ascent;H   XDrawString(display,window_info->id,window_info->widget_context,x1,y1,5     triangle_info->text,Extent(triangle_info->text));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e N o r t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XDrawTriangleNorth draws a triangle with a highlighted left C %  bevel and a shadowed right and lower bevel.  The highlighted and ' %  shadowed bevels create a 3-D effect.  % 4 %  The format of the XDrawTriangleNorth function is: % < %      XDrawTriangleNorth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */O static void XDrawTriangleNorth(Display *display,const XWindowInfo *window_info,    XWidgetInfo *triangle_info)  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;,   y1=triangle_info->y+triangle_info->height;2   x2=triangle_info->x+(triangle_info->width >> 1);   y2=triangle_info->y;+   x3=triangle_info->x+triangle_info->width; ,   y3=triangle_info->y+triangle_info->height;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2-bevel_width-2;    points[3].x=x1-bevel_width-1;    points[3].y=y1+bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3;    points[1].y=y3;    points[2].x=x3+bevel_width;    points[2].y=y3+bevel_width;    points[3].x=x2;    points[3].y=y2-bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw lower bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1+bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3+bevel_width; L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w T r i a n g l e S o u t h                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XDrawTriangleSouth draws a border with a highlighted left and H %  right bevel and a shadowed lower bevel.  The highlighted and shadowed %  bevels create a 3-D effect. % 4 %  The format of the XDrawTriangleSouth function is: % < %      XDrawTriangleSouth(display,window_info,triangle_info) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % I %    o triangle_info: Specifies a pointer to a XWidgetInfo structure.  It , %      contains the extents of the triangle. %  %  */O static void XDrawTriangleSouth(Display *display,const XWindowInfo *window_info,    XWidgetInfo *triangle_info)  {    int      x1,      x2,      x3,      y1,      y2,      y3;      unsigned int     bevel_width;     XPoint     points[4];     /*     Draw triangle matte.   */   x1=triangle_info->x;   y1=triangle_info->y;2   x2=triangle_info->x+(triangle_info->width >> 1);,   y2=triangle_info->y+triangle_info->height;+   x3=triangle_info->x+triangle_info->width;    y3=triangle_info->y;)   bevel_width=triangle_info->bevel_width;    points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x3;    points[2].y=y3; <   XSetMatteColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,3,     Complex,CoordModeOrigin);    /*     Draw top bevel.    */   points[0].x=x3;    points[0].y=y3;    points[1].x=x1;    points[1].y=y1;    points[2].x=x1-bevel_width;    points[2].y=y1-bevel_width;    points[3].x=x3+bevel_width;    points[3].y=y3-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw right bevel.    */   points[0].x=x2;    points[0].y=y2;    points[1].x=x3+1;    points[1].y=y3-bevel_width;    points[2].x=x3+bevel_width;    points[2].y=y3-bevel_width;    points[3].x=x2;    points[3].y=y2+bevel_width; L   XSetBevelColor(display,window_info,(unsigned int) !triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin);    /*     Draw left bevel.   */   points[0].x=x1;    points[0].y=y1;    points[1].x=x2;    points[1].y=y2;    points[2].x=x2;    points[2].y=y2+bevel_width;    points[3].x=x1-bevel_width;    points[3].y=y1-bevel_width; <   XSetBevelColor(display,window_info,triangle_info->raised);L   XFillPolygon(display,window_info->id,window_info->widget_context,points,4,     Complex,CoordModeOrigin); ?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D r a w W i d g e t T e x t                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Function XDrawWidgetText first clears the widget and draws a text string G %  justifed left (or center) in the x-direction and centered within the  %  y-direction.  % 1 %  The format of the XDrawWidgetText function is:  % 5 %      XDrawWidgetText(display,window_info,text_info)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % C %    o window_info: Specifies a pointer to a XWindowText structure.  % ? %    o text_info: Specifies a pointer to XWidgetInfo structure.  %  %  */L static void XDrawWidgetText(Display *display,const XWindowInfo *window_info,   XWidgetInfo *text_info)  {    GC     widget_context;      int      x,     y;     unsigned int     height, 
     width;  
   XFontStruct      *font_info;      XRectangle     crop_info;     /*     Clear the text area.   *//   widget_context=window_info->annotate_context;    if (text_info->raised)A     XClearArea(display,window_info->id,text_info->x,text_info->y, 0       text_info->width,text_info->height,False);   else     { I       XFillRectangle(display,window_info->id,widget_context,text_info->x, 9         text_info->y,text_info->width,text_info->height); 4       widget_context=window_info->highlight_context;     } '   if (text_info->text == (char *) NULL)      return;    if (*text_info->text == '\0')      return;    /*     Set cropping region.   */#   font_info=window_info->font_info; #   crop_info.width=text_info->width; %   crop_info.height=text_info->height;    crop_info.x=text_info->x;    crop_info.y=text_info->y;    /*     Draw text.   */F   width=XTextWidth(font_info,text_info->text,Extent(text_info->text));&   x=text_info->x+(QuantumMargin >> 1);   if (text_info->center)8     x=text_info->x+(text_info->width >> 1)-(width >> 1);   if (text_info->raised)1     if (width > (text_info->width-QuantumMargin)) 0       x+=(text_info->width-QuantumMargin-width);.   height=font_info->ascent+font_info->descent;E   y=text_info->y+((text_info->height-height) >> 1)+font_info->ascent; G   XSetClipRectangles(display,widget_context,0,0,&crop_info,1,Unsorted); I   XDrawString(display,window_info->id,widget_context,x,y,text_info->text,      Extent(text_info->text)); ,   XSetClipMask(display,widget_context,None);   if (x < text_info->x) D     XDrawLine(display,window_info->id,window_info->annotate_context,O       text_info->x,text_info->y,text_info->x,text_info->y+text_info->height-1);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X E d i t T e x t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XEditText edits a text string as indicated by the key symbol.  % + %  The format of the XEditText function is:  % 9 %      XEditText(display,text_info,key_symbol,text,state)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % E %    o text_info: Specifies a pointer to a XWidgetInfo structure.  It ( %      contains the extents of the text. % H %    o key_symbol:  A X11 KeySym that indicates what editing function to %      perform to the text.  % 8 %    o text: A character string to insert into the text. % J %    o state:  An unsigned long that indicates whether the key symbol is a  %      control character or not. %  %  */> static void XEditText(Display *display,XWidgetInfo *text_info,?   const KeySym key_symbol,char *text,const unsigned long state)  {    switch (key_symbol)    {      case XK_BackSpace:     case XK_Delete:      {        if (text_info->highlight) 	         {            /**             Erase the entire line of text.           */            *text_info->text='\0';,           text_info->cursor=text_info->text;,           text_info->marker=text_info->text;%           text_info->highlight=False; 	         }        /*         Erase one character.       *//       if (text_info->cursor != text_info->text) 	         {            text_info->cursor--;?           (void) strcpy(text_info->cursor,text_info->cursor+1); %           text_info->highlight=False;            break;	         }      }      case XK_Left:      case XK_KP_Left:     {        /*&         Move cursor one position left.       *//       if (text_info->cursor == text_info->text)          break;       text_info->cursor--;       break;     }      case XK_Right:     case XK_KP_Right:      {        /*'         Move cursor one position right.        */I       if (text_info->cursor == (text_info->text+Extent(text_info->text)))          break;       text_info->cursor++;       break;     }      default:     {        register char          *p,          *q;          register int
         i;         if (state & ControlState)          break;       if (*text == '\0')         break;7       if ((Extent(text_info->text)+1) >= MaxTextExtent)          XBell(display,0); 
       else	         { #           if (text_info->highlight) 
             {                /*.                 Erase the entire line of text.               */$               *text_info->text='\0';0               text_info->cursor=text_info->text;0               text_info->marker=text_info->text;)               text_info->highlight=False; 
             }            /**             Insert a string into the text.           */A           q=text_info->text+Extent(text_info->text)+Extent(text); 8           for (i=0; i <= Extent(text_info->cursor); i++)           { #             *q=(*(q-Extent(text)));              q--;           }            p=text; *           for (i=0; i < Extent(text); i++)(             *text_info->cursor++=(*p++);	         }        break;     }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X G e t W i d g e t I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Function XGetWidgetInfo initializes the XWidgetInfo structure.  % 0 %  The format of the XGetWidgetInfo function is: % ' %      XGetWidgetInfo(text,widget_info)  % + %  A description of each parameter follows:  % ? %    o text: A string of characters associated with the widget.  % G %    o widget_info: Specifies a pointer to a X11 XWidgetInfo structure.  %  %  */? static void XGetWidgetInfo(char *text,XWidgetInfo *widget_info)  {    /*     Initialize widget info.    */   widget_info->id=(~0);    widget_info->bevel_width=3;    widget_info->width=1;    widget_info->height=1;   widget_info->x=0;    widget_info->y=0;    widget_info->min_y=0;    widget_info->max_y=0;    widget_info->raised=True;    widget_info->active=False;   widget_info->center=True;    widget_info->trough=False;   widget_info->highlight=False;    widget_info->text=text;    widget_info->cursor=text;    if (text != (char *) NULL)&     widget_info->cursor+=Extent(text);   widget_info->marker=text;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X H i g h l i g h t W i d g e t                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XHighlightWidget draws a highlighted border around a window. % 2 %  The format of the XHighlightWidget function is: % 0 %      XHighlightWidget(display,window_info,x,y) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % G %    o x: Specifies an integer representing the rectangle offset in the  %      x-direction.  % G %    o y: Specifies an integer representing the rectangle offset in the  %      y-direction.  %  %  */M static void XHighlightWidget(Display *display,const XWindowInfo *window_info,    int x,int y) {    /*+     Draw the widget highlighting rectangle.    */+   XSetBevelColor(display,window_info,True); I   XDrawRectangle(display,window_info->id,window_info->widget_context,x,y, >     window_info->width-(x << 1),window_info->height-(y << 1));M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, B     window_info->width-(x << 1)+1,window_info->height-(y << 1)+1);,   XSetBevelColor(display,window_info,False);M   XDrawRectangle(display,window_info->id,window_info->widget_context,x-1,y-1, >     window_info->width-(x << 1),window_info->height-(y << 1));?   XSetFillStyle(display,window_info->widget_context,FillSolid);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S c r e e n E v e n t                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XScreenEvent returns True if the any event on the X server queue( %  is associated with the widget window. % . %  The format of the XScreenEvent function is: % ' %      XScreenEvent(display,event,data)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % < %    o event: Specifies a pointer to a X11 XEvent structure. % 9 %    o data: Specifies a pointer to a XWindows structure.  %  %  */B static int XScreenEvent(Display *display,XEvent *event,char *data) { 
   XWindows
     *windows;      windows=(XWindows *) data;.   if (event->xany.window == windows->popup.id)     { #       if (event->type == MapNotify) #         windows->popup.mapped=True; %       if (event->type == UnmapNotify) $         windows->popup.mapped=False;       return(True);      } /   if (event->xany.window == windows->widget.id)      { #       if (event->type == MapNotify) $         windows->widget.mapped=True;%       if (event->type == UnmapNotify) %         windows->widget.mapped=False;        return(True);      }    switch (event->type)   {      case ButtonPress:      { /       if ((event->xbutton.button == Button3) && ,           (event->xbutton.state & Mod1Mask))	         {            /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         }        return(True);      }      case Expose:     { 5       if (event->xexpose.window == windows->image.id) 	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         } 7       if (event->xexpose.window == windows->magnify.id) &         if (event->xexpose.count == 0)&           if (windows->magnify.mapped)
             { 1               XMakeMagnifyImage(display,windows);                break;
             } 7       if (event->xexpose.window == windows->command.id) &         if (event->xexpose.count == 0)           { H             (void) XCommandWidget(display,windows,(char **) NULL,event);             break;           }        break;     }      case FocusOut:     {        /*,         Set input focus for backdrop window.       */4       if (event->xfocus.window == windows->image.id)K         XSetInputFocus(display,windows->image.id,RevertToNone,CurrentTime);        return(True);      }      case ButtonRelease:      case KeyPress:     case KeyRelease:     case MotionNotify:     case SelectionNotify:        return(True);      default:       break;   }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t B e v e l C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Function XSetBevelColor sets the graphic context for drawing a beveled 
 %  border. % 0 %  The format of the XSetBevelColor function is: % 1 %      XSetBevelColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */K static void XSetBevelColor(Display *display,const XWindowInfo *window_info,    const unsigned int raised) {    if (window_info->depth == 1)     {        Pixmap         stipple;         /*         Monochrome window.       */9       XSetBackground(display,window_info->widget_context, 2         XBlackPixel(display,window_info->screen));9       XSetForeground(display,window_info->widget_context, 2         XWhitePixel(display,window_info->screen));L       XSetFillStyle(display,window_info->widget_context,FillOpaqueStippled);-       stipple=window_info->highlight_stipple;        if (!raised),         stipple=window_info->shadow_stipple;?       XSetStipple(display,window_info->widget_context,stipple);      }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 8         window_info->pixel_info->highlight_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 5         window_info->pixel_info->shadow_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t M a t t e C o l o r                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XSetMatteColor sets the graphic context for drawing the matte. % 0 %  The format of the XSetMatteColor function is: % 1 %      XSetMatteColor(display,window_info,raised)  % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % E %    o raised: A value other than zero indicates the matte is active.  %  %  */K static void XSetMatteColor(Display *display,const XWindowInfo *window_info,    const unsigned int raised) {    if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));     }    else     if (raised) 9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->matte_color.pixel);     else9       XSetForeground(display,window_info->widget_context, 4         window_info->pixel_info->depth_color.pixel); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X S e t T e x t C o l o r                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XSetTextColor sets the graphic context for drawing text on a	 %  matte.  % / %  The format of the XSetTextColor function is:  % 0 %      XSetTextColor(display,window_info,raised) % + %  A description of each parameter follows:  % L %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. % G %    o window_info: Specifies a pointer to a X11 XWindowInfo structure.  % D %    o raised: A value other than zero indicates the color show be a> %      "highlight" color, otherwise the "shadow" color is set. %  %  */J static void XSetTextColor(Display *display,const XWindowInfo *window_info,   const unsigned int raised) {    int      foreground, 
     matte;     if (window_info->depth == 1)     {        /*         Monochrome window.       */       if (raised) ;         XSetForeground(display,window_info->widget_context, 4           XBlackPixel(display,window_info->screen));
       else;         XSetForeground(display,window_info->widget_context, 4           XWhitePixel(display,window_info->screen));
       return;      } N   foreground=XDownScale(Intensity(window_info->pixel_info->foreground_color));D   matte=XDownScale(Intensity(window_info->pixel_info->matte_color));6   if (AbsoluteValue(foreground-matte) > (MaxRGB >> 3))7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->foreground_color.pixel);    else7     XSetForeground(display,window_info->widget_context, 7       window_info->pixel_info->background_color.pixel);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r B r o w s e r W i d g e t                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XColorBrowserWidget displays a Color Browser widget with a colorM %  query to the user.  The user keys a reply and presses the Action or Cancel O %  button to exit.  The typed text is returned as the reply function parameter.  % 4 %  The format of the XColorBrowserWidget routine is: % 6 %    XColorBrowserWidget(display,windows,action,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % G %    o reply: The response from the user is returned in this parameter.  %  %  */P Export void XColorBrowserWidget(Display *display,XWindows *windows,char *action,   char *reply) { " #define CancelButtonText  "Cancel" #define ColornameText  "Name:"$ #define ColorPatternText  "Pattern:" #define GrabButtonText  "Grab"  #define ResetButtonText  "Reset"     char     **colorlist,%     primary_selection[MaxTextExtent], !     reset_pattern[MaxTextExtent],      text[MaxTextExtent];     int      colors,      status,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextExtent] = "*";  
   static char *     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,      text_width,      visible_colors, 
     width;     unsigned long 
     delay,
     state;     XColor
     color;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     expose_info,     grab_info,     list_info,     mode_info,     north_info,      reply_info,      reset_info,      scroll_info,     selection_info,      slider_info,     south_info,      text_info;     XWindowChanges     window_changes;      /*/     Get color list and sort in ascending order.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(action != (char *) NULL);!   assert(reply != (char *) NULL); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);#   (void) strcpy(reset_pattern,"*"); -   colorlist=ListColors(glob_pattern,&colors); "   if (colorlist == (char **) NULL)     {        /*.         Pattern failed, obtain all the colors.       */&       (void) strcpy(glob_pattern,"*");1       colorlist=ListColors(glob_pattern,&colors); &       if (colorlist == (char **) NULL)	         { I           XNoticeWidget(display,windows,"Unable to obtain colors names:",              glob_pattern);J           (void) XDialogWidget(display,windows,action,"Enter color name:",             reply);            return; 	         }      }    /*.     Determine Color Browser widget attributes.   */&   font_info=windows->widget.font_info;   text_width=0;    for (i=0; i < colors; i++)M     if (XTextWidth(font_info,colorlist[i],Extent(colorlist[i])) > text_width) I       text_width=XTextWidth(font_info,colorlist[i],Extent(colorlist[i])); 4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText));J   if (XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText));   width+=QuantumMargin; N   if (XTextWidth(font_info,ColorPatternText,Extent(ColorPatternText)) > width)J     width=XTextWidth(font_info,ColorPatternText,Extent(ColorPatternText));H   if (XTextWidth(font_info,ColornameText,Extent(ColornameText)) > width)D     width=XTextWidth(font_info,ColornameText,Extent(ColornameText));.   height=font_info->ascent+font_info->descent;   /*"     Position Color Browser widget.   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Color Browser widget.    */B   (void) strcpy(windows->widget.name,"Browse and Select a Color");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_colors=0;    delay=SuspendTime << 2; !   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          int 
           id;   
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1; N         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(GrabButtonText,&grab_info);         grab_info.width=width;)         grab_info.height=(3*height) >> 1; "         grab_info.x=QuantumMargin;4         grab_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width; *         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin; @         reset_info.y=grab_info.y+grab_info.height+QuantumMargin;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*&           Initialize mode information.
         */1         XGetWidgetInfo((char *) NULL,&mode_info);          mode_info.active=True;          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin; ,         mode_info.height=action_info.height;!         mode_info.x=reply_info.x; "         mode_info.y=action_info.y;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height; I         scroll_info.height=reply_info.y-grab_info.y-(QuantumMargin >> 1); H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=grab_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width; -         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_colors= A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3); $         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x; "         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState; 
         /*&           Initialize text information.
         */         *text='\0'; (         XGetWidgetInfo(text,&text_info);         text_info.center=False; )         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*&           Redraw Color Browser window.
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,9           x,y,ColorPatternText,Extent(ColorPatternText)); 9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledButton(display,&windows->widget,&grab_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info); ?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,ColornameText,Extent(ColornameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0); !         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {          char           **checklist;           int            number_colors;  F         status=XParseColor(display,windows->widget.map_info->colormap,           glob_pattern,&color); I         if ((status != 0) || (strchr(glob_pattern,'-') != (char *) NULL))            {              /*2               Reply is a single color name-- exit.             */.             (void) strcpy(reply,glob_pattern);6             (void) strcpy(glob_pattern,reset_pattern);%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 
         /*           Update color list.
         */:         checklist=ListColors(glob_pattern,&number_colors);         if (number_colors == 0)            { 6             (void) strcpy(glob_pattern,reset_pattern);             XBell(display,0);            }          else           { &             for (i=0; i < colors; i++)*               free((char *) colorlist[i]);,             if (colorlist != (char **) NULL)'               free((char *) colorlist);               colorlist=checklist;!             colors=number_colors;            } 
         /*-           Sort color list in ascending order. 
         */         slider_info.height= J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;$         if (colors > visible_colors)H           slider_info.height=(visible_colors*slider_info.height)/colors;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*$           Redraw color name & reply.
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); "         state&=(~UpdateListState);       }      if (state & JumpListState)       { 
         /**           Jump scroll to match user color.
         */         list_info.id=(~0);"         for (i=0; i < colors; i++).           if (strcmp(colorlist[i],reply) >= 0)
             { D               list_info.id=strcmp(colorlist[i],reply) == 0 ? i : ~0;               break;
             } K         if ((i < slider_info.id) || (i >= (slider_info.id+visible_colors))) 1           slider_info.id=i-(visible_colors >> 1);          selection_info.id=(~0);          state|=RedrawListState;           state&=(~JumpListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position. 
         */<         if (slider_info.id >= (int) (colors-visible_colors))/           slider_info.id=colors-visible_colors; ?         if ((slider_info.id < 0) || (colors <= visible_colors))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (colors > 0)            slider_info.y+= J             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/colors;0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; .             for (i=0; i < visible_colors; i++)
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;.               if ((slider_info.id+i) < colors)@                 selection_info.text=colorlist[slider_info.id+i];H               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               } E             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       {          static char #           colorname[MaxTextExtent];   
         /*7           Display the selected color in a drawing area. 
         */6         color=windows->widget.pixel_info->matte_color;F         (void) XParseColor(display,windows->widget.map_info->colormap,D           reply_info.text,&windows->widget.pixel_info->matte_color);N         XBestPixel(display,windows->widget.map_info->colormap,(XColor *) NULL,D           (unsigned int) windows->widget.visual_info->colormap_size,4           &windows->widget.pixel_info->matte_color);!         mode_info.text=colorname; 6         (void) sprintf(mode_info.text,"#%02x%02x%02x",B           XDownScale(windows->widget.pixel_info->matte_color.red),D           XDownScale(windows->widget.pixel_info->matte_color.green),D           XDownScale(windows->widget.pixel_info->matte_color.blue));@         XDrawBeveledButton(display,&windows->widget,&mode_info);6         windows->widget.pixel_info->matte_color=color;$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState; 
             }          if (!south_info.raised) &           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */               slider_info.id++; %               state|=RedrawListState; 
             } (         if (event.type != ButtonRelease)           continue;        }      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))&           if (slider_info.id < colors)
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)1               slider_info.id-=(visible_colors-1);              else1               slider_info.id+=(visible_colors-1); #             state|=RedrawListState;              break;           } 3         if (MatteIsActive(list_info,event.xbutton))            {              unsigned int               id;                /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= colors)                break;9             (void) strcpy(reply_info.text,colorlist[id]); '             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState; #             if (id == list_info.id)                { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                } #             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;              break;           } 3         if (MatteIsActive(grab_info,event.xbutton))            {              /*'               User pressed Grab button.              */#             grab_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } 4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } 3         if (MatteIsActive(mode_info,event.xbutton))            {              /*'               User pressed mode button.              */:             (void) strcpy(reply_info.text,mode_info.text);=             (void) strcpy(primary_selection,reply_info.text); E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, "               event.xbutton.time);J             reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==!               windows->widget.id; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {              /*)               User pressed action button.              */%             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*)               User pressed Cancel button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {              static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);            }          if (slider_info.active)            {              /*#               Stop tracking slider.              */%             slider_info.active=False;              break;           }          if (!grab_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(grab_info,event.xbutton))                  {                    /*9                     Select a pen color from the X server.                    */B                   (void) XGetWindowColor(display,reply_info.text);4                   reply_info.marker=reply_info.text;L                   reply_info.cursor=reply_info.text+Extent(reply_info.text);G                   XDrawMatteText(display,&windows->widget,&reply_info); +                   state|=RedrawActionState;                  } "             grab_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&grab_info);           }          if (!reset_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) :               if (MatteIsActive(reset_info,event.xbutton))                 { <                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;                  } #             reset_info.raised=True; E             XDrawBeveledButton(display,&windows->widget,&reset_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0') #                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }           if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  { (                   *reply_info.text='\0';#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } 5         if (!MatteIsActive(reply_info,event.xbutton))            break;         break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            { "             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextExtent];            static int           length;            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:                case XK_KP_Home:               { !                 slider_info.id=0;                  break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                { /                 slider_info.id-=visible_colors;                  break;               }                case XK_Next:                case XK_KP_Next:               { /                 slider_info.id+=visible_colors;                  break;               }                case XK_End:               case XK_KP_End:                { &                 slider_info.id=colors;                 break;               } 
             } #             state|=RedrawListState;              break;           } E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*-               Read new color or glob patterm.              */)             if (*reply_info.text == '\0')                break;8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)            switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          state|=JumpListState; F         status=XParseColor(display,windows->widget.map_info->colormap,"           reply_info.text,&color);         if (status != 0)#           state|=RedrawActionState;          break;       }        case KeyRelease:       {          static char !           command[MaxTextExtent];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MapNotify:        {          mask&=(~CWX);          mask&=(~CWY);          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y) J               slider_info.id=(colors*(slider_info.y-slider_info.min_y+1))/8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (grab_info.raised == MatteIsActive(grab_info,event.xmotion))            {              /*)               Grab button status changed.              *//             grab_info.raised=!grab_info.raised; D             XDrawBeveledButton(display,&windows->widget,&grab_info);             break;           } I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))            {              /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised; E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised; F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       { #         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);          break;       }        case SelectionNotify:        {          Atom           type;            int            format,            status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);          else           {              /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info); !             state|=JumpListState; %             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free color list.   */   for (i=0; i < colors; i++)      free((char *) colorlist[i]);"   if (colorlist != (char **) NULL)     free((char *) colorlist); ?   if ((*reply == '\0') || (strchr(reply,'-') != (char *) NULL))      return; N   status=XParseColor(display,windows->widget.map_info->colormap,reply,&color);   if (status != 0)     return; G   XNoticeWidget(display,windows,"Color is unknown to X server:",reply);    (void) strcpy(reply,"gray"); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m m a n d W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XCommandWidget maps a menu and returns the command pointed to by( %  the user when the button is released. % / %  The format of the XCommandWidget routine is:  % F %    selection_number=XCommandWidget(display,windows,selections,event) % + %  A description of each parameter follows:  % G %    o selection_number: Specifies the number of the selection that the  %      user choose.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % K %    o selections: Specifies a pointer to one or more strings that comprise  %      the choices in the menu.  % < %    o event: Specifies a pointer to a X11 XEvent structure. %  %  */O Export int XCommandWidget(Display *display,XWindows *windows,char **selections,    XEvent *event) {  #define tile_width 112 #define tile_height 70  #   static unsigned char tile_bits[]=    { K     0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x1e, 0x38, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x1e, 0xbc, 0x9f, 0x03, 0x00, 0x3e, 0x00, 0xc0, K     0x1f, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x0f, 0x80, 0x3f, K     0x00, 0xf0, 0x1f, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, 0xff, 0x1f, K     0xe0, 0x3f, 0x00, 0xfc, 0x1f, 0xf0, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0xfc, K     0xff, 0x1f, 0xf0, 0x3f, 0x00, 0xfe, 0x1f, 0xf8, 0x0f, 0x00, 0x00, 0x00, K     0x1e, 0xfc, 0xfc, 0x3f, 0xf8, 0x3f, 0x00, 0xff, 0x1e, 0xfc, 0x0f, 0x00, K     0x00, 0x00, 0x1e, 0x7c, 0xfc, 0x3e, 0xf8, 0x3c, 0x80, 0x1f, 0x1e, 0x7c, K     0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, 0xc0, 0x0f, K     0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, 0x7c, 0x3c, K     0xc0, 0x07, 0x1e, 0x3e, 0x0f, 0x00, 0x00, 0x00, 0x1e, 0x78, 0x78, 0x3c, K     0x7c, 0x7c, 0xc0, 0x0f, 0x1e, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x78, K     0x78, 0x3c, 0xfc, 0x7c, 0x80, 0x7f, 0x1e, 0x7c, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0xf8, 0x78, 0x7c, 0xf8, 0xff, 0x00, 0xff, 0x1f, 0xf8, 0xff, 0x00, K     0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xfe, 0x1f, 0xf8, K     0xff, 0x00, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xf0, 0xff, 0x07, 0xf8, K     0x1f, 0xf0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0xf8, 0x78, 0x7c, 0xc0, 0xef, K     0x07, 0xe0, 0x1f, 0xc0, 0xff, 0x01, 0x00, 0x00, 0x1e, 0x70, 0x40, 0x78, K     0x00, 0xc7, 0x07, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1e, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, K     0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xc0, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x02, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x07, K     0x1e, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x60, 0x00, 0xc0, 0x0f, 0x1f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xc0, 0x8f, 0x3f, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0x9f, 0x7f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x78, 0x00, 0xe0, 0xdf, K     0x7f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x78, 0x00, K     0xe0, 0xdf, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x0c, K     0x78, 0x30, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1e, K     0x00, 0x0f, 0xf8, 0x70, 0xf0, 0xff, 0x7b, 0x00, 0x00, 0x1f, 0x00, 0xe0, K     0x0f, 0x1e, 0x80, 0x0f, 0xf8, 0x78, 0xf0, 0xfd, 0xf9, 0x00, 0xc0, 0x1f, K     0x00, 0xf8, 0x0f, 0x00, 0xe0, 0x1f, 0xf8, 0x7c, 0xf0, 0xfc, 0xf9, 0x00, K     0xf0, 0x1f, 0x00, 0xfe, 0x0f, 0x00, 0xf0, 0x07, 0xf8, 0x3e, 0xf8, 0xfc, K     0xf0, 0x01, 0xf8, 0x1f, 0x00, 0xff, 0x0f, 0x1e, 0xf0, 0x03, 0xf8, 0x3f, K     0xf8, 0xf8, 0xf0, 0x01, 0xfc, 0x1f, 0x80, 0x7f, 0x0f, 0x1e, 0xf8, 0x00, K     0xf8, 0x1f, 0x78, 0x18, 0xf0, 0x01, 0x7c, 0x1e, 0xc0, 0x0f, 0x0f, 0x1e, K     0x7c, 0x00, 0xf0, 0x0f, 0x78, 0x00, 0xf0, 0x01, 0x3e, 0x1e, 0xe0, 0x07, K     0x0f, 0x1e, 0x7c, 0x00, 0xf0, 0x07, 0x7c, 0x00, 0xe0, 0x01, 0x3e, 0x1e, K     0xe0, 0x03, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x0f, 0x7c, 0x00, 0xe0, 0x03, K     0x3e, 0x3e, 0xe0, 0x07, 0x0f, 0x1e, 0x1e, 0x00, 0xf0, 0x1f, 0x3c, 0x00, K     0xe0, 0x03, 0x7e, 0x3e, 0xc0, 0x3f, 0x0f, 0x1e, 0x3e, 0x00, 0xf0, 0x1f, K     0x3e, 0x00, 0xe0, 0x03, 0xfc, 0x7f, 0x80, 0xff, 0x0f, 0x1e, 0xfc, 0x00, K     0xf0, 0x3e, 0x3e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xff, 0x0f, 0x1e, K     0xfc, 0x07, 0xf0, 0x7c, 0x1e, 0x00, 0xc0, 0x03, 0xf8, 0xff, 0x03, 0xfc, K     0x0f, 0x1e, 0xf8, 0x1f, 0xf0, 0xf8, 0x1e, 0x00, 0xc0, 0x03, 0xe0, 0xf7, K     0x03, 0xf0, 0x0f, 0x1e, 0xe0, 0x3f, 0xf0, 0x78, 0x1c, 0x00, 0x80, 0x03, K     0x80, 0xe3, 0x03, 0x00, 0x0f, 0x1e, 0xc0, 0x3f, 0xf0, 0x30, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x00, 0x3e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, 0x00, 0x10, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0f, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, K     0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0xe0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, K     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 2     0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   };     int      id,      y;     register int     i;     static unsigned int      number_selections;     static XWidgetInfo+     *selection_info = (XWidgetInfo *) NULL;      unsigned int     height;      unsigned long 
     state;  
   XFontStruct      *font_info;   &   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); '   font_info=windows->command.font_info; .   height=font_info->ascent+font_info->descent;   state=DefaultState;    if (event == (XEvent *) NULL)      {        unsigned int         width;         XTextProperty          window_name;         XWindowChanges         window_changes;          /*,         Determine command window attributes.       */+       assert(selections != (char **) NULL);        windows->command.width=0; 4       for (i=0; selections[i] != (char *) NULL; i++)       { H         width=XTextWidth(font_info,selections[i],Extent(selections[i]));+         if (width > windows->command.width) '           windows->command.width=width;        }        number_selections=i;1       windows->command.width+=3*QuantumMargin+10; A       if (windows->command.width < (tile_width+QuantumMargin+10)) ;         windows->command.width=tile_width+QuantumMargin+10;        windows->command.height=@         number_selections*(((3*height) >> 1)+10)+tile_height+20;8       windows->command.min_width=windows->command.width;:       windows->command.min_height=windows->command.height;:       XConstrainWindowPosition(display,&windows->command);/       if (windows->command.id != (Window) NULL) 	         { 
           int              status;              /*'             Reconfigure command window.            */D           status=XStringListToTextProperty(&windows->command.name,1,             &window_name);           if (status != 0)
             { C               XSetWMName(display,windows->command.id,&window_name); G               XSetWMIconName(display,windows->command.id,&window_name); 0               XFree((void *) window_name.value);
             } 6           window_changes.width=windows->command.width;8           window_changes.height=windows->command.height;;           XReconfigureWMWindow(display,windows->command.id, H             windows->command.screen,CWWidth | CWHeight,&window_changes);	         }        /*'         Allocate selection info memory.        */1       if (selection_info != (XWidgetInfo *) NULL) &         free((char *) selection_info);$       selection_info=(XWidgetInfo *)6         malloc(number_selections*sizeof(XWidgetInfo));1       if (selection_info == (XWidgetInfo *) NULL) L         Error("Unable to create Command Widget","Memory allocation failed");&       state|=UpdateConfigurationState;     }    /*     Wait for next event.   */
   id=(~0);   if (event != (XEvent *) NULL)      switch (event->type)     {        case ButtonPress:        { -         for (i=0; i < number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue; )           if (i >= windows->command.data) 
             { -               selection_info[i].raised=False; O               XDrawBeveledButton(display,&windows->command,&selection_info[i]);                break;
             } )           submenu_info=selection_info[i]; #           submenu_info.active=True;            toggle_info.y=P             submenu_info.y+(submenu_info.height >> 1)-(toggle_info.height >> 1);           id=i; N           XCheckWindowEvent(display,windows->widget.id,LeaveWindowMask,event);           break;	         }          break;       }        case ButtonRelease:        { -         for (i=0; i < number_selections; i++) 	         { ?           if (!MatteIsActive(selection_info[i],event->xbutton))              continue;            id=i; *           if (id >= windows->command.data)
             { -               selection_info[id].raised=True; P               XDrawBeveledButton(display,&windows->command,&selection_info[id]);               break;
             }            break;	         }          break;       }        case ClientMessage:        { 
         /*C           If client window delete message, withdraw command widget. 
         */A         if (event->xclient.message_type != windows->wm_protocols)            break;@         if (*event->xclient.data.l != windows->wm_delete_window)           break;M         XWithdrawWindow(display,windows->command.id,windows->command.screen);          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */<         if (event->xconfigure.window != windows->command.id)           break;.         if (event->xconfigure.send_event != 0)           { 3             windows->command.x=event->xconfigure.x; 3             windows->command.y=event->xconfigure.y;            } B         if ((event->xconfigure.width == windows->command.width) &&B             (event->xconfigure.height == windows->command.height))           break;         windows->command.width= B           Max(event->xconfigure.width,windows->command.min_width);          windows->command.height=D           Max(event->xconfigure.height,windows->command.min_height);(         state|=UpdateConfigurationState;         break;       }        case Expose:       { 9         if (event->xexpose.window != windows->command.id)            break;&         if (event->xexpose.count != 0)           break;!         state|=RedrawWidgetState;          break;       }        case MotionNotify:       { 
         /*6           Return the ID of the highlighted menu entry.
         */         for ( ; ; ) 	         { /           for (i=0; i < number_selections; i++)            { +             if (i >= windows->command.data)                { /                 if (selection_info[i].raised == D                     MatteIsActive(selection_info[i],event->xmotion))                   {                      /*,                       Button status changed.                     */G                     selection_info[i].raised=!selection_info[i].raised; A                     XDrawBeveledButton(display,&windows->command, *                       &selection_info[i]);                   }                  continue;                } A             if (!MatteIsActive(selection_info[i],event->xmotion))                continue; +             submenu_info=selection_info[i]; %             submenu_info.active=True; $             toggle_info.raised=True;D             toggle_info.y=submenu_info.y+(submenu_info.height >> 1)-(               (toggle_info.height >> 1);F             XDrawTriangleEast(display,&windows->command,&toggle_info);             id=i;            } &           XDelay(display,SuspendTime);?           if (!XCheckMaskEvent(display,ButtonMotionMask,event))              break;B           while (XCheckMaskEvent(display,ButtonMotionMask,event));#           toggle_info.raised=False; (           if (windows->command.data > 0)F             XDrawTriangleEast(display,&windows->command,&toggle_info);	         }          break;       }        case MapNotify:        { %         windows->command.mapped=True;          break;       }        case UnmapNotify:        { &         windows->command.mapped=False;         break;       }        default:         break;     } '   if (state & UpdateConfigurationState)      {        /*&         Initialize button information.       */+       assert(selections != (char **) NULL);        y=tile_height+20; +       for (i=0; i < number_selections; i++)        { 9         XGetWidgetInfo(selections[i],&selection_info[i]); '         selection_info[i].center=False; (         selection_info[i].bevel_width--;1         selection_info[i].height=(3*height) >> 1; 3         selection_info[i].x=(QuantumMargin >> 1)+4;           selection_info[i].width=<           windows->command.width-(selection_info[i].x << 1);         selection_info[i].y=y;K         y+=selection_info[i].height+(selection_info[i].bevel_width << 1)+6;        } 1       XGetWidgetInfo((char *) NULL,&toggle_info);         toggle_info.bevel_width--;I       toggle_info.width=((5*height) >> 3)-(toggle_info.bevel_width << 1); +       toggle_info.height=toggle_info.width; @       toggle_info.x=selection_info[0].x+selection_info[0].width-/         toggle_info.width-(QuantumMargin >> 1); "       if (windows->command.mapped)2         XClearWindow(display,windows->command.id);     }     if (state & RedrawWidgetState)     {        Pixmap         tile_pixmap;         /*         Draw command buttons.        */J       tile_pixmap=XCreatePixmapFromBitmapData(display,windows->command.id,;         (char *) tile_bits,tile_width,tile_height,1L,0L,1); '       if (tile_pixmap != (Pixmap) NULL) 	         { =           XCopyPlane(display,tile_pixmap,windows->command.id, I             windows->command.annotate_context,0,0,tile_width,tile_height, <             (windows->command.width-tile_width) >> 1,10,1L);+           XFreePixmap(display,tile_pixmap); 	         } +       for (i=0; i < number_selections; i++)        { I         XDrawBeveledButton(display,&windows->command,&selection_info[i]); '         if (i >= windows->command.data)            continue; #         toggle_info.raised=i == id; *         toggle_info.y=selection_info[i].y+D           (selection_info[i].height >> 1)-(toggle_info.height >> 1);B         XDrawTriangleEast(display,&windows->command,&toggle_info);       } L       XHighlightWidget(display,&windows->command,BorderOffset,BorderOffset);     } 
   return(id);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i r m W i d g e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Function XConfirmWidget displays a Confirm widget with a notice to the user. I %  The function returns -1 if Dismiss is pressed, 0 for Cancel, and 1 for  %  Yes.  % / %  The format of the XConfirmWidget routine is:  % = %    status=XConfirmWidget(display,windows,message,qualifier)  % + %  A description of each parameter follows:  % L %    o status:  Function XConfirmWidget returns True if the user presses Yes# %      otherwise False is returned.  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */= Export int XConfirmWidget(Display *display,XWindows *windows, ,   const char *message,const char *qualifier) { " #define CancelButtonText  "Cancel"$ #define DismissButtonText  "Dismiss" #define YesButtonText  "Yes"     int      confirm,     status,      x,     y;     unsigned int     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      cancel_info,     dismiss_info, 
     yes_info;      XWindowChanges     window_changes;      /*(     Determine Confirm widget attributes.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); #   assert(message != (char *) NULL); %   assert(qualifier != (char *) NULL); (   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;H   width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));P   if (XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText)) > width)L     width=XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));H   if (XTextWidth(font_info,YesButtonText,Extent(YesButtonText)) > width)D     width=XTextWidth(font_info,YesButtonText,Extent(YesButtonText));   width<<=1;!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,Extent(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,Extent(qualifier));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,Extent(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,Extent(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Confirm widget.   */.   windows->widget.width=width+9*QuantumMargin;,   windows->widget.min_width=9*QuantumMargin+D     XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText))+F     XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText))+>     XTextWidth(font_info,YesButtonText,Extent(YesButtonText));8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height; &   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Confirm widget.    */0   (void) strcpy(windows->widget.name,"Confirm");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */   confirm=0;!   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);(         cancel_info.width=QuantumMargin+J           XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));+         cancel_info.height=(3*height) >> 1; L         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin;G         cancel_info.y=windows->widget.height-(cancel_info.height << 1); !         dismiss_info=cancel_info; ,         dismiss_info.text=DismissButtonText;<         if (strcmp(qualifier,"Do you want to save it") == 0))           dismiss_info.text="Don't Save"; )         dismiss_info.width=QuantumMargin+ L           XTextWidth(font_info,dismiss_info.text,Extent(dismiss_info.text));N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);         yes_info=cancel_info; $         yes_info.text=YesButtonText;<         if (strcmp(qualifier,"Do you want to save it") == 0)           yes_info.text="Save"; %         yes_info.width=QuantumMargin+ D           XTextWidth(font_info,yes_info.text,Extent(yes_info.text));/         if (yes_info.width < cancel_info.width) +           yes_info.width=cancel_info.width; !         yes_info.x=QuantumMargin; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*            Redraw Confirm widget.
         */<         width=XTextWidth(font_info,message,Extent(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,Extent(message)); '         if (qualifier != (char *) NULL)            {              char&               question[MaxTextExtent];  .             (void) strcpy(question,qualifier);(             (void) strcat(question,"?");B             width=XTextWidth(font_info,question,Extent(question));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id, N               windows->widget.annotate_context,x,y,question,Extent(question));           } B         XDrawBeveledButton(display,&windows->widget,&cancel_info);C         XDrawBeveledButton(display,&windows->widget,&dismiss_info); ?         XDrawBeveledButton(display,&windows->widget,&yes_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        { 5         if (MatteIsActive(cancel_info,event.xbutton))            {              /*%               User pressed No button.              */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } 6         if (MatteIsActive(dismiss_info,event.xbutton))           {              /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           } 2         if (MatteIsActive(yes_info,event.xbutton))           {              /*&               User pressed Yes button.             */"             yes_info.raised=False;C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        case ButtonRelease:        { $         if (!windows->widget.mapped)           break;          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  {                    confirm=0;#                   state|=ExitState;                  } $             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           } !         if (!dismiss_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(dismiss_info,event.xbutton))                 {                    confirm=(-1); #                   state|=ExitState;                  } %             dismiss_info.raised=True; G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            }          if (!yes_info.raised)            { ;             if (event.xbutton.window == windows->widget.id) 8               if (MatteIsActive(yes_info,event.xbutton))                 {                    confirm=1;#                   state|=ExitState;                  } !             yes_info.raised=True; C             XDrawBeveledButton(display,&windows->widget,&yes_info);            }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)            break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static char !           command[MaxTextExtent];            static KeySym            key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             confirm=(-1);              state|=ExitState;              break;           }          break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {              /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           } M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {              /*,               Dismiss button status changed.             */4             dismiss_info.raised=!cancel_info.raised;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           } E         if (yes_info.raised == MatteIsActive(yes_info,event.xmotion))            {              /*(               Yes button status changed.             */-             yes_info.raised=!yes_info.raised; C             XDrawBeveledButton(display,&windows->widget,&yes_info);              break;           }          break;       }        default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   return(confirm); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i a l o g W i d g e t                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDialogWidget displays a Dialog widget with a query to the user.J %  The user keys a reply and presses the Ok or Cancel button to exit.  The: %  typed text is returned as the reply function parameter. % . %  The format of the XDialogWidget routine is: % 6 %    XDialogWidget(display,windows,action,query,reply) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  % @ %    o action: Specifies a pointer to the action of this widget. % F %    o query: Specifies a pointer to the query to present to the user. % G %    o reply: The response from the user is returned in this parameter.  %  %  */I Export int XDialogWidget(Display *display,XWindows *windows,char *action,    char *query,char *reply) { " #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextExtent];      int      status,      x,     y;     register int     i;     static unsigned int      raised = False;      unsigned int     anomaly,     height, 
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextProperty      window_name;  
   XWidgetInfo      action_info,     cancel_info,     reply_info,      special_info,      text_info;     XWindowChanges     window_changes;      /*'     Determine Dialog widget attributes.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(action != (char *) NULL);!   assert(query != (char *) NULL); !   assert(reply != (char *) NULL); (   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));    width+=(3*QuantumMargin) >> 1;.   height=font_info->ascent+font_info->descent;   /*     Position Dialog widget.    */O   windows->widget.width=Max(2*width,XTextWidth(font_info,query,Extent(query))); H   if (windows->widget.width < XTextWidth(font_info,reply,Extent(reply)))D     windows->widget.width=XTextWidth(font_info,reply,Extent(reply));)   windows->widget.width+=6*QuantumMargin;    windows->widget.min_width=9     width+25*XTextWidth(font_info,"#",1)+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;7   windows->widget.height=7*height+(QuantumMargin << 1); 4   windows->widget.min_height=windows->widget.height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);    /*     Map Dialog widget.   *//   (void) strcpy(windows->widget.name,"Dialog"); I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);    if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen, 4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */N   anomaly=(strcmp(action,"Background") == 0) || (strcmp(action,"New") == 0) ||I     (strcmp(action,"Quantize") == 0) || (strcmp(action,"Resize") == 0) || B     (strcmp(action,"Save") == 0) || (strcmp(action,"Shade") == 0);!   state=UpdateConfigurationState; (   XSetCursorState(display,windows,True);   do   { )     if (state & UpdateConfigurationState)        { 
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;          cancel_info.x=K           windows->widget.width-cancel_info.width-((3*QuantumMargin) >> 1);          cancel_info.y=M           windows->widget.height-cancel_info.height-((3*QuantumMargin) >> 1); ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; E         action_info.x=cancel_info.x-(cancel_info.width+QuantumMargin+ *           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information. 
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; A         reply_info.width=windows->widget.width-(3*QuantumMargin); &         reply_info.height=height << 1;,         reply_info.x=(3*QuantumMargin) >> 1;C         reply_info.y=action_info.y-reply_info.height-QuantumMargin; 
         /*(           Initialize option information.
         *//         XGetWidgetInfo("Dither",&special_info); #         special_info.raised=raised; #         special_info.bevel_width--; .         special_info.width=QuantumMargin >> 1;/         special_info.height=QuantumMargin >> 1; $         special_info.x=reply_info.x;L         special_info.y=action_info.y+action_info.height-special_info.height;-         if (strcmp(action,"Background") == 0) '           special_info.text="Backdrop"; &         if (strcmp(action,"New") == 0)(           special_info.text="Gradation";)         if (strcmp(action,"Resize") == 0) .           special_info.text="Constrain ratio";'         if (strcmp(action,"Save") == 0) *           special_info.text="Progressive";(         if (strcmp(action,"Shade") == 0),           special_info.text="Color shading";
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info); )         text_info.width=reply_info.width;           text_info.height=height;6         text_info.x=reply_info.x-(QuantumMargin >> 1);"         text_info.y=QuantumMargin;         text_info.center=False; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*           Redraw Dialog widget. 
         */=         XDrawWidgetText(display,&windows->widget,&text_info); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);          if (anomaly)E           XDrawBeveledButton(display,&windows->widget,&special_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)      {        case ButtonPress:        {          if (anomaly)8           if (MatteIsActive(special_info,event.xbutton))
             {                /*-                 Option button status changed.9               */7               special_info.raised=!special_info.raised; I               XDrawBeveledButton(display,&windows->widget,&special_info);P               break;
             }i5         if (MatteIsActive(action_info,event.xbutton))a           {p             /*)               User pressed Action button.i             */%             action_info.raised=False;sF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }p5         if (MatteIsActive(cancel_info,event.xbutton))n           {              /*)               User pressed Cancel button.y             */%             cancel_info.raised=False;wF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }y5         if (!MatteIsActive(reply_info,event.xbutton))o           break;,         if (event.xbutton.button != Button2)           {p             static Time                click_time;                /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {t                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,%&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;i               } A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           }m
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,_1           windows->widget.id,event.xbutton.time);i         break;       }d       case ButtonRelease:<       {n$         if (!windows->widget.mapped)           break;          if (!action_info.raised)           {m;             if (event.xbutton.window == windows->widget.id)p;               if (MatteIsActive(action_info,event.xbutton)) !                 state|=ExitState;h$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }e          if (!cancel_info.raised)           {n;             if (event.xbutton.window == windows->widget.id)d;               if (MatteIsActive(cancel_info,event.xbutton))                  {T(                   *reply_info.text='\0';#                   state|=ExitState;d                 }r$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }a         break;       }e       case ClientMessage:        {e
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);0             break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)t           break;7         if (event.xclient.window == windows->widget.id),           {C"             *reply_info.text='\0';             state|=ExitState;t             break;           }o         break;       }        case ConfigureNotify:s       {I
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }%       case Expose:       {%7         if (event.xexpose.window != windows->widget.id)h           break;%         if (event.xexpose.count != 0)a           break;!         state|=RedrawWidgetState;e         break;       }        case KeyPress:       {e         static char !           command[MaxTextExtent];f           static int           length;a           static KeySym            key_symbol;f  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),u/           &key_symbol,(XComposeStatus *) NULL);v         *(command+length)='\0';aE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { %             action_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&action_info);             state|=ExitState;l             break;           }b'         if (key_symbol == XK_Control_L)i           {               state|=ControlState;             break;           }e!         if (state & ControlState)            switch (key_symbol)=           {s             case XK_u:             case XK_U:
             {.               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;l               break;
             }o             default:               break;           }i@         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);s         break;       }=       case KeyRelease:       {s         static char !           command[MaxTextExtent];            static KeySymh           key_symbol;v  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),i/           &key_symbol,(XComposeStatus *) NULL);l'         if (key_symbol == XK_Control_L),!           state&=(~ControlState);%         break;       }%       case LeaveNotify:%       {%9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;%F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }bK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))g           {e             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;rF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }        case SelectionClear:       {t#         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);r         break;       }o       case SelectionNotify:o       {t         Atom           type;n           intt           format,            status;i           unsigned charl           *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection.c
         */5         if (event.xselection.property == (Atom) None)r           break;E         status=XGetWindowProperty(display,event.xselection.requestor,yJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||=             (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);n         else           {x             /*5               Insert primary selection in reply text.f             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,n               state);)A             XDrawMatteText(display,&windows->widget,&reply_info);            }n         XFree((void *) data);          break;       }e       case SelectionRequest:       {i         XSelectionEvent            notify;b           XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));-N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection));>$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }l       default:         break;     }t!   } while (!(state & ExitState));o)   XSetCursorState(display,windows,False);,E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);f(   XCheckRefreshWindows(display,windows);   if (anomaly)     if (special_info.raised)       if (*reply != '\0')g         raised=True;   return(!raised); }d   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             % O %   X F i l e B r o w s e r W i d g e t                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% %%O %  Function XFileBrowserWidget displays a File Browser widget with a file querywN %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. % 3 %  The format of the XFileBrowserWidget routine is:s % 5 %    XFileBrowserWidget(display,windows,action,reply)i %)+ %  A description of each parameter follows:o % E %    o display: Specifies a connection to an X server;  returned fromt %      XOpenDisplay. %i; %    o window: Specifies a pointer to a XWindows structure.X %d@ %    o action: Specifies a pointer to the action of this widget. %WG %    o reply: The response from the user is returned in this parameter.  %  %  */O Export void XFileBrowserWidget(Display *display,XWindows *windows,char *action,d   char *reply) {)" #define CancelButtonText  "Cancel"# #define DirectoryText  "Directory:"e" #define FilenameText  "File name:" #define GrabButtonText  "Grab"" #define FormatButtonText  "Format" #define HomeButtonText  "Home" #define UpButtonText  "Up"  
   static char      *ImageOutputFormats[]=     {        "avs",       "bie",       "bmp",
       "cmyk",        "dcx",       "eps",
       "epsf", 
       "epsi",        "fax",
       "fits",        "fpx",       "gif",       "gif87",
       "gray",        "g3",        "hdf",       "histogram",
       "html", 
       "jbig", 
       "jpeg",        "jpg",       "map",       "matte",
       "miff", 
       "mono",        "mpg",       "mtv",       "pbm",       "pcl",       "pcx",       "pdf",       "pgm",
       "pict",        "png",       "ppm",       "pnm",       "ps",%       "ps2",       "ras",       "rgb",       "rle",       "sgi",       "shtml",       "sun",       "tga",
       "tiff",r
       "uyvy",w       "vid",
       "viff", 
       "x",       "xbm",       "xpm",       "xv",A       "xwd",       "yuv",
       "yuv3",        (char *) NULLc     };     char     **filelist,c"     home_directory[MaxTextExtent],%     primary_selection[MaxTextExtent],e     text[MaxTextExtent],%     working_directory[MaxTextExtent];f     inti
     files,     status,I     x,     y;     register int     i;  
   static chare&     glob_pattern[MaxTextExtent] = "*",#     format[MaxTextExtent] = "miff";n  
   static chars*     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     anomaly,     height,|     text_width,p     visible_files,
     width;     unsigned long>
     delay,
     state;     XEvent
     event;  
   XFontStructo     *font_info;i     XTextPropertyg     window_name;  
   XWidgetInfoe     action_info,     cancel_info,     expose_info,     special_info,i     list_info,     home_info,     north_info,d     reply_info,o     scroll_info,     selection_info,      slider_info,     south_info,t     text_info,     up_info;     XWindowChanges     window_changes;%     /*)     Read filelist from current directory.%   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); "   assert(action != (char *) NULL);!   assert(reply != (char *) NULL); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);0   (void) getcwd(home_directory,MaxTextExtent-1);2   (void) strcpy(working_directory,home_directory);<   filelist=ListFiles(working_directory,glob_pattern,&files);!   if (filelist == (char **) NULL)      {        /*         Directory read failed.       */@       XNoticeWidget(display,windows,"Unable to read directory:",         working_directory);%K       (void) XDialogWidget(display,windows,action,"Enter filename:",reply);F
       return;t     }d   /*-     Determine File Browser widget attributes.e   */&   font_info=windows->widget.font_info;   text_width=0;r   for (i=0; i < files; i++)TK     if (XTextWidth(font_info,filelist[i],Extent(filelist[i])) > text_width)aG       text_width=XTextWidth(font_info,filelist[i],Extent(filelist[i])); 4   width=XTextWidth(font_info,action,Extent(action));J   if (XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText)) > width)F     width=XTextWidth(font_info,GrabButtonText,Extent(GrabButtonText));N   if (XTextWidth(font_info,FormatButtonText,Extent(FormatButtonText)) > width)J     width=XTextWidth(font_info,FormatButtonText,Extent(FormatButtonText));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));J   if (XTextWidth(font_info,HomeButtonText,Extent(HomeButtonText)) > width)F     width=XTextWidth(font_info,HomeButtonText,Extent(HomeButtonText));F   if (XTextWidth(font_info,UpButtonText,Extent(UpButtonText)) > width)B     width=XTextWidth(font_info,UpButtonText,Extent(UpButtonText));   width+=QuantumMargin;nH   if (XTextWidth(font_info,DirectoryText,Extent(DirectoryText)) > width)D     width=XTextWidth(font_info,DirectoryText,Extent(DirectoryText));F   if (XTextWidth(font_info,FilenameText,Extent(FilenameText)) > width)B     width=XTextWidth(font_info,FilenameText,Extent(FilenameText));.   height=font_info->ascent+font_info->descent;   /*!     Position File Browser widget.t   */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin; ?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin;t8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);u4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);)   /*     Map File Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a File");(I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);e   if (status != 0)     { :       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }o-   window_changes.width=windows->widget.width;i/   window_changes.height=windows->widget.height;i%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;oN   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes);e)   XMapRaised(display,windows->widget.id);d   windows->widget.mapped=False;n   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);_,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_files=0;N   anomaly=(strcmp(action,"Composite") == 0) || (strcmp(action,"Open") == 0) ||      (strcmp(action,"Map") == 0);   delay=SuspendTime << 2;d!   state=UpdateConfigurationState;w   do   {i)     if (state & UpdateConfigurationState)        {-         intt
           id;k  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;dN         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;5         XGetWidgetInfo(GrabButtonText,&special_info); !         special_info.width=width; ,         special_info.height=(3*height) >> 1;M         special_info.x=action_info.x-(action_info.width+(QuantumMargin >> 1)+ +           (special_info.bevel_width << 1)); %         special_info.y=action_info.y;%         if (!anomaly)%           {%             register char%               *p;   /             special_info.text=FormatButtonText;e$             p=reply+Extent(reply)-1;2             while ((p > reply) && (*(p-1) != '.'))               p--;/             if ((p > reply) && (*(p-1) == '.'))a&               (void) strcpy(format,p);           }y.         XGetWidgetInfo(UpButtonText,&up_info);         up_info.width=width;'         up_info.height=(3*height) >> 1;           up_info.x=QuantumMargin;2         up_info.y=((5*QuantumMargin) >> 1)+height;2         XGetWidgetInfo(HomeButtonText,&home_info);         home_info.width=width;)         home_info.height=(3*height) >> 1;e"         home_info.x=QuantumMargin;;         home_info.y=up_info.y+up_info.height+QuantumMargin;i
         /*'           Initialize reply information.d
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;_N         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);C         reply_info.y=action_info.y-reply_info.height-QuantumMargin;n
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);b"         scroll_info.bevel_width--;!         scroll_info.width=height; G         scroll_info.height=reply_info.y-up_info.y-(QuantumMargin >> 1);CH         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);7         scroll_info.y=up_info.y-reply_info.bevel_width; !         scroll_info.raised=False;           scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;=8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;o-         north_info.x+=north_info.bevel_width;_-         north_info.y+=north_info.bevel_width;          south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2;sP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=;J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;M         visible_files=(scroll_info.height-(height >> 3)-3)/((9*height) >> 3);0"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);_         list_info.raised=False;i          list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;f"         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState;t
         /*&           Initialize text information.
         */         *text='\0';%(         XGetWidgetInfo(text,&text_info);         text_info.center=False; )         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1); "         text_info.y=QuantumMargin;
         /*+           Initialize selection information. 
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*%           Redraw File Browser window.%
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;bP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,3           x,y,DirectoryText,Extent(DirectoryText));rA         (void) sprintf(text_info.text,"%s%s%s",working_directory,,+           DirectorySeparator,glob_pattern);i=         XDrawWidgetText(display,&windows->widget,&text_info); >         XDrawBeveledButton(display,&windows->widget,&up_info);@         XDrawBeveledButton(display,&windows->widget,&home_info);?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);eA         XDrawTriangleNorth(display,&windows->widget,&north_info);pB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FilenameText,Extent(FilenameText));t@         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info);gC         XDrawBeveledButton(display,&windows->widget,&special_info);nB         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0);*         state|=RedrawListState;o$         state&=(~RedrawWidgetState);       }.      if (state & UpdateListState)       {2         char           **checklist;           int1           number_files;s  
         /*           Update file list.s
         */J         checklist=ListFiles(working_directory,glob_pattern,&number_files);(         if (checklist == (char **) NULL)           {i             /*(               Reply is a filename, exit.             */%             action_info.raised=False;1F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }.!         for (i=0; i < files; i++)r%           free((char *) filelist[i]);i'         if (filelist != (char **) NULL)l"           free((char *) filelist);         filelist=checklist;p         files=number_files; 
         /*           Update file list..
         */         slider_info.height==J           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (files > visible_files)F           slider_info.height=(visible_files*slider_info.height)/files;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0;x(         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);          list_info.id=(~0);         state|=RedrawListState; 
         /*(           Redraw directory name & reply.
         */%         if (!IsGlob(reply_info.text))            { "             *reply_info.text='\0';.             reply_info.cursor=reply_info.text;           } A         (void) sprintf(text_info.text,"%s%s%s",working_directory, +           DirectorySeparator,glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info); =         XDrawMatteText(display,&windows->widget,&reply_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info);%A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);nM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);g"         state&=(~UpdateListState);       }e     if (state & JumpListState)       { 
         /*-           Jump scroll to match user filename.o
         */         list_info.id=(~0);!         for (i=0; i < files; i++) -           if (strcmp(filelist[i],reply) >= 0)f
             {oC               list_info.id=strcmp(filelist[i],reply) == 0 ? i : ~0;                break;
             }IJ         if ((i < slider_info.id) || (i >= (slider_info.id+visible_files)))0           slider_info.id=i-(visible_files >> 1);         selection_info.id=(~0);t         state|=RedrawListState;1          state&=(~JumpListState);       }       if (state & RedrawListState)       {;
         /*+           Determine slider id and position.a
         */:         if (slider_info.id >= (int) (files-visible_files))-           slider_info.id=files-visible_files;i=         if ((slider_info.id < 0) || (files <= visible_files))a           slider_info.id=0;n(         slider_info.y=slider_info.min_y;         if (files > 0)           slider_info.y+=1I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/files;.0         if (slider_info.id != selection_info.id)           {s             /*/               Redraw scroll bar and file names.c             */-             selection_info.id=slider_info.id;w9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_files; i++)s
             {wG               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < files)l?                 selection_info.text=filelist[slider_info.id+i];tH               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }3             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {h?                 expose_info.height=slider_info.y-expose_info.y;_?                 expose_info.y=slider_info.y-expose_info.height-o,                   slider_info.bevel_width-1;               }*             else               {n?                 expose_info.height=expose_info.y-slider_info.y;.?                 expose_info.y=slider_info.y+slider_info.height+n,                   slider_info.bevel_width+1;               }tE             XDrawTriangleNorth(display,&windows->widget,&north_info);d>             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);%(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);      else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0) 
             {                /*                 Move slider up.%               */               slider_info.id--;%%               state|=RedrawListState;o
             }x         if (!south_info.raised)w%           if (slider_info.id < files)c
             {-               /*!                 Move slider down.                */               slider_info.id++;s%               state|=RedrawListState;w
             }_(         if (event.type != ButtonRelease)           continue;        }l     switch (event.type)o     {s       case ButtonPress:        { 5         if (MatteIsActive(slider_info,event.xbutton))o           {i             /*               Track slider.p             */$             slider_info.active=True;             break;           }i4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.e               */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;i               break;
             }n4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < files)f
             {e               /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++;t%               state|=RedrawListState;i               break;
             }n5         if (MatteIsActive(scroll_info,event.xbutton))=           {L             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_files-1);             else0               slider_info.id+=(visible_files-1);#             state|=RedrawListState;e             break;           }.3         if (MatteIsActive(list_info,event.xbutton))E           {f             unsigned int               id;>               /*&               User pressed file matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= files)               break;8             (void) strcpy(reply_info.text,filelist[id]);'             reply_info.highlight=False;t.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info);a#             if (id == list_info.id)f               {xA                 (void) strcpy(working_directory,reply_info.text);t'                 state|=UpdateListState;t               }o#             selection_info.id=(~0);*             list_info.id=id;#             state|=RedrawListState;%             break;           } 1         if (MatteIsActive(up_info,event.xbutton))            {              /*%               User pressed Up button.              */!             up_info.raised=False; B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } 3         if (MatteIsActive(home_info,event.xbutton))            {              /*'               User pressed Home button.              */#             home_info.raised=False; D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           }%6         if (MatteIsActive(special_info,event.xbutton))           {%             /**               User pressed Special button.             */&             special_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&special_info);e             if (!anomaly)p               {m                 /*/                   Let user select image format.r                 */9                 XDefineCursor(display,windows->widget.id,o/                   windows->widget.busy_cursor);nC                 XListBrowserWidget(display,windows,&windows->popup,tJ                   ImageOutputFormats,"Select","Select image format type:",                   format);6                 XSetCursorState(display,windows,True);9                 XDefineCursor(display,windows->widget.id,c*                   windows->widget.cursor);:                 AppendImageFormat(format,reply_info.text);J                 reply_info.cursor=reply_info.text+Extent(reply_info.text);E                 XDrawMatteText(display,&windows->widget,&reply_info); )                 special_info.raised=True; K                 XDrawBeveledButton(display,&windows->widget,&special_info);                }n             break;           }f5         if (MatteIsActive(action_info,event.xbutton))=           {x             /*)               User pressed action button.              */%             action_info.raised=False;(F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }p5         if (MatteIsActive(cancel_info,event.xbutton))e           {l             /*)               User pressed Cancel button.e             */%             cancel_info.raised=False; F             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }r5         if (!MatteIsActive(reply_info,event.xbutton))            break;,         if (event.xbutton.button != Button2)           {r             static Time                click_time;f               /*;               Move text cursor to position of button press.              */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);eI                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, &                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;                } A             XDrawMatteText(display,&windows->widget,&reply_info);(*             click_time=event.xbutton.time;             break;           } 
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);%         break;       }%       case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {              /*&               User released up button.             */#             delay=SuspendTime << 2; #             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);            }          if (!south_info.raised)            {              /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);%           }%         if (slider_info.active)o           {t             /*#               Stop tracking slider.X             */%             slider_info.active=False;e             break;           }p         if (!up_info.raised)           {o;             if (event.xbutton.window == windows->widget.id) 7               if (MatteIsActive(up_info,event.xbutton))t                 { 8                   (void) strcpy(working_directory,"..");)                   state|=UpdateListState;w                 }               up_info.raised=True;B             XDrawBeveledButton(display,&windows->widget,&up_info);           }g         if (!home_info.raised)           {t;             if (event.xbutton.window == windows->widget.id)i9               if (MatteIsActive(home_info,event.xbutton))n                 {tB                   (void) strcpy(working_directory,home_directory);)                   state|=UpdateListState;                  }a"             home_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&home_info);           }%!         if (!special_info.raised)%           {%;             if (event.xbutton.window == windows->widget.id) <               if (MatteIsActive(special_info,event.xbutton))                 { 6                   (void) strcpy(reply_info.text,"x:");#                   state|=ExitState;                  } %             special_info.raised=True; G             XDrawBeveledButton(display,&windows->widget,&special_info);            }           if (!action_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0')%#                   XBell(display,0);%                 else#                   state|=ExitState;h$             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }p          if (!cancel_info.raised)           {a;             if (event.xbutton.window == windows->widget.id)e;               if (MatteIsActive(cancel_info,event.xbutton))a                 {o(                   *reply_info.text='\0';#                   state|=ExitState;c                 }p$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }          break;       }d       case ClientMessage:t       {H
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {nG             XSetInputFocus(display,event.xclient.window,RevertToParent,f'               event.xclient.data.l[1]);s             break;           }>?         if (*event.xclient.data.l != windows->wm_delete_window)w           break;7         if (event.xclient.window == windows->widget.id)            {e"             *reply_info.text='\0';             state|=ExitState;              break;           }w         break;       }        case ConfigureNotify:w       {d
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }%       case Expose:       {%7         if (event.xexpose.window != windows->widget.id)y           break;%         if (event.xexpose.count != 0)i           break;!         state|=RedrawWidgetState;u         break;       }c       case KeyPress:       {          static charo!           command[MaxTextExtent];            static int           length;s           static KeySym            key_symbol;a  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);)         *(command+length)='\0';=1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol)w
             {=               case XK_Home:                case XK_KP_Home:               {e!                 slider_info.id=0;p                 break;               }.               case XK_Up:n               case XK_KP_Up:               {e!                 slider_info.id--;)                 break;               }                case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;                  break;               }                case XK_Prior:               case XK_KP_Prior:                {b.                 slider_info.id-=visible_files;                 break;               }u               case XK_Next::               case XK_KP_Next:               {o.                 slider_info.id+=visible_files;                 break;               }                case XK_End:               case XK_KP_End:=               {.%                 slider_info.id=files;=                 break;               }e
             } #             state|=RedrawListState;i             break;           }rE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))n           {              /*1               Read new directory or glob patterm.X             */)             if (*reply_info.text == '\0')                break;(             if (IsGlob(reply_info.text)):               (void) strcpy(glob_pattern,reply_info.text);             else               {-A                 (void) strcpy(working_directory,reply_info.text);y.                 if (*working_directory == '~')4                   ExpandFilename(working_directory);               }s#             state|=UpdateListState;t             break;           }i'         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           }%!         if (state & ControlState)%           switch (key_symbol)            {              case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;                break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);%         state|=JumpListState;%         break;       }%       case KeyRelease:       {e         static chari!           command[MaxTextExtent];            static KeySyma           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),./           &key_symbol,(XComposeStatus *) NULL);a'         if (key_symbol == XK_Control_L)r!           state&=(~ControlState);c         break;       }        case LeaveNotify:        { 9         if (event.xcrossing.window != windows->widget.id)e           break;#         state|=InactiveWidgetState;          break;       }i       case MapNotify:i       {h         mask&=(~CWX);i         mask&=(~CWY);          break;       }h       case MotionNotify:       {a
         /*/           Discard pending button motion events.k
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));>         if (slider_info.active)i           {i             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;l3             if (slider_info.y != slider_info.min_y)sI               slider_info.id=(files*(slider_info.y-slider_info.min_y+1))/_8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;%             break;           } (         if (state & InactiveWidgetState)           break;C         if (up_info.raised == MatteIsActive(up_info,event.xmotion))            {              /*'               Up button status changed.              */+             up_info.raised=!up_info.raised; B             XDrawBeveledButton(display,&windows->widget,&up_info);             break;           } G         if (home_info.raised == MatteIsActive(home_info,event.xmotion))            {              /*)               Home button status changed.              *//             home_info.raised=!home_info.raised;%D             XDrawBeveledButton(display,&windows->widget,&home_info);             break;           } M         if (special_info.raised == MatteIsActive(special_info,event.xmotion))n           {              /*)               Grab button status changed.s             */5             special_info.raised=!special_info.raised;oG             XDrawBeveledButton(display,&windows->widget,&special_info);              break;           }oK         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {s             /*+               Action button status changed.r             */3             action_info.raised=!action_info.raised;iF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           } K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))            {W             /*+               Cancel button status changed.              */3             cancel_info.raised=!cancel_info.raised;kF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }o         break;       }        case SelectionClear:       {e#         reply_info.highlight=False;o=         XDrawMatteText(display,&windows->widget,&reply_info);i         break;       }l       case SelectionNotify:%       {%         Atom           type;%           int%           format,            status;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);o         else           {t             /*5               Insert primary selection in reply text.l             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); A             XDrawMatteText(display,&windows->widget,&reply_info);p!             state|=JumpListState;f%             state|=RedrawActionState;c           }          XFree((void *) data);          break;       }s       case SelectionRequest:       {e         XSelectionEventi           notify;            XSelectionRequestEvent           *request;w  "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));eN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection));n$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }w       default:         break;     }e!   } while (!(state & ExitState));%)   XSetCursorState(display,windows,False);%E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free file list.    */   for (i=0; i < files; i++)      free((char *) filelist[i]); !   if (filelist != (char **) NULL)      free((char *) filelist);   if (*reply == '~')     ExpandFilename(reply); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   X F o n t B r o w s e r W i d g e t                                       %aO %                                                                             %nO %                                                                             %tO %                                                                             %oO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %oO %  Function XFontBrowserWidget displays a Font Browser widget with a font query N %  to the user.  The user keys a reply and presses the Action or Cancel buttonH %  to exit.  The typed text is returned as the reply function parameter. % 3 %  The format of the XFontBrowserWidget routine is:n %i5 %    XFontBrowserWidget(display,windows,action,reply)e %d+ %  A description of each parameter follows:a %oE %    o display: Specifies a connection to an X server;  returned fromo %      XOpenDisplay. %n; %    o window: Specifies a pointer to a XWindows structure." %d@ %    o action: Specifies a pointer to the action of this widget. %rG %    o reply: The response from the user is returned in this parameter.t %x %t */  3 static int FontCompare(const void *x,const void *y)  {    register char      *p,      *q;c     p=(char *) *((char **) x);   q=(char *) *((char **) y);4   while ((*p != '\0') && (*q != '\0') && (*p == *q))   {i     p++;     q++;   }t   return(*p-(*q)); }o  O Export void XFontBrowserWidget(Display *display,XWindows *windows,char *action,o   char *reply) {  #define BackButtonText  "Back"" #define CancelButtonText  "Cancel" #define FontnameText  "Name:" # #define FontPatternText  "Pattern:"   #define ResetButtonText  "Reset"     char      back_pattern[MaxTextExtent],     **fontlist,o     **listhead,o%     primary_selection[MaxTextExtent],o!     reset_pattern[MaxTextExtent],o     text[MaxTextExtent];     intg
     fonts,     status,      x,     y;     register int     i;  
   static char &     glob_pattern[MaxTextExtent] = "*";  
   static charo*     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,p     text_width,L     visible_fonts,
     width;     unsigned longC
     delay,
     state;     XEvent
     event;  
   XFontStructr     *font_info;l     XTextProperty_     window_name;  
   XWidgetInfo      action_info,     back_info,     cancel_info,     expose_info,     list_info,     mode_info,     north_info,b     reply_info,      reset_info,t     scroll_info,     selection_info,f     slider_info,     south_info,      text_info;     XWindowChanges     window_changes;o     /*.     Get font list and sort in ascending order.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);e"   assert(action != (char *) NULL);!   assert(reply != (char *) NULL);o(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);+   (void) strcpy(back_pattern,glob_pattern);f#   (void) strcpy(reset_pattern,"*");x9   fontlist=XListFonts(display,glob_pattern,32767,&fonts);i   if (fonts == 0)l     {E       /*-         Pattern failed, obtain all the fonts.o       */D       XNoticeWidget(display,windows,"Unable to obtain fonts names:",         glob_pattern);&       (void) strcpy(glob_pattern,"*");=       fontlist=XListFonts(display,glob_pattern,32767,&fonts);t%       if (fontlist == (char **) NULL)i	         {iH           XNoticeWidget(display,windows,"Unable to obtain fonts names:",             glob_pattern);           return;B	         }      })   /*&     Sort font list in ascending order.   */   listhead=fontlist;3   fontlist=(char **) malloc(fonts*sizeof(char **));C!   if (fontlist == (char **) NULL)T     { <       XNoticeWidget(display,windows,"Unable to view fonts:",$         "Memory allocation failed");
       return;r     }t   for (i=0; i < fonts; i++)t     fontlist[i]=listhead[i];0   qsort((void *) fontlist,fonts,sizeof(char **),7     (int (*)(const void *, const void *)) FontCompare);i   /*-     Determine Font Browser widget attributes.t   */&   font_info=windows->widget.font_info;   text_width=0;w   for (i=0; i < fonts; i++)TK     if (XTextWidth(font_info,fontlist[i],Extent(fontlist[i])) > text_width)_G       text_width=XTextWidth(font_info,fontlist[i],Extent(fontlist[i]));w4   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));L   if (XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText)) > width)H     width=XTextWidth(font_info,ResetButtonText,Extent(ResetButtonText));J   if (XTextWidth(font_info,BackButtonText,Extent(BackButtonText)) > width)F     width=XTextWidth(font_info,BackButtonText,Extent(BackButtonText));   width+=QuantumMargin;rL   if (XTextWidth(font_info,FontPatternText,Extent(FontPatternText)) > width)H     width=XTextWidth(font_info,FontPatternText,Extent(FontPatternText));F   if (XTextWidth(font_info,FontnameText,Extent(FontnameText)) > width)B     width=XTextWidth(font_info,FontnameText,Extent(FontnameText));.   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.    */K   windows->widget.width=width+Min(text_width,MaxTextWidth)+6*QuantumMargin;t?   windows->widget.min_width=width+MinTextWidth+4*QuantumMargin;d8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;H   windows->widget.height=((85*height) >> 2)+((13*QuantumMargin) >> 1)+4;L   windows->widget.min_height=((27*height) >> 1)+((13*QuantumMargin) >> 1)+4;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2); 4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);i   /*     Map Font Browser widget.   */A   (void) strcpy(windows->widget.name,"Browse and Select a Font");gI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);u   if (status != 0)     {c:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }t-   window_changes.width=windows->widget.width;l/   window_changes.height=windows->widget.height; %   window_changes.x=windows->widget.x;)%   window_changes.y=windows->widget.y;;N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes);.)   XMapRaised(display,windows->widget.id);.   windows->widget.mapped=False;f   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);n,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_fonts=0;   delay=SuspendTime << 2;o!   state=UpdateConfigurationState;n   do   { )     if (state & UpdateConfigurationState)r       {          int 
           id;t  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;eN         cancel_info.x=windows->widget.width-cancel_info.width-QuantumMargin-2;N         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1; L         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;2         XGetWidgetInfo(BackButtonText,&back_info);         back_info.width=width;)         back_info.height=(3*height) >> 1; "         back_info.x=QuantumMargin;4         back_info.y=((5*QuantumMargin) >> 1)+height;4         XGetWidgetInfo(ResetButtonText,&reset_info);         reset_info.width=width;m*         reset_info.height=(3*height) >> 1;#         reset_info.x=QuantumMargin;w@         reset_info.y=back_info.y+back_info.height+QuantumMargin;
         /*'           Initialize reply information.i
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--;eN         reply_info.width=windows->widget.width-width-((6*QuantumMargin) >> 1);&         reply_info.height=height << 1;0         reply_info.x=width+(QuantumMargin << 1);K         reply_info.y=action_info.y-(action_info.height << 1)-QuantumMargin;-
         /*&           Initialize mode information.
         */)         XGetWidgetInfo(reply,&mode_info);t          mode_info.bevel_width=0;A         mode_info.width=action_info.x-reply_info.x-QuantumMargin;_1         mode_info.height=action_info.height << 1; !         mode_info.x=reply_info.x; M         mode_info.y=action_info.y-action_info.height+action_info.bevel_width;s
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info); "         scroll_info.bevel_width--;!         scroll_info.width=height;iI         scroll_info.height=reply_info.y-back_info.y-(QuantumMargin >> 1);oH         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);9         scroll_info.y=back_info.y-reply_info.bevel_width; !         scroll_info.raised=False;;          scroll_info.trough=True;         north_info=scroll_info;f         north_info.raised=True;a8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;.-         north_info.x+=north_info.bevel_width;;-         north_info.y+=north_info.bevel_width;n         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;m         slider_info.id=id;         slider_info.width-=2;tP         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=oJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_fonts=A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3);e"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);i         list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;a"         list_info.y=scroll_info.y;$         if (!windows->widget.mapped)           state|=JumpListState;y
         /*&           Initialize text information.
         */         *text='\0';r(         XGetWidgetInfo(text,&text_info);         text_info.center=False;))         text_info.width=reply_info.width;o          text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1);f"         text_info.y=QuantumMargin;
         /*+           Initialize selection information.l
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width; .         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        }D"     if (state & RedrawWidgetState)       {l
         /*%           Redraw Font Browser window.w
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent;tP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,7           x,y,FontPatternText,Extent(FontPatternText));o9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);;@         XDrawBeveledButton(display,&windows->widget,&back_info);A         XDrawBeveledButton(display,&windows->widget,&reset_info);;?         XDrawBeveledMatte(display,&windows->widget,&list_info);cA         XDrawBeveledMatte(display,&windows->widget,&scroll_info);0A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);          x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent;DP         XDrawString(display,windows->widget.id,windows->widget.annotate_context,1           x,y,FontnameText,Extent(FontnameText)); @         XDrawBeveledMatte(display,&windows->widget,&reply_info);=         XDrawMatteText(display,&windows->widget,&reply_info); B         XDrawBeveledButton(display,&windows->widget,&action_info);B         XDrawBeveledButton(display,&windows->widget,&cancel_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);          selection_info.id=(~0); !         state|=RedrawActionState;s         state|=RedrawListState;l$         state&=(~RedrawWidgetState);       }       if (state & UpdateListState)       {s         char           **checklist;           intf           number_fonts;o  
         /*           Update font list.n
         */G         checklist=XListFonts(display,glob_pattern,32767,&number_fonts);((         if (checklist == (char **) NULL)           {d>             if ((strchr(glob_pattern,'*') == (char *) NULL) &&<                 (strchr(glob_pattern,'?') == (char *) NULL))               {d                 /*3                   Might be a scaleable font-- exit.n                 */2                 (void) strcpy(reply,glob_pattern);9                 (void) strcpy(glob_pattern,back_pattern); )                 action_info.raised=False; J                 XDrawBeveledButton(display,&windows->widget,&action_info);                 break;               }T5             (void) strcpy(glob_pattern,back_pattern);a             XBell(display,0);d           }f         else            if (number_fonts == 1)
             {l               /*3                 Reply is a single font name-- exit.f               */0               (void) strcpy(reply,checklist[0]);7               (void) strcpy(glob_pattern,back_pattern);,(               XFreeFontNames(checklist);'               action_info.raised=False;eH               XDrawBeveledButton(display,&windows->widget,&action_info);               break;
             }            else
             {u'               XFreeFontNames(listhead);.&               free((char *) fontlist);!               fontlist=checklist;t!               fonts=number_fonts; 
             }t
         /*,           Sort font list in ascending order.
         */         listhead=fontlist;9         fontlist=(char **) malloc(fonts*sizeof(char **));o'         if (fontlist == (char **) NULL)i           { B             XNoticeWidget(display,windows,"Unable to view fonts:",*               "Memory allocation failed");             return;            }t!         for (i=0; i < fonts; i++) "           fontlist[i]=listhead[i];6         qsort((void *) fontlist,fonts,sizeof(char **),=           (int (*)(const void *, const void *)) FontCompare);s         slider_info.height=iJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+1;"         if (fonts > visible_fonts)F           slider_info.height=(visible_fonts*slider_info.height)/fonts;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;         slider_info.id=0; (         slider_info.y=slider_info.min_y;$         expose_info.y=slider_info.y;         selection_info.id=(~0);f         list_info.id=(~0);         state|=RedrawListState;)
         /*#           Redraw font name & reply.+
         */         *reply_info.text='\0';*         reply_info.cursor=reply_info.text;9         (void) sprintf(text_info.text,"%s",glob_pattern); =         XDrawWidgetText(display,&windows->widget,&text_info);e=         XDrawMatteText(display,&windows->widget,&reply_info);aA         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info); B         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);i"         state&=(~UpdateListState);       }      if (state & JumpListState)       { 
         /*)           Jump scroll to match user font. 
         */         list_info.id=(~0);!         for (i=0; i < fonts; i++) -           if (strcmp(fontlist[i],reply) >= 0)g
             { C               list_info.id=strcmp(fontlist[i],reply) == 0 ? i : ~0;a               break;
             }eJ         if ((i < slider_info.id) || (i >= (slider_info.id+visible_fonts)))0           slider_info.id=i-(visible_fonts >> 1);         selection_info.id=(~0);          state|=RedrawListState;&          state&=(~JumpListState);       }       if (state & RedrawListState)       { 
         /*+           Determine slider id and position.t
         */:         if (slider_info.id >= (int) (fonts-visible_fonts))-           slider_info.id=fonts-visible_fonts;i=         if ((slider_info.id < 0) || (fonts <= visible_fonts))            slider_info.id=0;_(         slider_info.y=slider_info.min_y;         if (fonts > 0)           slider_info.y+= I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/fonts; 0         if (slider_info.id != selection_info.id)           {)             /*/               Redraw scroll bar and file names.o             */-             selection_info.id=slider_info.id;;9             selection_info.y=list_info.y+(height >> 3)+2;f-             for (i=0; i < visible_fonts; i++)w
             {>G               selection_info.raised=(slider_info.id+i) != list_info.id;t0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < fonts)u?                 selection_info.text=fontlist[slider_info.id+i];nH               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             }/             /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-u,                   slider_info.bevel_width-1;               }c             else               {h?                 expose_info.height=expose_info.y-slider_info.y; ?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               }dE             XDrawTriangleNorth(display,&windows->widget,&north_info); >             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info); (             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       } "     if (state & RedrawActionState)       {          XFontStructt           *font_info,b           *save_info;   
         /*6           Display the selected font in a drawing area.
         */,         save_info=windows->widget.font_info;:         font_info=XLoadQueryFont(display,reply_info.text);.         if (font_info != (XFontStruct *) NULL)           { 1             windows->widget.font_info=font_info;; L             XSetFont(display,windows->widget.widget_context,font_info->fid);           } @         XDrawBeveledButton(display,&windows->widget,&mode_info);,         windows->widget.font_info=save_info;.         if (font_info != (XFontStruct *) NULL)           { <             XSetFont(display,windows->widget.widget_context,.               windows->widget.font_info->fid);)             XFreeFont(display,font_info);            }tM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);A=         XDrawMatteText(display,&windows->widget,&reply_info);*$         state&=(~RedrawActionState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)-=       XIfEvent(display,&event,XScreenEvent,(char *) windows);c     else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised) !           if (slider_info.id > 0)n
             {u               /*                 Move slider up.                */               slider_info.id--;o%               state|=RedrawListState; 
             }e         if (!south_info.raised) %           if (slider_info.id < fonts) 
             {l               /*!                 Move slider down.o               */               slider_info.id++; %               state|=RedrawListState;w
             }y(         if (event.type != ButtonRelease)           continue;f       }i     switch (event.type)      {        case ButtonPress:p       {t5         if (MatteIsActive(slider_info,event.xbutton))s           {              /*               Track slider.~             */$             slider_info.active=True;             break;           }r4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;w%               state|=RedrawListState;                break;
             }v4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < fonts)b
             {                /*!                 Move slider down.                */&               south_info.raised=False;               slider_info.id++; %               state|=RedrawListState;f               break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))            {              /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_fonts-1);             else0               slider_info.id+=(visible_fonts-1);#             state|=RedrawListState;X             break;           }A3         if (MatteIsActive(list_info,event.xbutton))            {m             unsigned int               id;o               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= fonts)               break;8             (void) strcpy(reply_info.text,fontlist[id]);'             reply_info.highlight=False; .             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);A             XDrawMatteText(display,&windows->widget,&reply_info); %             state|=RedrawActionState; #             if (id == list_info.id)i               { <                 (void) strcpy(glob_pattern,reply_info.text);'                 state|=UpdateListState;                }M#             selection_info.id=(~0);)             list_info.id=id;#             state|=RedrawListState;              break;           }T3         if (MatteIsActive(back_info,event.xbutton))            {o             /*'               User pressed Back button.              */#             back_info.raised=False;uD             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }h4         if (MatteIsActive(reset_info,event.xbutton))           {              /*(               User pressed Reset button.             */$             reset_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&reset_info);              break;           } 5         if (MatteIsActive(action_info,event.xbutton))            {/             /*)               User pressed action button.o             */%             action_info.raised=False;_F             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }t5         if (MatteIsActive(cancel_info,event.xbutton))            {-             /*)               User pressed Cancel button.d             */%             cancel_info.raised=False;cF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }t5         if (!MatteIsActive(reply_info,event.xbutton))P           break;,         if (event.xbutton.button != Button2)           {)             static Time                click_time;e               /*;               Move text cursor to position of button press.f             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;              else               {                  /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text); I                 XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id,/&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) ==%                   windows->widget.id;=               }.A             XDrawMatteText(display,&windows->widget,&reply_info); *             click_time=event.xbutton.time;             break;           }r
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, 1           windows->widget.id,event.xbutton.time);          break;       }_       case ButtonRelease:.       { $         if (!windows->widget.mapped)           break;         if (!north_info.raised)            {A             /*&               User released up button.             */#             delay=SuspendTime << 2;&#             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);v           }i         if (!south_info.raised)            {(             /*(               User released down button.             */#             delay=SuspendTime << 2;t#             south_info.raised=True;UE             XDrawTriangleSouth(display,&windows->widget,&south_info);e           }          if (slider_info.active)d           {r             /*#               Stop tracking slider.r             */%             slider_info.active=False;d             break;           }          if (!back_info.raised)           {b;             if (event.xbutton.window == windows->widget.id) 9               if (MatteIsActive(back_info,event.xbutton))                  {|;                   (void) strcpy(glob_pattern,back_pattern); )                   state|=UpdateListState;e                 } "             back_info.raised=True;D             XDrawBeveledButton(display,&windows->widget,&back_info);           }          if (!reset_info.raised)(           {v;             if (event.xbutton.window == windows->widget.id)i:               if (MatteIsActive(reset_info,event.xbutton))                 { ;                   (void) strcpy(back_pattern,glob_pattern);n<                   (void) strcpy(glob_pattern,reset_pattern);)                   state|=UpdateListState;o                 }a#             reset_info.raised=True;aE             XDrawBeveledButton(display,&windows->widget,&reset_info);l           }e          if (!action_info.raised)           {s;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(action_info,event.xbutton)) -                 if (*reply_info.text == '\0')x#                   XBell(display,0);                  else#                   state|=ExitState; $             action_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&action_info);           }d          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id) ;               if (MatteIsActive(cancel_info,event.xbutton))                  {o(                   *reply_info.text='\0';#                   state|=ExitState;/                 }.$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }&         break;       }f       case ClientMessage:d       {t
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {tG             XSetInputFocus(display,event.xclient.window,RevertToParent,o'               event.xclient.data.l[1]);s             break;           } ?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id).           {d"             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        {K
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=aB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        { 9         if (event.xcrossing.window != windows->widget.id)            break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)X           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;a         break;       }        case KeyPress:       {          static charw!           command[MaxTextExtent];            static int           length;a           static KeySym            key_symbol;:  4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);o         *(command+length)='\0'; 1         if (AreaIsActive(scroll_info,event.xkey))            {P             /*               Move slider.             */             switch (key_symbol) 
             {                case XK_Home:t               case XK_KP_Home:               { !                 slider_info.id=0;_                 break;               }                case XK_Up:*               case XK_KP_Up:               { !                 slider_info.id--;r                 break;               }r               case XK_Down:p               case XK_KP_Down:               {t!                 slider_info.id++;r                 break;               }l               case XK_Prior:               case XK_KP_Prior:t               {r.                 slider_info.id-=visible_fonts;                 break;               }                case XK_Next:X               case XK_KP_Next:               { .                 slider_info.id+=visible_fonts;                 break;               }                case XK_End:               case XK_KP_End:=               { %                 slider_info.id=fonts;n                 break;               }g
             } #             state|=RedrawListState;              break;           }rE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))m           {              /*,               Read new font or glob patterm.             */)             if (*reply_info.text == '\0')r               break;5             (void) strcpy(back_pattern,glob_pattern);r8             (void) strcpy(glob_pattern,reply_info.text);#             state|=UpdateListState;              break;           } '         if (key_symbol == XK_Control_L)T           {               state|=ControlState;             break;           }n!         if (state & ControlState))           switch (key_symbol)            {p             case XK_u:             case XK_U:
             {t               /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;.               break;
             }d             default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);=         XDrawMatteText(display,&windows->widget,&reply_info);          state|=JumpListState;          break;       }        case KeyRelease:       {o         static char/!           command[MaxTextExtent];s           static KeySyme           key_symbol;d  4         if (event.xkey.window != windows->widget.id)           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); '         if (key_symbol == XK_Control_L) !           state&=(~ControlState);r         break;       }        case LeaveNotify:f       { 9         if (event.xcrossing.window != windows->widget.id).           break;#         state|=InactiveWidgetState;(         break;       }d       case MapNotify:        {          mask&=(~CWX);i         mask&=(~CWY);          break;       }S       case MotionNotify:       { 
         /*/           Discard pending button motion events.a
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));          if (slider_info.active)            {b             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0; 3             if (slider_info.y != slider_info.min_y)eI               slider_info.id=(fonts*(slider_info.y-slider_info.min_y+1))/.8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           } (         if (state & InactiveWidgetState)           break;G         if (back_info.raised == MatteIsActive(back_info,event.xmotion))_           {              /*)               Back button status changed.=             *//             back_info.raised=!back_info.raised; D             XDrawBeveledButton(display,&windows->widget,&back_info);             break;           }!I         if (reset_info.raised == MatteIsActive(reset_info,event.xmotion))e           {o             /**               Reset button status changed.             */1             reset_info.raised=!reset_info.raised;gE             XDrawBeveledButton(display,&windows->widget,&reset_info);)             break;           } K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))            {              /*+               Action button status changed.              */3             action_info.raised=!action_info.raised;eF             XDrawBeveledButton(display,&windows->widget,&action_info);             break;           }sK         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))o           {p             /*+               Cancel button status changed.p             */3             cancel_info.raised=!cancel_info.raised;tF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }n         break;       }a       case SelectionClear:       {x#         reply_info.highlight=False; =         XDrawMatteText(display,&windows->widget,&reply_info);*         break;       }i       case SelectionNotify:        {          Atom           type;t           int            format,p           status;y           unsigned chara           *data;           unsigned longD           after,           length;,  
         /*1           Obtain response from primary selection.t
         */5         if (event.xselection.property == (Atom) None))           break;E         status=XGetWindowProperty(display,event.xselection.requestor,vJ           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);          else           {p             /*5               Insert primary selection in reply text.a             */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,a               state);eA             XDrawMatteText(display,&windows->widget,&reply_info);o!             state|=JumpListState;t%             state|=RedrawActionState;m           }f         XFree((void *) data);          break;       }e       case SelectionRequest:       {          XSelectionEventp           notify;v           XSelectionRequestEvent           *request;s  
         /*#           Set XA_PRIMARY selection. 
         */-         request=(&(event.xselectionrequest));sN         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection));l$         notify.type=SelectionNotify;(         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;F         (void) XSendEvent(request->display,request->requestor,False,0,           (XEvent *) &notify);       }%       default:         break;     } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   /*     Free font list.    */   XFreeFontNames(listhead);    free((char *) fontlist); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %%O %   X I n f o W i d g e t                                                     %cO %                                                                             % O %                                                                             %lO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %eL %  Function XInfoWidget displays text in the Info widget.  The purpose is toH %  inform the user that what activity is currently being performed (e.g.. %  reading an image, rotating an image, etc.). %i, %  The format of the XInfoWidget routine is: %s* %    XInfoWidget(display,windows,activity) %o+ %  A description of each parameter follows:t %tE %    o display: Specifies a connection to an X server;  returned fromw %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.h %hK %    o activity: This character string reflects the current activity and is0$ %      displayed in the Info widget. %0 %x */J Export void XInfoWidget(Display *display,XWindows *windows,char *activity) {    unsigned int     height,x     margin,0
     width;  
   XFontStruct0     *font_info;0     XWindowChanges     window_changes;0     /*     Map Info widget.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);x$   assert(activity != (char *) NULL);$   font_info=windows->info.font_info;   width=O     XTextWidth(font_info,activity,Extent(activity))+((3*QuantumMargin) >> 1)+4;x=   height=((6*(font_info->ascent+font_info->descent)) >> 2)+4; I   if ((windows->info.width != width) || (windows->info.height != height))0     {        /*9         Size Info widget to accomodate the activity text.0       */        windows->info.width=width;"       windows->info.height=height;!       window_changes.width=width; #       window_changes.height=height;xI       XReconfigureWMWindow(display,windows->info.id,windows->info.screen, ,         CWWidth | CWHeight,&window_changes);     }    if (!windows->info.mapped)     {x+       XMapRaised(display,windows->info.id);         windows->info.mapped=True;     }    /*&     Initialize Info matte information.   */.   height=font_info->ascent+font_info->descent;)   XGetWidgetInfo(activity,&monitor_info);    monitor_info.bevel_width--;xI   margin=monitor_info.bevel_width+((windows->info.height-height) >> 1)-2;    monitor_info.center=False;   monitor_info.x=margin;   monitor_info.y=margin;7   monitor_info.width=windows->info.width-(margin << 1);x;   monitor_info.height=windows->info.height-(margin << 1)+1;8   /*     Draw Info widget.f   */   monitor_info.raised=False;:   XDrawBeveledMatte(display,&windows->info,&monitor_info);   monitor_info.raised=True;08   XDrawWidgetText(display,&windows->info,&monitor_info); }  f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %7O %                                                                             %xO %                                                                             % O %   X L i s t B r o w s e r W i d g e t                                       %0O %                                                                             %xO %                                                                             % O %                                                                             %0O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%x % M %  Function XListBrowserWidget displays a List Browser widget with a query toxN %  the user.  The user keys a reply or select a reply from the list.  Finally,K %  the user presses the Action or Cancel button to exit.  The typed text is0, %  returned as the reply function parameter. % 3 %  The format of the XListBrowserWidget routine is:  %0L %    XListBrowserWidget(display,windows,window_info,list,action,query,reply) %x+ %  A description of each parameter follows:  %1E %    o display: Specifies a connection to an X server;  returned from0 %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.x % F %    o list: Specifies a pointer to an array of strings.  The user can; %      select from these strings as a possible reply value.x % @ %    o action: Specifies a pointer to the action of this widget. %fF %    o query: Specifies a pointer to the query to present to the user. %xG %    o reply: The response from the user is returned in this parameter.0 %x %  */B Export void XListBrowserWidget(Display *display,XWindows *windows,L   XWindowInfo *window_info,char **list,char *action,char *query,char *reply) {0" #define CancelButtonText  "Cancel"     char%     primary_selection[MaxTextExtent];      inte     entries,     status,x     x,     y;  
   static char *     mask = CWWidth | CWHeight | CWX | CWY;     register int     i;     unsigned int     height,      text_width,      visible_entries,
     width;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextPropertyx     window_name;  
   XWidgetInfox     action_info,     cancel_info,     expose_info,     list_info,     north_info,      reply_info,      scroll_info,     selection_info,f     slider_info,     south_info,0     text_info;     XWindowChanges     window_changes;x     /*,     Count the number of entries in the list.   */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL); .   assert(window_info != (XWindowInfo *) NULL);!   assert(list != (char **) NULL); "   assert(action != (char *) NULL);!   assert(query != (char *) NULL); !   assert(reply != (char *) NULL); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   if (list == (char **) NULL)x     {0H       XNoticeWidget(display,windows,"No text to browse:",(char *) NULL);
       return;3     }    for (entries=0; ; entries++)'     if (list[entries] == (char *) NULL)x       break;   /*-     Determine Font Browser widget attributes.0   */#   font_info=window_info->font_info; 7   text_width=XTextWidth(font_info,query,Extent(query));3   for (i=0; i < entries; i++) C     if (XTextWidth(font_info,list[i],Extent(list[i])) > text_width)0?       text_width=XTextWidth(font_info,list[i],Extent(list[i]));04   width=XTextWidth(font_info,action,Extent(action));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));   width+=QuantumMargin; .   height=font_info->ascent+font_info->descent;   /*!     Position Font Browser widget.    */K   window_info->width=Min(text_width,MaxTextWidth)+((9*QuantumMargin) >> 1); 6   window_info->min_width=MinTextWidth+4*QuantumMargin;2   if (window_info->width < window_info->min_width).     window_info->width=window_info->min_width;E   window_info->height=((81*height) >> 2)+((13*QuantumMargin) >> 1)+4; I   window_info->min_height=((23*height) >> 1)+((13*QuantumMargin) >> 1)+4;04   if (window_info->height < window_info->min_height)0     window_info->height=window_info->min_height;2   XQueryPosition(display,window_info->root,&x,&y);1   window_info->x=x-((3*window_info->width) >> 2); .   window_info->y=y-(window_info->height >> 1);0   XConstrainWindowPosition(display,window_info);   /*     Map Font Browser widget.   */,   (void) strcpy(window_info->name,"Browse");F   status=XStringListToTextProperty(&window_info->name,1,&window_name);   if (status != 0)     {s7       XSetWMName(display,window_info->id,&window_name); >       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } *   window_changes.width=window_info->width;,   window_changes.height=window_info->height;"   window_changes.x=window_info->x;"   window_changes.y=window_info->y;H   XReconfigureWMWindow(display,window_info->id,window_info->screen,mask,     &window_changes);c&   XMapRaised(display,window_info->id);   window_info->mapped=False;   /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info);_,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_entries=0;   delay=SuspendTime << 2; !   state=UpdateConfigurationState;i   do   {a)     if (state & UpdateConfigurationState)i       {m         int(
           id;t  
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;wK         cancel_info.x=window_info->width-cancel_info.width-QuantumMargin-2;aK         cancel_info.y=window_info->height-cancel_info.height-QuantumMargin; ,         XGetWidgetInfo(action,&action_info);          action_info.width=width;+         action_info.height=(3*height) >> 1;oL         action_info.x=cancel_info.x-(cancel_info.width+(QuantumMargin >> 1)+*           (action_info.bevel_width << 1));$         action_info.y=cancel_info.y;
         /*'           Initialize reply information.y
         */*         XGetWidgetInfo(reply,&reply_info);          reply_info.raised=False;!         reply_info.bevel_width--; E         reply_info.width=window_info->width-((4*QuantumMargin) >> 1);a&         reply_info.height=height << 1;#         reply_info.x=QuantumMargin;cC         reply_info.y=action_info.y-reply_info.height-QuantumMargin;n
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);e"         scroll_info.bevel_width--;!         scroll_info.width=height;tH         scroll_info.height=reply_info.y-((6*QuantumMargin) >> 1)-height;H         scroll_info.x=reply_info.x+(reply_info.width-scroll_info.width);M         scroll_info.y=((5*QuantumMargin) >> 1)+height-reply_info.bevel_width;c!         scroll_info.raised=False;a          scroll_info.trough=True;         north_info=scroll_info;*         north_info.raised=True; 8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1; -         north_info.x+=north_info.bevel_width;n-         north_info.y+=north_info.bevel_width;i         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;n         slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=uJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;         visible_entries=A           (scroll_info.height-(height >> 3)-3)/((9*height) >> 3); &         if (entries > visible_entries)J           slider_info.height=(visible_entries*slider_info.height)/entries;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;           list_info.bevel_width--;H         list_info.width=scroll_info.x-reply_info.x-(QuantumMargin >> 1);,         list_info.height=scroll_info.height;!         list_info.x=reply_info.x;o"         list_info.y=scroll_info.y;!         if (!window_info->mapped)w%           for (i=0; i < entries; i++) +             if (strcmp(list[i],reply) == 0)i               {d                 list_info.id=i; 8                 slider_info.id=i-(visible_entries >> 1);'                 if (slider_info.id < 0) #                   slider_info.id=0;.               }-
         /*&           Initialize text information.
         */)         XGetWidgetInfo(query,&text_info);i)         text_info.width=reply_info.width;           text_info.height=height;5         text_info.x=list_info.x-(QuantumMargin >> 1);i"         text_info.y=QuantumMargin;
         /*+           Initialize selection information.o
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;c.         selection_info.height=(9*height) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*%           Redraw List Browser window. 
         */         x=QuantumMargin;I         y=text_info.y+((text_info.height-height) >> 1)+font_info->ascent; 8         XDrawWidgetText(display,window_info,&text_info);:         XDrawBeveledMatte(display,window_info,&list_info);<         XDrawBeveledMatte(display,window_info,&scroll_info);<         XDrawTriangleNorth(display,window_info,&north_info);=         XDrawBeveledButton(display,window_info,&slider_info); <         XDrawTriangleSouth(display,window_info,&south_info);         x=QuantumMargin;K         y=reply_info.y+((reply_info.height-height) >> 1)+font_info->ascent; ;         XDrawBeveledMatte(display,window_info,&reply_info); 8         XDrawMatteText(display,window_info,&reply_info);=         XDrawBeveledButton(display,window_info,&action_info);s=         XDrawBeveledButton(display,window_info,&cancel_info);[H         XHighlightWidget(display,window_info,BorderOffset,BorderOffset);         selection_info.id=(~0);l!         state|=RedrawActionState;          state|=RedrawListState; $         state&=(~RedrawWidgetState);       }       if (state & RedrawListState)       {g
         /*+           Determine slider id and position.n
         */>         if (slider_info.id >= (int) (entries-visible_entries))1           slider_info.id=entries-visible_entries;mA         if ((slider_info.id < 0) || (entries <= visible_entries))l           slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (entries > 0)           slider_info.y+=lK             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/entries;a0         if (slider_info.id != selection_info.id)           {              /*/               Redraw scroll bar and file names.              */-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2;;/             for (i=0; i < visible_entries; i++) 
             {cG               selection_info.raised=(slider_info.id+i) != list_info.id;r0               selection_info.text=(char *) NULL;/               if ((slider_info.id+i) < entries) ;                 selection_info.text=list[slider_info.id+i];NC               XDrawWidgetText(display,window_info,&selection_info);n<               selection_info.y+=(int) selection_info.height;
             }              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               {t?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height-(,                   slider_info.bevel_width-1;               }              else               {l?                 expose_info.height=expose_info.y-slider_info.y;n?                 expose_info.y=slider_info.y+slider_info.height+;,                   slider_info.bevel_width+1;               }w@             XDrawTriangleNorth(display,window_info,&north_info);9             XDrawMatte(display,window_info,&expose_info); A             XDrawBeveledButton(display,window_info,&slider_info);-@             XDrawTriangleSouth(display,window_info,&south_info);(             expose_info.y=slider_info.y;           } "         state&=(~RedrawListState);       }      /*       Wait for next event.     *//     if (north_info.raised && south_info.raised)a=       XIfEvent(display,&event,XScreenEvent,(char *) windows);i     else       { 
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)d!           if (slider_info.id > 0)x
             {e               /*                 Move slider up.s               */               slider_info.id--;t%               state|=RedrawListState;_
             }          if (!south_info.raised)a'           if (slider_info.id < entries)i
             {                /*!                 Move slider down.                */               slider_info.id++;h%               state|=RedrawListState;(
             }s(         if (event.type != ButtonRelease)           continue;l       }w     switch (event.type)o     {s       case ButtonPress:)       { 5         if (MatteIsActive(slider_info,event.xbutton))%           {%             /*               Track slider.              */$             slider_info.active=True;             break;           } 4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {                /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--; %               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))'           if (slider_info.id < entries) 
             {                /*!                 Move slider down.%               */&               south_info.raised=False;               slider_info.id++;f%               state|=RedrawListState;                break;
             } 5         if (MatteIsActive(scroll_info,event.xbutton))T           {t             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)2               slider_info.id-=(visible_entries-1);             else2               slider_info.id+=(visible_entries-1);#             state|=RedrawListState;              break;           }o3         if (MatteIsActive(list_info,event.xbutton))n           {              unsigned int               id;o               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= entries)               break;4             (void) strcpy(reply_info.text,list[id]);'             reply_info.highlight=False;f.             reply_info.marker=reply_info.text;F             reply_info.cursor=reply_info.text+Extent(reply_info.text);<             XDrawMatteText(display,window_info,&reply_info);#             selection_info.id=(~0); #             if (id == list_info.id)                { )                 action_info.raised=False;lE                 XDrawBeveledButton(display,window_info,&action_info);d!                 state|=ExitState;                }t             list_info.id=id;#             state|=RedrawListState;n             break;           }s5         if (MatteIsActive(action_info,event.xbutton))            {)             /*)               User pressed action button.i             */%             action_info.raised=False;CA             XDrawBeveledButton(display,window_info,&action_info);n             break;           }s5         if (MatteIsActive(cancel_info,event.xbutton))D           {e             /*)               User pressed Cancel button.Y             */%             cancel_info.raised=False;=A             XDrawBeveledButton(display,window_info,&cancel_info);<             break;           } 5         if (!MatteIsActive(reply_info,event.xbutton))u           break;,         if (event.xbutton.button != Button2)           {e             static Time(               click_time;x               /*;               Move text cursor to position of button press.f             */@             x=event.xbutton.x-reply_info.x-(QuantumMargin >> 2);:             for (i=1; i <= Extent(reply_info.marker); i++)@               if (XTextWidth(font_info,reply_info.marker,i) > x)                 break;4             reply_info.cursor=reply_info.marker+i-1;>             if (event.xbutton.time > (click_time+DoubleClick)))               reply_info.highlight=False;Y             else               {;                 /*8                   Become the XA_PRIMARY selection owner.                 */A                 (void) strcpy(primary_selection,reply_info.text);dF                 XSetSelectionOwner(display,XA_PRIMARY,window_info->id,&                   event.xbutton.time);N                 reply_info.highlight=XGetSelectionOwner(display,XA_PRIMARY) =="                   window_info->id;               } <             XDrawMatteText(display,window_info,&reply_info);*             click_time=event.xbutton.time;             break;           }r
         /*$           Request primary selection.
         */A         XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING,i.           window_info->id,event.xbutton.time);         break;       }s       case ButtonRelease:        {t!         if (!window_info->mapped)i           break;         if (!north_info.raised)v           {              /*&               User released up button.             */#             delay=SuspendTime << 2;c#             north_info.raised=True;w@             XDrawTriangleNorth(display,window_info,&north_info);           }i         if (!south_info.raised)W           {g             /*(               User released down button.             */#             delay=SuspendTime << 2; #             south_info.raised=True; @             XDrawTriangleSouth(display,window_info,&south_info);           }d         if (slider_info.active)t           {o             /*#               Stop tracking slider.n             */%             slider_info.active=False;i             break;           }_          if (!action_info.raised)           {+8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(action_info,event.xbutton))1-                 if (*reply_info.text == '\0')-#                   XBell(display,0);                  else#                   state|=ExitState;t$             action_info.raised=True;A             XDrawBeveledButton(display,window_info,&action_info);t           }r          if (!cancel_info.raised)           {m8             if (event.xbutton.window == window_info->id);               if (MatteIsActive(cancel_info,event.xbutton))e                 {n(                   *reply_info.text='\0';#                   state|=ExitState;i                 } $             cancel_info.raised=True;A             XDrawBeveledButton(display,window_info,&cancel_info);o           } 5         if (!MatteIsActive(reply_info,event.xbutton))w           break;         break;       }f       case ClientMessage:n       {o
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);n             break;           }>?         if (*event.xclient.data.l != windows->wm_delete_window)h           break;4         if (event.xclient.window == window_info->id)           {t"             *reply_info.text='\0';             state|=ExitState;              break;           }          break;       }        case ConfigureNotify:n       {x
         /*&           Update widget configuration.
         */7         if (event.xconfigure.window != window_info->id)x           break;=         if ((event.xconfigure.width == window_info->width) &&h=             (event.xconfigure.height == window_info->height))S           break;         window_info->width= =           Max(event.xconfigure.width,window_info->min_width);)         window_info->height=?           Max(event.xconfigure.height,window_info->min_height);D(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:y       {-6         if (event.xcrossing.window != window_info->id)           break;&         state&=(~InactiveWidgetState);         break;       }        case Expose:       {f4         if (event.xexpose.window != window_info->id)           break;%         if (event.xexpose.count != 0)            break;!         state|=RedrawWidgetState;f         break;       }f       case KeyPress:       {          static char !           command[MaxTextExtent];            static int           length;a           static KeySym            key_symbol;l  1         if (event.xkey.window != window_info->id);           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0';w1         if (AreaIsActive(scroll_info,event.xkey))            {              /*               Move slider.             */             switch (key_symbol)s
             {b               case XK_Home:                case XK_KP_Home:               {v!                 slider_info.id=0;,                 break;               }                case XK_Up:                case XK_KP_Up:               { !                 slider_info.id--;                  break;               }i               case XK_Down:                case XK_KP_Down:               { !                 slider_info.id++;a                 break;               }                case XK_Prior:               case XK_KP_Prior:i               { 0                 slider_info.id-=visible_entries;                 break;               }i               case XK_Next:                case XK_KP_Next:               { 0                 slider_info.id+=visible_entries;                 break;               }f               case XK_End:               case XK_KP_End:                { '                 slider_info.id=entries;t                 break;               } 
             }_#             state|=RedrawListState;B             break;           }dE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            {              /*               Read new entry.d             */)             if (*reply_info.text == '\0')u               break;%             action_info.raised=False; A             XDrawBeveledButton(display,window_info,&action_info);e             state|=ExitState;              break;           }d'         if (key_symbol == XK_Control_L)            {               state|=ControlState;             break;           } !         if (state & ControlState)e           switch (key_symbol)v           {e             case XK_u:             case XK_U:
             {                /*.                 Erase the entire line of text.               */$               *reply_info.text='\0';0               reply_info.cursor=reply_info.text;0               reply_info.marker=reply_info.text;)               reply_info.highlight=False;m               break;
             }              default:               break;           } @         XEditText(display,&reply_info,key_symbol,command,state);8         XDrawMatteText(display,window_info,&reply_info);         break;       }        case KeyRelease:       {f         static char/!           command[MaxTextExtent];o           static KeySym            key_symbol;   1         if (event.xkey.window != window_info->id)h           break;
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),s/           &key_symbol,(XComposeStatus *) NULL);g'         if (key_symbol == XK_Control_L)h!           state&=(~ControlState);          break;       }a       case LeaveNotify:;       { 6         if (event.xcrossing.window != window_info->id)           break;#         state|=InactiveWidgetState;a         break;       }t       case MapNotify:        {          mask&=(~CWX);p         mask&=(~CWY);          break;       }!       case MotionNotify:       {r
         /*/           Discard pending button motion events.;
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));r         if (slider_info.active)a           {              /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;e3             if (slider_info.y != slider_info.min_y)lK               slider_info.id=(entries*(slider_info.y-slider_info.min_y+1))/ 8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;              break;           }e(         if (state & InactiveWidgetState)           break;K         if (action_info.raised == MatteIsActive(action_info,event.xmotion))e           {r             /*+               Action button status changed.*             */3             action_info.raised=!action_info.raised; A             XDrawBeveledButton(display,window_info,&action_info);              break;           })K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))f           {o             /*+               Cancel button status changed.o             */3             cancel_info.raised=!cancel_info.raised;aA             XDrawBeveledButton(display,window_info,&cancel_info);-             break;           }          break;       }        case SelectionClear:       {e#         reply_info.highlight=False; 8         XDrawMatteText(display,window_info,&reply_info);         break;       }        case SelectionNotify:_       {e         Atom           type;            intd           format,d           status;s           unsigned chara           *data;           unsigned longe           after,           length;t  
         /*1           Obtain response from primary selection.a
         */5         if (event.xselection.property == (Atom) None).           break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||(             (length == 0))           break;>         if ((Extent(reply_info.text)+length) >= MaxTextExtent)           XBell(display,0);%         else           {%             /*5               Insert primary selection in reply text.              */              *(data+length)='\0';K             XEditText(display,&reply_info,(KeySym) XK_Insert,(char *) data,                state); <             XDrawMatteText(display,window_info,&reply_info);%             state|=RedrawActionState;            }          XFree((void *) data);          break;       }        case SelectionRequest:       {          XSelectionEvent            notify;            XSelectionRequestEvent           *request;   "         if (!reply_info.highlight)           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest)); N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection)); $         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }p       default:         break;     }l!   } while (!(state & ExitState));*)   XSetCursorState(display,windows,False);*?   XWithdrawWindow(display,window_info->id,window_info->screen);m(   XCheckRefreshWindows(display,windows); }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             %lO %                                                                             % O %                                                                             %iO %   X M e n u W i d g e t                                                     % O %                                                                             %eO %                                                                             %eO %                                                                             %!O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%- %dM %  Function XMenuWidget maps a menu and returns the command pointed to by thex$ %  user when the button is released. %C, %  The format of the XMenuWidget routine is: %fH %    selection_number=XMenuWidget(display,windows,title,selections,item) %i+ %  A description of each parameter follows:o %eG %    o selection_number: Specifies the number of the selection that the= %      user choose.h %nE %    o display: Specifies a connection to an X server;  returned fromh %      XOpenDisplay. %e; %    o window: Specifies a pointer to a XWindows structure.E %nN %    o title: Specifies a character string that describes the menu selections. %=K %    o selections: Specifies a pointer to one or more strings that comprisew %      the choices in the menu._ %tJ %    o item: Specifies a character array.  The item selected from the menu %      is returned here. %n %  */F Export int XMenuWidget(Display *display,XWindows *windows,char *title,   char **selections,char *item)n {i   Cursor     cursor;e     intw     id,i     x,     y;     unsigned int     height,o     number_selections,     title_height,.     top_offset,g
     width;     unsigned longd
     state;     XEvent
     event;  
   XFontStructi     *font_info;l     XSetWindowAttributes     window_attributes;  
   XWidgetInfo)     highlight_info,e     menu_info,     selection_info;i     XWindowChanges     window_changes;&     /*%     Determine Menu widget attributes.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);n!   assert(title != (char *) NULL); '   assert(selections != (char **) NULL);     assert(item != (char *) NULL);&   font_info=windows->widget.font_info;.   windows->widget.width=!submenu_info.active ?2     XTextWidth(font_info,title,Extent(title)) : 0;3   for (id=0; selections[id] != (char *) NULL; id++)t   {iF     width=XTextWidth(font_info,selections[id],Extent(selections[id]));&     if (width > windows->widget.width)"       windows->widget.width=width;   }    number_selections=id;e+   XGetWidgetInfo((char *) NULL,&menu_info);r%   title_height=!submenu_info.active ?=:     (3*(font_info->descent+font_info->ascent) >> 1)+5 : 2;2   width=XTextWidth(font_info,title,Extent(title));9   height=(3*(font_info->ascent+font_info->descent)) >> 1;g   /*     Position Menu widget.(   */D   windows->widget.width+=QuantumMargin+(menu_info.bevel_width << 1);2   top_offset=title_height+menu_info.bevel_width-1;?   windows->widget.height=top_offset+number_selections*height+4;x2   windows->widget.min_width=windows->widget.width;4   windows->widget.min_height=windows->widget.height;5   XQueryPosition(display,windows->widget.root,&x,&y);i+   windows->widget.x=x-(QuantumMargin >> 1);    if (submenu_info.active)     {w       windows->widget.x=@         windows->command.x+windows->command.width-QuantumMargin;       toggle_info.raised=True;@       XDrawTriangleEast(display,&windows->command,&toggle_info);     }iI   windows->widget.y=!submenu_info.active ? y-((3*title_height) >> 2) : y;o   if (submenu_info.active)8     windows->widget.y=windows->command.y+submenu_info.y;5   XConstrainWindowPosition(display,&windows->widget);G   /*     Map Menu widget.   */+   window_attributes.override_redirect=True;lH   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);-   window_changes.width=windows->widget.width;n/   window_changes.height=windows->widget.height;y%   window_changes.x=windows->widget.x;m%   window_changes.y=windows->widget.y;iI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,l4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);c   windows->widget.mapped=False;;   /*     Respond to X events.   */   selection_info.height=height;o1   cursor=XCreateFontCursor(display,XC_right_ptr);o2   XDefineCursor(display,windows->image.id,cursor);4   XDefineCursor(display,windows->command.id,cursor);3   XDefineCursor(display,windows->widget.id,cursor);,!   state=UpdateConfigurationState;o   do   {a)     if (state & UpdateConfigurationState)        { 
         /*+           Initialize selection information.(
         */1         XGetWidgetInfo((char *) NULL,&menu_info);r          menu_info.bevel_width--;M         menu_info.width=windows->widget.width-((menu_info.bevel_width) << 1); O         menu_info.height=windows->widget.height-((menu_info.bevel_width) << 1);t*         menu_info.x=menu_info.bevel_width;*         menu_info.y=menu_info.bevel_width;6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=menu_info.width;(%         selection_info.height=height; %         selection_info.x=menu_info.x; &         highlight_info=selection_info;%         highlight_info.bevel_width--;d@         highlight_info.width-=(highlight_info.bevel_width << 1);A         highlight_info.height-=(highlight_info.bevel_width << 1);e5         highlight_info.x+=highlight_info.bevel_width;(+         state&=(~UpdateConfigurationState);y       }-"     if (state & RedrawWidgetState)       {d
         /*           Redraw Menu widget.o
         */!         if (!submenu_info.active)-           {e             y=title_height;i;             XSetBevelColor(display,&windows->widget,False); P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,C               selection_info.x,y-1,(int) selection_info.width,y-1); :             XSetBevelColor(display,&windows->widget,True);P             XDrawLine(display,windows->widget.id,windows->widget.widget_context,?               selection_info.x,y,(int) selection_info.width,y);bL             XSetFillStyle(display,windows->widget.widget_context,FillSolid);           }a
         /*           Draw menu selections.l
         */#         selection_info.center=True; /         selection_info.y=menu_info.bevel_width;v"         selection_info.text=title;!         if (!submenu_info.active) D           XDrawWidgetText(display,&windows->widget,&selection_info);$         selection_info.center=False;$         selection_info.y=top_offset;0         for (id=0; id < number_selections; id++)	         {(-           selection_info.text=selections[id]; D           XDrawWidgetText(display,&windows->widget,&selection_info);G           highlight_info.y=selection_info.y+highlight_info.bevel_width;B&           if (id == selection_info.id)A             XDrawBevel(display,&windows->widget,&highlight_info);s8           selection_info.y+=(int) selection_info.height;	         }n8         XDrawBevel(display,&windows->widget,&menu_info);$         state&=(~RedrawWidgetState);       }      if (number_selections > 2)       {t
         /*           Redraw Menu line. 
         */A         y=top_offset+selection_info.height*(number_selections-1); 7         XSetBevelColor(display,&windows->widget,False); L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,?           selection_info.x,y-1,(int) selection_info.width,y-1); 6         XSetBevelColor(display,&windows->widget,True);L         XDrawLine(display,windows->widget.id,windows->widget.widget_context,;           selection_info.x,y,(int) selection_info.width,y); H         XSetFillStyle(display,windows->widget.widget_context,FillSolid);       }o     /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);      switch (event.type)i     {        case ButtonPress:h       {X7         if (event.xbutton.window != windows->widget.id)            {d             /*               Exit menu.             */<             if (event.xbutton.window == windows->command.id),               XPutBackEvent(display,&event);#             selection_info.id=(~0);              *item='\0';              state|=ExitState;(             break;           }T&         state&=(~InactiveWidgetState);D         id=(event.xbutton.y-top_offset)/(int) selection_info.height;         selection_info.id=id;o2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.d
         */=         selection_info.y=top_offset+id*selection_info.height;n+         selection_info.text=selections[id];eB         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;(=         XDrawBevel(display,&windows->widget,&highlight_info);o         break;       }e       case ButtonRelease:a       {v$         if (!windows->widget.mapped)           break;8         if (event.xbutton.window == windows->command.id)-           if (!(state & InactiveWidgetState))              break;
         /*           Exit menu.
         *//         XSetCursorState(display,windows,False);          *item='\0';e         state|=ExitState;          break;       }        case ConfigureNotify:t       {,
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=fB           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:o       { 9         if (event.xcrossing.window != windows->widget.id)            break;'         if (event.xcrossing.state == 0)/           break;&         state&=(~InactiveWidgetState);H         id=((event.xcrossing.y-top_offset)/(int) selection_info.height);P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {;             /*)               Unhighlight last selection.i             */(             if (id == selection_info.id)               break;             selection_info.y=,A               top_offset+selection_info.id*selection_info.height;t>             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           } 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.d
         */         selection_info.id=id;;L         selection_info.y=top_offset+selection_info.id*selection_info.height;:         selection_info.text=selections[selection_info.id];B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width; =         XDrawBevel(display,&windows->widget,&highlight_info);n         break;       }        case Expose:       { 7         if (event.xexpose.window != windows->widget.id)h           break;%         if (event.xexpose.count != 0)o           break;!         state|=RedrawWidgetState;L         break;       }e       case LeaveNotify:(       {o9         if (event.xcrossing.window != windows->widget.id)            break;#         state|=InactiveWidgetState;          id=selection_info.id;d2         if ((id < 0) || (id >= number_selections))           break;
         /*%           Unhighlight last selection.K
         */=         selection_info.y=top_offset+id*selection_info.height;r         selection_info.id=(~0);t+         selection_info.text=selections[id];yB         XDrawWidgetText(display,&windows->widget,&selection_info);         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events.i
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));           if (submenu_info.active):           if (event.xmotion.window == windows->command.id)/             if (!(state & InactiveWidgetState))                { ?                 if (!MatteIsActive(submenu_info,event.xmotion))m                   { +                     selection_info.id=(~0);y                     *item='\0';=%                     state|=ExitState;                      break;                   }]               }t             elseA               if (WindowIsActive(windows->command,event.xmotion))t                 {a)                   selection_info.id=(~0);                    *item='\0'; #                   state|=ExitState;&                   break;                 } 7         if (event.xmotion.window != windows->widget.id)_           break;(         if (state & InactiveWidgetState)           break;D         id=(event.xmotion.y-top_offset)/(int) selection_info.height;P         if ((selection_info.id >= 0) && (selection_info.id < number_selections))           {              /*)               Unhighlight last selection.              */(             if (id == selection_info.id)               break;             selection_info.y=BA               top_offset+selection_info.id*selection_info.height;)>             selection_info.text=selections[selection_info.id];F             XDrawWidgetText(display,&windows->widget,&selection_info);           }b         selection_info.id=id; 2         if ((id < 0) || (id >= number_selections))           break;
         /*#           Highlight this selection.a
         */=         selection_info.y=top_offset+id*selection_info.height;s+         selection_info.text=selections[id];)B         XDrawWidgetText(display,&windows->widget,&selection_info);E         highlight_info.y=selection_info.y+highlight_info.bevel_width;.=         XDrawBevel(display,&windows->widget,&highlight_info);e         break;       }        default:         break;     };!   } while (!(state & ExitState));a   XFreeCursor(display,cursor);,   window_attributes.override_redirect=False;H   XChangeWindowAttributes(display,windows->widget.id,CWOverrideRedirect,     &window_attributes);E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows);   if (submenu_info.active)     {i        submenu_info.active=False;       toggle_info.raised=False; @       XDrawTriangleEast(display,&windows->command,&toggle_info);     }vJ   if ((selection_info.id < 0) || (selection_info.id >= number_selections))     return(~0);(4   (void) strcpy(item,selections[selection_info.id]);   return(selection_info.id); }, S /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%sO %                                                                             % O %                                                                             % O %                                                                             % O %   X M o n i t o r W i d g e t                                               %tO %                                                                             %aO %                                                                             %,O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %iD %  Function XMonitorWidget displays the progress a task is making inM %  completing a task.  A span of zero toggles the active status.  An inactiver' %  state disables the progress monitor.= %e/ %  The format of the XMonitorWidget routine is:t %e6 %    XMonitorWidget(display,windows,task,quantum,span) % + %  A description of each parameter follows:e %hE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %t; %    o window: Specifies a pointer to a XWindows structure.y %q- %    o task: Identifies the task in progress.c %nO %    o quantum: Specifies the quantum position within the span which represents=< %      how much progress has been made in completing a task. % > %    o span: Specifies the span relative to completing a task. %o %t */I Export void XMonitorWidget(Display *display,XWindows *windows,char *task,s5   const unsigned int quantum,const unsigned int span)  {    unsigned int
     width;     XEvent
     event;  &   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);i    assert(task != (char *) NULL);   if (span == 0)     return;s   /*<     Update image windows if there is a pending expose event.   */   XFlush(display);K   while (XCheckTypedWindowEvent(display,windows->command.id,Expose,&event))%A     (void) XCommandWidget(display,windows,(char **) NULL,&event); I   while (XCheckTypedWindowEvent(display,windows->image.id,Expose,&event)) 3     XRefreshWindow(display,&windows->image,&event); H   while (XCheckTypedWindowEvent(display,windows->info.id,Expose,&event))+     if (monitor_info.text != (char *) NULL) 5       XInfoWidget(display,windows,monitor_info.text);    /*H     Draw progress monitor bar to represent percent completion of a task.   */;   if (!windows->info.mapped || (task != monitor_info.text)) &     XInfoWidget(display,windows,task);G   width=((quantum+1)*(windows->info.width-(monitor_info.x << 1)))/span; "   if (width == monitor_info.width)     return;%!   if (width < monitor_info.width)      {F       monitor_info.raised=True;y<       XDrawWidgetText(display,&windows->info,&monitor_info);        monitor_info.raised=False;     }o   monitor_info.width=width;t8   XDrawWidgetText(display,&windows->info,&monitor_info); }.   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%iO %                                                                             % O %                                                                             %XO %                                                                             %dO %   X N o t i c e W i d g e t                                                 %pO %                                                                             %tO %                                                                             %rO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %mM %  Function XNoticeWidget displays a Notice widget with a notice to the user.UC %  The function returns when the user presses the "Dismiss" button., % . %  The format of the XNoticeWidget routine is: %x5 %    XNoticeWidget(display,windows,message,qualifier)  %x+ %  A description of each parameter follows:, % E %    o display: Specifies a connection to an X server;  returned fromr %      XOpenDisplay. % ; %    o window: Specifies a pointer to a XWindows structure.  %tG %    o message: Specifies the message to display before terminating thep %      program., % 9 %    o qualifier: Specifies any qualifier to the message.  %p %, */= Export void XNoticeWidget(Display *display,XWindows *windows,s,   const char *message,const char *qualifier) { $ #define DismissButtonText  "Dismiss" #define Timeout  8     int"     status,d     x,     y;     time_t
     timer;     unsigned int     height,A
     width;     unsigned long 
     state;     XEvent
     event;  
   XFontStruct      *font_info;      XTextPropertyM     window_name;  
   XWidgetInfoo     dismiss_info;      XWindowChanges     window_changes;e     /*'     Determine Notice widget attributes.    */&   assert(display != (Display *) NULL);'   assert(windows != (XWindows *) NULL);M#   assert(message != (char *) NULL);eC   XDelay(display,SuspendTime << 3);  /* avoid surpise with delay */ (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;J   width=XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));   if (message != (char *) NULL) >     if (XTextWidth(font_info,message,Extent(message)) > width):       width=XTextWidth(font_info,message,Extent(message));!   if (qualifier != (char *) NULL) B     if (XTextWidth(font_info,qualifier,Extent(qualifier)) > width)>       width=XTextWidth(font_info,qualifier,Extent(qualifier));0   height=(font_info->ascent+font_info->descent);   /*     Position Notice widget.    */.   windows->widget.width=width+4*QuantumMargin;0   windows->widget.min_width=width+QuantumMargin;8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;#   windows->widget.height=12*height;g&   windows->widget.min_height=7*height;:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 3   windows->widget.x=x-(windows->widget.width >> 1);d8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);y   /*     Map Notice widget.   *//   (void) strcpy(windows->widget.name,"Notice");nI   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);i   if (status != 0)     {o:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     })-   window_changes.width=windows->widget.width;a/   window_changes.height=windows->widget.height;x%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y;xI   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,e4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);o   windows->widget.mapped=False;n   XBell(display,0);x   /*     Respond to X events.   */&   timer=time((time_t *) NULL)+Timeout;!   state=UpdateConfigurationState;f   do   {h&     if (time((time_t *) NULL) > timer)       break;)     if (state & UpdateConfigurationState)t       {x
         /*0           Initialize Dismiss button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);)         dismiss_info.width=QuantumMargin+aL           XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));,         dismiss_info.height=(3*height) >> 1;N         dismiss_info.x=(windows->widget.width >> 1)-(dismiss_info.width >> 1);I         dismiss_info.y=windows->widget.height-(dismiss_info.height << 1);t+         state&=(~UpdateConfigurationState);f       }>"     if (state & RedrawWidgetState)       {g
         /*           Redraw Notice widget.(
         */<         width=XTextWidth(font_info,message,Extent(message));4         x=(windows->widget.width >> 1)-(width >> 1);6         y=(windows->widget.height >> 1)-(height << 1);P         XDrawString(display,windows->widget.id,windows->widget.annotate_context,'           x,y,message,Extent(message));w'         if (qualifier != (char *) NULL)Q           { D             width=XTextWidth(font_info,qualifier,Extent(qualifier));8             x=(windows->widget.width >> 1)-(width >> 1);             y+=height;3             XDrawString(display,windows->widget.id,(P               windows->widget.annotate_context,x,y,qualifier,Extent(qualifier));           }tC         XDrawBeveledButton(display,&windows->widget,&dismiss_info);oM         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);i$         state&=(~RedrawWidgetState);       }d     /*       Wait for next event.     */E     if (!XCheckIfEvent(display,&event,XScreenEvent,(char *) windows))_       { 
         /*$           Do not block if delay > 0.
         */)         XDelay(display,SuspendTime << 2);          continue;g       }w     switch (event.type)      {c       case ButtonPress:d       {t6         if (MatteIsActive(dismiss_info,event.xbutton))           {s             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);l             break;           }t         break;       }o       case ButtonRelease:)       {t$         if (!windows->widget.mapped)           break;!         if (!dismiss_info.raised)i           { ;             if (event.xbutton.window == windows->widget.id),<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;f%             dismiss_info.raised=True;tG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);            }          break;       }o       case ClientMessage:        {G
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {wG             XSetInputFocus(display,event.xclient.window,RevertToParent,o'               event.xclient.data.l[1]);f             break;           }f?         if (*event.xclient.data.l != windows->wm_delete_window)c           break;7         if (event.xclient.window == windows->widget.id)<           {              state|=ExitState;              break;           }T         break;       }        case ConfigureNotify:        { 
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height==B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:o       {_9         if (event.xcrossing.window != windows->widget.id)t           break;&         state&=(~InactiveWidgetState);         break;       }M       case Expose:       { 7         if (event.xexpose.window != windows->widget.id)i           break;%         if (event.xexpose.count != 0)1           break;!         state|=RedrawWidgetState;i         break;       }e       case KeyPress:       {*         static chare!           command[MaxTextExtent];            static KeySymy           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),r/           &key_symbol,(XComposeStatus *) NULL);pE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))            { &             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);o             state|=ExitState;              break;           }p         break;       }        case LeaveNotify:.       {n9         if (event.xcrossing.window != windows->widget.id)i           break;#         state|=InactiveWidgetState;l         break;       }        case MotionNotify:       { 
         /*/           Discard pending button motion events. 
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));i(         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))o           {              /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;iG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }l         break;       }o       default:         break;     }i!   } while (!(state & ExitState));i)   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen); (   XCheckRefreshWindows(display,windows); }h > /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%.O %                                                                             %_O %                                                                             %dO %                                                                             %iO %   X P r e f e r e n c e s W i d g e t                                       %;O %                                                                             %gO %                                                                             %tO %                                                                             %MO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %_I %  Function XPreferencesWidget displays a Preferences widget with programmJ %  preferences.  If the user presses the Apply button, the preferences are? %  stored in a configuration file in the users' home directory.i %t3 %  The format of the XPreferencesWidget routine is:e % 6 %    XPreferencesWidget(display,resource_info,windows) %f+ %  A description of each parameter follows:f %-E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %cK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.o %n; %    o window: Specifies a pointer to a XWindows structure._ %o %d */8 Export unsigned int XPreferencesWidget(Display *display,1   XResourceInfo *resource_info,XWindows *windows)  {   #define ApplyButtonText  "Apply"L #define CacheButtonText  "%u mega-bytes of memory in the undo edit cache   "" #define CancelButtonText  "Cancel" #define NumberPreferences  7  
   static chare     *Preferences[] =     {h-       "display image centered on a backdrop",S        "confirm on program exit",(       "correct image for display gamma",!       "display warning messages",y7       "apply Floyd/Steinberg error diffusion to image",w8       "use a shared colormap for colormapped X visuals",,       "display images as an X server pixmap"     };     char     cache[MaxTextExtent];d     ints     status,-     x,     y;     register int     i;     unsigned int     height,h     text_width, 
     width;     unsigned longn
     state;     XEvent
     event;  
   XFontStruct(     *font_info;>     XTextProperty)     window_name;  
   XWidgetInfol     apply_info,e     cache_info,      cancel_info,(     preferences_info[NumberPreferences];     XWindowChanges     window_changes;y     /*,     Determine Preferences widget attributes.   */&   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);'   assert(windows != (XWindows *) NULL);>(   XCheckRefreshWindows(display,windows);&   font_info=windows->widget.font_info;K   text_width=XTextWidth(font_info,CacheButtonText,Extent(CacheButtonText));t'   for (i=0; i < NumberPreferences; i++)fQ     if (XTextWidth(font_info,Preferences[i],Extent(Preferences[i])) > text_width) M       text_width=XTextWidth(font_info,Preferences[i],Extent(Preferences[i]));dF   width=XTextWidth(font_info,ApplyButtonText,Extent(ApplyButtonText));N   if (XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText)) > width)J     width=XTextWidth(font_info,CancelButtonText,Extent(CancelButtonText));   width+=QuantumMargin;t0   height=(font_info->ascent+font_info->descent);   /*      Position Preferences widget.   */C   windows->widget.width=Max(width << 1,text_width)+6*QuantumMargin; 7   windows->widget.min_width=(width << 1)+QuantumMargin;t8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= =     7*height+NumberPreferences*(height+(QuantumMargin >> 1));    windows->widget.min_height=d=     7*height+NumberPreferences*(height+(QuantumMargin >> 1)); :   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y);e3   windows->widget.x=x-(windows->widget.width >> 1); 8   windows->widget.y=y-((5*windows->widget.height) >> 3);5   XConstrainWindowPosition(display,&windows->widget);m   /*     Map Preferences widget.    */4   (void) strcpy(windows->widget.name,"Preferences");I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);_   if (status != 0)     {t:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     }i-   window_changes.width=windows->widget.width;t/   window_changes.height=windows->widget.height;r%   window_changes.x=windows->widget.x; %   window_changes.y=windows->widget.y; I   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,r4     CWWidth | CWHeight | CWX | CWY,&window_changes);)   XMapRaised(display,windows->widget.id);o   windows->widget.mapped=False;r   /*     Respond to X events.   */!   state=UpdateConfigurationState;i(   XSetCursorState(display,windows,True);   do   {e)     if (state & UpdateConfigurationState)(       {w
         /*(           Initialize button information.
         */6         XGetWidgetInfo(CancelButtonText,&cancel_info);          cancel_info.width=width;+         cancel_info.height=(3*height) >> 1;y>         cancel_info.x=windows->widget.width-cancel_info.width-           (QuantumMargin << 1);BN         cancel_info.y=windows->widget.height-cancel_info.height-QuantumMargin;4         XGetWidgetInfo(ApplyButtonText,&apply_info);         apply_info.width=width; *         apply_info.height=(3*height) >> 1;(         apply_info.x=QuantumMargin << 1;#         apply_info.y=cancel_info.y;          y=height << 1;-         for (i=0; i < NumberPreferences; i++) 	         { >           XGetWidgetInfo(Preferences[i],&preferences_info[i]);,           preferences_info[i].bevel_width--;7           preferences_info[i].width=QuantumMargin >> 1; 8           preferences_info[i].height=QuantumMargin >> 1;3           preferences_info[i].x=QuantumMargin << 1;f"           preferences_info[i].y=y;)           y+=height+(QuantumMargin >> 1); 	         }n<         preferences_info[0].raised=!resource_info->backdrop;@         preferences_info[1].raised=!resource_info->confirm_exit;A         preferences_info[2].raised=!resource_info->gamma_correct; D         preferences_info[3].raised=!resource_info->display_warnings;:         preferences_info[4].raised=!resource_info->dither;M         preferences_info[5].raised=resource_info->colormap != SharedColormap;r>         preferences_info[6].raised=!resource_info->use_pixmap;H         (void) sprintf(cache,CacheButtonText,resource_info->undo_cache);*         XGetWidgetInfo(cache,&cache_info);!         cache_info.bevel_width--;(,         cache_info.width=QuantumMargin >> 1;-         cache_info.height=QuantumMargin >> 1; (         cache_info.x=QuantumMargin << 1;         cache_info.y=y; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       { 
         /*$           Redraw Preferences widget.
         */A         XDrawBeveledButton(display,&windows->widget,&apply_info); B         XDrawBeveledButton(display,&windows->widget,&cancel_info);-         for (i=0; i < NumberPreferences; i++)sL           XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);@         XDrawTriangleEast(display,&windows->widget,&cache_info);M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset); $         state&=(~RedrawWidgetState);       }      /*       Wait for next event.     */;     XIfEvent(display,&event,XScreenEvent,(char *) windows);_     switch (event.type)      {i       case ButtonPress:r       {g4         if (MatteIsActive(apply_info,event.xbutton))           {t             /*(               User pressed Apply button.             */$             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);w             break;           } 5         if (MatteIsActive(cancel_info,event.xbutton))i           {              /*)               User pressed Cancel button.t             */%             cancel_info.raised=False;fF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }S-         for (i=0; i < NumberPreferences; i++) ?           if (MatteIsActive(preferences_info[i],event.xbutton)).
             {                /*2                 User pressed a Preferences button.               */E               preferences_info[i].raised=!preferences_info[i].raised; P               XDrawBeveledButton(display,&windows->widget,&preferences_info[i]);               break;
             } 4         if (MatteIsActive(cache_info,event.xbutton))           {s             /*(               User pressed Cache button.             */C             x=cache_info.x+cache_info.width+cache_info.bevel_width+ #               (QuantumMargin >> 1); =             y=cache_info.y+((cache_info.height-height) >> 1);d<             width=XTextWidth(font_info,cache,Extent(cache));J             XClearArea(display,windows->widget.id,x,y,width,height,False);*             resource_info->undo_cache<<=1;0             if (resource_info->undo_cache > 256)*               resource_info->undo_cache=1;L             (void) sprintf(cache,CacheButtonText,resource_info->undo_cache);$             cache_info.raised=False;D             XDrawTriangleEast(display,&windows->widget,&cache_info);             break;           }          break;       }o       case ButtonRelease:        { $         if (!windows->widget.mapped)           break;         if (!apply_info.raised)|           {a;             if (event.xbutton.window == windows->widget.id)I:               if (MatteIsActive(apply_info,event.xbutton))!                 state|=ExitState; #             apply_info.raised=True;iE             XDrawBeveledButton(display,&windows->widget,&apply_info); $             apply_info.raised=False;           }|          if (!cancel_info.raised)           { ;             if (event.xbutton.window == windows->widget.id));               if (MatteIsActive(cancel_info,event.xbutton)) !                 state|=ExitState;n$             cancel_info.raised=True;F             XDrawBeveledButton(display,&windows->widget,&cancel_info);           }.         if (!cache_info.raised)            {a#             cache_info.raised=True; D             XDrawTriangleEast(display,&windows->widget,&cache_info);           }          break;       }        case ClientMessage:        { 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {vG             XSetInputFocus(display,event.xclient.window,RevertToParent,g'               event.xclient.data.l[1]);=             break;           }l?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)d           {.             state|=ExitState;              break;           }e         break;       }        case ConfigureNotify:L       {t
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height= B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:        {i9         if (event.xcrossing.window != windows->widget.id)&           break;&         state&=(~InactiveWidgetState);         break;       }A       case Expose:       {t7         if (event.xexpose.window != windows->widget.id)e           break;%         if (event.xexpose.count != 0)_           break;!         state|=RedrawWidgetState;s         break;       }e       case KeyPress:       {a         static char !           command[MaxTextExtent];            static KeySymm           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),F/           &key_symbol,(XComposeStatus *) NULL); E         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter)),           { $             apply_info.raised=False;E             XDrawBeveledButton(display,&windows->widget,&apply_info);              state|=ExitState;p             break;           }e         break;       }o       case LeaveNotify:e       { 9         if (event.xcrossing.window != windows->widget.id)i           break;#         state|=InactiveWidgetState;          break;       }u       case MotionNotify:       {i
         /*/           Discard pending button motion events.f
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event)); (         if (state & InactiveWidgetState)           break;I         if (apply_info.raised == MatteIsActive(apply_info,event.xmotion))t           {i             /**               Apply button status changed.             */1             apply_info.raised=!apply_info.raised; E             XDrawBeveledButton(display,&windows->widget,&apply_info);              break;           }.K         if (cancel_info.raised == MatteIsActive(cancel_info,event.xmotion))e           {              /*+               Cancel button status changed.y             */3             cancel_info.raised=!cancel_info.raised;uF             XDrawBeveledButton(display,&windows->widget,&cancel_info);             break;           }          break;       }s       default:         break;     } !   } while (!(state & ExitState));o)   XSetCursorState(display,windows,False); E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);f(   XCheckRefreshWindows(display,windows);   if (apply_info.raised)     return(False);   /*;     Save user preferences to the client configuration file.o   */6   resource_info->backdrop=!preferences_info[0].raised;:   resource_info->confirm_exit=!preferences_info[1].raised;;   resource_info->gamma_correct=!preferences_info[2].raised;o>   resource_info->display_warnings=!preferences_info[3].raised;4   resource_info->dither=!preferences_info[4].raised;)   resource_info->colormap=SharedColormap;w!   if (preferences_info[5].raised).,     resource_info->colormap=PrivateColormap;8   resource_info->use_pixmap=!preferences_info[6].raised;"   XUserPreferences(resource_info);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             %mO %                                                                             %GO %                                                                             % O %   X T e x t V i e w W i d g e t                                             %eO %                                                                             % O %                                                                             %pO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%. %s@ %  Function XTextViewWidget displays text in a Text View widget. %b0 %  The format of the XTextViewWidget routine is: % G %    XTextViewWidget(display,resource_info,windows,mono,title,textlist)u %d+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %lK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.r %;; %    o window: Specifies a pointer to a XWindows structure.  % 8 %    o mono:  Use mono-spaced font when displaying text. % I %    o title: This character string is displayed at the top of the widget  %      window. %)K %    o textlist: This string list is displayed within the Text View widget.  %  %  */P Export void XTextViewWidget(Display *display,const XResourceInfo *resource_info,H   XWindows *windows,const unsigned int mono,char *title,char **textlist) { $ #define DismissButtonText  "Dismiss"     char%     primary_selection[MaxTextExtent];f     intA     status,f     x,     y;     register int     i;  
   static charv*     mask = CWWidth | CWHeight | CWX | CWY;     unsigned int     height,d
     lines,     text_width,      visible_lines,
     width;     unsigned long 
     delay,
     state;     XEvent
     event;  
   XFontStruct      *font_info,f     *text_info;a     XTextProperty%     window_name;  
   XWidgetInfod     dismiss_info,e     expose_info,     list_info,     north_info,o     scroll_info,     selection_info,      slider_info,     south_info;_     XWindowChanges     window_changes;|     /*'     Convert text string to a text list.c   */&   assert(display != (Display *) NULL);2   assert(resource_info != (XResourceInfo *) NULL);'   assert(windows != (XWindows *) NULL);i!   assert(title != (char *) NULL);(%   assert(textlist != (char **) NULL);.(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);!   if (textlist == (char **) NULL)      { F       XNoticeWidget(display,windows,"No text to view:",(char *) NULL);
       return;      }    /**     Determine Text View widget attributes.   */&   font_info=windows->widget.font_info;!   text_info=(XFontStruct *) NULL;e   if (mono))4     text_info=XBestFont(display,resource_info,True);(   if (text_info == (XFontStruct *) NULL)(     text_info=windows->widget.font_info;   text_width=0; .   for (i=0; textlist[i] != (char *) NULL; i++)K     if (XTextWidth(text_info,textlist[i],Extent(textlist[i])) > text_width)fG       text_width=XTextWidth(text_info,textlist[i],Extent(textlist[i]));c
   lines=i;J   width=XTextWidth(font_info,DismissButtonText,Extent(DismissButtonText));   width+=QuantumMargin; .   height=text_info->ascent+text_info->descent;   /*     Position Text View widget.   */E   windows->widget.width=Min(text_width,MaxTextWidth)+5*QuantumMargin;d9   windows->widget.min_width=MinTextWidth+4*QuantumMargin; 8   if (windows->widget.width < windows->widget.min_width)4     windows->widget.width=windows->widget.min_width;   windows->widget.height= L     Min(Max(lines,3),32)*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);   windows->widget.min_height=i9     3*height+((13*height) >> 1)+((9*QuantumMargin) >> 1);p:   if (windows->widget.height < windows->widget.min_height)6     windows->widget.height=windows->widget.min_height;5   XQueryPosition(display,windows->widget.root,&x,&y); 7   windows->widget.x=x-((3*windows->widget.width) >> 2);v4   windows->widget.y=y-(windows->widget.height >> 1);5   XConstrainWindowPosition(display,&windows->widget);s   /*     Map Text View widget.e   */,   (void) strcpy(windows->widget.name,title);I   status=XStringListToTextProperty(&windows->widget.name,1,&window_name);i   if (status != 0)     {m:       XSetWMName(display,windows->widget.id,&window_name);>       XSetWMIconName(display,windows->widget.id,&window_name);(       XFree((void *) window_name.value);     } -   window_changes.width=windows->widget.width; /   window_changes.height=windows->widget.height;.%   window_changes.x=windows->widget.x;(%   window_changes.y=windows->widget.y; N   XReconfigureWMWindow(display,windows->widget.id,windows->widget.screen,mask,     &window_changes); )   XMapRaised(display,windows->widget.id);    windows->widget.mapped=False;    /*     Respond to X events.   */-   XGetWidgetInfo((char *) NULL,&slider_info); ,   XGetWidgetInfo((char *) NULL,&north_info);,   XGetWidgetInfo((char *) NULL,&south_info);   visible_lines=0;   delay=SuspendTime << 2;_.   height=font_info->ascent+font_info->descent;!   state=UpdateConfigurationState;    do   { )     if (state & UpdateConfigurationState)        {          intX
           id;K  
         /*(           Initialize button information.
         */8         XGetWidgetInfo(DismissButtonText,&dismiss_info);!         dismiss_info.width=width;r,         dismiss_info.height=(3*height) >> 1;P         dismiss_info.x=windows->widget.width-dismiss_info.width-QuantumMargin-2;P         dismiss_info.y=windows->widget.height-dismiss_info.height-QuantumMargin;
         /*(           Initialize scroll information.
         */3         XGetWidgetInfo((char *) NULL,&scroll_info);p"         scroll_info.bevel_width--;!         scroll_info.width=height;dC         scroll_info.height=dismiss_info.y-((5*QuantumMargin) >> 1); L         scroll_info.x=windows->widget.width-QuantumMargin-scroll_info.width;-         scroll_info.y=(3*QuantumMargin) >> 1;;!         scroll_info.raised=False;a          scroll_info.trough=True;         north_info=scroll_info;          north_info.raised=True;i8         north_info.width-=(north_info.bevel_width << 1);-         north_info.height=north_info.width-1;_-         north_info.x+=north_info.bevel_width;d-         north_info.y+=north_info.bevel_width;a         south_info=north_info;N         south_info.y=scroll_info.y+scroll_info.height-scroll_info.bevel_width-           south_info.height;         id=slider_info.id;         slider_info=north_info;          slider_info.id=id;         slider_info.width-=2; P         slider_info.min_y=north_info.y+north_info.height+north_info.bevel_width+$           slider_info.bevel_width+2;         slider_info.height=pJ           scroll_info.height-((slider_info.min_y-scroll_info.y+1) << 1)+2;;         visible_lines=(scroll_info.height-(height >> 3)-3)/ <           ((9*(text_info->ascent+text_info->descent)) >> 3);"         if (lines > visible_lines)F           slider_info.height=(visible_lines*slider_info.height)/lines;>         slider_info.max_y=south_info.y-south_info.bevel_width-$           slider_info.bevel_width-2;>         slider_info.x=scroll_info.x+slider_info.bevel_width+1;(         slider_info.y=slider_info.min_y;          expose_info=scroll_info;$         expose_info.y=slider_info.y;
         /*&           Initialize list information.
         */1         XGetWidgetInfo((char *) NULL,&list_info);          list_info.raised=False;X          list_info.bevel_width--;?         list_info.width=scroll_info.x-((3*QuantumMargin) >> 1); ,         list_info.height=scroll_info.height;"         list_info.x=QuantumMargin;"         list_info.y=scroll_info.y;
         /*+           Initialize selection information.g
         */6         XGetWidgetInfo((char *) NULL,&selection_info);$         selection_info.center=False;-         selection_info.width=list_info.width;bN         selection_info.height=(9*(text_info->ascent+text_info->descent)) >> 3;%         selection_info.x=list_info.x; +         state&=(~UpdateConfigurationState);        } "     if (state & RedrawWidgetState)       {x
         /*"           Redraw Text View window.
         */?         XDrawBeveledMatte(display,&windows->widget,&list_info); A         XDrawBeveledMatte(display,&windows->widget,&scroll_info); A         XDrawTriangleNorth(display,&windows->widget,&north_info);aB         XDrawBeveledButton(display,&windows->widget,&slider_info);A         XDrawTriangleSouth(display,&windows->widget,&south_info);nC         XDrawBeveledButton(display,&windows->widget,&dismiss_info); M         XHighlightWidget(display,&windows->widget,BorderOffset,BorderOffset);a         selection_info.id=(~0);S         state|=RedrawListState; $         state&=(~RedrawWidgetState);       }=      if (state & RedrawListState)       {r
         /*+           Determine slider id and position. 
         */:         if (slider_info.id >= (int) (lines-visible_lines))-           slider_info.id=lines-visible_lines;M=         if ((slider_info.id < 0) || (lines <= visible_lines))            slider_info.id=0; (         slider_info.y=slider_info.min_y;         if (lines != 0).           slider_info.y+=(I             slider_info.id*(slider_info.max_y-slider_info.min_y+1)/lines;r0         if (slider_info.id != selection_info.id)           {r             /*/               Redraw scroll bar and file names.              */0             windows->widget.font_info=text_info;N             XSetFont(display,windows->widget.annotate_context,text_info->fid);O             XSetFont(display,windows->widget.highlight_context,text_info->fid);s-             selection_info.id=slider_info.id; 9             selection_info.y=list_info.y+(height >> 3)+2; -             for (i=0; i < visible_lines; i++) 
             { G               selection_info.raised=(slider_info.id+i) != list_info.id; 0               selection_info.text=(char *) NULL;-               if ((slider_info.id+i) < lines)p?                 selection_info.text=textlist[slider_info.id+i];sH               XDrawWidgetText(display,&windows->widget,&selection_info);<               selection_info.y+=(int) selection_info.height;
             } 0             windows->widget.font_info=font_info;N             XSetFont(display,windows->widget.annotate_context,font_info->fid);O             XSetFont(display,windows->widget.highlight_context,font_info->fid);              /*               Update slider.             */.             if (slider_info.y > expose_info.y)               { ?                 expose_info.height=slider_info.y-expose_info.y; ?                 expose_info.y=slider_info.y-expose_info.height- ,                   slider_info.bevel_width-1;               }              else               { ?                 expose_info.height=expose_info.y-slider_info.y;t?                 expose_info.y=slider_info.y+slider_info.height+ ,                   slider_info.bevel_width+1;               }dE             XDrawTriangleNorth(display,&windows->widget,&north_info);->             XDrawMatte(display,&windows->widget,&expose_info);F             XDrawBeveledButton(display,&windows->widget,&slider_info);E             XDrawTriangleSouth(display,&windows->widget,&south_info);d(             expose_info.y=slider_info.y;           }c"         state&=(~RedrawListState);       }t     /*       Wait for next event.     *//     if (north_info.raised && south_info.raised) =       XIfEvent(display,&event,XScreenEvent,(char *) windows);n     else       {o
         /*2           Brief delay before advancing scroll bar.
         */         XDelay(display,delay);         delay=SuspendTime;D         XCheckIfEvent(display,&event,XScreenEvent,(char *) windows);         if (!north_info.raised)c!           if (slider_info.id > 0)n
             {                /*                 Move slider up.                */               slider_info.id--; %               state|=RedrawListState;p
             }m         if (!south_info.raised) %           if (slider_info.id < lines)n
             {q               /*!                 Move slider down.L               */               slider_info.id++;a%               state|=RedrawListState;c
             }!(         if (event.type != ButtonRelease)           continue;        }      switch (event.type)n     {_       case ButtonPress:T       {)5         if (MatteIsActive(slider_info,event.xbutton))            {              /*               Track slider.i             */$             slider_info.active=True;             break;           }(4         if (MatteIsActive(north_info,event.xbutton))!           if (slider_info.id > 0) 
             {t               /*                 Move slider up.                */&               north_info.raised=False;               slider_info.id--;e%               state|=RedrawListState;                break;
             } 4         if (MatteIsActive(south_info,event.xbutton))%           if (slider_info.id < lines) 
             {                /*!                 Move slider down.;               */&               south_info.raised=False;               slider_info.id++;t%               state|=RedrawListState;(               break;
             }e5         if (MatteIsActive(scroll_info,event.xbutton))e           {e             /*               Move slider.             */0             if (event.xbutton.y < slider_info.y)0               slider_info.id-=(visible_lines-1);             else0               slider_info.id+=(visible_lines-1);#             state|=RedrawListState;e             break;           }m6         if (MatteIsActive(dismiss_info,event.xbutton))           {o             /**               User pressed Dismiss button.             */&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);i             break;           } 3         if (MatteIsActive(list_info,event.xbutton)))           {s             unsigned int               id;W               static Timee               click_time;)               /*&               User pressed list matte.             */N             id=slider_info.id+(event.xbutton.y-(list_info.y+(height >> 1))+1)/$               selection_info.height;             if (id >= lines)               break;#             if (id != list_info.id)%               {%                  list_info.id=id;.                 click_time=event.xbutton.time;                 break;               }              list_info.id=id;?             if (event.xbutton.time >= (click_time+DoubleClick))                { .                 click_time=event.xbutton.time;                 break;               } *             click_time=event.xbutton.time;             /*4               Become the XA_PRIMARY selection owner.             */D             (void) strcpy(primary_selection,textlist[list_info.id]);E             XSetSelectionOwner(display,XA_PRIMARY,windows->widget.id, "               event.xbutton.time);M             if (XGetSelectionOwner(display,XA_PRIMARY) != windows->widget.id)                break;#             selection_info.id=(~0);              list_info.id=id;#             state|=RedrawListState;s             break;           }          break;       }        case ButtonRelease:n       {a$         if (!windows->widget.mapped)           break;         if (!north_info.raised)d           {i             /*&               User released up button.             */#             delay=SuspendTime << 2;c#             north_info.raised=True; E             XDrawTriangleNorth(display,&windows->widget,&north_info);o           }"         if (!south_info.raised)p           {              /*(               User released down button.             */#             delay=SuspendTime << 2;/#             south_info.raised=True; E             XDrawTriangleSouth(display,&windows->widget,&south_info);a           }*         if (slider_info.active)y           {(             /*#               Stop tracking slider.              */%             slider_info.active=False;v             break;           }i!         if (!dismiss_info.raised)n           {e;             if (event.xbutton.window == windows->widget.id)n<               if (MatteIsActive(dismiss_info,event.xbutton))!                 state|=ExitState;e%             dismiss_info.raised=True;kG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);_           }T         break;       }a       case ClientMessage:        {e
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;<         if (*event.xclient.data.l == windows->wm_take_focus)           {eG             XSetInputFocus(display,event.xclient.window,RevertToParent,n'               event.xclient.data.l[1]);              break;           }f?         if (*event.xclient.data.l != windows->wm_delete_window)            break;7         if (event.xclient.window == windows->widget.id)            {              state|=ExitState;              break;           }t         break;       }e       case ConfigureNotify:f       {o
         /*&           Update widget configuration.
         */:         if (event.xconfigure.window != windows->widget.id)           break;@         if ((event.xconfigure.width == windows->widget.width) &&@             (event.xconfigure.height == windows->widget.height))           break;         windows->widget.width=@           Max(event.xconfigure.width,windows->widget.min_width);         windows->widget.height=)B           Max(event.xconfigure.height,windows->widget.min_height);(         state|=UpdateConfigurationState;         break;       }        case EnterNotify:l       {s9         if (event.xcrossing.window != windows->widget.id)o           break;&         state&=(~InactiveWidgetState);         break;       }"       case Expose:       {(7         if (event.xexpose.window != windows->widget.id)=           break;%         if (event.xexpose.count != 0)i           break;!         state|=RedrawWidgetState;          break;       }        case KeyPress:       {          static charn!           command[MaxTextExtent];            static int           length;m           static KeySym*           key_symbol;   4         if (event.xkey.window != windows->widget.id)           break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),v/           &key_symbol,(XComposeStatus *) NULL);(         *(command+length)='\0';oE         if ((key_symbol == XK_Return) || (key_symbol == XK_KP_Enter))/           {=&             dismiss_info.raised=False;G             XDrawBeveledButton(display,&windows->widget,&dismiss_info);[             state|=ExitState;w             break;           }t1         if (AreaIsActive(scroll_info,event.xkey))i           {h             /*               Move slider.             */             switch (key_symbol)B
             {i               case XK_Home:n               case XK_KP_Home:               {;!                 slider_info.id=0;u                 break;               })               case XK_Up:_               case XK_KP_Up:               { !                 slider_info.id--;o                 break;               }                case XK_Down:B               case XK_KP_Down:               {Q!                 slider_info.id++;n                 break;               }T               case XK_Prior:               case XK_KP_Prior:E               {T.                 slider_info.id-=visible_lines;                 break;               }=               case XK_Next:T               case XK_KP_Next:               {s.                 slider_info.id+=visible_lines;                 break;               }e               case XK_End:               case XK_KP_End:t               {e%                 slider_info.id=lines;m                 break;               }i
             }i#             state|=RedrawListState;i             break;           }w         break;       }g       case KeyRelease:         break;       case LeaveNotify:g       {e9         if (event.xcrossing.window != windows->widget.id)d           break;#         state|=InactiveWidgetState;w         break;       }g       case MapNotify:y       {d         mask&=(~CWX);r         mask&=(~CWY);-         break;       }w       case MotionNotify:       {d
         /*/           Discard pending button motion events.i
         */A         while (XCheckMaskEvent(display,ButtonMotionMask,&event));v         if (slider_info.active)"           {l             /*                Move slider matte.             */*             slider_info.y=event.xmotion.y-D               ((slider_info.height+slider_info.bevel_width) >> 1)+1;2             if (slider_info.y < slider_info.min_y).               slider_info.y=slider_info.min_y;2             if (slider_info.y > slider_info.max_y).               slider_info.y=slider_info.max_y;             slider_info.id=0;w3             if (slider_info.y != slider_info.min_y)tI               slider_info.id=(lines*(slider_info.y-slider_info.min_y+1))/e8                 (slider_info.max_y-slider_info.min_y+1);#             state|=RedrawListState;.             break;           } (         if (state & InactiveWidgetState)           break;M         if (dismiss_info.raised == MatteIsActive(dismiss_info,event.xmotion))            {n             /*,               Dismiss button status changed.             */5             dismiss_info.raised=!dismiss_info.raised;tG             XDrawBeveledButton(display,&windows->widget,&dismiss_info);              break;           }          break;       }i       case SelectionClear:       {o         list_info.id=(~0);         selection_info.id=(~0);g         state|=RedrawListState;c         break;       }.       case SelectionRequest:       {;         XSelectionEventi           notify;t           XSelectionRequestEvent           *request;n  !         if (list_info.id == (~0))i           break;
         /*            Set primary selection.
         */-         request=(&(event.xselectionrequest));(N         XChangeProperty(request->display,request->requestor,request->property,P           request->target,8,PropModeReplace,(unsigned char *) primary_selection,%           Extent(primary_selection));i$         notify.type=SelectionNotify;         notify.send_event=True; (         notify.display=request->display;,         notify.requestor=request->requestor;,         notify.selection=request->selection;&         notify.target=request->target;"         notify.time=request->time;&         if (request->property == None)*           notify.property=request->target;         else,           notify.property=request->property;P         (void) XSendEvent(request->display,request->requestor,False,NoEventMask,           (XEvent *) &notify);       }_       default:         break;     }(!   } while (!(state & ExitState));e-   if (text_info != windows->widget.font_info)o!     XFreeFont(display,text_info); )   XSetCursorState(display,windows,False);.E   XWithdrawWindow(display,windows->widget.id,windows->widget.screen);o(   XCheckRefreshWindows(display,windows); }r