 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %             DDDD   IIIII  SSSSS  PPPP   L       AAA   Y   Y                 % O %             D   D    I    SS     P   P  L      A   A   Y Y                  % O %             D   D    I     SSS   PPPP   L      AAAAA    Y                   % O %             D   D    I       SS  P      L      A   A    Y                   % O %             DDDD   IIIII  SSSSS  P      LLLLL  A   A    Y                   % O %                                                                             % O %                                                                             % O %          Display Machine Independent File Format Image via X11.             % O %                                                                             % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. du Pont de Nemours and Company                        % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. du Pont de Nemours    % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. du Pont de Nemours and Company makes no representations % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. du Pont de Nemours and Company disclaims all warranties with regard  % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. du Pont de Nemours and Company be     % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Display is a machine architecture independent image processing G %  and display program.  It can display any image in the MIFF format on C %  any workstation display running X.  Display first determines the E %  hardware capabilities of the workstation.  If the number of unique J %  colors in the image is less than or equal to the number the workstationE %  can support, the image is displayed in an X window.  Otherwise the D %  number of colors in the image is first reduced to match the color8 %  resolution of the workstation before it is displayed. % M %  This means that a continuous-tone 24 bits-per-pixel image can display on a I %  8 bit pseudo-color device or monochrome device.  In most instances the H %  reduced color image closely resembles the original.  Alternatively, aG %  monochrome or pseudo-color image can display on a continuous-tone 24  %  bits-per-pixel device.  % ) %  The Display program command syntax is:  % > %  Usage: display [options ...] file [ [options ...] file ...] %  %  Where options include: < %    -backdrop          display image centered on a backdrop= %    -border geometry   surround image with a border of color ) %    -colormap type     Shared or Private ? %    -colors value      preferred number of colors in the image G %    -colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV 5 %    -comment string    annotate image with comment", / %    -compress type     RunlengthEncoded or Zip < %    -contrast          enhance or reduce the image contrastH %    -crop geometry     preferred size and location of the cropped image< %    -delay seconds     display the next image after pausingD %    -density geometry  vertical and horizontal density of the image; %    -despeckle         reduce the speckles within an image 6 %    -display server    display image to this X server+ %    -dispose method    GIF disposal method F %    -dither            apply Floyd/Steinberg error diffusion to imageC %    -edge factor       apply a filter to detect edges in the image G %    -enhance           apply a digital filter to enhance a noisy image < %    -flip              flip image in the vertical direction> %    -flop              flop image in the horizontal direction@ %    -frame geometry    surround image with an ornamental border1 %    -gamma value       level of gamma correction G %    -geometry geometry preferred size and location of the Image window : %    -immutable         displayed image cannot be modified7 %    -interlace type    None, Line, Plane, or Partition 2 %    -label name        assign a label to an imageB %    -map type          display image using this Standard Colormap@ %    -matte             store matte channel if the image has one: %    -monochrome        transform image to black and white6 %    -negate            apply color inversion to image@ %    -page geometry     size and location of the Postscript page, %    -quality value     JPEG quality settingI %    -raise value       lighten/darken image edges to create a 3-D effect @ %    -roll geometry     roll an image vertically or horizontally9 %    -rotate degrees    apply Paeth rotation to the image 7 %    -sample geometry   scale image with pixel sampling * %    -scene value       image scene number( %    -segment value     segment an image; %    -sharpen factor    apply a filter to sharpen the image 1 %    -size geometry     width and height of image I %    -texture filename  name of texture to tile onto the image background > %    -treedepth value   depth of the color classification treeH %    -update seconds    detect when image file is modified and redisplayB %    -verbose           print detailed information about the image< %    -visual type       display image using this visual typeB %    -window id         display image to background of this windowE %    -window_group id   exit program when this window id is destroyed - %    -write filename    write image to a file  % F %  In addition to those listed above, you can specify these standard XA %  resources as command line options:  -background, -bordercolor, I %  -borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor, 0 %  -name, -shared_memory, -usePixmap, or -title. % D %  Change '-' to '+' in any option above to reverse its effect.  ForH %  example, specify +matte to store the image without its matte channel. % D %  By default, the image format of `file' is determined by its magicF %  number.  To specify a particular image format, precede the filenameG %  with an image format name and a colon (i.e. ps:image) or specify the H %  image type as the filename suffix (i.e. image.ps).  Specify 'file' as$ %  '-' for standard input or output. %  %  Buttons: 2 %    1    press to map or unmap the Command widget8 %    2    press and drag to magnify a region of an image> %    3    press to load an image from a visual image directory %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "display.h" #include "version.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 6 %  Function Usage displays the program command syntax. % & %  The format of the Usage routine is: %  %      Usage(client_name)  % + %  A description of each parameter follows:  % J %    o client_name: a character string representing the name of the client %      program.  %  */* static void Usage(const char *client_name) {    char     **p;  
   static char      *buttons[]=      { 6       "1    press to map or unmap the Command widget",<       "2    press and drag to magnify a region of an image",B       "3    press to load an image from a visual image directory",       (char *) NULL      },     *options[]=      { @       "-backdrop          display image centered on a backdrop",A       "-border geometry   surround image with a border of color", -       "-colormap type     Shared or Private", C       "-colors value      preferred number of colors in the image", K       "-colorspace type   GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV", 7       "-comment string    annotate image with comment", 3       "-compress type     RunlengthEncoded or Zip", @       "-contrast          enhance or reduce the image contrast",L       "-crop geometry     preferred size and location of the cropped image",@       "-delay seconds     display the next image after pausing",H       "-density geometry  vertical and horizontal density of the image",?       "-despeckle         reduce the speckles within an image", :       "-display server    display image to this X server",/       "-dispose method    GIF disposal method", J       "-dither            apply Floyd/Steinberg error diffusion to image",G       "-edge factor       apply a filter to detect edges in the image", K       "-enhance           apply a digital filter to enhance a noisy image", @       "-flip              flip image in the vertical direction",B       "-flop              flop image in the horizontal direction",D       "-frame geometry    surround image with an ornamental border",5       "-gamma value       level of gamma correction", K       "-geometry geometry preferred size and location of the Image window", >       "-immutable         displayed image cannot be modified",;       "-interlace type    None, Line, Plane, or Partition", 6       "-label name        assign a label to an image",F       "-map type          display image using this Standard Colormap",D       "-matte             store matte channel if the image has one",>       "-monochrome        transform image to black and white",:       "-negate            apply color inversion to image",D       "-page geometry     size and location of the Postscript page",0       "-quality value     JPEG quality setting",M       "-raise value       lighten/darken image edges to create a 3-D effect", D       "-roll geometry     roll an image vertically or horizontally",=       "-rotate degrees    apply Paeth rotation to the image", .       "-scene value       image scene number",,       "-segment value     segment an image",;       "-sample geometry   scale image with pixel sampling", ?       "-sharpen factor    apply a filter to sharpen the image", 5       "-size geometry     width and height of image", M       "-texture filename  name of texture to tile onto the image background", B       "-treedepth value   depth of the color classification tree",L       "-update seconds    detect when image file is modified and redisplay",F       "-verbose           print detailed information about the image",@       "-visual type       display image using this visual type",F       "-window id         display image to background of this window",I       "-window_group id   exit program when this window id is destroyed", 1       "-write filename    write image to a file",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version);    (void) printf(N     "Usage: %s [-options ...] file [ [-options ...] file ...]\n",client_name);/   (void) printf("\nWhere options include: \n"); +   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(O     "\nIn addition to those listed above, you can specify these standard X\n");    (void) printf(H     "resources as command line options:  -background, -bordercolor,\n");   (void) printf(P     "-borderwidth, -font, -foreground, -iconGeometry, -iconic, -mattecolor,\n");   (void) printf(7     "-name, -shared_memory, -usePixmap, or -title.\n");    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(M     "example, specify +matte to store the image without a matte channel.\n");    (void) printf(M     "\nBy default, the image format of `file' is determined by its magic\n");    (void) printf(M     "number.  To specify a particular image format, precede the filename\n");    (void) printf(N     "with an image format name and a colon (i.e. ps:image) or specify the\n");   (void) printf(O     "image type as the filename suffix (i.e. image.ps).  Specify 'file' as\n"); 7   (void) printf("'-' for standard input or output.\n"); !   (void) printf("\nButtons: \n"); +   for (p=buttons; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n n o t a t e E d i t I m a g e                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XAnnotateEditImage annotates the image with text.  % 3 %  The format of the XAnnotateEditImage routine is:  % < %    XAnnotateEditImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */8 static unsigned int XAnnotateEditImage(Display *display,>   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   static char      *AnnotateMenu[]=     {        "Font Name",       "Font Color",        "Box Color",       "Rotate Text",
       "Help",        "Dismiss",       (char *) NULL      },     *TextMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      };     static double      degrees = 0.0;     static ModeType      AnnotateCommands[]=      {        AnnotateNameCommand,       AnnotateFontColorCommand, %       AnnotateBackgroundColorCommand,        AnnotateRotateCommand,       AnnotateHelpCommand,       AnnotateDismissCommand     },     TextCommands[]=      {        TextHelpCommand,       TextDismissCommand     };     static unsigned int      box_id = MaxNumberPens-2,      font_id = 0,     pen_id = 0,      transparent_box = True,      transparent_pen = False;     char      *ColorMenu[MaxNumberPens+1],     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      GC     annotate_context;      int      id,      pen_number,      x,     y;     KeySym     key_symbol;      register char      *p;      register int     i;     unsigned int     height,      status, 
     width;     unsigned long 
     state;     XAnnotateInfo      *annotate_info,      *previous_info;      XColor
     color;  
   XFontStruct      *font_info;      XEvent
     event,     text_event;      /*     Map Command widget.    */#   windows->command.name="Annotate";    windows->command.data=4;F   (void) XCommandWidget(display,windows,AnnotateMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,AnnotateMenu,&event);          if (id < 0)            continue; %         switch (AnnotateCommands[id]) 	         { #           case AnnotateNameCommand:            {              char(               *FontMenu[MaxNumberFonts];               int                font_number;               /*)               Initialize menu selections.              */.             for (i=0; i < MaxNumberFonts; i++)6               FontMenu[i]=resource_info->font_name[i];4             FontMenu[MaxNumberFonts-2]="Browser...";5             FontMenu[MaxNumberFonts-1]=(char *) NULL;              /*6               Select a font name from the pop-up menu.             */E             font_number=XMenuWidget(display,windows,AnnotateMenu[id],                 FontMenu,command);              if (font_number < 0)               break;2             if (font_number == (MaxNumberFonts-2))               {                  static char 3                   font_name[MaxTextExtent]="fixed";                    /*4                   Select a font name from a browser.                 */@                 resource_info->font_name[font_number]=font_name;G                 XFontBrowserWidget(display,windows,"Select",font_name); '                 if (*font_name == '\0')                    break;               }              /*#               Initialize font info.              */             font_info=L               XLoadQueryFont(display,resource_info->font_name[font_number]);2             if (font_info == (XFontStruct *) NULL)               { E                 XNoticeWidget(display,windows,"Unable to load font:", 9                   resource_info->font_name[font_number]);                  break;               }               font_id=font_number;)             XFreeFont(display,font_info);              break;           } (           case AnnotateFontColorCommand:           {              /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */D             pen_number=XMenuWidget(display,windows,AnnotateMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_pen=pen_number == (MaxNumberPens-2);              if (transparent_pen)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } .           case AnnotateBackgroundColorCommand:           {              /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];5             ColorMenu[MaxNumberPens-2]="transparent"; 4             ColorMenu[MaxNumberPens-1]="Browser...";3             ColorMenu[MaxNumberPens]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */D             pen_number=XMenuWidget(display,windows,AnnotateMenu[id],!               ColorMenu,command);              if (pen_number < 0)                break;<             transparent_box=pen_number == (MaxNumberPens-2);              if (transparent_box)               break;0             if (pen_number == (MaxNumberPens-1))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             box_id=pen_number;             break;           } %           case AnnotateRotateCommand:            {              int                entry;               static char ,               angle[MaxTextExtent] = "30.0",               *RotateMenu[]=               {                  "-90",                 "-45",                 "-30",                 "0",                 "30",                  "45",                  "90",                  "180",                 (char *) NULL,                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */&             RotateMenu[8]="Dialog...";J             entry=XMenuWidget(display,windows,AnnotateMenu[id],RotateMenu,               command);              if (entry < 0)               break;             if (entry != 8)                { 0                 degrees=atof(RotateMenu[entry]);                 break;               } N             (void) XDialogWidget(display,windows,"OK","Enter rotation angle:",               angle);              if (*angle == '\0')                break;              degrees=atof(angle);             break;           } #           case AnnotateHelpCommand:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           } &           case AnnotateDismissCommand:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*'           Change to text entering mode. 
         */         x=event.xbutton.x;         y=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } !   } while (!(state & ExitState)); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*0     Set font info and check boundary conditions.   */F   font_info=XLoadQueryFont(display,resource_info->font_name[font_id]);(   if (font_info == (XFontStruct *) NULL)     { ;       XNoticeWidget(display,windows,"Unable to load font:", +         resource_info->font_name[font_id]); )       font_info=windows->image.font_info;      } >   if ((x+font_info->max_bounds.width) >= windows->image.width)7     x=windows->image.width-font_info->max_bounds.width; 1   if (y < (font_info->ascent+font_info->descent)) +     y=font_info->ascent+font_info->descent; =   if ((font_info->max_bounds.width > windows->image.width) || H       ((font_info->ascent+font_info->descent) >= windows->image.height))     return(False);   /*"     Initialize annotate structure.   */@   annotate_info=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));.   if (annotate_info == (XAnnotateInfo *) NULL)     return(False);"   XGetAnnotateInfo(annotate_info);   annotate_info->x=x;    annotate_info->y=y; +   if (!transparent_box && !transparent_pen) )     annotate_info->stencil=OpaqueStencil;    else     if (!transparent_box) /       annotate_info->stencil=BackgroundStencil;      else/       annotate_info->stencil=ForegroundStencil; =   annotate_info->height=font_info->ascent+font_info->descent; !   annotate_info->degrees=degrees; %   annotate_info->font_info=font_info; &   annotate_info->text=(char *) malloc(N     (windows->image.width/Max(font_info->min_bounds.width,1)+2)*sizeof(char));+   if (annotate_info->text == (char *) NULL)      return(False);   /**     Create cursor and set graphic context.   */.   cursor=XCreateFontCursor(display,XC_pencil);2   XDefineCursor(display,windows->image.id,cursor);3   annotate_context=windows->image.annotate_context; 4   XSetFont(display,annotate_context,font_info->fid);*   XSetBackground(display,annotate_context,9     windows->image.pixel_info->pen_colors[box_id].pixel); *   XSetForeground(display,annotate_context,9     windows->image.pixel_info->pen_colors[pen_id].pixel);    /*)     Begin annotating the image with text.    */   windows->command.name="Text";    windows->command.data=0;B   (void) XCommandWidget(display,windows,TextMenu,(XEvent *) NULL);   state=DefaultState; D   XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);F   text_event.xexpose.width=(unsigned int) font_info->max_bounds.width;9   text_event.xexpose.height=font_info->max_bounds.ascent+ "     font_info->max_bounds.descent;   p=annotate_info->text;   do   {      /*       Display text cursor.     */     *p='\0';F     XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */0         XSetBackground(display,annotate_context,=           windows->image.pixel_info->background_color.pixel); 0         XSetForeground(display,annotate_context,=           windows->image.pixel_info->foreground_color.pixel); ?         id=XCommandWidget(display,windows,AnnotateMenu,&event); 0         XSetBackground(display,annotate_context,?           windows->image.pixel_info->pen_colors[box_id].pixel); 0         XSetForeground(display,annotate_context,?           windows->image.pixel_info->pen_colors[pen_id].pixel);          if (id < 0)            continue; !         switch (TextCommands[id]) 	         {            case TextHelpCommand:            { @             XTextViewWidget(display,resource_info,windows,False,B               "Help Viewer - Image Annotation",ImageAnnotateHelp);<             XDefineCursor(display,windows->image.id,cursor);             break;           } "           case TextDismissCommand:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               Extent(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:             break;	         }          continue;        }      /*       Erase text cursor.     */     text_event.xexpose.x=x; 8     text_event.xexpose.y=y-font_info->max_bounds.ascent;@     XClearArea(display,windows->image.id,x,text_event.xexpose.y,@       text_event.xexpose.width,text_event.xexpose.height,False);8     XRefreshWindow(display,&windows->image,&text_event);     switch (event.type)      {        case ButtonPress:        { 6         if (event.xbutton.window != windows->image.id)           break;,         if (event.xbutton.button == Button2)           {              /*(               Request primary selection.             */E             XConvertSelection(display,XA_PRIMARY,XA_STRING,XA_STRING, -               windows->image.id,CurrentTime);              break;           }          break;       }        case Expose:       { %         if (event.xexpose.count == 0)            {              XAnnotateInfo                *text_info;                /*#               Refresh Image window.              */D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);$             text_info=annotate_info;7             while (text_info != (XAnnotateInfo *) NULL) 
             { >               if (annotate_info->stencil == ForegroundStencil)G                 XDrawString(display,windows->image.id,annotate_context, <                   text_info->x,text_info->y,text_info->text,+                   Extent(text_info->text));                elseL                 XDrawImageString(display,windows->image.id,annotate_context,<                   text_info->x,text_info->y,text_info->text,+                   Extent(text_info->text)); ,               text_info=text_info->previous;
             } N             XDrawString(display,windows->image.id,annotate_context,x,y,"_",1);           }          break;       }        case KeyPress:       {          int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; N         if ((event.xkey.state & ControlMask) || (event.xkey.state & Mod1Mask))           state|=ModifierState; "         if (state & ModifierState)           switch (key_symbol)            {              case XK_u:             case XK_U:
             { '               key_symbol=DeleteCommand;                break;
             }              default:               break;           }          switch (key_symbol) 	         {            case XK_BackSpace:           {              /*"               Erase one character.             */)             if (p == annotate_info->text) D               if (annotate_info->previous == (XAnnotateInfo *) NULL)                 break;               else                 {                    /*;                     Go to end of the previous line of text.                    */8                   annotate_info=annotate_info->previous;(                   p=annotate_info->text;:                   x=annotate_info->x+annotate_info->width;%                   y=annotate_info->y; 0                   if (annotate_info->width != 0)3                     p+=Extent(annotate_info->text);                    break;                 }              p--;)             x-=XTextWidth(font_info,p,1); #             text_event.xexpose.x=x; @             text_event.xexpose.y=y-font_info->max_bounds.ascent;@             XRefreshWindow(display,&windows->image,&text_event);             break;           }            case DeleteCommand:            {              /*,               Erase the entire line of text.             */,             while (p != annotate_info->text)
             {                p--;+               x-=XTextWidth(font_info,p,1); %               text_event.xexpose.x=x; B               XRefreshWindow(display,&windows->image,&text_event);
             }              break;           }            case XK_Escape:            case XK_F20:           {              /*"               Finished annotating.             */J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               Extent(annotate_info->text)); @             XRefreshWindow(display,&windows->image,&text_event);             state|=ExitState;              break;           }            default:           {              /*:               Draw a single character on the Image window.             */&             if (state & ModifierState)               break;!             if (*command == '\0')                break;             *p=(*command);<             if (annotate_info->stencil == ForegroundStencil)N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);             elseN               XDrawImageString(display,windows->image.id,annotate_context,x,y,                 p,1); )             x+=XTextWidth(font_info,p,1);              p++;G             if ((x+font_info->max_bounds.width) < windows->image.width)                break;           }            case XK_Return:            case XK_KP_Enter:            {              /*/               Advance to the next line of text.              */             *p='\0';J             annotate_info->width=XTextWidth(font_info,annotate_info->text,+               Extent(annotate_info->text)); >             if (annotate_info->next != (XAnnotateInfo *) NULL)               {                  /*.                   Line of text already exists.                 */2                 annotate_info=annotate_info->next;#                 x=annotate_info->x; #                 y=annotate_info->y; &                 p=annotate_info->text;                 break;               } P             annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));>             if (annotate_info->next == (XAnnotateInfo *) NULL)               return(False);2             *annotate_info->next=(*annotate_info);8             annotate_info->next->previous=annotate_info;.             annotate_info=annotate_info->next;F             annotate_info->text=(char *) malloc((windows->image.width/B               Max(font_info->min_bounds.width,1)+2)*sizeof(char));5             if (annotate_info->text == (char *) NULL)                return(False);4             annotate_info->y+=annotate_info->height;9             if (annotate_info->y > windows->image.height) 5               annotate_info->y=annotate_info->height; 7             annotate_info->next=(XAnnotateInfo *) NULL;              x=annotate_info->x;              y=annotate_info->y; "             p=annotate_info->text;             break;           } 	         }          break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);           state&=(~ModifierState);         break;       }        case SelectionNotify:        {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   
         /*1           Obtain response from primary selection. 
         */5         if (event.xselection.property == (Atom) None)            break;E         status=XGetWindowProperty(display,event.xselection.requestor, J           event.xselection.property,0L,2047L,True,XA_STRING,&type,&format,            &length,&after,&data);K         if ((status != Success) || (type != XA_STRING) || (format == 32) ||              (length == 0))           break;
         /*7           Annotate Image window with primary selection. 
         */"         for (i=0; i < length; i++)	         {            if (data[i] != '\n')
             {                /*<                 Draw a single character on the Image window.               */               *p=data[i]; N               XDrawString(display,windows->image.id,annotate_context,x,y,p,1);+               x+=XTextWidth(font_info,p,1);                p++;I               if ((x+font_info->max_bounds.width) < windows->image.width)                  continue; 
             }            /*-             Advance to the next line of text.            */           *p='\0';H           annotate_info->width=XTextWidth(font_info,annotate_info->text,)             Extent(annotate_info->text)); <           if (annotate_info->next != (XAnnotateInfo *) NULL)
             {                /*,                 Line of text already exists.               */0               annotate_info=annotate_info->next;!               x=annotate_info->x; !               y=annotate_info->y; $               p=annotate_info->text;               continue; 
             } N           annotate_info->next=(XAnnotateInfo *) malloc(sizeof(XAnnotateInfo));<           if (annotate_info->next == (XAnnotateInfo *) NULL)             return(False);0           *annotate_info->next=(*annotate_info);6           annotate_info->next->previous=annotate_info;,           annotate_info=annotate_info->next;D           annotate_info->text=(char *) malloc((windows->image.width/@             Max(font_info->min_bounds.width,1)+2)*sizeof(char));3           if (annotate_info->text == (char *) NULL)              return(False);2           annotate_info->y+=annotate_info->height;7           if (annotate_info->y > windows->image.height) 3             annotate_info->y=annotate_info->height; 5           annotate_info->next=(XAnnotateInfo *) NULL;            x=annotate_info->x;            y=annotate_info->y;             p=annotate_info->text;	         }          XFree((void *) data);          break;       }        default:         break;     } !   } while (!(state & ExitState));    XFreeCursor(display,cursor);   /*2     Annotation is relative to image configuration.   */   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);    /*     Initialize annotated image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);1   while (annotate_info != (XAnnotateInfo *) NULL)    { "     if (annotate_info->width == 0)       { 
         /*>           No text on this line--  go to the next line of text.
         */.         previous_info=annotate_info->previous;+         free((char *) annotate_info->text); %         free((char *) annotate_info); $         annotate_info=previous_info;         continue;        }      /*2       Determine pixel index for box and pen color.     */)     windows->image.pixel_info->box_color= 4       windows->image.pixel_info->pen_colors[box_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[box_id].pixel)           { 3             windows->image.pixel_info->box_index=i;              break;           } )     windows->image.pixel_info->pen_color= 4       windows->image.pixel_info->pen_colors[pen_id];/     if (windows->image.pixel_info->colors != 0) ;       for (i=0; i < windows->image.pixel_info->colors; i++) 3         if (windows->image.pixel_info->pixels[i] == @             windows->image.pixel_info->pen_colors[pen_id].pixel)           { 3             windows->image.pixel_info->pen_index=i;              break;           }      /**       Define the annotate geometry string.     */     annotate_info->x= M       width*(annotate_info->x+windows->image.x)/windows->image.ximage->width; @     annotate_info->y=height*(annotate_info->y-font_info->ascent+6       windows->image.y)/windows->image.ximage->height;9     (void) sprintf(annotate_info->geometry,"%ux%u%+d%+d", >       width*annotate_info->width/windows->image.ximage->width,A       height*annotate_info->height/windows->image.ximage->height, -       annotate_info->x+x,annotate_info->y+y);      /*       Annotate image with text.      */     status= L       XAnnotateImage(display,windows->image.pixel_info,annotate_info,image);     if (status == 0)       return(False);     /*       Free up memory.      */*     previous_info=annotate_info->previous;'     free((char *) annotate_info->text); !     free((char *) annotate_info);       annotate_info=previous_info;   } *   XSetForeground(display,annotate_context,7     windows->image.pixel_info->foreground_color.pixel); *   XSetBackground(display,annotate_context,7     windows->image.pixel_info->background_color.pixel); C   XSetFont(display,annotate_context,windows->image.font_info->fid); )   XSetCursorState(display,windows,False);    XFreeFont(display,font_info);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X B a c k g r o u n d I m a g e                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Function XBackgroundImage displays the image in the background of a window. % 1 %  The format of the XBackgroundImage routine is:  % A %    status=XBackgroundImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o status: Function XBackgroundImage return True if the image isJ %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */6 static unsigned int XBackgroundImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)  { = #define BackgroundImageText  "  Backgrounding the image...  "   
   static char &     window_id[MaxTextExtent] = "root";     XResourceInfo      background_resources;      unsigned int     status;      /*     Put image in background.   */4   status=XDialogWidget(display,windows,"Background",H     "Enter window id (id 0x00 selects window with pointer):",window_id);   if (*window_id == '\0')      return(False);J   (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);3   XInfoWidget(display,windows,BackgroundImageText); (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);(   background_resources=(*resource_info);+   background_resources.window_id=window_id; '   background_resources.backdrop=status; G   status=XDisplayBackgroundImage(display,&background_resources,*image); 
   if (status) C     XClientMessage(display,windows->image.id,windows->im_protocols, -       windows->im_retain_colors,CurrentTime); )   XSetCursorState(display,windows,False); I   (void) XMagickCommand(display,resource_info,windows,UndoCommand,image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C h o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ) %  Function XChopImage chops the X image.  % + %  The format of the XChopImage routine is:  % ; %    status=XChopImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % > %    o status: Function XChopImage return True if the image isF %      cut.  False is returned is there is a memory shortage or if the %      image fails to cut. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */M static unsigned int XChopImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) { 
   static char      *ChopMenu[]=     {        "Direction",
       "Help",        "Dismiss",       (char *) NULL      };     static ModeType      ChopCommands[]=      {        ChopDirectionCommand,        ChopHelpCommand,       ChopDismissCommand     },&     direction = HorizontalChopCommand,     DirectionCommands[]=     {        HorizontalChopCommand,       VerticalChopCommand      };     char     text[MaxTextExtent];     Image      *chop_image;     int      id,      x,     y;     RectangleInfo      chop_info;     unsigned int
     distance,      height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;  
   XSegment     segment_info;      /*     Map Command widget.    */   windows->command.name="Chop";    windows->command.data=1;B   (void) XCommandWidget(display,windows,ChopMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */;         id=XCommandWidget(display,windows,ChopMenu,&event);          if (id < 0)            continue; !         switch (ChopCommands[id]) 	         { $           case ChopDirectionCommand:           {              char%               command[MaxTextExtent];                static char                *Directions[]=               {                  "horizontal",                  "vertical",                  (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */             id= K               XMenuWidget(display,windows,ChopMenu[id],Directions,command);              if (id >= 0).               direction=DirectionCommands[id];             break;           }            case ChopHelpCommand:            { @             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);             break;           } "           case ChopDismissCommand:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*=           User has committed to start point of chopping line. 
         */(         segment_info.x1=event.xbutton.x;(         segment_info.x2=event.xbutton.x;(         segment_info.y1=event.xbutton.y;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];            KeySym           key_symbol;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */?         (void) XLookupString((XKeyEvent *) &event.xkey,command, ?           sizeof(command),&key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,<               "Help Viewer - Image Chopping",ImageChopHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);        }      } !   } while (!(state & ExitState)); A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (state & EscapeState)     return(True);    /*B     Draw line as pointer moves until the mouse button is released.   */   chop_info.width=0;   chop_info.height=0;    chop_info.x=0;   chop_info.y=0;
   distance=0; B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;    do   {      if (distance > 9)        { 
         /*.           Display info and draw chopping line.
         */"         if (!windows->info.mapped)/           XMapWindow(display,windows->info.id); L         (void) sprintf(text," %ux%u%+d%+d",chop_info.width,chop_info.height,#           chop_info.x,chop_info.y); *         XInfoWidget(display,windows,text);1         XHighlightLine(display,windows->image.id, :           windows->image.highlight_context,&segment_info);       }      else       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen);      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event);      if (distance > 9) /       XHighlightLine(display,windows->image.id, 8         windows->image.highlight_context,&segment_info);     switch (event.type)      {        case ButtonPress:        { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;         break;       }        case ButtonRelease:        { 
         /*.           User has committed to chopping line.
         */(         segment_info.x2=event.xbutton.x;(         segment_info.y2=event.xbutton.y;         state|=ExitState;          break;       }        case Expose:         break;       case MotionNotify:       { (         segment_info.x2=event.xmotion.x;(         segment_info.y2=event.xmotion.y;       }        default:         break;     }      /*        Check boundary conditions.     */     if (segment_info.x2 < 0)       segment_info.x2=0;     else9       if (segment_info.x2 > windows->image.ximage->width) 5         segment_info.x2=windows->image.ximage->width;      if (segment_info.y2 < 0)       segment_info.y2=0;     else:       if (segment_info.y2 > windows->image.ximage->height)6         segment_info.y2=windows->image.ximage->height;
     distance= L       ((segment_info.x2-segment_info.x1)*(segment_info.x2-segment_info.x1))+L       ((segment_info.y2-segment_info.y1)*(segment_info.y2-segment_info.y1));     /*        Compute chopping geometry.     */+     if (direction == HorizontalChopCommand)        { :         chop_info.width=segment_info.x2-segment_info.x1+1;5         chop_info.x=windows->image.x+segment_info.x1;          chop_info.height=0;          chop_info.y=0;.         if (segment_info.x1 > segment_info.x2)           { >             chop_info.width=segment_info.x1-segment_info.x2+1;9             chop_info.x=windows->image.x+segment_info.x2;            }        }      else       {          chop_info.width=0;;         chop_info.height=segment_info.y2-segment_info.y1+1;          chop_info.x=0;5         chop_info.y=windows->image.y+segment_info.y1; .         if (segment_info.y1 > segment_info.y2)           { ?             chop_info.height=segment_info.y1-segment_info.y2+1; 9             chop_info.y=windows->image.y+segment_info.y2;            }        } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (distance <= 9)     return(True);    /*6     Image chopping is relative to image configuration.   */J   (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);&   windows->image.window_changes.width=1     windows->image.ximage->width-chop_info.width; '   windows->image.window_changes.height= 3     windows->image.ximage->height-chop_info.height;    x=0;   y=0;   width=(*image)->columns;   height=(*image)->rows;4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    chop_info.x+=x; 2   chop_info.x=DownShift(chop_info.x*scale_factor);:   chop_info.width=DownShift(chop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    chop_info.y+=y; 2   chop_info.y=DownShift(chop_info.y*scale_factor);<   chop_info.height=DownShift(chop_info.height*scale_factor);   /*     Chop image.    */*   chop_image=ChopImage(*image,&chop_info);)   XSetCursorState(display,windows,False); #   if (chop_image == (Image *) NULL)      return(False);   DestroyImage(*image);    *image=chop_image;   /*     Update image configuration.    */@   XConfigureImageColormap(display,resource_info,windows,*image);?   (void) XConfigureImage(display,resource_info,windows,*image);    return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o l o r E d i t I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Function XColorEditImage allows the user to interactively change K %  the color of one pixel for a DirectColor image or one colormap entry for  %  a PseudoClass image.  % 0 %  The format of the XColorEditImage routine is: % 9 %    XColorEditImage(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */5 static unsigned int XColorEditImage(Display *display, ?   XResourceInfo *resource_info,XWindows *windows,Image **image)  { 
   static char      *ColorEditMenu[]=      {        "Pixel Color",       "Method",        "Delta",
       "Undo", 
       "Help",        "Dismiss",       (char *) NULL      };     static ModeType      ColorEditCommands[]=     {        ColorEditColorCommand,       ColorEditMethodCommand,        ColorEditDeltaCommand,       ColorEditUndoCommand,        ColorEditHelpCommand,        ColorEditDismissCommand      };     static PaintMethod     method = PointMethod;      static unsigned int      delta = 0,     pen_id = 0;      char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      int 
     entry,     id,      x,
     x_offset,      y,
     y_offset;      register int     i;     register RunlengthPacket     *p;      unsigned int     height, 
     width;     unsigned long 
     state;     XColor
     color;     XEvent
     event;     /*     Map Command widget.    */%   windows->command.name="Color Edit";    windows->command.data=3;G   (void) XCommandWidget(display,windows,ColorEditMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id, F     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,ColorEditMenu,&event);         if (id < 0)            { <             XDefineCursor(display,windows->image.id,cursor);             continue;            } &         switch (ColorEditCommands[id])	         { %           case ColorEditColorCommand:            {              char(               *ColorMenu[MaxNumberPens];               int                pen_number;                /*)               Initialize menu selections.              */7             for (i=0; i < (int) (MaxNumberPens-2); i++) 8               ColorMenu[i]=resource_info->pen_colors[i];4             ColorMenu[MaxNumberPens-2]="Browser...";5             ColorMenu[MaxNumberPens-1]=(char *) NULL;              /*6               Select a pen color from the pop-up menu.             */O             pen_number=XMenuWidget(display,windows,ColorEditMenu[id],ColorMenu,                command);              if (pen_number < 0)                break;0             if (pen_number == (MaxNumberPens-2))               {                  static char 5                   color_name[MaxTextExtent] = "gray";                    /*3                   Select a pen color from a dialog.                  */A                 resource_info->pen_colors[pen_number]=color_name; I                 XColorBrowserWidget(display,windows,"Select",color_name); (                 if (*color_name == '\0')                   break;               }              /*               Set pen color.             */I             (void) XParseColor(display,windows->image.map_info->colormap, <               resource_info->pen_colors[pen_number],&color);A             XBestPixel(display,windows->image.map_info->colormap, ?               (XColor *) NULL,(unsigned int) MaxColors,&color); D             windows->image.pixel_info->pen_colors[pen_number]=color;             pen_id=pen_number;             break;           } &           case ColorEditMethodCommand:           {              static char                *MethodMenu[]=               {                  "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu.              */             entry=P               XMenuWidget(display,windows,ColorEditMenu[id],MethodMenu,command);             if (entry >= 0) )               method=(PaintMethod) entry;              break;           } %           case ColorEditDeltaCommand:            {              static char                *DeltaMenu[]=                {                  "0",                 "1",                 "2",                 "4",                 "8",                 "16",                  "32",                  (char *) NULL,                 (char *) NULL,               },)               value[MaxTextExtent] = "3";                /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog..."; J             entry=XMenuWidget(display,windows,ColorEditMenu[id],DeltaMenu,               command);              if (entry < 0)               break;             if (entry != 7)                { -                 delta=atoi(DeltaMenu[entry]);                  break;               } K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",                value);              if (*value == '\0')                break;             delta=atoi(value);             break;           } $           case ColorEditUndoCommand:           { L             (void) XMagickCommand(display,resource_info,windows,UndoCommand,               image);              break;           } $           case ColorEditHelpCommand:           default:           { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           } '           case ColorEditDismissCommand:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           } 	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*           Exit loop.
         */         x=event.xbutton.x;         y=event.xbutton.y;<         (void) XMagickCommand(display,resource_info,windows,)           SaveToUndoBufferCommand,image); (         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { ,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];            KeySym           key_symbol;   5         if (event.xkey.window == windows->magnify.id)            {              Window               window;   '             window=windows->magnify.id; J             while (XCheckWindowEvent(display,window,KeyPressMask,&event));           } 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { @             XTextViewWidget(display,resource_info,windows,False,C               "Help Viewer - Image Annotation",ImageColorEditHelp);              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*E           Map and unmap Info widget as cursor crosses its boundaries. 
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id);          break;       }        default:         break;     } 1     if (event.xany.window == windows->magnify.id)        { .         x=windows->magnify.x-windows->image.x;.         y=windows->magnify.y-windows->image.y;       }      x_offset=x;      y_offset=y; )     if (state & UpdateConfigurationState)        {          int            x,           y;  
         /*8           Pixel edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); <         color=windows->image.pixel_info->pen_colors[pen_id];G         XPutPixel(windows->image.ximage,x_offset,y_offset,color.pixel);          x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);          x_offset= K           width*(windows->image.x+x_offset)/windows->image.ximage->width+x;          y_offset= M           height*(windows->image.y+y_offset)/windows->image.ximage->height+y; -         if ((x_offset < 0) || (y_offset < 0))            continue; L         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;          switch (method) 	         {            case PointMethod:            default:           {              /*=               Update color information using point algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset); )             p->red=XDownScale(color.red); -             p->green=XDownScale(color.green); +             p->blue=XDownScale(color.blue);              break;           }            case ReplaceMethod:            {              RunlengthPacket                target;                /*?               Update color information using replace algorithm.              */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                x+=(p->length+1); <               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             } '             target=(*image)->pixels[i]; /             if ((*image)->class == DirectClass)                { #                 p=(*image)->pixels; 5                 for (i=0; i < (*image)->packets; i++)                  { 2                   if (ColorMatch(*p,target,delta))                     { 3                       p->red=XDownScale(color.red); 7                       p->green=XDownScale(color.green); 5                       p->blue=XDownScale(color.blue);                      }                    p++;                 }                }              else               { 4                 for (i=0; i < (*image)->colors; i++)E                   if (ColorMatch((*image)->colormap[i],target,delta))                      { F                       (*image)->colormap[i].red=XDownScale(color.red);J                       (*image)->colormap[i].green=XDownScale(color.green);H                       (*image)->colormap[i].blue=XDownScale(color.blue);                     } "                 SyncImage(*image);               }              break;           }            case FloodfillMethod:            {              ColorPacket                pen_color;               /*A               Update color information using floodfill algorithm.              */(             (*image)->class=DirectClass;)             if (!UncompressImage(*image))                break;0             pen_color.red=XDownScale(color.red);4             pen_color.green=XDownScale(color.green);2             pen_color.blue=XDownScale(color.blue);K             ColorFloodfillImage(*image,x_offset,y_offset,&pen_color,delta);              break;           }            case ResetMethod:            {              /*=               Update color information using reset algorithm.              */(             (*image)->class=DirectClass;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             { +               p->red=XDownScale(color.red); /               p->green=XDownScale(color.green); -               p->blue=XDownScale(color.blue);                p++;
             }              break;           } 	         } +         state&=(~UpdateConfigurationState);        } !   } while (!(state & ExitState)); )   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o m p o s i t e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Function XCompositeImage requests an image name from the user, reads M %  the image and composites it with the X window image at a location the user  %  chooses with the pointer. % 0 %  The format of the XCompositeImage routine is: % @ %    status=XCompositeImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % D %    o status: Function XCompositeImage returns True if the image isM %      composited.  False is returned is there is a memory shortage or if the $ %      image fails to be composited. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  */5 static unsigned int XCompositeImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   static char      *CompositeMenu[]=      {        "Operators",       "Blend",       "Displace", 
       "Help",        "Dismiss",       (char *) NULL      },3     displacement_geometry[MaxTextExtent] = "30x30", #     filename[MaxTextExtent] = "\0";      static CompositeOperator!     compose = ReplaceCompositeOp;      static ModeType      CompositeCommands[]=     {         CompositeOperatorsCommand,       CompositeBlendCommand,       CompositeDisplaceCommand,        CompositeHelpCommand,        CompositeDismissCommand      };     char     text[MaxTextExtent];     Cursor     cursor;      double
     blend;     Image      *composite_image;      int      id,      x,     y;     RectangleInfo      highlight_info,      composite_info;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*&     Request image file name from user.   */;   XFileBrowserWidget(display,windows,"Composite",filename);    if (*filename == '\0')     return(True);    /*     Read image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);7   composite_image=ReadImage(resource_info->image_info); )   XSetCursorState(display,windows,False); (   if (composite_image == (Image *) NULL)     { F       XNoticeWidget(display,windows,"Unable to read image:",filename);       return(False);     }    if (!composite_image->matte)     {        /*/         Request mask image file name from user.        */$       XNoticeWidget(display,windows,C         "Your image does not have the required matte information.", ?         "Press dismiss and choose an image to use as a mask."); ?       XFileBrowserWidget(display,windows,"Composite",filename);        if (*filename != '\0')	         {            char              size[MaxTextExtent];             Image              *mask_image;             ImageInfo              image_info;              /*             Read image.            */0           XSetCursorState(display,windows,True);0           XCheckRefreshWindows(display,windows);$           GetImageInfo(&image_info);6           (void) strcpy(image_info.filename,filename);           image_info.size=size; J           (void) sprintf(image_info.size,"%ux%u",composite_image->columns,#             composite_image->rows); ,           mask_image=ReadImage(&image_info);1           XSetCursorState(display,windows,False); +           if (mask_image == (Image *) NULL) 
             { N               XNoticeWidget(display,windows,"Unable to read image:",filename);               return(False);
             } L           CompositeImage(composite_image,AddMaskCompositeOp,mask_image,0,0);#           DestroyImage(mask_image); 	         }      }    /*     Map Command widget.    */$   windows->command.name="Composite";   windows->command.data=1;G   (void) XCommandWidget(display,windows,CompositeMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);&   composite_info.x=windows->image.x+x;&   composite_info.y=windows->image.y+y;   composite_info.width=0;    composite_info.height=0;0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   blend=0.0;   state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */J         (void) sprintf(text," %+d%+d ",composite_info.x,composite_info.y);*         XInfoWidget(display,windows,text);       } "     highlight_info=composite_info;7     highlight_info.x=composite_info.x-windows->image.x; 7     highlight_info.y=composite_info.y-windows->image.y; 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */@         id=XCommandWidget(display,windows,CompositeMenu,&event);         if (id < 0)            continue; &         switch (CompositeCommands[id])	         { )           case CompositeOperatorsCommand:            {              char%               command[MaxTextExtent];                static char                *OperatorMenu[]=               {                  "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",                  "bumpmap",                 "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */E             compose=(CompositeOperator) (XMenuWidget(display,windows, 9               CompositeMenu[id],OperatorMenu,command)+1);              break;           } %           case CompositeBlendCommand:            {              static char -               factor[MaxTextExtent] = "20.0";                /*3               Blend the two images a given percent.              */J             XSetFunction(display,windows->image.highlight_context,GXcopy);9             (void) XDialogWidget(display,windows,"Blend", >               "Enter the blend factor (0.0 - 99.9%):",factor);L             XSetFunction(display,windows->image.highlight_context,GXinvert);              if (*factor == '\0')               break;             blend=atof(factor); %             compose=BlendCompositeOp;              break;           } (           case CompositeDisplaceCommand:           {              /*F               Get horizontal and vertical scale displacement geometry.             */J             XSetFunction(display,windows->image.highlight_context,GXcopy);<             (void) XDialogWidget(display,windows,"Displace",P               "Enter the horizontal and vertical scale:",displacement_geometry);L             XSetFunction(display,windows->image.highlight_context,GXinvert);/             if (*displacement_geometry == '\0')                break;(             compose=DisplaceCompositeOp;             break;           } $           case CompositeHelpCommand:           { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           } '           case CompositeDismissCommand:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*           Change cursor.
         */6         composite_info.width=composite_image->columns;4         composite_info.height=composite_image->rows;8         XDefineCursor(display,windows->image.id,cursor);:         composite_info.x=windows->image.x+event.xbutton.x;:         composite_info.y=windows->image.y+event.xbutton.y;         break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;H         if ((composite_info.width != 0) && (composite_info.height != 0))           {              /*D               User has selected the location of the composite image.             */>             composite_info.x=windows->image.x+event.xbutton.x;>             composite_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }          break;       }        case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];            KeySym           key_symbol;            int            length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */*             DestroyImage(composite_image);             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            { J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,D               "Help Viewer - Image Compositing",ImageCompositeHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); ,         composite_info.x=windows->image.x+x;,         composite_info.y=windows->image.y+y;         break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      } !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);    /*9     Image compositing is relative to image configuration.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    composite_info.x+=x;<   composite_info.x=DownShift(composite_info.x*scale_factor);D   composite_info.width=DownShift(composite_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    composite_info.y+=y;<   composite_info.y=DownShift(composite_info.y*scale_factor);F   composite_info.height=DownShift(composite_info.height*scale_factor);;   if ((composite_info.width != composite_image->columns) || 7       (composite_info.height != composite_image->rows))      {        Image          *zoomed_image;         /*         Scale composite image.       */B       zoomed_image=ZoomImage(composite_image,composite_info.width,.         composite_info.height,MitchellFilter);$       DestroyImage(composite_image);)       if (zoomed_image == (Image *) NULL) 	         { 1           XSetCursorState(display,windows,False);            return(False);	         } #       composite_image=zoomed_image;      } %   if (compose == DisplaceCompositeOp) 4     composite_image->geometry=displacement_geometry;   if (blend != 0.0)      {        register int
         i;         register RunlengthPacket         *p;          unsigned short         index;         /*#         Create mattes for blending.        */C       index=(unsigned short) (((int) DownScale(MaxRGB)*blend)/100); )       composite_image->class=DirectClass; "       composite_image->matte=True;        p=composite_image->pixels;2       for (i=0; i < composite_image->packets; i++)       {          p->index=index;          p++;       }        index=(unsigned short)F         ((int) DownScale(MaxRGB)-((int) DownScale(MaxRGB)*blend)/100);       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=index;          p++;       }      }    /*(     Composite image with X Image window.   */@   CompositeImage(image,compose,composite_image,composite_info.x,     composite_info.y);    DestroyImage(composite_image);)   XSetCursorState(display,windows,False);    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e C o l o r m a p                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % = %  Function XConfigureImageColormap creates a new X colormap.  % 8 %  The format of the XConfigureImageColormap routine is: % A %    XConfigureImageColormap(display,resource_info,windows,image)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static void XConfigureImageColormap(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) { 
   Colormap
     colormap;      /*     Make standard colormap.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);5   if (image->packets == (image->columns*image->rows))      CompressImage(image); I   XMakeStandardColormap(display,windows->image.visual_info,resource_info, =     image,windows->image.map_info,windows->image.pixel_info); -   colormap=windows->image.map_info->colormap; 9   XSetWindowColormap(display,windows->image.id,colormap); ;   XSetWindowColormap(display,windows->command.id,colormap); :   XSetWindowColormap(display,windows->widget.id,colormap);   if (windows->magnify.mapped)=     XSetWindowColormap(display,windows->magnify.id,colormap);    if (windows->pan.mapped)9     XSetWindowColormap(display,windows->pan.id,colormap); )   XSetCursorState(display,windows,False); A   XClientMessage(display,windows->image.id,windows->im_protocols, -     windows->im_update_colormap,CurrentTime);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C o n f i g u r e I m a g e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Function XConfigureImage creates a new X image.  It also notifies theL %  window manager of the new image size and configures the transient widows. % 0 %  The format of the XConfigureImage routine is: % @ %    status=XConfigureImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % E %    o status: Function XConfigureImage returns True if the window is J %      resized.  False is returned is there is a memory shortage or if the %      window fails to resize. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */5 static unsigned int XConfigureImage(Display *display, >   XResourceInfo *resource_info,XWindows *windows,Image *image) {    char     geometry[MaxTextExtent];     int      x,     y;     unsigned int     height, 	     mask,      stasis,      status, 
     width;     XSizeHints     *size_hints;     XWindowChanges     window_changes;      /**     Dismiss if window dimensions are zero.   */,   width=windows->image.window_changes.width;.   height=windows->image.window_changes.height;   if (resource_info->debug) <     (void) fprintf(stderr,"Configure Image: %dx%d=>%ux%u\n",O       windows->image.ximage->width,windows->image.ximage->height,width,height);    if ((width*height) == 0)     return(True);    /*0     Resize image to fit Image window dimensions.   */(   XSetCursorState(display,windows,True);   XFlush(display);3   stasis=(width == windows->image.ximage->width) && .     (height == windows->image.ximage->height);K   windows->magnify.x=width*windows->magnify.x/windows->image.ximage->width; M   windows->magnify.y=height*windows->magnify.y/windows->image.ximage->height; G   windows->image.x=width*windows->image.x/windows->image.ximage->width; I   windows->image.y=height*windows->image.y/windows->image.ximage->height; N   status=XMakeImage(display,resource_info,&windows->image,image,width,height);   if (status == False)A     XNoticeWidget(display,windows,"Unable to configure X image:",        windows->image.name);    /*3     Notify window manager of the new configuration.    */P   (void) sprintf(geometry,"%ux%u>",XDisplayWidth(display,windows->image.screen),3     XDisplayHeight(display,windows->image.screen)); ;   (void) ParseImageGeometry(geometry,&x,&y,&width,&height);    window_changes.width=width;    window_changes.height=height;    mask=CWWidth | CWHeight;   if (resource_info->backdrop)     {        mask|=CWX | CWY;       window_changes.x= I         (XDisplayWidth(display,windows->image.screen) >> 1)-(width >> 1);        window_changes.y= K         (XDisplayHeight(display,windows->image.screen) >> 1)-(height >> 1);      } L   XReconfigureWMWindow(display,windows->image.id,windows->image.screen,mask,     &window_changes);    if (image->matte) ,     XClearWindow(display,windows->image.id);
   if (stasis) <     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*(     Update Magnify window configuration.   */   if (windows->magnify.mapped)'     XMakeMagnifyImage(display,windows);    /*$     Update pan window configuration.   */:   windows->pan.crop_geometry=windows->image.crop_geometry;-   XBestIconSize(display,&windows->pan,image); -   while ((windows->pan.width < MinPanSize) && ,          (windows->pan.height < MinPanSize))   {      windows->pan.width<<=1;      windows->pan.height<<=1;   } -   if (windows->pan.geometry != (char *) NULL) D     (void) ParseImageGeometry(windows->pan.geometry,&windows->pan.x,@       &windows->pan.y,&windows->pan.width,&windows->pan.height);*   window_changes.width=windows->pan.width;,   window_changes.height=windows->pan.height;   size_hints=XAllocSizeHints(); (   if (size_hints != (XSizeHints *) NULL)     {        /*         Set new size hints.        */4       size_hints->flags=PSize | PMinSize | PMaxSize;-       size_hints->width=window_changes.width; /       size_hints->height=window_changes.height; .       size_hints->min_width=size_hints->width;0       size_hints->min_height=size_hints->height;.       size_hints->max_width=size_hints->width;0       size_hints->max_height=size_hints->height;:       XSetNormalHints(display,windows->pan.id,size_hints);!       XFree((void *) size_hints);      } L   XReconfigureWMWindow(display,windows->pan.id,windows->pan.screen,CWWidth |     CWHeight,&window_changes);   if (windows->pan.mapped)7     XMakePanImage(display,resource_info,windows,image);    /*%     Update icon window configuration.    */;   windows->icon.crop_geometry=windows->image.crop_geometry; .   XBestIconSize(display,&windows->icon,image);+   window_changes.width=windows->icon.width; -   window_changes.height=windows->icon.height; E   XReconfigureWMWindow(display,windows->icon.id,windows->icon.screen, (     CWWidth | CWHeight,&window_changes);)   XSetCursorState(display,windows,False);    return(status);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X C r o p I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Function XCropImage allows the user to select a region of the image andI %  crop, copy, or cut it.  For copy or cut, the image can subsequently be . %  composited onto the image with XPasteImage. % + %  The format of the XCropImage routine is:  % @ %    status=XCropImage(display,resource_info,windows,image,mode) % + %  A description of each parameter follows:  % ? %    o status: Function XCropImage returns True if the image is J %      copyped.  False is returned is there is a memory shortage or if the! %      image fails to be copyped.  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  % F %    o mode: This unsigned value specified whether the image should be %      cropped, copied, or cut.  %  %  */M static unsigned int XCropImage(Display *display,XResourceInfo *resource_info, :   XWindows *windows,Image *image,const ClipboardMode mode) { 
   static char      *CropModeMenu[]=     { 
       "Help",        "Dismiss",       (char *) NULL      },     *RectifyModeMenu[]=      { 
       "Crop", 
       "Help",        "Dismiss",       (char *) NULL      };     static ModeType      CropCommands[]=      {        CropHelpCommand,       CropDismissCommand     },     RectifyCommands[]=     {        RectifyCopyCommand,        RectifyHelpCommand,        RectifyDismissCommand      };     char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;      int      id,      x,     y;     KeySym     key_symbol;      Image      *crop_image;     RectangleInfo      crop_info,     highlight_info;      register RunlengthPacket     *p;      unsigned int     height, 
     width;     unsigned long      scale_factor, 
     state;     XEvent
     event;     /*     Map Command widget.    */   switch (mode)    {      case CopyMode:     { #       windows->command.name="Copy";        break;     }      case CropMode:     { #       windows->command.name="Crop";        break;     }      case CutMode:      { "       windows->command.name="Cut";       break;     }    } +   RectifyModeMenu[0]=windows->command.name;    windows->command.data=0;F   (void) XCommandWidget(display,windows,CropModeMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);!   crop_info.x=windows->image.x+x; !   crop_info.y=windows->image.y+y;    crop_info.width=0;   crop_info.height=0; -   cursor=XCreateFontCursor(display,XC_fleur);    state=DefaultState;    do   {      if (windows->info.mapped)        { 
         /*#           Display pointer position. 
         */@         (void) sprintf(text," %+d%+d ",crop_info.x,crop_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 1     if (event.xany.window == windows->command.id)        { 
         /*3           Select a command from the Command widget. 
         */?         id=XCommandWidget(display,windows,CropModeMenu,&event);          if (id < 0)            continue; !         switch (CropCommands[id]) 	         {            case CropHelpCommand:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           } "           case CropDismissCommand:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }          continue;        }      switch (event.type)      {        case ButtonPress:        { ,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*>           Note first corner of cropping rectangle-- exit loop.
         */8         XDefineCursor(display,windows->image.id,cursor);5         crop_info.x=windows->image.x+event.xbutton.x; 5         crop_info.y=windows->image.y+event.xbutton.y;          state|=ExitState;          break;       }        case ButtonRelease:          break;       case Expose:         break;       case KeyPress:       { 3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          switch (key_symbol) 	         {            case XK_Escape:            case XK_F20:           {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            case XK_F1:            case XK_Help:            {              switch (mode) 
             {                case CopyMode:               { D                 XTextViewWidget(display,resource_info,windows,False,?                   "Help Viewer - Image Copying",ImageCopyHelp);                  break;               }                case CropMode:               { D                 XTextViewWidget(display,resource_info,windows,False,@                   "Help Viewer - Image Cropping",ImageCropHelp);                 break;               }                case CutMode:                { D                 XTextViewWidget(display,resource_info,windows,False,>                   "Help Viewer - Image Cutting",ImageCutHelp);                 break;               } 
             }              break;           }            default:           {              XBell(display,0);              break;           } 	         }          break;       }        case MotionNotify:       { 
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height))) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); '         crop_info.x=windows->image.x+x; '         crop_info.y=windows->image.y+y;          break;       }        default:         break;     } !   } while (!(state & ExitState));    if (state & EscapeState)     {        /*+         User want to exit without cropping.        */E       XWithdrawWindow(display,windows->info.id,windows->info.screen); "       XFreeCursor(display,cursor);       return(True);      } B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {      /*I       Size rectangle as pointer moves until the mouse button is released.      */     x=crop_info.x;     y=crop_info.y;     crop_info.width=0;     crop_info.height=0;      state=DefaultState;      do     {        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;D       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {            /*5             Display info and draw cropping rectangle.            */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id); N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         } 
       else!         if (windows->info.mapped) I           XWithdrawWindow(display,windows->info.id,windows->info.screen);        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event); D       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { 7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y;            break;	         }          case ButtonRelease: 	         {            /*5             User has committed to cropping rectangle.            */7           crop_info.x=windows->image.x+event.xbutton.x; 7           crop_info.y=windows->image.y+event.xbutton.y; 1           XSetCursorState(display,windows,False);            state|=ExitState; ;           if (strcmp(windows->command.name,"Rectify") == 0)              break;*           windows->command.name="Rectify";"           windows->command.data=0;@           (void) XCommandWidget(display,windows,RectifyModeMenu,             (XEvent *) NULL);            break;	         }          case Expose:           break;         case MotionNotify:	         { 7           crop_info.x=windows->image.x+event.xmotion.x; 7           crop_info.y=windows->image.y+event.xmotion.y; 	         }          default:           break;       } L       if (((crop_info.x != x) && (crop_info.y != y)) || (state & ExitState))	         {            /*&             Check boundary conditions.           */           if (crop_info.x < 0)             crop_info.x=0;           else;             if (crop_info.x > windows->image.ximage->width) 7               crop_info.x=windows->image.ximage->width;            if (crop_info.x < x);             crop_info.width=(unsigned int) (x-crop_info.x);            else
             { =               crop_info.width=(unsigned int) (crop_info.x-x);                crop_info.x=x;
             }            if (crop_info.y < 0)             crop_info.y=0;           else<             if (crop_info.y > windows->image.ximage->height)8               crop_info.y=windows->image.ximage->height;           if (crop_info.y < y)<             crop_info.height=(unsigned int) (y-crop_info.y);           else
             { >               crop_info.height=(unsigned int) (crop_info.y-y);               crop_info.y=y;
             } 	         } #     } while (!(state & ExitState));      /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;      do     {        if (windows->info.mapped) 	         {            /*%             Display pointer position.            */N           (void) sprintf(text," %ux%u%+d%+d",crop_info.width,crop_info.height,%             crop_info.x,crop_info.y); ,           XInfoWidget(display,windows,text);	         }        highlight_info=crop_info; 4       highlight_info.x=crop_info.x-windows->image.x;4       highlight_info.y=crop_info.y-windows->image.y;F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {            state|=EscapeState;            state|=ExitState;            break;	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);+       XScreenEvent(display,windows,&event); 3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);D           id=XCommandWidget(display,windows,RectifyModeMenu,&event);J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);           if (id >= 0)(             switch (RectifyCommands[id])
             { &               case RectifyCopyCommand:               { !                 state|=ExitState;                  break;               } &               case RectifyHelpCommand:               { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);                 switch (mode)                  {                     case CopyMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,C                       "Help Viewer - Image Copying",ImageCopyHelp);                      break;                   }                     case CropMode:                   { H                     XTextViewWidget(display,resource_info,windows,False,D                       "Help Viewer - Image Cropping",ImageCropHelp);                     break;                   }                    case CutMode:                    { H                     XTextViewWidget(display,resource_info,windows,False,B                       "Help Viewer - Image Cutting",ImageCutHelp);                     break;                   }                  } P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               } )               case RectifyDismissCommand:                {                  /*#                   Prematurely exit.                  */#                 state|=EscapeState; !                 state|=ExitState;                  break;               }                default:                 break;
             }            continue; 	         } 4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {          case ButtonPress: 	         { .           if (event.xbutton.button != Button1)             break;8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y; M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 6               crop_info.x=crop_info.x+crop_info.width;7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } M           if ((x < (crop_info.x+RoiDelta)) && (x > (crop_info.x-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { 6               crop_info.x=crop_info.x+crop_info.width;.               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && K               (y < (crop_info.y+RoiDelta)) && (y > (crop_info.y-RoiDelta))) 
             { 7               crop_info.y=crop_info.y+crop_info.height; .               state|=UpdateConfigurationState;               break;
             } =           if ((x < (crop_info.x+crop_info.width+RoiDelta)) && =               (x > (crop_info.x+crop_info.width-RoiDelta)) && >               (y < (crop_info.y+crop_info.height+RoiDelta)) &&<               (y > (crop_info.y+crop_info.height-RoiDelta)))
             { .               state|=UpdateConfigurationState;               break;
             } 	         }          case ButtonRelease: 	         { 6           if (event.xbutton.window == windows->pan.id)E             if ((highlight_info.x != crop_info.x-windows->image.x) || C                 (highlight_info.y != crop_info.y-windows->image.y)) <               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&highlight_info);           break;	         }          case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)                { 1                 event.xexpose.x=highlight_info.x; 1                 event.xexpose.y=highlight_info.y; 9                 event.xexpose.width=highlight_info.width; ;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);                } 7           if (event.xexpose.window == windows->info.id) )             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         { 5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command, A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);            switch (key_symbol)            {              case XK_Escape:              case XK_F20:!               state|=EscapeState;              case XK_Return: 
             {                state|=ExitState;                break;
             }              case XK_F1:              case XK_Help: 
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);               switch (mode)                {                  case CopyMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,A                     "Help Viewer - Image Copying",ImageCopyHelp);                    break;                 }                  case CropMode:                 { F                   XTextViewWidget(display,resource_info,windows,False,B                     "Help Viewer - Image Cropping",ImageCropHelp);                   break;                 }                  case CutMode:                  { F                   XTextViewWidget(display,resource_info,windows,False,@                     "Help Viewer - Image Cutting",ImageCutHelp);                   break;                 }                } N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {                XBell(display,0);                break;
             }            }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         {            /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */           x=event.xmotion.x;           y=event.xmotion.y;#           if (windows->info.mapped) 
             { @               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }            else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);            break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         { (           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         } #     } while (!(state & ExitState)); !   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);    if (state & EscapeState)     return(True);    if (mode == CropMode) <     if ((crop_info.width != windows->image.ximage->width) ||<         (crop_info.height != windows->image.ximage->height))       { 
         /*D           Reconfigure Image window as defined by cropping rectangle.
         */;         XSetCropGeometry(display,windows,&crop_info,image); <         windows->image.window_changes.width=crop_info.width;>         windows->image.window_changes.height=crop_info.height;D         (void) XConfigureImage(display,resource_info,windows,image);         return(True);        }    /*0     Copy image before applying image transforms.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows; 4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    crop_info.x+=x; 2   crop_info.x=DownShift(crop_info.x*scale_factor);:   crop_info.width=DownShift(crop_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    crop_info.y+=y; 2   crop_info.y=DownShift(crop_info.y*scale_factor);<   crop_info.height=DownShift(crop_info.height*scale_factor);)   crop_image=CropImage(image,&crop_info); )   XSetCursorState(display,windows,False); #   if (crop_image == (Image *) NULL)      return(False);#   if (copy_image != (Image *) NULL)      DestroyImage(copy_image);    copy_image=crop_image;   if (mode == CopyMode)      { B       (void) XConfigureImage(display,resource_info,windows,image);       return(True);      }    /*     Cut image.   */   image->class=DirectClass;    if (!image->matte)     {        /*         Initialize matte data.       */       p=image->pixels;(       for (x=0; x < image->packets; x++)       {          p->index=Opaque;         p++;       }        image->matte=True;     }    if (UncompressImage(image)) (     for (y=0; y < crop_info.height; y++)     { A       p=image->pixels+(crop_info.y+y)*image->columns+crop_info.x; )       for (x=0; x < crop_info.width; x++)        {          p->index=Transparent;          p++;       }      }    /*     Update image configuration.    */?   XConfigureImageColormap(display,resource_info,windows,image); >   (void) XConfigureImage(display,resource_info,windows,image);   return(True);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayBackgroundImage displays an image in the background of a
 %  window. % 8 %  The format of the XDisplayBackgroundImage routine is: % B %      status=XDisplayBackgroundImage(display,resource_info,image) % + %  A description of each parameter follows:  % C %    o status: Function XDisplayBackgroundImage returns True if the , %      designated window is the root window. % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */= static unsigned int XDisplayBackgroundImage(Display *display, ,   XResourceInfo *resource_info,Image *image) {    char     geometry[MaxTextExtent],     visual_type[MaxTextExtent];      static XPixelInfo      pixel_info;      static XStandardColormap     *map_info;     static XVisualInfo(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo     window_info;     unsigned int     height,      status, 
     width;     Window     root_window;     XGCValues      context_values;      XResourceInfo      resources;     XWindowAttributes      window_attributes;     /*     Determine target window.   */   resources=(*resource_info);    window_info.id=(Window) NULL; ;   root_window=XRootWindow(display,XDefaultScreen(display)); 5   if (Latin1Compare(resources.window_id,"root") == 0)      window_info.id=root_window;    else     { (       if (isdigit(*resources.window_id))7         window_info.id=XWindowByID(display,root_window, J           (Window) strtol((char *) resources.window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id= A           XWindowByName(display,root_window,resources.window_id);      } &   if (window_info.id == (Window) NULL)D     Error("No window with specified id exists",resources.window_id);   /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)'     (void) sprintf(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual)); *   if (visual_info == (XVisualInfo *) NULL)     {        /*#         Allocate standard colormap.        */(       map_info=XAllocStandardColormap();1       if (map_info == (XStandardColormap *) NULL) O         Error("Unable to create standard colormap","Memory allocation failed"); )       map_info->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL; +       pixel_info.gamma_map=(XColor *) NULL;        /*         Initialize visual info.        */'       resources.map_type=(char *) NULL; (       resources.visual_type=visual_type;?       visual_info=XBestVisualInfo(display,map_info,&resources); .       if (visual_info == (XVisualInfo *) NULL)<         Error("Unable to get visual",resources.visual_type);       /*         Initialize window info.        */)       window_info.ximage=(XImage *) NULL; .       window_info.matte_image=(XImage *) NULL;'       window_info.pixmap=(Pixmap) NULL; -       window_info.matte_pixmap=(Pixmap) NULL; &       window_info.shared_memory=False;     }    /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);   /*     Initialize colormap.   */$   resources.colormap=SharedColormap;F   XMakeStandardColormap(display,visual_info,&resources,image,map_info,     &pixel_info);    /*     Graphic context superclass.    */>   context_values.background=pixel_info.background_color.pixel;>   context_values.foreground=pixel_info.foreground_color.pixel;M   pixel_info.annotate_context=XCreateGC(display,window_info.id,GCBackground | "     GCForeground,&context_values);/   if (pixel_info.annotate_context == (GC) NULL) <     Error("Unable to create graphic context",(char *) NULL);   /*'     Initialize Image window attributes.    */O   XGetWindowInfo(display,visual_info,map_info,&pixel_info,(XFontStruct *) NULL,      &resources,&window_info);    /*     Create the X image.    */#   window_info.width=image->columns; !   window_info.height=image->rows; ;   (void) sprintf(geometry,"%ux%u>",window_attributes.width,      window_attributes.height);C   (void) ParseImageGeometry(geometry,&window_info.x,&window_info.y, ,     &window_info.width,&window_info.height);L   status=XMakeImage(display,&resources,&window_info,image,window_info.width,     window_info.height);   if (status == False)4     Error("Unable to create X image",(char *) NULL);   window_info.x=0;   window_info.y=0;   if (resources.debug)     { C       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",image->filename, 1         image->scene,image->columns,image->rows);        if (image->colors != 0) 4         (void) fprintf(stderr,"%uc ",image->colors);2       (void) fprintf(stderr,"%s\n",image->magick);     }    /*I     Adjust image dimensions as specified by backdrop or geometry options.    */   width=window_info.width;   height=window_info.height;   if (resources.backdrop)      {        /*$         Center image on root window.       */3       window_info.x=(window_attributes.width >> 1)- )         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 0   if (resources.image_geometry != (char *) NULL)     { 
       char(         default_geometry[MaxTextExtent];  	       int          flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints(); ,       if (size_hints == (XSizeHints *) NULL)H         Error("Unable to display on window","Memory allocation failed");$       size_hints->flags=(long) NULL;<       (void) sprintf(default_geometry,"%ux%u",width,height);M       flags=XWMGeometry(display,visual_info->screen,resources.image_geometry, L         default_geometry,window_info.border_width,size_hints,&window_info.x,@         &window_info.y,(int *) &width,(int *) &height,&gravity);$       if (flags & (XValue | YValue))	         { (           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);      }    /*     Create the X pixmap.   */   window_info.pixmap= I     XCreatePixmap(display,window_info.id,width,height,window_info.depth); *   if (window_info.pixmap == (Pixmap) NULL)5     Error("Unable to create X pixmap",(char *) NULL);    /*!     Display pixmap on the window.    */C   if ((width > window_info.width) || (height > window_info.height)) K     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,%       0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,      window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);I   if (resources.delay != 0) )     XDelay(display,1000*resources.delay); (   return(window_info.id == root_window); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X D i s p l a y I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Function XDisplayImage displays an image via X11.  A new image is createdI %  and returned if the user interactively transforms the displayed image.  % . %  The format of the XDisplayImage routine is: %2N %      loaded_image=XDisplayImage(display,resource_info,argv,argc,image,state) % + %  A description of each parameter follows:  % F %    o loaded_image:  Function XDisplayImage returns an image when theF %      user chooses 'Open Image' from the command menu or picks a tileE %      from the image directory.  Otherwise a null image is returned.  % E %    o display: Specifies a connection to an X server;  returned froml %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % 7 %    o argv: Specifies the application's argument list.  %i/ %    o argc: Specifies the number of arguments.  % G %    o image: Specifies an address to an address of an Image structure;o %      returned from ReadImage.P %  %N */J static Image *XDisplayImage(Display *display,XResourceInfo *resource_info,:   char **argv,int argc,Image **image,unsigned long *state) {c4 #define MagnifySize  256  /* must be a power of 2 */ #define MagickMenus  10C #define MaxWindows  10 #define MagickTitle  "Commands"i  
   static charr     *CommandMenu[]=t     {v
       "File","
       "Edit",e
       "View",e       "Transform",       "Enhance",       "Effects",       "F/X",       "Image Edit",        "Miscellany", 
       "Help",        (char *) NULLo     },     *FileMenu[]=     {r       "Open...",
       "Next",s       "Former",i       "Select...",       "Save...",       "Print...",a       "Delete...",       "New...",u       "Visual Directory...",
       "Quit",a       (char *) NULLi     },     *EditMenu[]=     {o
       "Undo", 
       "Redo",w       "Cut",
       "Copy",        "Paste",       (char *) NULL      },     *ViewMenu[]=     {g       "Half Size",       "Original Size",       "Double Size",       "Resize...",       "Apply",       "Refresh",       "Restore",       (char *) NULL      },     *TransformMenu[]=      { 
       "Crop",%
       "Chop",%
       "Flop",%
       "Flip",%       "Rotate Right",%       "Rotate Left",       "Rotate...",       "Shear...",i       "Roll...",       "Trim Edges",m       (char *) NULL      },     *EnhanceMenu[]=      {w       "Hue...",y       "Saturation...",       "Brightness...",       "Gamma...",s       "Spiff",
       "Dull",m       "Equalize",c       "Normalize",       "Negate",u       "Grayscale",       "Map...",c       "Quantize...",       (char *) NULLw     },     *EffectsMenu[]=m     {c       "Despeckle",       "Reduce Noise",h       "Add Noise...",o       "Sharpen...",b       "Blur...",       "Threshold...",        "Edge Detect...",        "Emboss...",       "Spread...",       "Solarize...",       "Shade...",e       "Raise...",n       "Segment...",c       (char *) NULLy     },     *FXMenu[]=     {n       "Swirl...",c       "Implode...",        "Oil Painting...",       "Charcoal Drawing...",       (char *) NULL      },     *ImageEditMenu[]=n     {        "Annotate...",       "Draw...",       "Color...",f       "Matte...",e       "Composite...",        "Add Border...",       "Add Frame...",        "Comment...",d       "Launch...",       "Region of Interest...",       (char *) NULL      },     *MiscellanyMenu[]=     {l       "Image Info",b       "Zoom Image",m       "Show Preview...",       "Show Histogram",        "Show Matte",        "Background...",       "Slide Show...",       "Preferences...",e       (char *) NULLE     },     *HelpMenu[]=     {        "Overview",d       "Browse Documentation",r       "About Display",       (char *) NULLf     },     *ShortCutsMenu[]=      { 
       "Next",        "Former",p       "Open...",       "Save...",
       "Undo",n       "Restore",       "Gamma...",c       "Image Info",e
       "Quit",n       (char *) NULLp     },     *ImmutableMenu[]=t     {e       "Image Info",e
       "Quit",p       (char *) NULLi     };  
   static chary     **Menus[MagickMenus]=      {e       FileMenu,o       EditMenu,i       ViewMenu,g       TransformMenu,       EnhanceMenu,       EffectsMenu,
       FXMenu,        ImageEditMenu,       MiscellanyMenu,a       HelpMenu     };     static CommandType     CommandMenus[]=h     {o       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,     },     FileCommands[]=      {a       OpenCommand,       NextCommand,       FormerCommand,       SelectCommand,       SaveCommand,       PrintCommand,l       DeleteCommand,       NewCommand,p       VisualDirectoryCommand,o       QuitCommand      },     EditCommands[]=e     {e       UndoCommand,       RedoCommand,       CutCommand,b       CopyCommand,       PasteCommand     },     ViewCommands[]=e     {-       HalfSizeCommand,       OriginalSizeCommand,       DoubleSizeCommand,       ResizeCommand,       ApplyCommand,u       RefreshCommand,i       RestoreCommand     },     TransformCommands[]=     {l       CropCommand,       ChopCommand,       FlopCommand,       FlipCommand,       RotateRightCommand,p       RotateLeftCommand,       RotateCommand,       ShearCommand,        RollCommand,       TrimCommandu     },     EnhanceCommands[]=     {a       HueCommand,t       SaturationCommand,       BrightnessCommand,       GammaCommand,g       SpiffCommand,e       DullCommand,       EqualizeCommand,       NormalizeCommand,e       NegateCommand,       GrayscaleCommand,r       MapCommand,c       QuantizeCommandg     },     EffectsCommands[]=     {-       DespeckleCommand,e       ReduceNoiseCommand,e       AddNoiseCommand,       SharpenCommand,s       BlurCommand,       ThresholdCommand,        EdgeDetectCommand,       EmbossCommand,       SpreadCommand,       SolarizeCommand,       ShadeCommand,        RaiseCommand,        SegmentCommand     },     FXCommands[]=h     {t       SwirlCommand,c       ImplodeCommand,        OilPaintCommand,       CharcoalDrawingCommand     },     ImageEditCommands[]=     {g       AnnotateCommand,       DrawCommand,       ColorCommand,e       MatteCommand,-       CompositeCommand,        AddBorderCommand,e       AddFrameCommand,       CommentCommand,f       LaunchCommand,       RegionofInterestCommand.     },     MiscellanyCommands[]=a     {i       InfoCommand,       ZoomCommand,       ShowPreviewCommand,        ShowHistogramCommand,e       ShowMatteCommand,r       BackgroundCommand,       SlideShowCommand,        PreferencesCommand     },     HelpCommands[]=      {y       HelpCommand,!       BrowseDocumentationCommand,        VersionCommand     },     ShortCutsCommands[]=     {        NextCommand,       FormerCommand,       OpenCommand,       SaveCommand,       UndoCommand,       RestoreCommand,        GammaCommand,l       InfoCommand,       QuitCommandk     },     ImmutableCommands[]=     {s       InfoCommand,       QuitCommand%     };     static CommandType     *Commands[MagickMenus]=      {        FileCommands,        EditCommands,        ViewCommands,        TransformCommands,       EnhanceCommands,       EffectsCommands,       FXCommands,        ImageEditCommands,       MiscellanyCommands,        HelpCommands     };     char     command[MaxTextExtent],      geometry[MaxTextExtent],#     image_signature[MaxTextExtent], !     resource_name[MaxTextExtent];   
   CommandType      command_type;      Image      *displayed_image,      *loaded_image;     int 
     entry,     id,      status;      KeySym     key_symbol;      MonitorHandler     handler;     register int     i;  
   static char%%     working_directory[MaxTextExtent];s     static Windowd     root_window;     static XClassHintr     *class_hints;      static XFontStruct     *font_info;i     static XPixelInfol     icon_pixel,o     pixel_info;h     static XPointe
     vid_info;e     static XResourceInfo     icon_resources;c     static XStandardColormap     *icon_map,     *map_info;     static XVisualInfo     *icon_visual, (     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo      *magick_windows[MaxWindows];     static XWMHints      *manager_hints;n     static unsigned inte     number_windows;c  
   struct stat      file_info;     time_t
     timer,     time_stamp,i     update_time;     unsigned int     context_mask;o     XEvent
     event;     XGCValues      context_values;o     XWindowChanges     window_changes;   *   if (visual_info != (XVisualInfo *) NULL)$     (void) chdir(working_directory);   else     {A       /*#         Allocate standard colormap.        */       if (resource_info->debug)m	         { %           XSynchronize(display,True);o9           (void) fprintf(stderr,"Version: %s\n",Version);m	         }t(       map_info=XAllocStandardColormap();(       icon_map=XAllocStandardColormap();5       if ((map_info == (XStandardColormap *) NULL) ||u3           (icon_map == (XStandardColormap *) NULL))nO         Error("Unable to create standard colormap","Memory allocation failed");a)       map_info->colormap=(Colormap) NULL;a)       icon_map->colormap=(Colormap) NULL; /       pixel_info.pixels=(unsigned long *) NULL; +       pixel_info.gamma_map=(XColor *) NULL;o,       pixel_info.annotate_context=(GC) NULL;-       pixel_info.highlight_context=(GC) NULL; *       pixel_info.widget_context=(GC) NULL;%       font_info=(XFontStruct *) NULL;p,       icon_pixel.annotate_context=(GC) NULL;/       icon_pixel.pixels=(unsigned long *) NULL;h+       icon_pixel.gamma_map=(XColor *) NULL;t       /*         Allocate visual.       */&       icon_resources=(*resource_info);,       icon_resources.map_type=(char *) NULL;+       icon_resources.visual_type="default";o-       icon_resources.colormap=SharedColormap; B       visual_info=XBestVisualInfo(display,map_info,resource_info);D       icon_visual=XBestVisualInfo(display,icon_map,&icon_resources);2       if ((visual_info == (XVisualInfo *) NULL) ||0           (icon_visual == (XVisualInfo *) NULL))A         Error("Unable to get visual",resource_info->visual_type);        if (resource_info->debug)e	         {--           (void) fprintf(stderr,"Visual:\n");eN           (void) fprintf(stderr,"  visual id: 0x%lx\n",visual_info->visualid);0           (void) fprintf(stderr,"  class: %s\n",2             XVisualClassName(visual_info->class));K           (void) fprintf(stderr,"  depth: %d planes\n",visual_info->depth);oC           (void) fprintf(stderr,"  size of colormap: %d entries\n",m(             visual_info->colormap_size);P           (void) fprintf(stderr,"  red, green, blue masks: 0x%lx 0x%lx 0x%lx\n",:             visual_info->red_mask,visual_info->green_mask,$             visual_info->blue_mask);I           (void) fprintf(stderr,"  significant bits in color: %d bits\n",t'             visual_info->bits_per_rgb);o	         }b       /*         Allocate atoms.u       */4       windows=(XWindows *) malloc(sizeof(XWindows));'       if (windows == (XWindows *) NULL)dG         Error("Unable to create X windows","Memory allocation failed");oF       windows->wm_protocols=XInternAtom(display,"WM_PROTOCOLS",False);N       windows->wm_delete_window=XInternAtom(display,"WM_DELETE_WINDOW",False);H       windows->wm_take_focus=XInternAtom(display,"WM_TAKE_FOCUS",False);F       windows->im_protocols=XInternAtom(display,"IM_PROTOCOLS",False);N       windows->im_update_widget=XInternAtom(display,"IM_UPDATE_WIDGET",False);"       windows->im_update_colormap=8         XInternAtom(display,"IM_UPDATE_COLORMAP",False);#       windows->im_update_signature= 9         XInternAtom(display,"IM_UPDATE_SIGNATURE",False);t       *image_signature='\0';L       windows->im_former_image=XInternAtom(display,"IM_FORMER_IMAGE",False);H       windows->im_next_image=XInternAtom(display,"IM_NEXT_IMAGE",False);N       windows->im_retain_colors=XInternAtom(display,"IM_RETAIN_COLORS",False);<       windows->im_exit=XInternAtom(display,"IM_EXIT",False);F       windows->dnd_protocols=XInternAtom(display,"DndProtocol",False);       if (resource_info->debug)i	         {n0           (void) fprintf(stderr,"Protocols:\n");<           (void) fprintf(stderr,"  Window Manager: 0x%lx\n",#             windows->wm_protocols);p=           (void) fprintf(stderr,"    delete window: 0x%lx\n",i'             windows->wm_delete_window); :           (void) fprintf(stderr,"    take focus: 0x%lx\n",$             windows->wm_take_focus);9           (void) fprintf(stderr,"  ImageMagick: 0x%lx\n",o#             windows->im_protocols); =           (void) fprintf(stderr,"    update widget: 0x%lx\n",y'             windows->im_update_widget);r?           (void) fprintf(stderr,"    update colormap: 0x%lx\n",))             windows->im_update_colormap);p@           (void) fprintf(stderr,"    update signature: 0x%lx\n",*             windows->im_update_signature);<           (void) fprintf(stderr,"    former image: 0x%lx\n",&             windows->im_former_image);:           (void) fprintf(stderr,"    next image: 0x%lx\n",$             windows->im_next_image);=           (void) fprintf(stderr,"    retain colors: 0x%lx\n", '             windows->im_retain_colors); F           (void) fprintf(stderr,"    exit: 0x%lx\n",windows->im_exit);;           (void) fprintf(stderr,"  Drag and Drop: 0x%lx\n", $             windows->dnd_protocols);	         }        /*)         Allocate class and manager hints.        */$       class_hints=XAllocClassHint();$       manager_hints=XAllocWMHints();1       if ((class_hints == (XClassHint *) NULL) ||%/           (manager_hints == (XWMHints *) NULL))t:         Error("Unable to allocate X hints",(char *) NULL);       /*.         Determine group leader if we have one.       */;       root_window=XRootWindow(display,visual_info->screen);r-       windows->group_leader.id=(Window) NULL;n7       if (resource_info->window_group != (char *) NULL)a	         { 4           if (isdigit(*resource_info->window_group))M             windows->group_leader.id=XWindowByID(display,root_window,(Window)tM               strtol((char *) resource_info->window_group,(char **) NULL,0)); 8           if (windows->group_leader.id == (Window) NULL)%             windows->group_leader.id=cM               XWindowByName(display,root_window,resource_info->window_group);A	         }[       /*         Initialize window id's.        */       number_windows=0; 8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image);c8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command); :       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup);m;       magick_windows[number_windows++]=(&windows->magnify);]7       magick_windows[number_windows++]=(&windows->pan);a(       for (i=0; i < number_windows; i++),         magick_windows[i]->id=(Window) NULL;       vid_info.x=0;        vid_info.y=0;e     }    /*!     Initialize Standard Colormap.C   */   loaded_image=(Image *) NULL;   displayed_image=(*image);M   if (resource_info->debug)      {rM       (void) fprintf(stderr,"Image: %s[%u] %ux%u ",displayed_image->filename,,O         displayed_image->scene,displayed_image->columns,displayed_image->rows);r'       if (displayed_image->colors != 0)t>         (void) fprintf(stderr,"%uc ",displayed_image->colors);<       (void) fprintf(stderr,"%s\n",displayed_image->magick);     }lJ   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,&pixel_info);   /*     Initialize font info.i   */(   if (font_info != (XFontStruct *) NULL)!     XFreeFont(display,font_info);e3   font_info=XBestFont(display,resource_info,False);M(   if (font_info == (XFontStruct *) NULL)5     Error("Unable to load font",resource_info->font);o   /*     Initialize graphic context.,   */$   windows->context.id=(Window) NULL;D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->context);o%   class_hints->res_name="superclass"; #   class_hints->res_class="Display";a-   manager_hints->flags=InputHint | StateHint;)   manager_hints->input=False;o.   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);e   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);>   context_values.background=pixel_info.background_color.pixel;%   context_values.font=font_info->fid;n>   context_values.foreground=pixel_info.foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;/   if (pixel_info.annotate_context != (GC) NULL) 1     XFreeGC(display,pixel_info.annotate_context);    pixel_info.annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);/   if (pixel_info.annotate_context == (GC) NULL)f<     Error("Unable to create graphic context",(char *) NULL);9   context_values.background=pixel_info.depth_color.pixel;U-   if (pixel_info.widget_context != (GC) NULL)n/     XFreeGC(display,pixel_info.widget_context);    pixel_info.widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);-   if (pixel_info.widget_context == (GC) NULL)r<     Error("Unable to create graphic context",(char *) NULL);>   context_values.background=pixel_info.foreground_color.pixel;>   context_values.foreground=pixel_info.background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;0   if (pixel_info.highlight_context != (GC) NULL)2     XFreeGC(display,pixel_info.highlight_context);E   pixel_info.highlight_context=XCreateGC(display,windows->context.id, 0     context_mask | GCPlaneMask,&context_values);0   if (pixel_info.highlight_context == (GC) NULL)<     Error("Unable to create graphic context",(char *) NULL);.   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.N   */O   XGetWindowInfo(display,icon_visual,icon_map,&icon_pixel,(XFontStruct *) NULL,o$     &icon_resources,&windows->icon);6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;e   class_hints->res_name="icon";/-   manager_hints->flags=InputHint | StateHint;s   manager_hints->input=False;M+   manager_hints->initial_state=IconicState; F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug)[H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.    *//   if (icon_pixel.annotate_context != (GC) NULL)d1     XFreeGC(display,icon_pixel.annotate_context); >   context_values.background=icon_pixel.background_color.pixel;>   context_values.foreground=icon_pixel.foreground_color.pixel;A   icon_pixel.annotate_context=XCreateGC(display,windows->icon.id,x1     GCBackground | GCForeground,&context_values);t/   if (icon_pixel.annotate_context == (GC) NULL)x<     Error("Unable to create graphic context",(char *) NULL);=   windows->icon.annotate_context=icon_pixel.annotate_context;    /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)W     {i)       free((char *) windows->image.name); .       free((char *) windows->image.icon_name);     }rD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->image);a   windows->image.shape=True;B   windows->image.name=(char *) malloc(MaxTextExtent*sizeof(char));G   windows->image.icon_name=(char *) malloc(MaxTextExtent*sizeof(char));>J   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))F     Error("Unable to create Image window","Memory allocation failed");O   if ((resource_info->title != (char *) NULL) && !(*state & MontageImageState))A     {B       /*#         User specified window name.        */>       (void) strcpy(windows->image.name,resource_info->title);C       (void) strcpy(windows->image.icon_name,resource_info->title);M     }r   else     {e       register char          *p;[         register Image         *q;          unsigned int         count;         /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+Extent(displayed_image->filename)-1;O       while ((p > displayed_image->filename) && (*(p-1) != *BasenameSeparator))          p--;A       (void) sprintf(windows->image.name,"ImageMagick: %s[%u]",p,           displayed_image->scene);       q=displayed_image;+       while (q->previous != (Image *) NULL)          q=q->previous;7       for (count=1; q->next != (Image *) NULL; count++)          q=q->next;G       (void) sprintf(windows->image.name,"ImageMagick: %s[%u of %u]",p, &         displayed_image->scene,count);:       if ((displayed_image->previous == (Image *) NULL) &&6           (displayed_image->next == (Image *) NULL) &&(           (displayed_image->scene == 0))@         (void) sprintf(windows->image.name,"ImageMagick: %s",p);0       (void) strcpy(windows->image.icon_name,p);     }    if (resource_info->immutable)e"     windows->image.immutable=True;6   windows->image.use_pixmap=resource_info->use_pixmap;8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;.   windows->image.height=displayed_image->rows;N   (void) sprintf(geometry,"%ux%u>",XDisplayWidth(display,visual_info->screen),1     XDisplayHeight(display,visual_info->screen)); I   (void) ParseImageGeometry(geometry,&windows->image.x,&windows->image.y,n2     &windows->image.width,&windows->image.height);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask |xG     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |1     StructureNotifyMask | SubstructureNotifyMask; D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))e     {m       /*#         Initialize backdrop window.        */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen); K       windows->backdrop.height=XDisplayHeight(display,visual_info->screen); '       windows->backdrop.border_width=0;n'       windows->backdrop.immutable=True; J       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop";oB       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state=S:         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug)e>         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id);t-       if (windows->image.id != (Window) NULL)b	         { 4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }        /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition;=I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)-u$         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);L     } +   if (resource_info->name == (char *) NULL) 5     class_hints->res_name=resource_info->client_name;    else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state= 6     resource_info->iconic ? IconicState : NormalState;0   if (windows->group_leader.id != (Window) NULL)     {"       /*         Follow the leader.       */,       manager_hints->flags|=WindowGroupHint;;       manager_hints->window_group=windows->group_leader.id; I       XSelectInput(display,windows->group_leader.id,StructureNotifyMask);        if (resource_info->debug) B         (void) fprintf(stderr,"Window id: 0x%lx (group leader)\n",$           windows->group_leader.id);     };   XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image);-0   if (windows->group_leader.id != (Window) NULL)M     XSetTransientForHint(display,windows->image.id,windows->group_leader.id);    if (resource_info->debug).J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*!     Initialize X image structure.l   */   windows->image.x=0;    windows->image.y=0; J   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)4     Error("Unable to create X image",(char *) NULL);H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XClientMessage(display,windows->image.id,windows->im_protocols, .     windows->im_update_signature,CurrentTime);   /*     Initialize Info widget.    */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,"     resource_info,&windows->info);   windows->info.name="Info";!   windows->info.icon_name="Info";t   windows->info.border_width=1;w   windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition; 4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;I   class_hints->res_name="info";A?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;t   manager_hints->input=False;x+   manager_hints->initial_state=NormalState;t0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);@   windows->info.highlight_stipple=XCreateBitmapFromData(display,N     windows->info.id,(char *) HighlightBitmap,HighlightWidth,HighlightHeight);=   windows->info.shadow_stipple=XCreateBitmapFromData(display, E     windows->info.id,(char *) ShadowBitmap,ShadowWidth,ShadowHeight);tC   XSetTransientForHint(display,windows->info.id,windows->image.id);x   if (windows->image.mapped)C     XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (resource_info->debug)lH     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->command);d$   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL);iH   (void) sprintf(resource_name,"%s.command",resource_info->client_name);O   windows->command.geometry=XGetResourceClass(resource_info->resource_database,d,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask |tJ     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;w   manager_hints->input=False;y+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command);mE   windows->command.highlight_stipple=windows->info.highlight_stipple;l?   windows->command.shadow_stipple=windows->info.shadow_stipple;oF   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (windows->command.mapped),     XMapRaised(display,windows->command.id);   if (resource_info->debug)oN     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize Widget window.[   */*   if (windows->widget.id != (Window) NULL)(     free((char *) windows->widget.name);D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,$     resource_info,&windows->widget);G   (void) sprintf(resource_name,"%s.widget",resource_info->client_name); N   windows->widget.geometry=XGetResourceClass(resource_info->resource_database,,     resource_name,"geometry",(char *) NULL);C   windows->widget.name=(char *) malloc(MaxTextExtent*sizeof(char)); #   if (windows->widget.name == NULL) F     Error("Unable to create Image window","Memory allocation failed");   *windows->widget.name='\0'; !   windows->widget.border_width=0;-#   windows->widget.flags|=PPosition;i6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True;iL   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |n<     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;!   class_hints->res_name="widget";o?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;t   manager_hints->input=True;+   manager_hints->initial_state=NormalState;g0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);D   windows->widget.highlight_stipple=windows->info.highlight_stipple;>   windows->widget.shadow_stipple=windows->info.shadow_stipple;E   XSetTransientForHint(display,windows->widget.id,windows->image.id);    if (resource_info->debug)pL     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL):'     free((char *) windows->popup.name);nD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,#     resource_info,&windows->popup); B   windows->popup.name=(char *) malloc(MaxTextExtent*sizeof(char));"   if (windows->popup.name == NULL)F     Error("Unable to create Image window","Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped;w,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask |_G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask |l;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;t    class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState;p0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup); C   windows->popup.highlight_stipple=windows->info.highlight_stipple; =   windows->popup.shadow_stipple=windows->info.shadow_stipple;sD   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug) K     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id);'   /*)     Initialize Magnify window and cursor.|   */+   if (windows->magnify.id != (Window) NULL)M)     free((char *) windows->magnify.name);rD   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,%     resource_info,&windows->magnify); H   (void) sprintf(resource_name,"%s.magnify",resource_info->client_name);O   windows->magnify.geometry=XGetResourceClass(resource_info->resource_database,w,     resource_name,"geometry",(char *) NULL);D   windows->magnify.name=(char *) malloc(MaxTextExtent*sizeof(char));$   if (windows->magnify.name == NULL)H     Error("Unable to create Magnify window","Memory allocation failed");M   (void) sprintf(windows->magnify.name,"Magnify %uX",resource_info->magnify); @   windows->magnify.cursor=XMakeCursor(display,windows->image.id,7     map_info->colormap,resource_info->background_color, %     resource_info->foreground_color);f/   if (windows->magnify.cursor == (Cursor) NULL)t3     Error("Unable to create cursor",(char *) NULL);n%   windows->magnify.width=MagnifySize;e&   windows->magnify.height=MagnifySize;$   windows->magnify.flags|=PPosition;)   windows->magnify.min_width=MagnifySize; *   windows->magnify.min_height=MagnifySize;)   windows->magnify.width_inc=MagnifySize;t*   windows->magnify.height_inc=MagnifySize;/   windows->magnify.data=resource_info->magnify;n=   windows->magnify.attributes.cursor=windows->magnify.cursor;dN   windows->magnify.attributes.event_mask=ButtonPressMask | ButtonReleaseMask |H     ExposureMask | KeyPressMask | KeyReleaseMask | OwnerGrabButtonMask |     StructureNotifyMask;"   class_hints->res_name="magnify";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;-   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->magnify);    if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (magnify)\n",windows->magnify.id);F   XSetTransientForHint(display,windows->magnify.id,windows->image.id);3   handler=SetMonitorHandler((MonitorHandler) NULL);fL   status=XMakeImage(display,resource_info,&windows->magnify,displayed_image,4     windows->magnify.width,windows->magnify.height);$   (void) SetMonitorHandler(handler);   if (status == False)<     Error("Unable to create X magnify image",(char *) NULL);   if (windows->magnify.mapped),     XMapRaised(display,windows->magnify.id);   /*     Initialize panning window.   */D   XGetWindowInfo(display,visual_info,map_info,&pixel_info,font_info,!     resource_info,&windows->pan);a   windows->pan.name="Pan Icon";e)   windows->pan.width=windows->icon.width; +   windows->pan.height=windows->icon.height;aD   (void) sprintf(resource_name,"%s.pan",resource_info->client_name);K   windows->pan.geometry=XGetResourceClass(resource_info->resource_database,s,     resource_name,"geometry",(char *) NULL);-   if (windows->pan.geometry != (char *) NULL)nD     (void) ParseImageGeometry(windows->pan.geometry,&windows->pan.x,@       &windows->pan.y,&windows->pan.width,&windows->pan.height);    windows->pan.flags|=PPosition;   windows->pan.immutable=True;I   windows->pan.attributes.event_mask=ButtonMotionMask | ButtonPressMask | F     ButtonReleaseMask | ExposureMask | KeyPressMask | KeyReleaseMask |     StructureNotifyMask;   class_hints->res_name="pan";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;=   manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->pan);a   if (resource_info->debug)tF     (void) fprintf(stderr,"Window id: 0x%lx (pan)\n",windows->pan.id);B   XSetTransientForHint(display,windows->pan.id,windows->image.id);   if (windows->info.mapped) C     XWithdrawWindow(display,windows->info.id,windows->info.screen);f   if (windows->image.mapped)@     if ((windows->image.width < windows->image.ximage->width) ||@         (windows->image.height < windows->image.ximage->height))*       XMapRaised(display,windows->pan.id);   /*     Respond to events.   */-   (void) SetMonitorHandler(XProgressMonitor);i%   (void) SetWarningHandler(XWarning);i'   if (!resource_info->display_warnings) 2     (void) SetWarningHandler((ErrorHandler) NULL);5   timer=time((time_t *) NULL)+resource_info->delay+1;    update_time=0;   if (resource_info->update)     {i       /*3         Determine when file data was last modified.;       */8       status=stat(displayed_image->filename,&file_info);       if (status == 0)'         update_time=file_info.st_mtime;e     }    *state&=(~FormerImageState);   *state&=(~MontageImageState);y   *state&=(~NextImageState);   do   {y     /*       Handle a window event.     */6     if (windows->image.mapped && resource_info->delay)       {c*         if (timer < time((time_t *) NULL))%           if (!resource_info->update)o/             *state|=NextImageState | ExitState;;           else
             {                /*5                 Determine if image file was modified.                */@               status=stat(displayed_image->filename,&file_info);               if (status == 0)6                 if (update_time != file_info.st_mtime)                   {                      /*&                       Redisplay image.                     */F                     (void) strcpy(resource_info->image_info->filename,1                       displayed_image->filename); F                     loaded_image=ReadImage(resource_info->image_info);7                     if (loaded_image != (Image *) NULL) 9                       *state|=NextImageState | ExitState;                    } A               timer=time((time_t *) NULL)+resource_info->delay+1; 
             } 9         if (XEventsQueued(display,QueuedAfterFlush) == 0)w           {n             /*(               Do not block if delay > 0.             */-             XDelay(display,SuspendTime << 2);o             continue;i           }w       } %     time_stamp=time((time_t *) NULL);      XNextEvent(display,&event);c     if (!windows->image.stasis) C       windows->image.stasis=(time((time_t *) NULL)-time_stamp) > 0;t1     if (event.xany.window == windows->command.id)t       {_
         /*3           Select a command from the Command widget.f
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)            continue; /         (void) strcpy(command,CommandMenu[id]); &         command_type=CommandMenus[id];         if (id < MagickMenus)            {e             /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);I             if (entry < 0)               continue;a4             (void) strcpy(command,Menus[id][entry]);-             command_type=Commands[id][entry];            }f(         if (command_type != NullCommand)D           loaded_image=XMagickCommand(display,resource_info,windows,+             command_type,&displayed_image);;         continue;o       }-     switch (event.type)      {        case ButtonPress:        {a!         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))            {              /*-               Convert Alt-Button3 to Button2.l             */)             event.xbutton.button=Button2;)-             event.xbutton.state&=(~Mod1Mask);n           }e9         if (event.xbutton.window == windows->backdrop.id)t           {mG             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           }y6         if (event.xbutton.window == windows->image.id)           {S)             switch (event.xbutton.button)e
             {s               case Button1:a               {X-                 if (resource_info->immutable)i                   {                      /*?                       Select a command from the Immutable menu.                      */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,                        command); #                     if (entry >= 0) H                       loaded_image=XMagickCommand(display,resource_info,K                         windows,ImmutableCommands[entry],&displayed_image);w                     break;                   }(                 /*+                   Map/unmap Command widget.d                 */,                 if (windows->command.mapped)>                   XWithdrawWindow(display,windows->command.id,-                     windows->command.screen);                  else                   {iF                     (void) XCommandWidget(display,windows,CommandMenu,'                       (XEvent *) NULL);-<                     XMapRaised(display,windows->command.id);                   }i                 break;               };               case Button2:i               {p                 /*8                   User pressed the image magnify button.                 */P                 (void) XMagickCommand(display,resource_info,windows,ZoomCommand,$                   &displayed_image);6                 XMagnifyImage(display,windows,&event);                 break;               }i               case Button3:                {->                 if (displayed_image->montage != (char *) NULL)                   {e                     /*J                       Open or delete a tile from a visual image directory.                     */J                     loaded_image=XTileImage(display,resource_info,windows,.                       displayed_image,&event);7                     if (loaded_image != (Image *) NULL)/M                       *state|=MontageImageState | NextImageState | ExitState;_0                     vid_info.x=windows->image.x;0                     vid_info.y=windows->image.y;                     break;                   }e-                 if (resource_info->immutable)r                   {                      /*?                       Select a command from the Immutable menu.i                     */O                     entry=XMenuWidget(display,windows,"Commands",ImmutableMenu,w                       command);o#                     if (entry >= 0)tH                       loaded_image=XMagickCommand(display,resource_info,K                         windows,ImmutableCommands[entry],&displayed_image);i                     break;                   }a                 /*<                   Select a command from the Short Cuts menu.                 */M                 entry=XMenuWidget(display,windows,"Short Cuts",ShortCutsMenu,%                   command);                  if (entry >= 0) L                   loaded_image=XMagickCommand(display,resource_info,windows,?                     ShortCutsCommands[entry],&displayed_image);                  break;               }                default:                 break;
             }              break;           } 8         if (event.xbutton.window == windows->magnify.id)           {              char%               command[MaxTextExtent];                int                factor;                static char                *MagnifyMenu[]=                {                  "2",                 "4",                 "5",                 "6",                 "7",                 "8",                 "9",                 "3",                 (char *) NULL,               };               static KeySyme                MagnifyCommands[]=               {s                 XK_2,t                 XK_4,o                 XK_5,g                 XK_6,i                 XK_7,p                 XK_8,n                 XK_9,                  XK_3               };               /*;               Select a magnify factor from the pop-up menu.r             */N             factor=XMenuWidget(display,windows,"Magnify",MagnifyMenu,command);             if (factor >= 0)O               XMagnifyWindowCommand(display,windows,0,MagnifyCommands[factor]);n             break;           }e4         if (event.xbutton.window == windows->pan.id)           {o.             XPanImage(display,windows,&event);             break;           }e;         timer=time((time_t *) NULL)+resource_info->delay+1;          break;       }t       case ButtonRelease:T       {]!         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);d         break;       }w       case ClientMessage:        {n!         if (resource_info->debug);I           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n",;<             event.xclient.window,event.xclient.message_type,J             event.xclient.format,(unsigned long) event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           {nC             if (*event.xclient.data.l == windows->im_update_widget)B               {s2                 windows->command.name=MagickTitle;2                 windows->command.data=MagickMenus;B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL);s                 break;               }oE             if (*event.xclient.data.l == windows->im_update_colormap)%               {%                 /*=                   Update graphic context and window colormap.                  */2                 for (i=0; i < number_windows; i++)                 { @                   if (magick_windows[i]->id == windows->icon.id)                     continue; N                   context_values.background=pixel_info.background_color.pixel;N                   context_values.foreground=pixel_info.foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);N                   context_values.background=pixel_info.foreground_color.pixel;N                   context_values.foreground=pixel_info.background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context,s@                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel= 6                     pixel_info.background_color.pixel;=                   magick_windows[i]->attributes.border_pixel=s2                     pixel_info.border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 }M(                 if (windows->pan.mapped)                   {iG                     XSetWindowBackgroundPixmap(display,windows->pan.id,s+                       windows->pan.pixmap); :                     XClearWindow(display,windows->pan.id);7                     XDrawPanRectangle(display,windows);[                   }i:                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);                  break;               }nF             if (*event.xclient.data.l == windows->im_update_signature)               { 0                 SignatureImage(displayed_image);J                 (void) strcpy(image_signature,displayed_image->signature);                 break;               }mB             if (*event.xclient.data.l == windows->im_former_image)               {e5                 *state|=FormerImageState | ExitState;m                 break;               }s@             if (*event.xclient.data.l == windows->im_next_image)               { 3                 *state|=NextImageState | ExitState;/                 break;               }.C             if (*event.xclient.data.l == windows->im_retain_colors).               { *                 *state|=RetainColorsState;                 break;               }f:             if (*event.xclient.data.l == windows->im_exit)               {("                 *state|=ExitState;                 break;               }              break;           }&A         if (event.xclient.message_type == windows->dnd_protocols)            {*             Atom               selection,               type;/               intn               format,,               status;                unsigned charo               *data;               unsigned long                after,               length;                /*A               Display image named by the Drag-and-Drop selection.t             */3             if ((int) (*event.xclient.data.l) != 2)                break;@             selection=XInternAtom(display,"DndSelection",False);M             status=XGetWindowProperty(display,root_window,selection,0L,2047L,mO               False,(Atom) AnyPropertyType,&type,&format,&length,&after,&data);,5             if ((status != Success) || (length == 0))>               break;M             (void) strcpy(resource_info->image_info->filename,(char *) data);e>             loaded_image=ReadImage(resource_info->image_info);/             if (loaded_image != (Image *) NULL) 1               *state|=NextImageState | ExitState; !             XFree((void *) data);              break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;?         if (*event.xclient.data.l != windows->wm_delete_window)            break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {a             *state|=ExitState;             break;           } 4         if (event.xclient.window == windows->pan.id)           {              /*E               Restore original image size when pan window is deleted.n             */M             windows->image.window_changes.width=windows->image.ximage->width;vO             windows->image.window_changes.height=windows->image.ximage->height;BA             (void) XConfigureImage(display,resource_info,windows,                displayed_image);            }          break;       }t       case ConfigureNotify:        {_!         if (resource_info->debug)wK           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width,gJ             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event);(9         if (event.xconfigure.window == windows->image.id)            {2             /*3               Image window has a new configuration.              */1             if (event.xconfigure.send_event != 0)E               {                  XWindowChanges!                   window_changes;X                   /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL)i/                   if (!windows->command.mapped)                      {w)                       windows->command.x= E                         event.xconfigure.x-windows->command.width-25; <                       windows->command.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->command);:                       window_changes.x=windows->command.x;:                       window_changes.y=windows->command.y;G                       XReconfigureWMWindow(display,windows->command.id, K                         windows->command.screen,CWX | CWY,&window_changes);                      }w?                 if (windows->magnify.geometry == (char *) NULL)(/                   if (!windows->magnify.mapped)                      {l)                       windows->magnify.x=dE                         event.xconfigure.x+event.xconfigure.width+25;.<                       windows->magnify.y=event.xconfigure.y;J                       XConstrainWindowPosition(display,&windows->magnify);:                       window_changes.x=windows->magnify.x;:                       window_changes.y=windows->magnify.y;G                       XReconfigureWMWindow(display,windows->magnify.id,=K                         windows->magnify.screen,CWX | CWY,&window_changes);                      }y;                 if (windows->pan.geometry == (char *) NULL)S+                   if (!windows->pan.mapped)                      { %                       windows->pan.x=nE                         event.xconfigure.x+event.xconfigure.width+25;w%                       windows->pan.y=vF                         event.xconfigure.y+windows->magnify.height+50;F                       XConstrainWindowPosition(display,&windows->pan);6                       window_changes.x=windows->pan.x;6                       window_changes.y=windows->pan.y;C                       XReconfigureWMWindow(display,windows->pan.id,WG                         windows->pan.screen,CWX | CWY,&window_changes);                      }.               }rC             if ((event.xconfigure.width == windows->image.width) &&gC                 (event.xconfigure.height == windows->image.height))g               {n*                 if (windows->image.mapped)J                   XRefreshWindow(display,&windows->image,(XEvent *) NULL);                 break;               };8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             windows->image.x=0;n             windows->image.y=0; :             if (displayed_image->montage != (char *) NULL)               {;,                 windows->image.x=vid_info.x;,                 windows->image.y=vid_info.y;               }v?             if (windows->image.mapped && windows->image.stasis)                {                  /*4                   Update Image window configuration.                 */K                 windows->image.window_changes.width=event.xconfigure.width;dM                 windows->image.window_changes.height=event.xconfigure.height;hE                 (void) XConfigureImage(display,resource_info,windows, #                   displayed_image);a               })J             if ((event.xconfigure.width < windows->image.ximage->width) ||J                 (event.xconfigure.height < windows->image.ximage->height))               {n4                 XMapRaised(display,windows->pan.id);3                 XDrawPanRectangle(display,windows);/               }o             else&               if (windows->pan.mapped)M                 XWithdrawWindow(display,windows->pan.id,windows->pan.screen);s             break;           }f;         if (event.xconfigure.window == windows->magnify.id)o           {_             unsigned int               magnify;               /*5               Magnify window has a new configuration.a             */:             windows->magnify.width=event.xconfigure.width;<             windows->magnify.height=event.xconfigure.height;)             if (!windows->magnify.mapped)                break;             magnify=1;5             while (magnify <= event.xconfigure.width))               magnify<<=1;6             while (magnify <= event.xconfigure.height)               magnify<<=1;             magnify>>=1;6             if ((magnify != event.xconfigure.width) ||5                 (magnify != event.xconfigure.height))_               { -                 window_changes.width=magnify;o.                 window_changes.height=magnify;A                 XReconfigureWMWindow(display,windows->magnify.id,rN                   windows->magnify.screen,CWWidth | CWHeight,&window_changes);                 break;               }w=             handler=SetMonitorHandler((MonitorHandler) NULL);iF             status=XMakeImage(display,resource_info,&windows->magnify,N               displayed_image,windows->magnify.width,windows->magnify.height);/             XMakeMagnifyImage(display,windows);*.             (void) SetMonitorHandler(handler);             break;           } 7         if (event.xconfigure.window == windows->pan.id)c           {&             /*6               Pan icon window has a new configuration.             */1             if (event.xconfigure.send_event != 0).               { 2                 windows->pan.x=event.xconfigure.x;2                 windows->pan.y=event.xconfigure.y;               } 6             windows->pan.width=event.xconfigure.width;8             windows->pan.height=event.xconfigure.height;             break;           }h8         if (event.xconfigure.window == windows->icon.id)           {s             /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width; 9             windows->icon.height=event.xconfigure.height;g             break;           }i         break;       }X       case DestroyNotify:u       {w
         /*"           Group leader has exited.
         */!         if (resource_info->debug)%:           (void) fprintf(stderr,"Destroy Notify: 0x%lx\n",)             event.xdestroywindow.window); D         if (event.xdestroywindow.window == windows->group_leader.id)           {              *state|=ExitState;             break;           }          break;       }        case EnterNotify:        { 
         /*'           Selectively install colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) 8             XInductColormap(display,map_info->colormap);         break;       }        case Expose:       {%!         if (resource_info->debug)%>           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y);a
         /*/           Refresh windows that are now exposed.i
         */6         if (event.xexpose.window == windows->image.id)$           if (windows->image.mapped)
             { =               XRefreshWindow(display,&windows->image,&event);dA               timer=time((time_t *) NULL)+resource_info->delay+1;                break;
             }u8         if (event.xexpose.window == windows->magnify.id)'           if (event.xexpose.count == 0) (             if (windows->magnify.mapped)               {I3                 XMakeMagnifyImage(display,windows);i                 break;               }c4         if (event.xexpose.window == windows->pan.id)'           if (event.xexpose.count == 0) 
             {r1               XDrawPanRectangle(display,windows);                break;
             } 5         if (event.xexpose.window == windows->icon.id)o'           if (event.xexpose.count == 0)i
             { <               XRefreshWindow(display,&windows->icon,&event);               break;
             }o         break;       }        case KeyPress:       {          intc           length;e  
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug)iN           (void) fprintf(stderr,"Key press: %d 0x%lx (%s)\n",event.xkey.state,              key_symbol,command);3         if (event.xkey.window == windows->image.id)            {*K             command_type=XImageWindowCommand(display,resource_info,windows,i<               event.xkey.state,key_symbol,&displayed_image);,             if (command_type != NullCommand)H               loaded_image=XMagickCommand(display,resource_info,windows,/                 command_type,&displayed_image);e           }n5         if (event.xkey.window == windows->magnify.id)uM           XMagnifyWindowCommand(display,windows,event.xkey.state,key_symbol);e1         if (event.xkey.window == windows->pan.id)o!           if (key_symbol == XK_q)aI             XWithdrawWindow(display,windows->pan.id,windows->pan.screen);s           elseA             if ((key_symbol == XK_F1) || (key_symbol == XK_Help))eB               XTextViewWidget(display,resource_info,windows,False,<                 "Help Viewer - Image Panning",ImagePanHelp);             elseA               XTranslateImage(display,windows,*image,key_symbol);d;         timer=time((time_t *) NULL)+resource_info->delay+1;n         break;       }S       case KeyRelease:       {)
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);n!         if (resource_info->debug) G           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,              *command);         break;       }t       case LeaveNotify:)       { 
         /*)           Selectively uninstall colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab)a:             XUninductColormap(display,map_info->colormap);         break;       }s       case MapNotify:        {n!         if (resource_info->debug) I           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window);[6         if (event.xmap.window == windows->backdrop.id)           {tD             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime);o*             windows->backdrop.mapped=True;             break;           }e3         if (event.xmap.window == windows->image.id)(           { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap);a*             if (resource_info->delay == 0)>               if (strcmp(displayed_image->magick,"LOGO") == 0)M                 loaded_image=XOpenImage(display,resource_info,windows,False);CH             if ((windows->image.width < windows->image.ximage->width) ||H                 (windows->image.height < windows->image.ximage->height))2               XMapRaised(display,windows->pan.id);'             windows->image.mapped=True;l             break;           }m5         if (event.xmap.window == windows->magnify.id)r           { /             XMakeMagnifyImage(display,windows);n)             windows->magnify.mapped=True;LK             XWithdrawWindow(display,windows->info.id,windows->info.screen);p             break;           } 1         if (event.xmap.window == windows->pan.id)            { I             XMakePanImage(display,resource_info,windows,displayed_image); %             windows->pan.mapped=True;              break;           } 2         if (event.xmap.window == windows->info.id)           { &             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {              /*#               Create an icon image.n             */F             XMakeStandardColormap(display,icon_visual,&icon_resources,4               displayed_image,icon_map,&icon_pixel);E             (void) XMakeImage(display,&icon_resources,&windows->icon, H               displayed_image,windows->icon.width,windows->icon.height);@             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id); K             XWithdrawWindow(display,windows->info.id,windows->info.screen); &             windows->icon.mapped=True;             break;           } 5         if (event.xmap.window == windows->command.id)m           { )             windows->command.mapped=True;"             break;           }(3         if (event.xmap.window == windows->popup.id)            {)'             windows->popup.mapped=True;              break;           } 4         if (event.xmap.window == windows->widget.id)           {y(             windows->widget.mapped=True;             break;           }i         break;       },       case MappingNotify:        { 1         XRefreshKeyboardMapping(&event.xmapping);          break;       }        case NoExpose:         break;       case ReparentNotify:       {d!         if (resource_info->debug) B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }e       case UnmapNotify:a       { !         if (resource_info->debug)eM           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window);t8         if (event.xunmap.window == windows->backdrop.id)           { +             windows->backdrop.mapped=False;              break;           }r5         if (event.xunmap.window == windows->image.id)c           { (             windows->image.mapped=False;             break;           } 7         if (event.xunmap.window == windows->magnify.id)            {n*             windows->magnify.mapped=False;             break;           } 3         if (event.xunmap.window == windows->pan.id)            {a&             windows->pan.mapped=False;             break;           } 4         if (event.xunmap.window == windows->info.id)           { '             windows->info.mapped=False;              break;           } 4         if (event.xunmap.window == windows->icon.id)           {o9             if (map_info->colormap == icon_map->colormap))D               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image); L             XFreeStandardColormap(display,icon_visual,icon_map,&icon_pixel);'             windows->icon.mapped=False;.             break;           }n7         if (event.xunmap.window == windows->command.id)            { *             windows->command.mapped=False;             break;           } 5         if (event.xunmap.window == windows->popup.id)i           {e6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);o(             windows->popup.mapped=False;             break;           }t6         if (event.xunmap.window == windows->widget.id)           { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime);w)             windows->widget.mapped=False;              break;           }          break;       }n       default:       { !         if (resource_info->debug)l?           (void) fprintf(stderr,"Event type: %d\n",event.type);.         break;       }m     }    }     while (!(*state & ExitState));   if (!(*state & ExitState))K     (void) XMagickCommand(display,resource_info,windows,FreeBuffersCommand,s       &displayed_image);   else     {X       /*(         Query user if image has changed.       */&       SignatureImage(displayed_image);B       if (strcmp(displayed_image->signature,image_signature) != 0)	         { F           status=XConfirmWidget(display,windows,"Your image changed.",&             "Do you want to save it");           if (status == 0)!             *state&=(~ExitState);(           else             if (status > 0) N               (void) XMagickCommand(display,resource_info,windows,SaveCommand,"                 &displayed_image);	         }      }    /*$     Withdraw pan and Magnify window.   */   if (windows->info.mapped) C     XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (windows->pan.mapped)A     XWithdrawWindow(display,windows->pan.id,windows->pan.screen);.   if (windows->magnify.mapped)I     XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);x   if (windows->command.mapped)I     XWithdrawWindow(display,windows->command.id,windows->command.screen);    if (!resource_info->backdrop)i!     if (windows->backdrop.mapped)o       { O         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen);i5         XDestroyWindow(display,windows->backdrop.id);i+         windows->backdrop.id=(Window) NULL;yI         XWithdrawWindow(display,windows->image.id,windows->image.screen);a2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       }w(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);?   if ((*state & FormerImageState) || (*state & NextImageState))a     *state&=(~ExitState);    /*     Change to home directory.    */3   (void) getcwd(working_directory,MaxTextExtent-1);o.   (void) chdir(resource_info->home_directory);   *image=displayed_image;s   return(loaded_image);o }= d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %)O %                                                                             %tO %                                                                             %yO %   X D r a w I m a g e                                                       %oO %                                                                             % O %                                                                             % O %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Function XDrawEditImage draws a graphic primitive (point, line, rectangle,: %  etc.) on the image. % / %  The format of the XDrawEditImage routine is:p %tG %    status=XDrawEditImage(display,resource_info,windows,degrees,image)  % + %  A description of each parameter follows:  % H %    o status: Function XDrawEditImage return True if the image is drawnG %      upon.  False is returned is there is a memory shortage or if theX  %      image cannot be drawn on. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %dK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %rF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %0 %  */4 static unsigned int XDrawEditImage(Display *display,?   XResourceInfo *resource_info,XWindows *windows,Image **image)u {+
   static char      *DrawMenu[]=     {        "Primitive",       "Color",       "Stipple",       "Width",
       "Undo",f
       "Help",s       "Dismiss",       (char *) NULL      };     static PrimitiveType     primitive = PointPrimitive;*     static ModeType      DrawCommands[]=      {        DrawPrimitiveCommand,a       DrawColorCommand,        DrawStippleCommand,        DrawWidthCommand,o       DrawUndoCommand,       DrawHelpCommand,       DrawDismissCommand     };     static PixmapD     stipple = (Pixmap) NULL;     static unsigned int      pen_id = 0,      line_width = 1;      char     command[MaxTextExtent],      text[MaxTextExtent];     Cursor     cursor;o     double     degrees;     into
     entry,     id,l     number_coordinates,      x,     y;     RectangleInfo      rectangle_info;o     register int     i;     unsigned int
     distance,      height,o     max_coordinates,     status,n
     width;     unsigned longg
     state;     Window     root_window;     XDrawInfo      draw_info;     XEvent
     event;     XPoint     *coordinate_info;   
   XSegment     line_info;     /*     Allocate polygon info.   */   max_coordinates=2048; D   coordinate_info=(XPoint *) malloc(max_coordinates*sizeof(XPoint));)   if (coordinate_info == (XPoint *) NULL)      { D       Warning("Unable to draw on image","Memory allocation failed");       return(False);     }    /*     Map Command widget.o   */   windows->command.name="Draw";    windows->command.data=4;B   (void) XCommandWidget(display,windows,DrawMenu,(XEvent *) NULL);*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);    /*      Wait for first button press.   */;   root_window=XRootWindow(display,XDefaultScreen(display)); "   draw_info.stencil=OpaqueStencil;   status=True;.   cursor=XCreateFontCursor(display,XC_tcross);
   for ( ; ; )    { 4     XQueryPosition(display,windows->image.id,&x,&y);4     XDefineCursor(display,windows->image.id,cursor);     state=DefaultState;S     do     {)       if (windows->info.mapped) 	         {            /*%             Display pointer position.&           */P           (void) sprintf(text," %+d%+d ",x+windows->image.x,y+windows->image.y);,           XInfoWidget(display,windows,text);	         }        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event);%3       if (event.xany.window == windows->command.id) 	         {            /*5             Select a command from the Command widget.            */=           id=XCommandWidget(display,windows,DrawMenu,&event);            if (id < 0)              continue; #           switch (DrawCommands[id])            { &             case DrawPrimitiveCommand:
             {                static char                  *Primitives[]=                 {                    "point",                   "line",                    "rectangle",#                   "fill rectangle",                    "ellipse",!                   "fill ellipse",%                   "polygon",!                   "fill polygon",u                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */E               primitive=(PrimitiveType) (XMenuWidget(display,windows,u4                 DrawMenu[id],Primitives,command)+1);               break;
             }t"             case DrawColorCommand:
             {e               char,                 *ColorMenu[MaxNumberPens+1];                 int                  pen_number;                  unsigned int                 transparent;                 XColor                 color;                 /*+                 Initialize menu selections.o               */9               for (i=0; i < (int) (MaxNumberPens-2); i++)n:                 ColorMenu[i]=resource_info->pen_colors[i];7               ColorMenu[MaxNumberPens-2]="transparent";I6               ColorMenu[MaxNumberPens-1]="Browser...";5               ColorMenu[MaxNumberPens]=(char *) NULL;                /*8                 Select a pen color from the pop-up menu.               */L               pen_number=XMenuWidget(display,windows,DrawMenu[id],ColorMenu,                 command); !               if (pen_number < 0)]                 break;:               transparent=pen_number == (MaxNumberPens-2);               if (transparent)                 {p7                   draw_info.stencil=TransparentStencil;a                   break;                 } 2               if (pen_number == (MaxNumberPens-1))                 {p                   static char 7                     color_name[MaxTextExtent] = "gray";                      /*5                     Select a pen color from a dialog.                    */C                   resource_info->pen_colors[pen_number]=color_name;nK                   XColorBrowserWidget(display,windows,"Select",color_name); *                   if (*color_name == '\0')                     break;                 }l               /*                 Set pen color.               */K               (void) XParseColor(display,windows->image.map_info->colormap,t>                 resource_info->pen_colors[pen_number],&color);C               XBestPixel(display,windows->image.map_info->colormap, A                 (XColor *) NULL,(unsigned int) MaxColors,&color);sF               windows->image.pixel_info->pen_colors[pen_number]=color;                pen_id=pen_number;.               draw_info.stencil=OpaqueStencil;               break;
             }($             case DrawStippleCommand:
             {e               static charf/                 filename[MaxTextExtent] = "\0",,                  *StipplesMenu[]=                 {r                   "Brick",                   "Diagonal",                    "Scales",                    "Vertical",l                   "Wavy",n                    "Translucent",                   "Opaque",r                    (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               StipplesMenu[7]="Open...";J               entry=XMenuWidget(display,windows,DrawMenu[id],StipplesMenu,                 command);                if (entry < 0)                 break;+               if (stipple != (Pixmap) NULL)v-                 XFreePixmap(display,stipple);i$               stipple=(Pixmap) NULL;               if (entry == 6)i                 break;               if (entry != 7)(                 {s                    switch (entry)                   {                      case 0:t                     {wH                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) BricksBitmap,BricksWidth,BricksHeight);                       break;                     }                      case 1:a                     {/H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) DiagonalBitmap,DiagonalWidth,DiagonalHeight);                       break;                     }l                     case 2:>                     {dH                       stipple=XCreateBitmapFromData(display,root_window,H                         (char *) ScalesBitmap,ScalesWidth,ScalesHeight);                       break;                     }n                     case 3:o                     { H                       stipple=XCreateBitmapFromData(display,root_window,N                         (char *) VerticalBitmap,VerticalWidth,VerticalHeight);                       break;                     }d                     case 4:                      {iH                       stipple=XCreateBitmapFromData(display,root_window,B                         (char *) WavyBitmap,WavyWidth,WavyHeight);                       break;                     }e                     case 5:c                     default:                     {oH                       stipple=XCreateBitmapFromData(display,root_window,@                         (char *) HighlightBitmap,HighlightWidth,)                         HighlightHeight);.                       break;                     }                    }l                   break;                 }iE               XFileBrowserWidget(display,windows,"Stipple",filename);w$               if (*filename == '\0')                 break;I               status=XReadBitmapFile(display,root_window,filename,&width,i(                 &height,&stipple,&x,&y);*               if (status != BitmapSuccess)O                 XNoticeWidget(display,windows,"Unable to read X bitmap image:",C                   filename);               break;
             }T"             case DrawWidthCommand:
             {                static char +                 width[MaxTextExtent] = "3",                  *WidthsMenu[]=                 {                    "1",                   "2",                   "4",                   "8",                   "16",                     (char *) NULL,                    (char *) NULL,                 };                 /*6                 Select a command from the pop-up menu.               */(               WidthsMenu[5]="Dialog...";H               entry=XMenuWidget(display,windows,DrawMenu[id],WidthsMenu,                 command);                if (entry < 0)                 break;               if (entry != 5)                  {m5                   line_width=atoi(WidthsMenu[entry]);c                   break;                 }2L               (void) XDialogWidget(display,windows,"Ok","Enter line width:",                 width); !               if (*width == '\0')m                 break;%               line_width=atoi(width);t               break;
             } !             case DrawUndoCommand:9
             {;N               (void) XMagickCommand(display,resource_info,windows,UndoCommand,                 image);=               break;
             } !             case DrawHelpCommand: 
             {CB               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);>               XDefineCursor(display,windows->image.id,cursor);               break;
             }d$             case DrawDismissCommand:
             {                /*!                 Prematurely exit.e               */!               state|=EscapeState;s               state|=ExitState;                break;
             }s             default:               break;           }s:           XDefineCursor(display,windows->image.id,cursor);           continue;o	         }        switch (event.type)        {          case ButtonPress:m	         { .           if (event.xbutton.button != Button1)             break;8           if (event.xbutton.window != windows->image.id)             break;           /*             Exit loop.           */           x=event.xbutton.x;           y=event.xbutton.y;           state|=ExitState;X           break;	         }          case ButtonRelease:C           break;         case Expose:           break;         case KeyPress:	         {            char#             command[MaxTextExtent];              KeySym             key_symbol;   5           if (event.xkey.window != windows->image.id)              break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,)A             sizeof(command),&key_symbol,(XComposeStatus *) NULL);n           switch (key_symbol)b           {b             case XK_Escape:b             case XK_F20:
             {t               /*!                 Prematurely exit.b               */!               state|=EscapeState;                state|=ExitState;o               break;
             }o             case XK_F1:o             case XK_Help:n
             {sB               XTextViewWidget(display,resource_info,windows,False,>                 "Help Viewer - Image Rotation",ImageDrawHelp);               break;
             }>             default:
             {a               XBell(display,0);l               break;
             }e           }            break;	         }d         case MotionNotify:	         {,           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */           x=event.xmotion.x;           y=event.xmotion.y;#           if (windows->info.mapped)!
             {e@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen); 
             }p           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);p           break;	         }a       }s#     } while (!(state & ExitState)); C     XWithdrawWindow(display,windows->info.id,windows->info.screen);      if (state & EscapeState)       break;     /*C       Draw primitive as pointer moves until the button is released.      */     distance=0;      degrees=0.0;     line_info.x1=x;X     line_info.y1=y;n     line_info.x2=x;a     line_info.y2=y;      rectangle_info.x=x;o     rectangle_info.y=y;      rectangle_info.width=0;      rectangle_info.height=0;     number_coordinates=1;r     coordinate_info->x=x;l     coordinate_info->y=y;dD     XSetFunction(display,windows->image.highlight_context,GXinvert);     state=DefaultState;:     do     {        switch (primitive)       {t         case PointPrimitive:         default:	         {o%           if (number_coordinates > 1)S
             { 3               XDrawLines(display,windows->image.id, A                 windows->image.highlight_context,coordinate_info, 4                 number_coordinates,CoordModeOrigin);,               (void) sprintf(text," %+d%+d",8                 coordinate_info[number_coordinates-1].x,9                 coordinate_info[number_coordinates-1].y); 0               XInfoWidget(display,windows,text);
             }e           break;	         }          case LinePrimitive: 	         {            if (distance > 9))
             {                /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2- E                 line_info.y1),(double) (line_info.x2-line_info.x1))); 3               (void) sprintf(text," %.2f",degrees);.0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,<=                 windows->image.highlight_context,&line_info);d
             }a           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);            break;	         }f          case RectanglePrimitive:$         case FillRectanglePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {                /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);s0               XInfoWidget(display,windows,text);<               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }t           else%             if (windows->info.mapped)uM               XWithdrawWindow(display,windows->info.id,windows->info.screen);=           break;	         }l         case EllipsePrimitive:"         case FillEllipsePrimitive:	         {NH           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))
             {c               /*8                 Display info and draw drawing rectangle.               */F               (void) sprintf(text," %ux%u%+d%+d",rectangle_info.width,I                 rectangle_info.height,rectangle_info.x,rectangle_info.y);h0               XInfoWidget(display,windows,text);:               XHighlightEllipse(display,windows->image.id,B                 windows->image.highlight_context,&rectangle_info);
             }            else%             if (windows->info.mapped))M               XWithdrawWindow(display,windows->info.id,windows->info.screen);m           break;	         }          case PolygonPrimitive:"         case FillPolygonPrimitive:	         {a%           if (number_coordinates > 1),1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info,a2               number_coordinates,CoordModeOrigin);           if (distance > 9) 
             {l               /**                 Display angle of the line.               */E               degrees=RadiansToDegrees(-atan2((double) (line_info.y2-eE                 line_info.y1),(double) (line_info.x2-line_info.x1))); 3               (void) sprintf(text," %.2f",degrees);n0               XInfoWidget(display,windows,text);7               XHighlightLine(display,windows->image.id,g=                 windows->image.highlight_context,&line_info);s
             }s           else%             if (windows->info.mapped) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);)           break;	         }i       }        /*         Wait for next event.       */+       XScreenEvent(display,windows,&event);n       switch (primitive)       {m         case PointPrimitive:         default:	         {=%           if (number_coordinates > 1)g1             XDrawLines(display,windows->image.id, ?               windows->image.highlight_context,coordinate_info,X2               number_coordinates,CoordModeOrigin);           break;	         }f         case LinePrimitive: 	         {a           if (distance > 9)u5             XHighlightLine(display,windows->image.id,a;               windows->image.highlight_context,&line_info);e           break;	         }           case RectanglePrimitive:$         case FillRectanglePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3)):             XHighlightRectangle(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case EllipsePrimitive:"         case FillEllipsePrimitive:	         { H           if ((rectangle_info.width > 3) && (rectangle_info.height > 3))8             XHighlightEllipse(display,windows->image.id,@               windows->image.highlight_context,&rectangle_info);           break;	         }          case PolygonPrimitive:"         case FillPolygonPrimitive:	         { %           if (number_coordinates > 1) 1             XDrawLines(display,windows->image.id,%?               windows->image.highlight_context,coordinate_info,m2               number_coordinates,CoordModeOrigin);           if (distance > 9)o5             XHighlightLine(display,windows->image.id,s;               windows->image.highlight_context,&line_info);a           break;	         }        }l       switch (event.type)t       {r         case ButtonPress:X           break;         case ButtonRelease:e	         {            /*,             User has committed to primitive.           */'           line_info.x2=event.xbutton.x;a'           line_info.y2=event.xbutton.y;u+           rectangle_info.x=event.xbutton.x; +           rectangle_info.y=event.xbutton.y;p@           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;1           if (((primitive != PolygonPrimitive) &&iG                (primitive != FillPolygonPrimitive)) || (distance <= 9))e
             {o               state|=ExitState;s               break;
             }a           number_coordinates++;n3           if (number_coordinates < max_coordinates),
             {p+               line_info.x1=event.xbutton.x;n+               line_info.y1=event.xbutton.y;w               break;
             }i           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL)fJ             Warning("Unable to draw on image","Memory allocation failed");           break;	         }          case Expose:           break;         case MotionNotify:	         {m8           if (event.xmotion.window != windows->image.id)             break;*           if (primitive != PointPrimitive)
             {%+               line_info.x2=event.xmotion.x; +               line_info.y2=event.xmotion.y; /               rectangle_info.x=event.xmotion.x; /               rectangle_info.y=event.xmotion.y;                break;
             } @           coordinate_info[number_coordinates].x=event.xbutton.x;@           coordinate_info[number_coordinates].y=event.xbutton.y;           number_coordinates++; 3           if (number_coordinates < max_coordinates)              break;           max_coordinates<<=1;$           coordinate_info=(XPoint *)D             realloc(coordinate_info,max_coordinates*sizeof(XPoint));1           if (coordinate_info == (XPoint *) NULL)%J             Warning("Unable to draw on image","Memory allocation failed");           break;	         }e         default:           break;       }        /*"         Check boundary conditions.       */       if (line_info.x2 < 0):         line_info.x2=0;u
       else0         if (line_info.x2 > windows->image.width),           line_info.x2=windows->image.width;       if (line_info.y2 < 0)g         line_info.y2=0;d
       else1         if (line_info.y2 > windows->image.height) -           line_info.y2=windows->image.height;z       distance=sF         ((line_info.x2-line_info.x1+1)*(line_info.x2-line_info.x1+1))+F         ((line_info.y2-line_info.y1+1)*(line_info.y2-line_info.y1+1));A       if (((rectangle_info.x != x) && (rectangle_info.y != y)) ||i           (state & ExitState))	         {e#           if (rectangle_info.x < 0)t             rectangle_info.x=0;            else8             if (rectangle_info.x > windows->image.width)4               rectangle_info.x=windows->image.width;#           if (rectangle_info.x < x)eE             rectangle_info.width=(unsigned int) (x-rectangle_info.x);k           else
             { G               rectangle_info.width=(unsigned int) (rectangle_info.x-x);d!               rectangle_info.x=x;f
             }o#           if (rectangle_info.y < 0)i             rectangle_info.y=0;g           else9             if (rectangle_info.y > windows->image.height) 5               rectangle_info.y=windows->image.height;,#           if (rectangle_info.y < y)wF             rectangle_info.height=(unsigned int) (y-rectangle_info.y);           else
             { H               rectangle_info.height=(unsigned int) (rectangle_info.y-y);!               rectangle_info.y=y;y
             }i	         }o#     } while (!(state & ExitState));iB     XSetFunction(display,windows->image.highlight_context,GXcopy);K     if ((primitive == PointPrimitive) || (primitive == PolygonPrimitive) ||*,         (primitive == FillPolygonPrimitive))       {i
         /*)           Determine polygon bounding box.m
         */,         rectangle_info.x=coordinate_info->x;,         rectangle_info.y=coordinate_info->y;         x=coordinate_info->x;n         y=coordinate_info->y;;.         for (i=1; i < number_coordinates; i++)	         {,'           if (coordinate_info[i].x > x)i#             x=coordinate_info[i].x;y'           if (coordinate_info[i].y > y) #             y=coordinate_info[i].y;x6           if (coordinate_info[i].x < rectangle_info.x)9             rectangle_info.x=Max(coordinate_info[i].x,0);P6           if (coordinate_info[i].y < rectangle_info.y)9             rectangle_info.y=Max(coordinate_info[i].y,0); 	         }W0         rectangle_info.width=x-rectangle_info.x;1         rectangle_info.height=y-rectangle_info.y;s.         for (i=0; i < number_coordinates; i++)	         { 1           coordinate_info[i].x-=rectangle_info.x; 1           coordinate_info[i].y-=rectangle_info.y;>	         }t       }      else       if (distance <= 9)         continue;d
       else0         if ((primitive == RectanglePrimitive) ||,             (primitive == EllipsePrimitive))           { #             rectangle_info.width--;s$             rectangle_info.height--;           }p     /*1       Drawing is relative to image configuration.g     */!     draw_info.x=rectangle_info.x;,!     draw_info.y=rectangle_info.y;nP     (void) XMagickCommand(display,resource_info,windows,SaveToUndoBufferCommand,
       image);S     x=0;     y=0;     width=(*image)->columns;     height=(*image)->rows;6     if (windows->image.crop_geometry != (char *) NULL)O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);-4     draw_info.x+=windows->image.x-(line_width >> 1);     if (draw_info.x < 0)       draw_info.x=0;?     draw_info.x=width*draw_info.x/windows->image.ximage->width;;4     draw_info.y+=windows->image.y-(line_width >> 1);     if (draw_info.y < 0)       draw_info.y=0;A     draw_info.y=height*draw_info.y/windows->image.ximage->height; ;     draw_info.width=rectangle_info.width+(line_width << 1); ,     if (draw_info.width > (*image)->columns)(       draw_info.width=(*image)->columns;=     draw_info.height=rectangle_info.height+(line_width << 1); *     if (draw_info.height > (*image)->rows)&       draw_info.height=(*image)->rows;4     (void) sprintf(draw_info.geometry,"%ux%u%+d%+d",9       width*draw_info.width/windows->image.ximage->width,S<       height*draw_info.height/windows->image.ximage->height,#       draw_info.x+x,draw_info.y+y);R     /*$       Initialize drawing attributes.     */     draw_info.degrees=0.0;"     draw_info.primitive=primitive;     draw_info.stipple=stipple;$     draw_info.line_width=line_width;"     draw_info.line_info=line_info;)     if (line_info.x1 > (line_width >> 1))o-       draw_info.line_info.x1=line_width >> 1;o)     if (line_info.y1 > (line_width >> 1))d-       draw_info.line_info.y1=line_width >> 1;wG     draw_info.line_info.x2=line_info.x2-line_info.x1+(line_width >> 1);nG     draw_info.line_info.y2=line_info.y2-line_info.y1+(line_width >> 1);gE     if ((draw_info.line_info.x2 < 0) && (draw_info.line_info.y2 < 0))        { 9         draw_info.line_info.x2=(-draw_info.line_info.x2);%9         draw_info.line_info.y2=(-draw_info.line_info.y2);        } #     if (draw_info.line_info.x2 < 0)        { 9         draw_info.line_info.x2=(-draw_info.line_info.x2); <         Swap(draw_info.line_info.x1,draw_info.line_info.x2);       } #     if (draw_info.line_info.y2 < 0)        { 9         draw_info.line_info.y2=(-draw_info.line_info.y2); <         Swap(draw_info.line_info.y1,draw_info.line_info.y2);       } ,     draw_info.rectangle_info=rectangle_info;7     if (draw_info.rectangle_info.x > (line_width >> 1)) 1       draw_info.rectangle_info.x=line_width >> 1; 7     if (draw_info.rectangle_info.y > (line_width >> 1))%1       draw_info.rectangle_info.y=line_width >> 1;C4     draw_info.number_coordinates=number_coordinates;.     draw_info.coordinate_info=coordinate_info;)     windows->image.pixel_info->pen_color=o4       windows->image.pixel_info->pen_colors[pen_id];     /*       Draw primitive on image.     */*     XSetCursorState(display,windows,True);*     XCheckRefreshWindows(display,windows);K     status=XDrawImage(display,windows->image.pixel_info,&draw_info,*image);e+     XSetCursorState(display,windows,False);d     /*8       Update image colormap and return to image drawing.     */B     XConfigureImageColormap(display,resource_info,windows,*image);A     (void) XConfigureImage(display,resource_info,windows,*image);    }n)   XSetCursorState(display,windows,False); !   free((char *) coordinate_info);    return(status);t }.   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%IO %                                                                             %eO %                                                                             %sO %                                                                             %nO %   X D r a w P a n R e c t a n g l e                                         %HO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%p %mK %  Function XDrawPanRectangle draws a rectangle in the pan window.  The pan J %  window displays a zoomed image and the rectangle shows which portion of. %  the image is displayed in the Image window. % 2 %  The format of the XDrawPanRectangle routine is: % ' %    XDrawPanRectangle(display,windows)i %i+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned fromc %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %  %t */A static void XDrawPanRectangle(Display *display,XWindows *windows)m {C   unsigned longa     scale_factor;e     RectangleInfo      highlight_info;d     /*2     Determine dimensions of the panning rectangle.   */   scale_factor=(unsigned long)?     (UpShift(windows->pan.width)/windows->image.ximage->width);m<   highlight_info.x=DownShift(windows->image.x*scale_factor);D   highlight_info.width=DownShift(windows->image.width*scale_factor);   scale_factor=(unsigned long)A     (UpShift(windows->pan.height)/windows->image.ximage->height);d<   highlight_info.y=DownShift(windows->image.y*scale_factor);F   highlight_info.height=DownShift(windows->image.height*scale_factor);   /*"     Display the panning rectangle.   */(   XClearWindow(display,windows->pan.id);L   XHighlightRectangle(display,windows->pan.id,windows->pan.annotate_context,     &highlight_info);a }S e /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %oO %                                                                             % O %                                                                             % O %   X I m a g e W i n d o w C o m m a n d                                     %eO %                                                                             %iO %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%M %:N %  Function XImageWindowCommand makes a transform to the image or Image window: %  as specified by a user menu button or keyboard command. %C/ %  The format of the XMagickCommand routine is:  % J %    loaded_image=XImageWindowCommand(display,resource_info,windows,state, %      key_symbol,image) %d+ %  A description of each parameter follows:I %eL %    o loaded_image:  Function XImageWindowCommand returns an image when theI %      user chooses 'Open Image' from the command menu.  Otherwise a nullp %      image is returned.a %,D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.C %D< %    o windows: Specifies a pointer to a XWindows structure. %t %    o state: key mask.  % 2 %    o key_symbol: Specifies a command to perform. %iL %    o image: Specifies a pointer to a Image structure;  XImageWIndowCommand> %      may transform the image and return a new image pointer. %y %  */8 static CommandType XImageWindowCommand(Display *display,J   XResourceInfo *resource_info,XWindows *windows,const unsigned int state,"   KeySym key_symbol,Image **image) {r
   static char*     delta[MaxTextExtent] = "",     Digits[]="01234567890";o     static KeySym      last_symbol = XK_0;,  3   if ((key_symbol >= XK_0) && (key_symbol <= XK_9))-     {x<       if (!((last_symbol >= XK_0) && (last_symbol <= XK_9)))	         {            *delta='\0';#           resource_info->quantum=1; 	         }R       last_symbol=key_symbol; "       delta[Extent(delta)+1]='\0';3       delta[Extent(delta)]=Digits[key_symbol-XK_0];o)       resource_info->quantum=atoi(delta);        return(NullCommand);     }u   last_symbol=key_symbol;    if (resource_info->immutable)y     {)       /*<         Immutable image window has a restricted command set.       */       switch(key_symbol)       {          case XK_question:e           return(InfoCommand);         case XK_q:	         { %           if (!(state & ControlMask))              break;           return(QuitCommand);	         }t         default:           break;       }        return(NullCommand);     }    switch (key_symbol)    {      case XK_o:     {o!       if (!(state & ControlMask))          break;       return(OpenCommand);     }T     case XK_space:       return(NextCommand);     case XK_BackSpace:       return(FormerCommand);     case XK_s:     {        if (state & Mod1Mask)          return(SwirlCommand);:!       if (!(state & ControlMask))          return(ShearCommand);e       return(SaveCommand);     }      case XK_p:     case XK_Print:     {p       if (state & Mod1Mask);          return(OilPaintCommand);       if (state & Mod4Mask)          return(ColorCommand);d!       if (!(state & ControlMask))a         return(NullCommand);       return(PrintCommand);C     };     case XK_d:     {;       if (state & Mod4Mask)          return(DrawCommand);!       if (!(state & ControlMask))          return(NullCommand);       return(DeleteCommand);     }      case XK_Select:      {a!       if (!(state & ControlMask))f         return(NullCommand);       return(SelectCommand);     }x     case XK_n:     {u!       if (!(state & ControlMask))n         return(NullCommand);       return(NewCommand);d     }f     case XK_q:     case XK_Cancel:      {<!       if (!(state & ControlMask))t         return(NullCommand);       return(QuitCommand);     }t     case XK_z:     case XK_Undo:(     {,!       if (!(state & ControlMask))e         return(NullCommand);       return(UndoCommand);     }f     case XK_r:     case XK_Redo:      { !       if (!(state & ControlMask)).         return(RollCommand);       return(RedoCommand);     }      case XK_x:     {w!       if (!(state & ControlMask))=         return(NullCommand);       return(CutCommand);a     }      case XK_c:     {        if (state & Mod1Mask))'         return(CharcoalDrawingCommand); !       if (!(state & ControlMask))i         return(CropCommand);       return(CopyCommand);     }-     case XK_v:     case XK_Insert:      {C       if (state & Mod4Mask) !         return(CompositeCommand);i!       if (!(state & ControlMask))_         return(FlipCommand);       return(PasteCommand);e     }n     case XK_less:        return(HalfSizeCommand);     case XK_minus:"       return(OriginalSizeCommand);     case XK_greater:        return(DoubleSizeCommand);     case XK_percent:       return(ResizeCommand);     case XK_at:i       return(RefreshCommand);>     case XK_bracketleft:       return(ChopCommand);     case XK_h:       return(FlopCommand);     case XK_slash:!       return(RotateRightCommand);      case XK_backslash:        return(RotateLeftCommand);     case XK_asterisk:        return(RotateCommand);     case XK_t:       return(TrimCommand);     case XK_H:       return(HueCommand);u     case XK_S:        return(SaturationCommand);     case XK_L:        return(BrightnessCommand);     case XK_G:       return(GammaCommand);g     case XK_C:       return(SpiffCommand);      case XK_Z:       return(DullCommand);     case XK_equal:       return(EqualizeCommand);     case XK_N:       return(NormalizeCommand);o     case XK_asciitilde:d       return(NegateCommand);     case XK_period:r       return(GrayscaleCommand);r     case XK_numbersign:&       return(QuantizeCommand);     case XK_F2:        return(DespeckleCommand);      case XK_F3:t!       return(ReduceNoiseCommand);      case XK_F4:i       return(AddNoiseCommand);     case XK_F5:w       return(SharpenCommand);      case XK_F6:P       return(BlurCommand);     case XK_F7:d       return(ThresholdCommand);      case XK_F8:.        return(EdgeDetectCommand);     case XK_F9:a       return(EmbossCommand);     case XK_F10:       return(SpreadCommand);     case XK_F11:       return(SolarizeCommand);     case XK_F12:       return(ShadeCommand);a     case XK_F13:       return(RaiseCommand);i     case XK_F14:       return(SegmentCommand);u     case XK_i:     {w       if (!(state & Mod1Mask))         return(NullCommand);       return(ImplodeCommand);"     }      case XK_m:     {        if (!(state & Mod4Mask))         return(NullCommand);       return(MatteCommand);i     }m     case XK_b:     {w       if (!(state & Mod4Mask))         return(NullCommand);       return(AddBorderCommand);E     }      case XK_f:     {        if (!(state & Mod4Mask))         return(NullCommand);       return(AddFrameCommand);     }      case XK_exclam:i     {e       if (!(state & Mod4Mask))         return(NullCommand);       return(CommentCommand);i     }=     case XK_a:     {y       if (state & Mod1Mask)          return(ApplyCommand);        if (state & Mod4Mask).          return(AnnotateCommand);!       if (!(state & ControlMask)).         return(NullCommand);&       return(RegionofInterestCommand);     }d     case XK_question:p       return(InfoCommand);     case XK_plus:        return(ZoomCommand);     case XK_P:     {=       if (!(state & ShiftMask))          return(NullCommand);!       return(ShowPreviewCommand);s     }n     case XK_Execute:       return(LaunchCommand);     case XK_F1:        return(HelpCommand);     case XK_Find:i)       return(BrowseDocumentationCommand);r     case XK_Menu:-     {x.       XMapRaised(display,windows->command.id);       return(NullCommand);     }      case XK_Next:)     case XK_Prior:     case XK_Home:d     case XK_KP_Home:     { 9       XTranslateImage(display,windows,*image,key_symbol);n       return(NullCommand);     }      case XK_Up:.     case XK_KP_Up:     case XK_Down:      case XK_KP_Down:     case XK_Left:      case XK_KP_Left:     case XK_Right:     case XK_KP_Right:r     {        if (state & Mod1Mask) 	         {            RectangleInfof             crop_info;             /*.             Trim one pixel from edge of image.           */           crop_info.x=0;           crop_info.y=0;7           crop_info.width=windows->image.ximage->width; 9           crop_info.height=windows->image.ximage->height; @           if ((key_symbol == XK_Up) || (key_symbol == XK_KP_Up))
             {.=               if (resource_info->quantum >= crop_info.height) :                 resource_info->quantum=crop_info.height-1;7               crop_info.height-=resource_info->quantum; 
             }aD           if ((key_symbol == XK_Down) || (key_symbol == XK_KP_Down))
             {iK               if (resource_info->quantum >= (crop_info.height-crop_info.y))EF                 resource_info->quantum=crop_info.height-crop_info.y-1;2               crop_info.y+=resource_info->quantum;7               crop_info.height-=resource_info->quantum; 
             }uD           if ((key_symbol == XK_Left) || (key_symbol == XK_KP_Left))
             {(<               if (resource_info->quantum >= crop_info.width)9                 resource_info->quantum=crop_info.width-1; 6               crop_info.width-=resource_info->quantum;
             }wF           if ((key_symbol == XK_Right) || (key_symbol == XK_KP_Right))
             {hJ               if (resource_info->quantum >= (crop_info.width-crop_info.x))E                 resource_info->quantum=crop_info.width-crop_info.x-1; 2               crop_info.x+=resource_info->quantum;6               crop_info.width-=resource_info->quantum;
             }wH           if ((windows->image.x+windows->image.width) > crop_info.width)B             windows->image.x=crop_info.width-windows->image.width;J           if ((windows->image.y+windows->image.height) > crop_info.height)D             windows->image.y=crop_info.height-windows->image.height;>           XSetCropGeometry(display,windows,&crop_info,*image);>           windows->image.window_changes.width=crop_info.width;@           windows->image.window_changes.height=crop_info.height;E           XSetWindowBackgroundPixmap(display,windows->image.id,None); G           (void) XConfigureImage(display,resource_info,windows,*image);            return(NullCommand);	         }T9       XTranslateImage(display,windows,*image,key_symbol);        return(NullCommand);     }C     default:       return(NullCommand);   }a   return(NullCommand); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%XO %                                                                             %mO %                                                                             % O %                                                                             % O %   X M a g i c k C o m m a n d                                               %lO %                                                                             % O %                                                                             %tO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %rI %  Function XMagickCommand makes a transform to the image or Image window : %  as specified by a user menu button or keyboard command. % / %  The format of the XMagickCommand routine is:  %(M %    loaded_image=XMagickCommand(display,resource_info,windows,command,image)  %<+ %  A description of each parameter follows:- %DG %    o loaded_image:  Function XMagickCommand returns an image when the.I %      user chooses 'Load Image' from the command menu.  Otherwise a null  %      image is returned.i %tD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %(K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.R %e< %    o windows: Specifies a pointer to a XWindows structure. %t/ %    o command: Specifies a command to perform.r %iG %    o image: Specifies a pointer to a Image structure;  XMagickCommand > %      may transform the image and return a new image pointer. %+ %p */K static Image *XMagickCommand(Display *display,XResourceInfo *resource_info,l<   XWindows *windows,const CommandType command,Image **image) {p   char     *argv[10],     geometry[MaxTextExtent],$     modulate_factors[MaxTextExtent];     Image      *cache_image,C     *loaded_image;     ImageInfor     image_info;      int      status,(     x,     y;  
   static charl"     color[MaxTextExtent] = "gray";     static Image!     *redo_image = (Image *) NULL,y!     *undo_image = (Image *) NULL;i     unsigned int     height,(
     width;  (   XCheckRefreshWindows(display,windows);   switch (command)   {d     case FreeBuffersCommand:     {        /*1         Free memory from the undo and redo cache.e       */*       while (undo_image != (Image *) NULL)       {p         cache_image=undo_image;t(         undo_image=undo_image->previous;(         DestroyImage(cache_image->list);"         DestroyImage(cache_image);       }         undo_image=(Image *) NULL;'       if (redo_image != (Image *) NULL)a!         DestroyImage(redo_image);o        redo_image=(Image *) NULL;       return((Image *) NULL);      }      case UndoCommand:i     {        /*+         Undo the last image transformation.        */'       if (undo_image == (Image *) NULL)p	         {i           XBell(display,0); !           return((Image *) NULL); 	         }        cache_image=undo_image;h&       undo_image=undo_image->previous;?       windows->image.window_changes.width=cache_image->columns;d=       windows->image.window_changes.height=cache_image->rows; 8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);9       windows->image.crop_geometry=cache_image->geometry; '       if (redo_image != (Image *) NULL) !         DestroyImage(redo_image);o       redo_image=(*image);       *image=cache_image->list;         DestroyImage(cache_image);        if (windows->image.orphan)         return((Image *) NULL);cD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       return((Image *) NULL);X     }      case CutCommand:     case PasteCommand:     case ApplyCommand:     case HalfSizeCommand:t     case OriginalSizeCommand:      case DoubleSizeCommand:      case ResizeCommand:      case TrimCommand:      case CropCommand:      case ChopCommand:y     case FlipCommand:h     case FlopCommand:      case RotateRightCommand:     case RotateLeftCommand:      case RotateCommand:      case ShearCommand:     case RollCommand:p     case NegateCommand:,     case EqualizeCommand:      case NormalizeCommand:     case HueCommand:     case SaturationCommand:      case BrightnessCommand:      case GammaCommand:     case SpiffCommand:     case DullCommand:i     case GrayscaleCommand:     case MapCommand:     case QuantizeCommand:C     case DespeckleCommand:     case ReduceNoiseCommand:     case AddNoiseCommand:      case SharpenCommand:     case BlurCommand:      case ThresholdCommand:     case EdgeDetectCommand:,     case EmbossCommand:l     case SpreadCommand:,     case SolarizeCommand:      case ShadeCommand:     case RaiseCommand:     case SegmentCommand:     case SwirlCommand:     case ImplodeCommand:     case OilPaintCommand:;      case CharcoalDrawingCommand:     case AnnotateCommand:      case AddBorderCommand:     case AddFrameCommand:      case CompositeCommand:     case CommentCommand:     case LaunchCommand: !     case RegionofInterestCommand:o!     case SaveToUndoBufferCommand:      case RedoCommand:a     {w       Image          *previous_image;         unsigned int         bytes;  G       bytes=(unsigned int) ((*image)->packets*sizeof(RunlengthPacket));d'       if (undo_image != (Image *) NULL)<	         {i           /*>             Ensure the undo cache has enough memory available.           */$           previous_image=undo_image;2           while (previous_image != (Image *) NULL)           { I             bytes+=previous_image->list->packets*sizeof(RunlengthPacket); ;             if (bytes <= (resource_info->undo_cache << 20))t               { 8                 previous_image=previous_image->previous;                 continue;l               }aI             bytes-=previous_image->list->packets*sizeof(RunlengthPacket); -             if (previous_image == undo_image) (               undo_image=(Image *) NULL;             else<               previous_image->next->previous=(Image *) NULL;             break;           } 2           while (previous_image != (Image *) NULL)           {              /*7               Delete any excess memory from undo cache.              */'             cache_image=previous_image;n4             previous_image=previous_image->previous;,             cache_image->file=(FILE *) NULL;,             DestroyImage(cache_image->list);&             DestroyImage(cache_image);           } 	         } 4       if (bytes > (resource_info->undo_cache << 20))         break;       /*6         Save image before transformations are applied.       */4       cache_image=AllocateImage((ImageInfo *) NULL);(       if (cache_image == (Image *) NULL)         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       (*image)->orphan=True;       cache_image->list=@         CopyImage(*image,(*image)->columns,(*image)->rows,True);       (*image)->orphan=False; -       XSetCursorState(display,windows,False);N.       if (cache_image->list == (Image *) NULL)	         {y$           DestroyImage(cache_image);           break;	         }a8       cache_image->columns=windows->image.ximage->width;6       cache_image->rows=windows->image.ximage->height;9       cache_image->geometry=windows->image.crop_geometry;t8       if (windows->image.crop_geometry != (char *) NULL)	         {iL           cache_image->geometry=(char *) malloc(MaxTextExtent*sizeof(char));5           if (cache_image->geometry != (char *) NULL)eN             (void) strcpy(cache_image->geometry,windows->image.crop_geometry);	         }U'       if (undo_image == (Image *) NULL)e	         {*!           undo_image=cache_image;g           break;	         };#       undo_image->next=cache_image; ,       undo_image->next->previous=undo_image;"       undo_image=undo_image->next;       break;     }      default:       break;   }s   if (command == RedoCommand)a     {        /*+         Redo the last image transformation./       */'       if (redo_image == (Image *) NULL)-	         {+           XBell(display,0);x!           return((Image *) NULL); 	         }m>       windows->image.window_changes.width=redo_image->columns;<       windows->image.window_changes.height=redo_image->rows;8       if (windows->image.crop_geometry != (char *) NULL)4         free((char *) windows->image.crop_geometry);8       windows->image.crop_geometry=redo_image->geometry;       DestroyImage(*image);        *image=redo_image;        redo_image=(Image *) NULL;        if (windows->image.orphan)         return((Image *) NULL);sD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        return((Image *) NULL);      }    /*     Process user command.    */%   argv[0]=resource_info->client_name;    loaded_image=(Image *) NULL;C   windows->image.window_changes.width=windows->image.ximage->width; E   windows->image.window_changes.height=windows->image.ximage->height;    switch (command)   {      case OpenCommand:      {        /*         Load image.        */C       loaded_image=XOpenImage(display,resource_info,windows,False);        break;     }      case NextCommand:      {        /*         Display next image.%       */E       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     }g     case FormerCommand:      {e       /*         Display former image.u       */E       XClientMessage(display,windows->image.id,windows->im_protocols, .         windows->im_former_image,CurrentTime);       break;     }F     case SelectCommand:d     {e       /*         Select image.a       */2       (void) chdir(resource_info->home_directory);B       loaded_image=XOpenImage(display,resource_info,windows,True);       break;     }n     case SaveCommand:      {1       /*         Save image.        */=       status=XSaveImage(display,resource_info,windows,image);        if (status == False)	         {sC           XNoticeWidget(display,windows,"Unable to write X image:",               (*image)->filename);           break;	         }x       break;     }p     case PrintCommand:     {X       /*         Print image.       */>       status=XPrintImage(display,resource_info,windows,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to print X image:",               (*image)->filename);           break;	         }V       break;     }a     case DeleteCommand:      {e       static charo'         filename[MaxTextExtent] = "\0";          /*         Delete image file.       */<       XFileBrowserWidget(display,windows,"Delete",filename);       if (*filename == '\0')         break;       status=remove(filename);       if (status != False)O         XNoticeWidget(display,windows,"Unable to delete image file:",filename);c       break;     }      case NewCommand:     {d       static char          *format = "gradation",&         color[MaxTextExtent] = "gray",,         geometry[MaxTextExtent] = "640x480";         /*'         Query user for canvas geometry.(       */I       status=XDialogWidget(display,windows,"New","Enter image geometry:",N         geometry);       if (*geometry == '\0')         break;       if (!status)         format="xc";:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')          break;       /*         Create canvas.       */        GetImageInfo(&image_info);?       (void) sprintf(image_info.filename,"%s:%s",format,color);,       image_info.size=geometry;)*       loaded_image=ReadImage(&image_info);)       free((char *) image_info.filename);oE       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     }       case VisualDirectoryCommand:     {r       /*         Visual Image directory.o       */H       loaded_image=XVisualDirectoryImage(display,resource_info,windows);       break;     }a     case QuitCommand:m     {L       /*         Exit program.g       */'       if (!resource_info->confirm_exit)lG         XClientMessage(display,windows->image.id,windows->im_protocols, (           windows->im_exit,CurrentTime);
       else	         {i           /*!             Confirm program exit.p           */M           status=XConfirmWidget(display,windows,"Do you really want to exit",a(             resource_info->client_name);           if (status > 0)iK             XClientMessage(display,windows->image.id,windows->im_protocols, ,               windows->im_exit,CurrentTime);	         }f       break;     }L     case CutCommand:     {i       /*         Cut image.       */F       (void) XCropImage(display,resource_info,windows,*image,CutMode);       break;     }d     case CopyCommand:D     {i       /*         Copy image.;       */G       (void) XCropImage(display,resource_info,windows,*image,CopyMode);k       break;     }p     case PasteCommand:     {e       /*         Paste image.       */?       status=XPasteImage(display,resource_info,windows,*image);i       if (status == False)	         {tB           XNoticeWidget(display,windows,"Unable to paste X image",              (*image)->filename);           break;	         }n       break;     }d     case HalfSizeCommand:i     {o       /*         Half image size.       */L       windows->image.window_changes.width=windows->image.ximage->width >> 1;N       windows->image.window_changes.height=windows->image.ximage->height >> 1;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case OriginalSizeCommand:-     {s       /*         Original image size.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }e     case DoubleSizeCommand:d     {,       /*         Double the image size.       */L       windows->image.window_changes.width=windows->image.ximage->width << 1;N       windows->image.window_changes.height=windows->image.ximage->height << 1;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }o     case ResizeCommand:      {m       unsigned int         height,r         width;         /*         Resize image.r       */)       width=windows->image.ximage->width; +       height=windows->image.ximage->height;r4       (void) sprintf(geometry,"%ux%u",width,height);4       status=XDialogWidget(display,windows,"Resize",@         "Enter resize geometry (e.g. 640x480, 200%):",geometry);       if (*geometry == '\0')         break;       if (!status)$         (void) strcat(geometry,"!");?       (void) ParseImageGeometry(geometry,&x,&y,&width,&height); 0       windows->image.window_changes.width=width;2       windows->image.window_changes.height=height;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case ApplyCommand:     {x
       char&         image_geometry[MaxTextExtent];  <       if ((windows->image.crop_geometry == (char *) NULL) &&@           ((*image)->columns == windows->image.ximage->width) &&>           ((*image)->rows == windows->image.ximage->height) &&.           (resource_info->number_colors == 0))         break;       /*'         Apply size transforms to image.)       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       /**         Crop and/or scale displayed image.       */J       (void) sprintf(image_geometry,"%dx%d!",windows->image.ximage->width,'         windows->image.ximage->height);(H       TransformImage(image,windows->image.crop_geometry,image_geometry);8       if (windows->image.crop_geometry != (char *) NULL)	         { 6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;P	         }a       windows->image.x=0;h       windows->image.y=0;f,       if (resource_info->number_colors != 0)	         {            /*5             Reduce the number of colors in the image.            */1           if (((*image)->class == DirectClass) ||nB               ((*image)->colors > resource_info->number_colors) ||<               (resource_info->colorspace == GRAYColorspace))
             {i               QuantizeInfo                 quantize_info;  .               GetQuantizeInfo(&quantize_info);G               quantize_info.number_colors=resource_info->number_colors;lA               quantize_info.tree_depth=resource_info->tree_depth;o9               quantize_info.dither=resource_info->dither;lA               quantize_info.colorspace=resource_info->colorspace;;3               QuantizeImage(&quantize_info,*image);%
             }%           SyncImage(*image);	         } D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case RefreshCommand:     { C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case RestoreCommand:     {        /*2         Restore Image window to its original size.       */8       if ((windows->image.width == (*image)->columns) &&6           (windows->image.height == (*image)->rows) &&:           (windows->image.crop_geometry == (char *) NULL))	         {%           XBell(display,0);%           break;	         } <       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {I6           free((char *) windows->image.crop_geometry);5           windows->image.crop_geometry=(char *) NULL;d           windows->image.x=0;l           windows->image.y=0;:	         }XD       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }l     case CropCommand:      {o       /*         Crop image.n       */G       (void) XCropImage(display,resource_info,windows,*image,CropMode);p       break;     }a     case ChopCommand:c     {        /*         Chop image.a       */=       status=XChopImage(display,resource_info,windows,image);g       if (status == False)	         {n@           XNoticeWidget(display,windows,"Unable to cut X image",              (*image)->filename);           break;	         }        break;     }o     case FlopCommand:r     {,       /*         Flop image scanlines.t       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flop";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);e8       if (windows->image.crop_geometry != (char *) NULL)	         {F           /*             Flop crop geometry.            */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height); J           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,<             height,(int) (*image)->columns-(int) width-x,y);	         }"        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case FlipCommand:,     {V       /*         Flip image scanlines.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-flip";;       MogrifyImage(resource_info->image_info,2,argv,image);o-       XSetCursorState(display,windows,False);i8       if (windows->image.crop_geometry != (char *) NULL)	         {,           /*             Flip crop geometry.T           */J           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,             &height);,J           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,:             height,x,(int) (*image)->rows-(int) height-y);	         }s        if (windows->image.orphan)         break;C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }      case RotateRightCommand:     {        /**         Rotate image 90 degrees clockwise.       */D       status=XRotateImage(display,resource_info,windows,90.0,image);       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }        break;     },     case RotateLeftCommand:,     {        /*2         Rotate image 90 degrees counter-clockwise.       */E       status=XRotateImage(display,resource_info,windows,-90.0,image);C       if (status == False)	         { C           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }M       break;     }      case RotateCommand:      {Z       /*         Rotate image..       */C       status=XRotateImage(display,resource_info,windows,0.0,image);        if (status == False)	         {sC           XNoticeWidget(display,windows,"Unable to rotate X image",               (*image)->filename);           break;	         }l       break;     }N     case ShearCommand:     {u       static char .         geometry[MaxTextExtent] = "45.0x45.0";         /*0         Query user for shear color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')t         break;K       (void) XDialogWidget(display,windows,"Shear","Enter shear geometry:",y         geometry);       if (*geometry == '\0')         break;       /*         Shear image.       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";,       argv[2]=color;       argv[3]="-shear";        argv[4]=geometry;o;       MogrifyImage(resource_info->image_info,5,argv,image);m-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);,       break;     }      case RollCommand:      {o       static charC)         geometry[MaxTextExtent] = "+2+2";-         /*)         Query user for the roll geometry.        */I       (void) XDialogWidget(display,windows,"Roll","Enter roll geometry:",a         geometry);       if (*geometry == '\0')         break;       /*         Roll image.h       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-roll";       argv[2]=geometry; ;       MogrifyImage(resource_info->image_info,3,argv,image);o-       XSetCursorState(display,windows,False);d        if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case TrimCommand:      {e       /*         Trim image.n       */>       status=XTrimImage(display,resource_info,windows,*image);       if (status == False)	         {dA           XNoticeWidget(display,windows,"Unable to trim X image",m              (*image)->filename);           break;	         }m       break;     }g     case HueCommand:     {        static char )         hue_percent[MaxTextExtent] = "3";          /**         Query user for percent hue change.       */3       (void) XDialogWidget(display,windows,"Apply", :         "Enter percent change in image hue:",hue_percent);       if (*hue_percent == '\0')          break;       /*         Vary the image hue.r       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);1       (void) strcpy(modulate_factors,"0.0/0.0/"); 2       (void) strcat(modulate_factors,hue_percent);       argv[1]="-modulate";       argv[2]=modulate_factors; ;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }      case SaturationCommand:a     {i       static char 1         saturation_percent[MaxTextExtent] = "10";i         /*1         Query user for percent saturation change.        */3       (void) XDialogWidget(display,windows,"Apply",aH         "Enter percent change in color saturation:",saturation_percent);&       if (*saturation_percent == '\0')         break;       /*         Vary color saturation.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);-       (void) strcpy(modulate_factors,"0.0/"); 9       (void) strcat(modulate_factors,saturation_percent);o       argv[1]="-modulate";       argv[2]=modulate_factors;t;       MogrifyImage(resource_info->image_info,3,argv,image);W-       XSetCursorState(display,windows,False);r        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }      case BrightnessCommand:      {a       static char 0         brightness_percent[MaxTextExtent] = "3";         /*1         Query user for percent brightness change.        */3       (void) XDialogWidget(display,windows,"Apply",rH         "Enter percent change in color brightness:",brightness_percent);&       if (*brightness_percent == '\0')         break;       /*"         Vary the color brightness.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);9       (void) strcpy(modulate_factors,brightness_percent);)       argv[1]="-modulate";       argv[2]=modulate_factors; ;       MogrifyImage(resource_info->image_info,3,argv,image);(-       XSetCursorState(display,windows,False);S        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }a     case GammaCommand:     {        static char(&         factor[MaxTextExtent] = "1.6";         /*#         Query user for gamma value.a       */3       (void) XDialogWidget(display,windows,"Gamma",a8         "Enter gamma value (e.g. 1.0/1.0/1.6):",factor);       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-gamma";G       argv[2]=factor;f;       MogrifyImage(resource_info->image_info,3,argv,image);G-       XSetCursorState(display,windows,False);g        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }v     case SpiffCommand:     {c       /*#         Sharpen the image contrast.i       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-contrast";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);v       break;     }s     case DullCommand:      {        /*          Dull the image contrast.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+contrast";;       MogrifyImage(resource_info->image_info,2,argv,image);"-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);v       break;     }      case EqualizeCommand:      {\       /*4         Perform histogram equalization on the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-equalize";;       MogrifyImage(resource_info->image_info,2,argv,image);l-       XSetCursorState(display,windows,False);=        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);F       break;     }-     case NormalizeCommand:     {I       /*5         Perform histogram normalization on the image.(       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-normalize"; ;       MogrifyImage(resource_info->image_info,2,argv,image);a-       XSetCursorState(display,windows,False);s        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     }(     case NegateCommand:"     {;       /*         Negate colors in image.y       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-negate";;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);:        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }n     case GrayscaleCommand:     {c       /*#         Convert image to grayscale.a       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colorspace";       argv[2]="gray";e;       MogrifyImage(resource_info->image_info,3,argv,image);x-       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }a     case MapCommand:     {f       static charm'         filename[MaxTextExtent] = "\0";e         /**         Request image file name from user.       */9       XFileBrowserWidget(display,windows,"Map",filename);        if (*filename == '\0')         break;       /*         Map image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-map";e       argv[2]=filename; ;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);s        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);v       break;     }      case QuantizeCommand:i     {i       static charr&         colors[MaxTextExtent] = "256";         /*0         Query user for maximum number of colors.       */6       status=XDialogWidget(display,windows,"Quantize",,         "Maximum number of colors:",colors);       if (*colors == '\0')         break;       /*         Color reduce the image.n       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-colors";       argv[2]=colors;B-       argv[3]=status ? "-dither" : "+dither";_;       MogrifyImage(resource_info->image_info,4,argv,image);s-       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }(     case DespeckleCommand:     {o       /*         Despeckle image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-despeckle"; ;       MogrifyImage(resource_info->image_info,2,argv,image); -       XSetCursorState(display,windows,False);a        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }m     case ReduceNoiseCommand:     {g       /*"         Reduce noise in the image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-noise";o;       MogrifyImage(resource_info->image_info,2,argv,image);l-       XSetCursorState(display,windows,False);"        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }      case AddNoiseCommand:/     {(       static charS/         noise_type[MaxTextExtent] = "gaussian";e         /*         Add noise to the image.,       */E       XListBrowserWidget(display,windows,&windows->widget,NoiseTypes,tO         "Add Noise","Select a type of noise to add to your image:",noise_type);-       if (*noise_type == '\0')         break;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="+noise";p       argv[2]=noise_type;r;       MogrifyImage(resource_info->image_info,3,argv,image);e-       XSetCursorState(display,windows,False);e        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);d       break;     }      case SharpenCommand:     {;       static charb'         factor[MaxTextExtent] = "60.0";e         /*&         Query user for sharpen factor.       */5       (void) XDialogWidget(display,windows,"Sharpen",_=         "Enter the sharpening factor (0.0 - 99.9%):",factor);        if (*factor == '\0')         break;       /*          Sharpen image scanlines.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-sharpen";t       argv[2]=factor;x;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);h        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }t     case BlurCommand:n     {,       static charx'         factor[MaxTextExtent] = "60.0";x         /*#         Query user for blur factor.p       */2       (void) XDialogWidget(display,windows,"Blur",;         "Enter the blurring factor (0.0 - 99.9%):",factor);i       if (*factor == '\0')         break;       /*         Blur an image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-blur";       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);x-       XSetCursorState(display,windows,False);_        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);e       break;     }      case ThresholdCommand:     {l       static chare&         factor[MaxTextExtent] = "128";         /*'         Query user for threshold value.u       */7       (void) XDialogWidget(display,windows,"Threshold",s)         "Enter threshold value:",factor);c       if (*factor == '\0')         break;       /*         Gamma correct image.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-threshold";t       argv[2]=factor;p;       MogrifyImage(resource_info->image_info,3,argv,image);M-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }f     case EdgeDetectCommand:      {        static char('         factor[MaxTextExtent] = "50.0";          /*#         Query user for edge factor.o       */:       (void) XDialogWidget(display,windows,"Detect Edges",>         "Enter the edge detect factor (0.0 - 99.9%):",factor);       if (*factor == '\0')         break;       /*         Detect edge in image.t       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-edge";       argv[2]=factor; ;       MogrifyImage(resource_info->image_info,3,argv,image);a-       XSetCursorState(display,windows,False);h        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);)       break;     }s     case EmbossCommand:a     {=       /*         Emboss image scanlines.;       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-emboss";;       MogrifyImage(resource_info->image_info,2,argv,image);d-       XSetCursorState(display,windows,False);c        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }s     case SpreadCommand:_     {s       static charM$         amount[MaxTextExtent] = "2";         /*%         Query user for spread amount.        */4       (void) XDialogWidget(display,windows,"Spread",1         "Enter the displacement amount:",amount);        if (*amount == '\0')         break;       /*1         Displace image pixels by a random amount.m       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-spread";       argv[2]=amount;_;       MogrifyImage(resource_info->image_info,3,argv,image);v-       XSetCursorState(display,windows,False);;        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);t       break;     }y     case SolarizeCommand:e     {L       static chars&         factor[MaxTextExtent] = "128";         /*'         Query user for solarize factor.v       */6       (void) XDialogWidget(display,windows,"Solarize",9         "Enter the solarize factor (0 - 99.9%):",factor);r       if (*factor == '\0')         break;       /*         Solarize image pixels.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-solarize";       argv[2]=factor;h;       MogrifyImage(resource_info->image_info,3,argv,image);u-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);-       break;     }n     case ShadeCommand:     {n       static charu*         geometry[MaxTextExtent] = "30x30";         /**         Query user for the shade geometry.       */3       status=XDialogWidget(display,windows,"Shade",cI         "Enter the azimuth and elevation of the light source:",geometry);,       if (*geometry == '\0')         break;       /*         Shade image pixels.|       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);+       argv[1]=status ? "-shade" : "+shade";i       argv[2]=geometry; ;       MogrifyImage(resource_info->image_info,3,argv,image);w-       XSetCursorState(display,windows,False);i        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }.     case RaiseCommand:     {-       static chars*         bevel_width[MaxTextExtent] = "10";         /*#         Query user for bevel width..       */O       (void) XDialogWidget(display,windows,"Raise","Bevel width:",bevel_width);        if (*bevel_width == '\0')r         break;       /*         Raise an image.c       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-raise";        argv[2]=bevel_width;;       MogrifyImage(resource_info->image_info,3,argv,image);o-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);a       break;     }C     case SegmentCommand:     {r       static char()         threshold[MaxTextExtent] = "1.5";          /*+         Query user for smoothing threshold.;       */L       (void) XDialogWidget(display,windows,"Segment","Smoothing threshold:",         threshold);b       if (*threshold == '\0')w         break;       /*         Segment an image.(       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-segment";d       argv[2]=threshold;;       MogrifyImage(resource_info->image_info,3,argv,image);f-       XSetCursorState(display,windows,False);l        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }n     case SwirlCommand:     {u       static char-&         degrees[MaxTextExtent] = "60";         /*#         Query user for swirl angle.g       */L       (void) XDialogWidget(display,windows,"Swirl","Enter the swirl angle:",         degrees);t       if (*degrees == '\0')          break;       /*,         Swirl image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-swirl";,       argv[2]=degrees;;       MogrifyImage(resource_info->image_info,3,argv,image); -       XSetCursorState(display,windows,False);f        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);s       break;     }d     case ImplodeCommand:     {f       static charb'         factor[MaxTextExtent] = "30.0";d         /*&         Query user for implode factor.       */5       (void) XDialogWidget(display,windows,"Implode",dH         "Enter the implosion/explosion factor (-99.9 - 99.9%):",factor);       if (*factor == '\0')         break;       /*.         Implode image pixels about the center.       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-implode";M       argv[2]=factor;s;       MogrifyImage(resource_info->image_info,3,argv,image);w-       XSetCursorState(display,windows,False);C        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     },     case OilPaintCommand:f     {o       static charw$         radius[MaxTextExtent] = "3";         /*4         Query user for circular neighborhood radius.       */7       (void) XDialogWidget(display,windows,"Oil Paint", )         "Enter the mask radius:",radius);p       if (*radius == '\0')         break;       /*!         OilPaint image scanlines.r       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-paint";e       argv[2]=radius; ;       MogrifyImage(resource_info->image_info,3,argv,image);--       XSetCursorState(display,windows,False);(        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);h       break;     }h      case CharcoalDrawingCommand:     {w       static charm%         factor[MaxTextExtent] = "50";.         /*#         Query user for bevel width.)       */>       (void) XDialogWidget(display,windows,"Charcoal Drawing",9         "Enter the charcoal factor (0 - 99.9%):",factor);i       if (*factor == '\0')         break;       /*         Raise an image.)       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-charcoal";       argv[2]=factor;a;       MogrifyImage(resource_info->image_info,3,argv,image);,-       XSetCursorState(display,windows,False);f        if (windows->image.orphan)         break;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);i       break;     }a     case AnnotateCommand:a     {e       /*%         Annotate the image with text.        */F       status=XAnnotateEditImage(display,resource_info,windows,*image);       if (status == False)	         { E           XNoticeWidget(display,windows,"Unable to annotate X image",t              (*image)->filename);           break;	         }f       break;     }e     case DrawCommand:w     {a       /*         Draw image.a       */A       status=XDrawEditImage(display,resource_info,windows,image);-       if (status == False)	         {wH           XNoticeWidget(display,windows,"Unable to draw on the X image",              (*image)->filename);           break;	         }e       break;     }d     case ColorCommand:     {h       /*         Color edit.F       */B       status=XColorEditImage(display,resource_info,windows,image);       if (status == False)	         {sG           XNoticeWidget(display,windows,"Unable to pixel edit X image",W              (*image)->filename);           break;	         }n       break;     }w     case MatteCommand:     {.       /*         Matte edit.(       */B       status=XMatteEditImage(display,resource_info,windows,image);       if (status == False)	         {fG           XNoticeWidget(display,windows,"Unable to matte edit X image",_              (*image)->filename);           break;	         }a       break;     }o     case CompositeCommand:     {g       /*         Composite image.       */C       status=XCompositeImage(display,resource_info,windows,*image);e       if (status == False)	         {cF           XNoticeWidget(display,windows,"Unable to composite X image",              (*image)->filename);           break;	         }.       break;     }      case AddBorderCommand:     {s       static char (         geometry[MaxTextExtent] = "6x6";         /*1         Query user for border color and geometry.B       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')e         break;8       (void) XDialogWidget(display,windows,"Add Border",+         "Enter border geometry:",geometry);        if (*geometry == '\0')         break;       /*"         Add a border to the image.       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-bordercolor";i       argv[2]=color;       argv[3]="-border";       argv[4]=geometry;w;       MogrifyImage(resource_info->image_info,5,argv,image);t-       XSetCursorState(display,windows,False);         if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);        break;     }s     case AddFrameCommand:p     {c       static charx(         geometry[MaxTextExtent] = "6x6";         /*0         Query user for frame color and geometry.       */:       XColorBrowserWidget(display,windows,"Select",color);       if (*color == '\0')d         break;O       (void) XDialogWidget(display,windows,"Add Frame","Enter frame geometry:",p         geometry);       if (*geometry == '\0')         break;       /*1         Surround image with an ornamental border.s       */N       (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);       argv[1]="-mattecolor";       argv[2]=color;       argv[3]="-frame";_       argv[4]=geometry;a;       MogrifyImage(resource_info->image_info,5,argv,image); -       XSetCursorState(display,windows,False);_        if (windows->image.orphan)         break;<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;D       XConfigureImageColormap(display,resource_info,windows,*image);C       (void) XConfigureImage(display,resource_info,windows,*image);o       break;     }n     case CommentCommand:     { 
       char         command[MaxTextExtent],           filename[MaxTextExtent];  
       FILE         *file;         /*         Edit image comment.o       */"       TemporaryFilename(filename);.       if ((*image)->comments != (char *) NULL)	         {r           register charg             *p;f  /           file=fopen(filename,WriteBinaryType);e$           if (file == (FILE *) NULL)
             {eK               XNoticeWidget(display,windows,"Unable to edit image comment",o                 filename);               break;
             }L5           for (p=(*image)->comments; *p != '\0'; p++) '             (void) putc((int) *p,file);n!           (void) putc('\n',file);s           (void) fclose(file);	         }c5       (void) sprintf(command,EditorCommand,filename);n9       if (resource_info->editor_command != (char *) NULL)eG         (void) sprintf(command,resource_info->editor_command,filename);L,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status)mN         XNoticeWidget(display,windows,"Unable to edit image comment",command);
       else	         {n1           (void) sprintf(command,"@%s",filename);t'           CommentImage(*image,command);z	         }w       (void) remove(filename);-       XSetCursorState(display,windows,False);w       break;     }r     case LaunchCommand:t     {.
       char         command[MaxTextExtent],k          filename[MaxTextExtent],'         retain_filename[MaxTextExtent];|         /*         Launch program.i       */"       TemporaryFilename(filename);E       (void) sprintf(command,resource_info->launch_command,filename);uO       (void) XDialogWidget(display,windows,"Launch","Launch command:",command);i       if (*command == '\0')o         break;7       (void) sprintf(command,LauncherCommand,filename);>,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);8       (void) strcpy(retain_filename,(*image)->filename);G       (void) sprintf((*image)->filename,"%s:%s",LaunchFormat,filename);M        GetImageInfo(&image_info);,       status=WriteImage(&image_info,*image);       if (status),	         {w(           status=SystemCommand(command);           if (status)nJ             XNoticeWidget(display,windows,"Unable to launch image editor",               command);            else
             { 2               loaded_image=ReadImage(&image_info);M               XClientMessage(display,windows->image.id,windows->im_protocols,i4                 windows->im_next_image,CurrentTime);
             }d	         }m       (void) remove(filename);<       (void) strcpy(loaded_image->filename,retain_filename);-       XSetCursorState(display,windows,False);p       break;     }i!     case RegionofInterestCommand:=     {o       /*D         Apply an image processing technique to a region of interest.       */<       (void) XROIImage(display,resource_info,windows,image);       break;     }d     case InfoCommand:o     {.       /*         Display image info..       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);I       XDisplayImageInfo(display,resource_info,windows,undo_image,*image);u-       XSetCursorState(display,windows,False);        break;     }      case ZoomCommand:      {i       /*         Zoom image._       */"       if (windows->magnify.mapped)2         XRaiseWindow(display,windows->magnify.id);
       else	         {a           /*             Make magnify image.-           */0           XSetCursorState(display,windows,True);K           status=XMakeImage(display,resource_info,&windows->magnify,*image,v<             windows->magnify.width,windows->magnify.height);           if (status == False)B             Error("Unable to create magnify image",(char *) NULL);2           XMapRaised(display,windows->magnify.id);1           XSetCursorState(display,windows,False); 	         }o       break;     }d     case ShowPreviewCommand:     {        static charg.         preview_type[MaxTextExtent] = "Gamma";  
       char         command[MaxTextExtent],p          filename[MaxTextExtent],#         server_name[MaxTextExtent];          register int
         i;         /*&         Select preview type from menu.       */G       XListBrowserWidget(display,windows,&windows->widget,PreviewTypes,eI         "Preview","Select an enhancement, effect, or F/X:",preview_type);         if (*preview_type == '\0')         break;        GetImageInfo(&image_info);6       for (i=0; PreviewTypes[i] != (char *) NULL; i++)6         if (strcmp(PreviewTypes[i],preview_type) == 0)           break;.       image_info.preview_type=(PreviewType) i;+       if (PreviewTypes[i] == (char *) NULL) 	         { O           XNoticeWidget(display,windows,"unknown image operator",preview_type);n           break;	         }        /*         Show image preview.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       TemporaryFilename(filename);       *server_name='\0';6       if (resource_info->server_name != (char *) NULL)M         (void) sprintf(server_name,"-display %s",resource_info->server_name);s:       (void) sprintf(command,ShowImageCommand,server_name,A         windows->image.id,"Preview",(*image)->filename,filename); ?       (void) sprintf((*image)->filename,"preview:%s",filename); ,       status=WriteImage(&image_info,*image);C       (void) sprintf((*image)->filename,(*image)->magick_filename); ,       XCheckRefreshWindows(display,windows);       if (status) '         status=!SystemCommand(command);*       if (!status)	         { P           XNoticeWidget(display,windows,"Unable to show image preview",command);"           (void) remove(filename);	         }        XDelay(display,1500);e-       XSetCursorState(display,windows,False);        break;     }      case ShowHistogramCommand:     { 
       char         command[MaxTextExtent],l          filename[MaxTextExtent],#         server_name[MaxTextExtent];          /*         Show image histogram.        */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       TemporaryFilename(filename);       *server_name='\0';6       if (resource_info->server_name != (char *) NULL)M         (void) sprintf(server_name,"-display %s",resource_info->server_name);(:       (void) sprintf(command,ShowImageCommand,server_name,C         windows->image.id,"Histogram",(*image)->filename,filename); A       (void) sprintf((*image)->filename,"histogram:%s",filename);n        GetImageInfo(&image_info);,       status=WriteImage(&image_info,*image);C       (void) sprintf((*image)->filename,(*image)->magick_filename);,,       XCheckRefreshWindows(display,windows);       if (status) '         status=!SystemCommand(command);        if (!status)	         {nI           XNoticeWidget(display,windows,"Unable to show image histogram",              command);m"           (void) remove(filename);	         }e       XDelay(display,1500);r-       XSetCursorState(display,windows,False);p       break;     }      case ShowMatteCommand:     {(
       char         command[MaxTextExtent],           filename[MaxTextExtent],#         server_name[MaxTextExtent];f         if (!(*image)->matte) 	         { (           XNoticeWidget(display,windows,L             "Image does not have any matte information",(*image)->filename);           break;	         }        /*         Show image matte.&       */,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);"       TemporaryFilename(filename);       *server_name='\0';6       if (resource_info->server_name != (char *) NULL)M         (void) sprintf(server_name,"-display %s",resource_info->server_name); :       (void) sprintf(command,ShowImageCommand,server_name,?         windows->image.id,"Matte",(*image)->filename,filename); =       (void) sprintf((*image)->filename,"matte:%s",filename);         GetImageInfo(&image_info);,       status=WriteImage(&image_info,*image);C       (void) sprintf((*image)->filename,(*image)->magick_filename);i,       XCheckRefreshWindows(display,windows);       if (status) '         status=!SystemCommand(command);        if (!status)	         { E           XNoticeWidget(display,windows,"Unable to show image matte",m             command); "           (void) remove(filename);	         }        XDelay(display,1500); -       XSetCursorState(display,windows,False);p       break;     }      case BackgroundCommand:,     {l       /*         Background image.        */C       status=XBackgroundImage(display,resource_info,windows,image);        if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);-       (*image)->orphan=False; )       if (loaded_image != (Image *) NULL) G         XClientMessage(display,windows->image.id,windows->im_protocols,i.           windows->im_next_image,CurrentTime);       break;     }      case SlideShowCommand:     {l       static char.#         delay[MaxTextExtent] = "5";          /*)         Display next image after pausing.o       */       resource_info->delay=0;*8       (void) XDialogWidget(display,windows,"Slide Show",8         "Pause how many seconds between images:",delay);       if (*delay == '\0')d         break;'       resource_info->delay=atoi(delay); E       XClientMessage(display,windows->image.id,windows->im_protocols,r,         windows->im_next_image,CurrentTime);       break;     }      case PreferencesCommand:     {g       /*         Set user preferences.        */?       status=XPreferencesWidget(display,resource_info,windows);l       if (status == False)         break;       (*image)->orphan=True;K       loaded_image=CopyImage(*image,(*image)->columns,(*image)->rows,True);        (*image)->orphan=False; )       if (loaded_image != (Image *) NULL)eG         XClientMessage(display,windows->image.id,windows->im_protocols,a.           windows->im_next_image,CurrentTime);       break;     }      case HelpCommand:n     {n       /*         User requested help.       */:       XTextViewWidget(display,resource_info,windows,False,1         "Help Viewer - Display",ImageMagickHelp);        break;     }e$     case BrowseDocumentationCommand:     { 
       Atom         mozilla_atom;   
       char         command[MaxTextExtent];"         Window         mozilla_window,o         root_window;         /*-         Browse the ImageMagick documentation.e       */?       root_window=XRootWindow(display,XDefaultScreen(display));uA       mozilla_atom=XInternAtom(display,"_MOZILLA_VERSION",False);;I       mozilla_window=XWindowByProperty(display,root_window,mozilla_atom);a*       if (mozilla_window != (Window) NULL)	         {            /*@             Display documentation using Netscape remote control.           */B           (void) sprintf(command,"openURL(%s,new-window,noraise)",             DocumentationURL);E           mozilla_atom=XInternAtom(display,"_MOZILLA_COMMAND",False);pJ           XChangeProperty(display,mozilla_window,mozilla_atom,XA_STRING,8,G             PropModeReplace,(unsigned char *) command,Extent(command)); 1           XSetCursorState(display,windows,False);m           break;	         } M       (void) sprintf(command,resource_info->browse_command,DocumentationURL); ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);$       status=SystemCommand(command);       if (status) P         XNoticeWidget(display,windows,"Unable to browse documentation",command);       XDelay(display,1500); -       XSetCursorState(display,windows,False);        break;     }      case VersionCommand:     { ,       XNoticeWidget(display,windows,Version,?         "Copyright 1997 E. I. du Pont de Nemours and Company");        break;     } !     case SaveToUndoBufferCommand:        break;     default:     {        XBell(display,0);        break;     }    }    return(loaded_image);a }g y /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%yO %                                                                             % O %                                                                             % O %                                                                             % O %   X M a g n i f y I m a g e                                                 % O %                                                                             %rO %                                                                             %dO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%v %.F %  Function XMagnifyImage magnifies portions of the image as indicatedL %  by the pointer.  The magnified portion is displayed in a separate window. % . %  The format of the XMagnifyImage routine is: %n) %    XMagnifyImage(display,windows,event), % + %  A description of each parameter follows:) %eE %    o display: Specifies a connection to an X server;  returned fromw %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %_H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.d %= %i */K static void XMagnifyImage(Display *display,XWindows *windows,XEvent *event)  {    char     text[MaxTextExtent];     register int     x,     y;     unsigned long(
     state;     /*>     Update magnified image until the mouse button is released.   */C   XDefineCursor(display,windows->image.id,windows->magnify.cursor);    state=DefaultState;    x=event->xbutton.x;    y=event->xbutton.y; (   windows->magnify.x=windows->image.x+x;(   windows->magnify.y=windows->image.y+y;   do   {      /*F       Map and unmap Info widget as text cursor crosses its boundaries.     */     if (windows->info.mapped)o       {u:         if ((x < (windows->info.x+windows->info.width)) &&9             (y < (windows->info.y+windows->info.height)))xI           XWithdrawWindow(display,windows->info.id,windows->info.screen);C       }i     else8       if ((x > (windows->info.x+windows->info.width)) ||7           (y > (windows->info.y+windows->info.height)))s-         XMapWindow(display,windows->info.id);      if (windows->info.mapped)s       {n
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",windows->magnify.x,windows->magnify.y);*         XInfoWidget(display,windows,text);       },     /*       Wait for next event.     */(     XScreenEvent(display,windows,event);     switch (event->type)     {        case ButtonPress:t         break;       case ButtonRelease:        {_
         /*-           User has finished magnifying image.o
         */         x=event->xbutton.x;          y=event->xbutton.y;_         state|=ExitState;          break;       }t       case Expose:         break;       case MotionNotify:       {t         x=event->xmotion.x;s         y=event->xmotion.y;          break;       }m       default:         break;     }      /*        Check boundary conditions.     */     if (x < 0)
       x=0;     else$       if (x >= windows->image.width)!         x=windows->image.width-1;      if (y < 0)
       y=0;     else$      if (y >= windows->image.height)!        y=windows->image.height-1; !   } while (!(state & ExitState));)   /*     Display magnified image.   */)   XSetCursorState(display,windows,False);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %rO %                                                                             % O %                                                                             % O %   X M a g n i f y W i n d o w C o m m a n d                                 %rO %                                                                             %eO %                                                                             %.O %                                                                             %SO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %xM %  Function XMagnifyWindowCommand moves the image within an Magnify window by , %  one pixel as specified by the key symbol. %;6 %  The format of the XMagnifyWindowCommand routine is: %=< %    XMagnifyWindowCommand(display,windows,state,key_symbol) %t+ %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %o< %    o windows: Specifies a pointer to a XWindows structure. %  %    o state: key mask.  % M %    o key_symbol: Specifies a KeySym which indicates which side of the imaged %      to trim.  %  %t */E static void XMagnifyWindowCommand(Display *display,XWindows *windows,h3   const unsigned int state,const KeySym key_symbol)e {y   unsigned int     quantum;     /*0     User specified a magnify factor or position.   */   quantum=1;   if (state & Mod1Mask)      quantum=10;r   switch (key_symbol)t   {F     case QuitCommand:t     {WK       XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);A       break;     }&     case XK_Home:h     case XK_KP_Home:     { 3       windows->magnify.x=windows->image.width >> 1; 4       windows->magnify.y=windows->image.height >> 1;       break;     }c     case XK_Left:      case XK_KP_Left:     {e!       if (windows->magnify.x > 0) $         windows->magnify.x-=quantum;       break;     }s     case XK_Up:a     case XK_KP_Up:     { !       if (windows->magnify.y > 0) $         windows->magnify.y-=quantum;       break;     }d     case XK_Right:     case XK_KP_Right:      {v8       if (windows->magnify.x < (windows->image.width-1))$         windows->magnify.x+=quantum;       break;     }m     case XK_Down:      case XK_KP_Down:     {d9       if (windows->magnify.y < (windows->image.height-1));$         windows->magnify.y+=quantum;       break;     }      case XK_0:     case XK_1:     case XK_2:     case XK_3:     case XK_4:     case XK_5:     case XK_6:     case XK_7:     case XK_8:     case XK_9:     { =       windows->magnify.data=(unsigned int) (key_symbol-XK_0);n       break;     }      case XK_KP_0:a     case XK_KP_1:i     case XK_KP_2:x     case XK_KP_3:      case XK_KP_4:a     case XK_KP_5:e     case XK_KP_6:.     case XK_KP_7:      case XK_KP_8:o     case XK_KP_9:y     {c@       windows->magnify.data=(unsigned int) (key_symbol-XK_KP_0);       break;     }      default:       break;   } %   XMakeMagnifyImage(display,windows);b }w   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %hO %                                                                             %vO %                                                                             % O %   X M a k e P a n I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%i % M %  Function XMakePanImage creates a thumbnail of the image and displays it in  %  the Pan icon window.m %d. %  The format of the XMakePanImage routine is: %n9 %      XMakePanImage(display,resource_info,windows,image)m %d+ %  A description of each parameter follows:  %nE %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %>K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  %  %  */H static void XMakePanImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)  {    unsigned int     status;      /*.     Create and display image for panning icon.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   windows->pan.x=windows->image.x;"   windows->pan.y=windows->image.y;>   status=XMakeImage(display,resource_info,&windows->pan,image,,     windows->pan.width,windows->pan.height);   if (status == False);     Error("Unable to create Pan icon image",(char *) NULL);lJ   XSetWindowBackgroundPixmap(display,windows->pan.id,windows->pan.pixmap);(   XClearWindow(display,windows->pan.id);%   XDrawPanRectangle(display,windows);p)   XSetCursorState(display,windows,False);  }  f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%xO %                                                                             % O %                                                                             %oO %                                                                             %iO %   X M a t t a E d i t I m a g e                                             % O %                                                                             %iO %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%f %rC %  Function XMatteEditImage allows the user to interactively change M %  the Matte channel of an image.  If the image is PseudoClass it is promoted-9 %  to DirectClass before the matte information is stored.  % 0 %  The format of the XMatteEditImage routine is: %.9 %    XMatteEditImage(display,resource_info,windows,image)h %h+ %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. %;K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.e %v< %    o windows: Specifies a pointer to a XWindows structure. %eE %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.e %a */5 static unsigned int XMatteEditImage(Display *display, ?   XResourceInfo *resource_info,XWindows *windows,Image **image)  { 
   static charw     matte[MaxTextExtent] = "0",e     *MatteEditMenu[]=      {        "Method",o       "Delta",       "Matte Value",
       "Undo", 
       "Help",a       "Dismiss",       (char *) NULL      };     static ModeTypet     MatteEditCommands[]=     {        MatteEditMethod,       MatteEditDeltaCommand,       MatteEditValueCommand,       MatteEditUndoCommand,        MatteEditHelpCommand,a       MatteEditDismissCommandn     };     static PaintMethod     method = PointMethod;      static unsigned inti     delta = 0;     char     command[MaxTextExtent],p     text[MaxTextExtent];     Cursor     cursor;      int;
     entry,     id,      x,
     x_offset,w     y,
     y_offset;f     register int     i;     register RunlengthPacket     *p;n     unsigned int     height, 
     width;     unsigned longc
     state;     XEvent
     event;     /*     Map Command widget.e   */%   windows->command.name="Matte Edit";g   windows->command.data=2;G   (void) XCommandWidget(display,windows,MatteEditMenu,(XEvent *) NULL);;*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols, +     windows->im_update_widget,CurrentTime);h   /*     Make cursor.   *//   cursor=XMakeCursor(display,windows->image.id,mF     windows->image.map_info->colormap,resource_info->background_color,%     resource_info->foreground_color); 2   XDefineCursor(display,windows->image.id,cursor);   /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);   state=DefaultState;d   do   {y     if (windows->info.mapped)d       {s
         /*#           Display pointer position. 
         */N         (void) sprintf(text," %+d%+d ",x+windows->image.x,y+windows->image.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event);i1     if (event.xany.window == windows->command.id)o       {l
         /*3           Select a command from the Command widget..
         */@         id=XCommandWidget(display,windows,MatteEditMenu,&event);         if (id < 0)            {f<             XDefineCursor(display,windows->image.id,cursor);             continue;            } &         switch (MatteEditCommands[id])	         {            case MatteEditMethod:t           {;             static char                *MethodMenu[]=               {;                 "point",                 "replace",                 "floodfill",                 "reset",                 (char *) NULL,               };               /*3               Select a method from the pop-up menu..             */             entry=P               XMenuWidget(display,windows,MatteEditMenu[id],MethodMenu,command);             if (entry >= 0) )               method=(PaintMethod) entry;              break;           } %           case MatteEditDeltaCommand:d           {.             static char(               *DeltaMenu[]=                {f                 "0",                 "1",                 "2",                 "4",                 "8",                 "16",r                 "32",                  (char *) NULL,                 (char *) NULL,               },)               value[MaxTextExtent] = "3";                /*8               Select a delta value from the pop-up menu.             */%             DeltaMenu[7]="Dialog...";yJ             entry=XMenuWidget(display,windows,MatteEditMenu[id],DeltaMenu,               command);r             if (entry < 0)               break;             if (entry != 7)                { -                 delta=atoi(DeltaMenu[entry]);r                 break;               },K             (void) XDialogWidget(display,windows,"Ok","Enter delta value:",                value);s             if (*value == '\0')*               break;             delta=atoi(value);             break;           }s%           case MatteEditValueCommand:            {-             /*0               Request matte value from the user.             */N             (void) XDialogWidget(display,windows,"Matte","Enter matte value:",               matte);              break;           }.$           case MatteEditUndoCommand:           {fL             (void) XMagickCommand(display,resource_info,windows,UndoCommand,               image);              break;           }d$           case MatteEditHelpCommand:           { @             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);P             break;           } '           case MatteEditDismissCommand:            {e             /*               Prematurely exit.(             */             state|=EscapeState;              state|=ExitState;&             break;           }            default:             break;	         } 8         XDefineCursor(display,windows->image.id,cursor);         continue;        }      switch (event.type)      {        case ButtonPress:h       {t,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*           Update matte data.
         */         x=event.xbutton.x;         y=event.xbutton.y;<         (void) XMagickCommand(display,resource_info,windows,)           SaveToUndoBufferCommand,image);u(         state|=UpdateConfigurationState;         break;       }l       case ButtonRelease:f       {_,         if (event.xbutton.button != Button1)           break;:         if ((event.xbutton.window != windows->image.id) &&:             (event.xbutton.window != windows->magnify.id))           break;
         /*&           Update colormap information.
         */         x=event.xbutton.x;         y=event.xbutton.y;F         XConfigureImageColormap(display,resource_info,windows,*image);E         (void) XConfigureImage(display,resource_info,windows,*image); *         XInfoWidget(display,windows,text);8         XDefineCursor(display,windows->image.id,cursor);+         state&=(~UpdateConfigurationState);          break;       }r       case Expose:         break;       case KeyPress:       {T         char!           command[MaxTextExtent];d           KeySym           key_symbol;o  5         if (event.xkey.window == windows->magnify.id)e           {              Window               window;a  '             window=windows->magnify.id;iJ             while (XCheckWindowEvent(display,window,KeyPressMask,&event));           }o3         if (event.xkey.window != windows->image.id)f           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);l         switch (key_symbol) 	         {_           case XK_Escape:o           case XK_F20:           {              /*               Prematurely exit.b             */             state|=ExitState;n             break;           }            case XK_F1:o           case XK_Help:            {i@             XTextViewWidget(display,resource_info,windows,False,=               "Help Viewer - Matte Edit",ImageMatteEditHelp);s             break;           }            default:           {e             XBell(display,0);              break;           } 	         }d         break;       };       case MotionNotify:       { 
         /*E           Map and unmap Info widget as cursor crosses its boundaries.(
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)            {(>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))mM               XWithdrawWindow(display,windows->info.id,windows->info.screen);t           }i         else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))s1             XMapWindow(display,windows->info.id);l         break;       }        default:         break;     } 1     if (event.xany.window == windows->magnify.id)        {i.         x=windows->magnify.x-windows->image.x;.         y=windows->magnify.y-windows->image.y;       }a     x_offset=x;d     y_offset=y;r)     if (state & UpdateConfigurationState)        {(         intn           x,           y;  
         /*8           Matte edit is relative to image configuration.
         */I         XClearArea(display,windows->image.id,x_offset,y_offset,1,1,True); :         XPutPixel(windows->image.ximage,x_offset,y_offset,=           windows->image.pixel_info->background_color.pixel);a         x=0;         y=0;          width=(*image)->columns;         height=(*image)->rows;:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,,             &width,&height);         x_offset=xK           width*(windows->image.x+x_offset)/windows->image.ximage->width+x;          y_offset=aM           height*(windows->image.y+y_offset)/windows->image.ximage->height+y;k-         if ((x_offset < 0) || (y_offset < 0))            continue;iL         if ((x_offset >= (*image)->columns) || (y_offset >= (*image)->rows))           continue;i$         (*image)->class=DirectClass;         if (!(*image)->matte)p           {              /*$               Initialize matte data.             */             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++) 
             {                p->index=Opaque;               p++;
             } !             (*image)->matte=True;p           }          switch (method) 	         {            case PointMethod:n           default:           {              /*=               Update matte information using point algorithm.              */)             if (!UncompressImage(*image))                break;E             p=(*image)->pixels+(y_offset*(*image)->columns+x_offset);s(             p->index=atoi(matte) & 0xff;             break;           }r           case ReplaceMethod:i           {d             RunlengthPacket0               target;v               /*?               Update matte information using replace algorithm.e             */             x=0;             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++)v
             {o               x+=(p->length+1);n<               if (x > (y_offset*(*image)->columns+x_offset))                 break;               p++;
             }r'             target=(*image)->pixels[i];o             p=(*image)->pixels; 1             for (i=0; i < (*image)->packets; i++)r
             { .               if (ColorMatch(*p,target,delta)),                 p->index=atoi(matte) & 0xff;               p++;
             }              break;           }f           case FloodfillMethod:>           {              /*A               Update matte information using floodfill algorithm.              */)             if (!UncompressImage(*image))                break;L             MatteFloodfillImage(*image,x_offset,y_offset,atoi(matte) & 0xff,               delta);o             break;           }            case ResetMethod:=           {o             /*=               Update matte information using reset algorithm.              */             p=(*image)->pixels;F1             for (i=0; i < (*image)->packets; i++)c
             { *               p->index=atoi(matte) & 0xff;               p++;
             } /             if ((atoi(matte) & 0xff) == Opaque) $               (*image)->matte=False;             break;           }r	         } +         state&=(~UpdateConfigurationState);n       }u!   } while (!(state & ExitState));f)   XSetCursorState(display,windows,False);    XFreeCursor(display,cursor);   return(True);. }R r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             % O %                                                                             % O %   X O p e n I m a g e                                                       % O %                                                                             %oO %                                                                             %)O %                                                                             %fO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%, %e2 %  Function XOpenImage loads an image from a file. % + %  The format of the XOpenImage routine is:  %nC %    loaded_image=XOpenImage(display,resource_info,windows,command)c %d+ %  A description of each parameter follows:  % J %    o loaded_image: Function XOpenImage returns an image if can be loaded9 %      successfully.  Otherwise a null image is returned.f %tD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %hK %    o command: A value other than zero indicates that the file is selecteda+ %      from the command line argument list.o %r %) */G static Image *XOpenImage(Display *display,XResourceInfo *resource_info,i/   XWindows *windows,const unsigned int command)e {    Imaged     *loaded_image;     ImageInfoi     image_info;y     MonitorHandler     handler;  
   static chart#     filename[MaxTextExtent] = "\0";i     /*      Request file name from user.   */   if (!command) 8     XFileBrowserWidget(display,windows,"Open",filename);   else     {a
       char         **filelist,a         **files;  	       intr         count,         status;p         register int
         i,
         j;         /*0         Select next image from the command line.       */B       status=XGetCommand(display,windows->image.id,&files,&count);       if (!status)	         {NA           Warning("Unable to select image","XGetCommand failed");e!           return((Image *) NULL);f	         } 6       filelist=(char **) malloc(count*sizeof(char *));%       if (filelist == (char **) NULL)t	         {cG           Warning("Unable to select image","Memory allocation failed");i!           XFreeStringList(files);o!           return((Image *) NULL); 	         }e
       j=0;       for (i=1; i < count; i++)%         if (*files[i] != '-')%!           filelist[j++]=files[i];         filelist[j]=(char *) NULL;J       XListBrowserWidget(display,windows,&windows->widget,filelist,"Load",*         "Select Image to Load:",filename);       free((char *) filelist);       XFreeStringList(files);      }    if (*filename == '\0')     return((Image *) NULL);    GetImageInfo(&image_info);.   (void) strcpy(image_info.filename,filename);"   SetImageInfo(&image_info,False);)   if (strcmp(image_info.magick,"X") == 0)      { 
       char         seconds[MaxTextExtent];          /*8         User may want to delay the X server screen grab.       */!       (void) strcpy(seconds,"0");%P       (void) XDialogWidget(display,windows,"Grab","Enter any delay in seconds:",         seconds);,)       XDelay(display,1000*atoi(seconds));      }T0   if ((strcmp(image_info.magick,"CMYK") == 0) ||0       (strcmp(image_info.magick,"GRAY") == 0) ||/       (strcmp(image_info.magick,"MAP") == 0) ||a1       (strcmp(image_info.magick,"MATTE") == 0) || /       (strcmp(image_info.magick,"RGB") == 0) || 0       (strcmp(image_info.magick,"TEXT") == 0) ||0       (strcmp(image_info.magick,"TILE") == 0) ||0       (strcmp(image_info.magick,"UYVY") == 0) ||.       (strcmp(image_info.magick,"XC") == 0) ||-       (strcmp(image_info.magick,"YUV") == 0))n     {a       static chars,         geometry[MaxTextExtent] = "512x512";         /*)         Request image size from the user.f       */;       if (resource_info->image_info->size != (char *) NULL) @         (void) strcpy(geometry,resource_info->image_info->size);/       resource_info->image_info->size=geometry;I2       (void) XDialogWidget(display,windows,"Load",.         "Enter the image geometry:",geometry);     }i   /*     Load the image.    */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);>   (void) strcpy(resource_info->image_info->filename,filename);)   if (strcmp(image_info.magick,"X") == 0)w5     handler=SetMonitorHandler((MonitorHandler) NULL);w4   loaded_image=ReadImage(resource_info->image_info);)   if (strcmp(image_info.magick,"X") == 0) &     (void) SetMonitorHandler(handler);)   XSetCursorState(display,windows,False);t%   if (loaded_image != (Image *) NULL) C     XClientMessage(display,windows->image.id,windows->im_protocols,M*       windows->im_next_image,CurrentTime);   else     {e
       char         *text,         **textlist;r  
       FILE         *file;  	       intl
         c;         register chare         *p;          unsigned int         length;          /*         Unknown image format.t       */(       file=(FILE *) fopen(filename,"r");        if (file == (FILE *) NULL)         return((Image *) NULL);e       length=MaxTextExtent; 0       text=(char *) malloc(length*sizeof(char));/       for (p=text ; text != (char *) NULL; p++)_       {e         c=fgetc(file);         if (c == EOF)a           break;!         if ((p-text+1) >= length)            {              *p='\0';             length<<=1;nE             text=(char *) realloc((char *) text,length*sizeof(char));*&             if (text == (char *) NULL)               break;              p=text+Extent(text);           }m         *p=(unsigned char) c;e       }t       (void) fclose(file);        if (text == (char *) NULL)         return((Image *) NULL);.       *p='\0';"       textlist=StringToList(text);%       if (textlist != (char **) NULL)r	         {o           char!             title[MaxTextExtent];D             register int             i;  >           (void) sprintf(title,"Unknown format: %s",filename);M           XTextViewWidget(display,resource_info,windows,True,title,textlist);g6           for (i=0; textlist[i] != (char *) NULL; i++)'             free((char *) textlist[i]); "           free((char *) textlist);	         }        free((char *) text);     }    return(loaded_image);& }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%yO %                                                                             %aO %                                                                             % O %                                                                             % O %   X P a n I m a g e                                                         %nO %                                                                             %oO %                                                                             %aO %                                                                             %PO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %"H %  Function XPanImage pans the image until the mouse button is released. % * %  The format of the XPanImage routine is: %l% %    XPanImage(display,windows,event)n % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % < %    o windows: Specifies a pointer to a XWindows structure. %iH %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.a %  */G static void XPanImage(Display *display,XWindows *windows,XEvent *event)  {    char     text[MaxTextExtent];     Cursor     cursor;      RectangleInfo 
     pan_info;u     unsigned long 
     state,
     x_factor, 
     y_factor;n     /*     Define cursor.   */>   if ((windows->image.ximage->width > windows->image.width) &&>       (windows->image.ximage->height > windows->image.height))/     cursor=XCreateFontCursor(display,XC_fleur);    else<     if (windows->image.ximage->width > windows->image.width)=       cursor=XCreateFontCursor(display,XC_sb_h_double_arrow);e     else@       if (windows->image.ximage->height > windows->image.height)?         cursor=XCreateFontCursor(display,XC_sb_v_double_arrow); 
       else3         cursor=XCreateFontCursor(display,XC_arrow);g0   XDefineCursor(display,windows->pan.id,cursor);   /*B     Pan image as pointer moves until the mouse button is released.   */   x_factor=(unsigned long)=     UpShift(windows->image.ximage->width)/windows->pan.width;)   y_factor=(unsigned long)?     UpShift(windows->image.ximage->height)/windows->pan.height;    pan_info.width= I     windows->pan.width*windows->image.width/windows->image.ximage->width;    pan_info.height=L     windows->pan.height*windows->image.height/windows->image.ximage->height;!   state=UpdateConfigurationState;    do   {e     switch (event->type)     {        case ButtonPress:        { 
         /*.           User choose an initial pan location.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;(         state|=UpdateConfigurationState;         break;       }        case ButtonRelease:        { 
         /*.           User has finished panning the image.
         */$         pan_info.x=event->xbutton.x;$         pan_info.y=event->xbutton.y;4         state|=UpdateConfigurationState | ExitState;         break;       }.       case MotionNotify:       { $         pan_info.x=event->xmotion.x;$         pan_info.y=event->xmotion.y;(         state|=UpdateConfigurationState;       }        default:         break;     } )     if (state & UpdateConfigurationState)        { 
         /*$           Check boundary conditions.
         */J         pan_info.x=DownShift((pan_info.x-(pan_info.width >> 1))*x_factor);         if (pan_info.x < 0)            pan_info.x=0;          elseO           if ((pan_info.x+windows->image.width) > windows->image.ximage->width)SI             pan_info.x=windows->image.ximage->width-windows->image.width; K         pan_info.y=DownShift((pan_info.y-(pan_info.height >> 1))*y_factor);c         if (pan_info.y < 0)            pan_info.y=0;          else2           if ((pan_info.y+windows->image.height) >-                windows->image.ximage->height) K             pan_info.y=windows->image.ximage->height-windows->image.height;d/         if ((windows->image.x != pan_info.x) ||o-             (windows->image.y != pan_info.y))            {;             /*'               Display image pan offset.              */(             windows->image.x=pan_info.x;(             windows->image.y=pan_info.y;E             (void) sprintf(text," %ux%u%+d%+d ",windows->image.width, G               windows->image.height,windows->image.x,windows->image.y); .             XInfoWidget(display,windows,text);             /*#               Refresh Image window.i             *//             XDrawPanRectangle(display,windows);,D             XRefreshWindow(display,&windows->image,(XEvent *) NULL);           } +         state&=(~UpdateConfigurationState);        }      /*       Wait for next event.     */     if (!(state & ExitState)) *       XScreenEvent(display,windows,event);!   } while (!(state & ExitState));    /*     Restore cursor.    */=   XDefineCursor(display,windows->pan.id,windows->pan.cursor);    XFreeCursor(display,cursor);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);  }c   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             %aO %   X P a s t e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%D %(H %  Function XPasteImage pastes an image previously saved with XCropImageI %  in the X window image at a location the user chooses with the pointer.  % , %  The format of the XPasteImage routine is: % < %    status=XPasteImage(display,resource_info,windows,image) %F+ %  A description of each parameter follows:l %m@ %    o status: Function XPasteImage returns True if the image isI %      pasted.  False is returned is there is a memory shortage or if thei  %      image fails to be pasted. %,E %    o display: Specifies a connection to an X server;  returned fromc %      XOpenDisplay. %UK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %a< %    o windows: Specifies a pointer to a XWindows structure. % E %    o image: Specifies a pointer to a Image structure; returned from= %      ReadImage.  %  */N static unsigned int XPasteImage(Display *display,XResourceInfo *resource_info,!   XWindows *windows,Image *image)  { 
   static char      *PasteMenu[]=      {        "Operator",L
       "Help",        "Dismiss",       (char *) NULL;     };     static ModeType      PasteCommands[]=     {        PasteOperatorsCommand,       PasteHelpCommand,s       PasteDismissCommand      };     static CompositeOperator#     operation = ReplaceCompositeOp;      char     text[MaxTextExtent];     Cursor     cursor;      Image      *paste_image;n     int      id,      x,     y;     RectangleInfow     highlight_info,e     paste_info;      unsigned int     height, 
     width;     unsigned longl     scale_factor,n
     state;     XEvent
     event;     /*     Copy image.    */#   if (copy_image == (Image *) NULL)      return(False);   copy_image->orphan=True;N   paste_image=CopyImage(copy_image,copy_image->columns,copy_image->rows,True);   copy_image->orphan=False;v   /*     Map Command widget.o   */    windows->command.name="Paste";   windows->command.data=1;C   (void) XCommandWidget(display,windows,PasteMenu,(XEvent *) NULL); *   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,a+     windows->im_update_widget,CurrentTime);D   /*,     Track pointer until button 1 is pressed.   */)   XSetCursorState(display,windows,False);e2   XQueryPosition(display,windows->image.id,&x,&y);"   paste_info.x=windows->image.x+x;"   paste_info.y=windows->image.y+y;   paste_info.width=0;    paste_info.height=0;0   cursor=XCreateFontCursor(display,XC_ul_angle);B   XSetFunction(display,windows->image.highlight_context,GXinvert);   state=DefaultState;w   do   {,     if (windows->info.mapped)        { 
         /*#           Display pointer position.a
         */B         (void) sprintf(text," %+d%+d ",paste_info.x,paste_info.y);*         XInfoWidget(display,windows,text);       }!     highlight_info=paste_info;3     highlight_info.x=paste_info.x-windows->image.x; 3     highlight_info.y=paste_info.y-windows->image.y;n2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);     /*       Wait for next event.     */)     XScreenEvent(display,windows,&event); 2     XHighlightRectangle(display,windows->image.id,8       windows->image.highlight_context,&highlight_info);1     if (event.xany.window == windows->command.id)        {r
         /*3           Select a command from the Command widget. 
         */<         id=XCommandWidget(display,windows,PasteMenu,&event);         if (id < 0)f           continue;,"         switch (PasteCommands[id])	         {e%           case PasteOperatorsCommand:a           {b             char%               command[MaxTextExtent];                static charr               *OperatorMenu[]=               {|                 "over",                  "in",                  "out",                 "atop",                  "xor",                 "plus",                  "minus",                 "add",                 "subtract",                  "difference",e                 "bumpmap",                 "replace",                 (char *) NULL,               };               /*4               Select a command from the pop-up menu.             */G             operation=(CompositeOperator) (XMenuWidget(display,windows, 5               PasteMenu[id],OperatorMenu,command)+1);s             break;           }             case PasteHelpCommand:           { @             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);             break;           }i#           case PasteDismissCommand:            {              /*               Prematurely exit.o             */             state|=EscapeState;e             state|=ExitState;-             break;           }            default:             break;	         }.         continue;        }p     switch (event.type)n     {p       case ButtonPress:        { !         if (resource_info->debug)aB           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);i,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*=           Paste rectangle is relative to image configuration. 
         */         x=0;         y=0;         width=image->columns;o         height=image->rows;i:         if (windows->image.crop_geometry != (char *) NULL)C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,a             &width,&height);A         scale_factor=UpShift(windows->image.ximage->width)/width;eF         paste_info.width=DownShift(paste_image->columns*scale_factor);C         scale_factor=UpShift(windows->image.ximage->height)/height; D         paste_info.height=DownShift(paste_image->rows*scale_factor);8         XDefineCursor(display,windows->image.id,cursor);6         paste_info.x=windows->image.x+event.xbutton.x;6         paste_info.y=windows->image.y+event.xbutton.y;         break;       }1       case ButtonRelease:W       {p!         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);l,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;@         if ((paste_info.width != 0) && (paste_info.height != 0))           {)             /*@               User has selected the location of the paste image.             */:             paste_info.x=windows->image.x+event.xbutton.x;:             paste_info.y=windows->image.y+event.xbutton.y;             state|=ExitState;            }W         break;       }d       case Expose:         break;       case KeyPress:       {          char!           command[MaxTextExtent];l           KeySym           key_symbol;            inte           length;   3         if (event.xkey.window != windows->image.id)            break;
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);c         *(command+length)='\0';I!         if (resource_info->debug) N           (void) fprintf(stderr,"Key press: 0x%lx (%s)\n",key_symbol,command);         switch (key_symbol)&	         {n           case XK_Escape:            case XK_F20:           {f             /*               Prematurely exit.,             */&             DestroyImage(paste_image);             state|=EscapeState;p             state|=ExitState;E             break;           }            case XK_F1:f           case XK_Help:e           {>J             XSetFunction(display,windows->image.highlight_context,GXcopy);@             XTextViewWidget(display,resource_info,windows,False,@               "Help Viewer - Image Compositing",ImagePasteHelp);L             XSetFunction(display,windows->image.highlight_context,GXinvert);             break;           }            default:           {,             XBell(display,0);              break;           }e	         }l         break;       }        case MotionNotify:       {d
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)t           { >             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))gM               XWithdrawWindow(display,windows->info.id,windows->info.screen);g           }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height)))e1             XMapWindow(display,windows->info.id); (         paste_info.x=windows->image.x+x;(         paste_info.y=windows->image.y+y;         break;       }.       default:       { !         if (resource_info->debug)t?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }e     }g!   } while (!(state & ExitState)); @   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);i   XFreeCursor(display,cursor);   if (state & EscapeState)     return(True);*   /*5     Image pasting is relative to image configuration.d   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   x=0;   y=0;   width=image->columns;    height=image->rows;>4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width;    paste_info.x+=x;4   paste_info.x=DownShift(paste_info.x*scale_factor);<   paste_info.width=DownShift(paste_info.width*scale_factor);=   scale_factor=UpShift(height)/windows->image.ximage->height;    paste_info.y+=y;4   paste_info.y=DownShift(paste_info.y*scale_factor);>   paste_info.height=DownShift(paste_info.height*scale_factor);   /*$     Paste image with X Image window.   */H   CompositeImage(image,operation,paste_image,paste_info.x,paste_info.y);   DestroyImage(paste_image);)   XSetCursorState(display,windows,False);    /*     Update image colormap.   */?   XConfigureImageColormap(display,resource_info,windows,image);c>   (void) XConfigureImage(display,resource_info,windows,image);   return(True);i }( p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %lO %                                                                             % O %                                                                             %cO %   X P r i n t I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             %sO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % @ %  Function XPrintImage prints an image to a Postscript printer. %f, %  The format of the XPrintImage routine is: %e< %    status=XPrintImage(display,resource_info,windows,image) % + %  A description of each parameter follows:  % ? %    o status: Function XPrintImage return True if the image is J %      printed.  False is returned is there is a memory shortage or if the %      image fails to print. % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.u %r< %    o windows: Specifies a pointer to a XWindows structure. %tF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.. %e %t */N static unsigned int XPrintImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {    char     command[MaxTextExtent],_     filename[MaxTextExtent],     geometry[MaxTextExtent];     ImageInfoU     *image_info;     intU     status;   
   static char !     print_command[MaxTextExtent];a     /*/     Request Postscript page geometry from user.    */'   image_info=resource_info->image_info; *   (void) sprintf(geometry,PSPageGeometry);(   if (image_info->page != (char *) NULL)-     (void) strcpy(geometry,image_info->page); I   XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",o1     "Select Postscript Page Geometry:",geometry);i   if (*geometry == '\0')     return(True);x0   image_info->page=PostscriptGeometry(geometry);   /*      Request file name from user.   */(   XCheckRefreshWindows(display,windows);   TemporaryFilename(filename);<   (void) strcpy(print_command,resource_info->print_command);O   (void) XDialogWidget(display,windows,"Print","Print command:",print_command);e   if (*print_command == '\0')f     return(True); >   if (strcmp(print_command,resource_info->print_command) != 0)     { 1       resource_info->print_command=print_command; &       XUserPreferences(resource_info);     }l   /*     Print image.   */J   (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);D   (void) sprintf((*image)->filename,"%s:%s",PrinterFormat,filename);'   status=WriteImage(image_info,*image);>1   (void) sprintf(command,print_command,filename); !   status&=SystemCommand(command); ; #if !defined(vms) && !defined(macintosh) && !defined(WIN32)i   (void) remove(filename); #endif)   XSetCursorState(display,windows,False);nI   (void) XMagickCommand(display,resource_info,windows,UndoCommand,image);y   return(status);l }_ o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             %oO %                                                                             % O %   X P r o g r e s s M o n i t o r                                           %cO %                                                                             %dO %                                                                             % O %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Function XProgressMonitor displays the progress a task is making in %  completing a task.  %e1 %  The format of the XProgressMonitor routine is:o %;* %      XProgressMonitor(task,quantum,span) % + %  A description of each parameter follows:l %n- %    o task: Identifies the task in progress.  % O %    o quantum: Specifies the quantum position within the span which representsl< %      how much progress has been made in completing a task. %=> %    o span: Specifies the span relative to completing a task. %p %i */C static void XProgressMonitor(char *task,const unsigned int quantum,    const unsigned int span) { 4   XMonitorWidget(display,windows,task,quantum,span); }  t /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %fO %                                                                             %(O %   X R O I I m a g e                                                         %nO %                                                                             % O %                                                                             %lO %                                                                             %yO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %iG %  Function XROIImage applies an image processing technique to a regionn %  of interest.t % * %  The format of the XROIImage routine is: % : %    status=XROIImage(display,resource_info,windows,image) %P+ %  A description of each parameter follows:s %i> %    o status: Function XROIImage returns True if the image isJ %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.  %/D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %mK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  %=< %    o windows: Specifies a pointer to a XWindows structure. %rE %    o image: Specifies a pointer to a Image structure; returned fromi %      ReadImage.i %w %i */L static unsigned int XROIImage(Display *display,XResourceInfo *resource_info,"   XWindows *windows,Image **image) {) #define ApplyMenus  7   
   static chari     *ROIMenu[]=i     {i
       "Help",d       "Dismiss",       (char *) NULL-     },     *ApplyMenu[]=(     {f
       "File", 
       "Edit",        "Transform",       "Enhance",       "Effects",       "F/X",       "Miscellany",t
       "Help",h       "Dismiss",       (char *) NULL.     },     *FileMenu[]=     {        "Save...",       "Print...",        (char *) NULLc     },     *EditMenu[]=     { 
       "Undo",r
       "Redo",>       (char *) NULL      },     *TransformMenu[]=w     { 
       "Flop",d
       "Flip",r       "Rotate Right",        "Rotate Left",       (char *) NULL-     },     *EnhanceMenu[]=n     {h       "Hue...",x       "Saturation...",       "Brightness...",       "Gamma...",        "Spiff",
       "Dull",        "Equalize",f       "Normalize",       "Negate",v       "Grayscale",       "Map...",t       "Quantize...",       (char *) NULL;     },     *EffectsMenu[]=e     {        "Despeckle",       "Reduce Noise",        "Add Noise",       "Sharpen...",>       "Blur...",       "Threshold...",>       "Edge Detect...",i       "Emboss...",       "Spread...",       "Solarize...",       "Shade...",1       "Raise...",n       "Segment...",i       (char *) NULLi     },     *FXMenu[]=     {        "Swirl...",l       "Implode...",d       "Oil Painting...",       "Charcoal Drawing...",       (char *) NULL_     },     *MiscellanyMenu[]=     {.       "Image Info",n       "Zoom Image",        "Show Preview...",       "Show Histogram",        "Show Matte",.       (char *) NULLn     };  
   static char      **Menus[ApplyMenus]=     {w       FileMenu,2       EditMenu,        TransformMenu,       EnhanceMenu,       EffectsMenu,
       FXMenu,d       MiscellanyMenu     };     static CommandType     ApplyCommands[]=     {2       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       NullCommand,       HelpCommand,       QuitCommandr     },     FileCommands[]=i     {h       SaveCommand,       PrintCommand     },     EditCommands[]=w     {u       UndoCommand,       RedoCommand      },     TransformCommands[]=     {f       FlopCommand,       FlipCommand,       RotateRightCommand,e       RotateLeftCommande     },     EnhanceCommands[]=     {        HueCommand,        SaturationCommand,       BrightnessCommand,       GammaCommand,w       SpiffCommand,X       DullCommand,       EqualizeCommand,       NormalizeCommand,        NegateCommand,       GrayscaleCommand,*       MapCommand,e       QuantizeCommand      },     EffectsCommands[]=     {m       DespeckleCommand,r       ReduceNoiseCommand,        AddNoiseCommand,       SharpenCommand,w       BlurCommand,       EdgeDetectCommand,       EmbossCommand,       SpreadCommand,       SolarizeCommand,       ShadeCommand,        RaiseCommand,%       SegmentCommand     },     FXCommands[]=%     {I       SwirlCommand,        ImplodeCommand,        OilPaintCommand,       CharcoalDrawingCommand     },     MiscellanyCommands[]=      {        InfoCommand,       ZoomCommand,       ShowPreviewCommand,        ShowHistogramCommand,        ShowMatteCommand     },     ROICommands[]=     {        ROIHelpCommand,        ROIDismissCommand      };     static CommandType     *Commands[ApplyMenus]=     {        FileCommands,        EditCommands,        TransformCommands,       EnhanceCommands,       EffectsCommands,       FXCommands,        MiscellanyCommands     };     char     command[MaxTextExtent],%     text[MaxTextExtent];  
   CommandTypeD     command_type;w     Cursor     cursor;w     Image      *roi_image;i     intz
     entry,     id,e     x,     y;     MonitorHandler     handler;     RectangleInfoe     crop_info,     highlight_info,r
     roi_info;r     unsigned int     height,c
     width;     unsigned long      scale_factor,a
     state;     XEvent
     event;     /*     Map Command widget.    */   windows->command.name="ROI";   windows->command.data=0;A   (void) XCommandWidget(display,windows,ROIMenu,(XEvent *) NULL);t*   XMapRaised(display,windows->command.id);A   XClientMessage(display,windows->image.id,windows->im_protocols,e+     windows->im_update_widget,CurrentTime);    /*,     Track pointer until button 1 is pressed.   */2   XQueryPosition(display,windows->image.id,&x,&y);    roi_info.x=windows->image.x+x;    roi_info.y=windows->image.y+y;   roi_info.width=0;*   roi_info.height=0;-   cursor=XCreateFontCursor(display,XC_fleur);*   state=DefaultState;_   do   {i     if (windows->info.mapped)s       {g
         /*#           Display pointer position._
         */>         (void) sprintf(text," %+d%+d ",roi_info.x,roi_info.y);*         XInfoWidget(display,windows,text);       }      /*       Wait for next event.     */)     XScreenEvent(display,windows,&event);g1     if (event.xany.window == windows->command.id)n       {_
         /*3           Select a command from the Command widget.%
         */:         id=XCommandWidget(display,windows,ROIMenu,&event);         if (id < 0)            continue;           switch (ROICommands[id])	         {            case ROIHelpCommand:           { @             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);              break;           } !           case ROIDismissCommand:            {              /*               Prematurely exit.              */             state|=EscapeState;              state|=ExitState;              break;           }            default:             break;	         }%         continue;%       }%     switch (event.type)%     {%       case ButtonPress:o       {i,         if (event.xbutton.button != Button1)           break;6         if (event.xbutton.window != windows->image.id)           break;
         /*H           Note first corner of region of interest rectangle-- exit loop.
         */8         XDefineCursor(display,windows->image.id,cursor);4         roi_info.x=windows->image.x+event.xbutton.x;4         roi_info.y=windows->image.y+event.xbutton.y;         state|=ExitState;e         break;       }o       case ButtonRelease:l         break;       case Expose:         break;       case KeyPress:       {s         KeySym           key_symbol;a  3         if (event.xkey.window != windows->image.id)X           break;
         /*&           Respond to a user key press.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command),m/           &key_symbol,(XComposeStatus *) NULL);o         switch (key_symbol)X	         {C           case XK_Escape:m           case XK_F20:           {n             /*               Prematurely exit.C             */             state|=EscapeState;c             state|=ExitState;u             break;           }s           case XK_F1:r           case XK_Help:t           {n@             XTextViewWidget(display,resource_info,windows,False,?               "Help Viewer - Region of Interest",ImageROIHelp);=             break;           }s           default:           {              XBell(display,0);              break;           }e	         }t         break;       }        case MotionNotify:       {t
         /*J           Map and unmap Info widget as text cursor crosses its boundaries.
         */         x=event.xmotion.x;         y=event.xmotion.y;!         if (windows->info.mapped)f           {f>             if ((x < (windows->info.x+windows->info.width)) &&=                 (y < (windows->info.y+windows->info.height)))oM               XWithdrawWindow(display,windows->info.id,windows->info.screen);            }          else<           if ((x > (windows->info.x+windows->info.width)) ||;               (y > (windows->info.y+windows->info.height))) 1             XMapWindow(display,windows->info.id); &         roi_info.x=windows->image.x+x;&         roi_info.y=windows->image.y+y;         break;       }        default:         break;     } !   } while (!(state & ExitState));n   if (state & EscapeState)     {c       /*5         User want to exit without region of interest.f       */E       XWithdrawWindow(display,windows->info.id,windows->info.screen);M"       XFreeCursor(display,cursor);       return(True);C     };B   XSetFunction(display,windows->image.highlight_context,GXinvert);   do   {k     /*I       Size rectangle as pointer moves until the mouse button is released.C     */     x=roi_info.x;(     y=roi_info.y;)     roi_info.width=0;C     roi_info.height=0;     state=DefaultState;      do     {        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x; 3       highlight_info.y=roi_info.y-windows->image.y;eD       if ((highlight_info.width > 3) && (highlight_info.height > 3))	         {o           /*?             Display info and draw region of interest rectangle.x           */$           if (!windows->info.mapped)1             XMapWindow(display,windows->info.id);nL           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);e,           XInfoWidget(display,windows,text);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);	         }U
       else!         if (windows->info.mapped)XI           XWithdrawWindow(display,windows->info.id,windows->info.screen);m       /*         Wait for next event.       */+       XScreenEvent(display,windows,&event);MD       if ((highlight_info.width > 3) && (highlight_info.height > 3))6         XHighlightRectangle(display,windows->image.id,<           windows->image.highlight_context,&highlight_info);       switch (event.type)e       {C         case ButtonPress:C	         { 6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;           break;	         }t         case ButtonRelease:i	         {            /*?             User has committed to region of interest rectangle.C           */6           roi_info.x=windows->image.x+event.xbutton.x;6           roi_info.y=windows->image.y+event.xbutton.y;1           XSetCursorState(display,windows,False);            state|=ExitState;f9           if (strcmp(windows->command.name,"Apply") == 0)C             break;(           windows->command.name="Apply";+           windows->command.data=ApplyMenus; K           (void) XCommandWidget(display,windows,ApplyMenu,(XEvent *) NULL);i           break;	         }a         case Expose:           break;         case MotionNotify:	         {H6           roi_info.x=windows->image.x+event.xmotion.x;6           roi_info.y=windows->image.y+event.xmotion.y;	         }X         default:           break;       }XJ       if (((roi_info.x != x) && (roi_info.y != y)) || (state & ExitState))	         {e           /*&             Check boundary conditions.           */           if (roi_info.x < 0)a             roi_info.x=0;e           else:             if (roi_info.x > windows->image.ximage->width)6               roi_info.x=windows->image.ximage->width;           if (roi_info.x < x)u9             roi_info.width=(unsigned int) (x-roi_info.x);c           else
             {4;               roi_info.width=(unsigned int) (roi_info.x-x);e               roi_info.x=x;a
             }            if (roi_info.y < 0)e             roi_info.y=0;s           else;             if (roi_info.y > windows->image.ximage->height)X7               roi_info.y=windows->image.ximage->height;            if (roi_info.y < y) :             roi_info.height=(unsigned int) (y-roi_info.y);           else
             {a<               roi_info.height=(unsigned int) (roi_info.y-y);               roi_info.y=y;m
             }e	         } #     } while (!(state & ExitState));      /*F       Wait for user to grab a corner of the rectangle or press return.     */     state=DefaultState;o     command_type=NullCommand;m     do     {e       if (windows->info.mapped) 	         {            /*%             Display pointer position.n           */L           (void) sprintf(text," %ux%u%+d%+d",roi_info.width,roi_info.height,#             roi_info.x,roi_info.y);N,           XInfoWidget(display,windows,text);	         }        highlight_info=roi_info;3       highlight_info.x=roi_info.x-windows->image.x;;3       highlight_info.y=roi_info.y-windows->image.y;_F       if ((highlight_info.width <= 3) || (highlight_info.height <= 3))	         {(           state|=EscapeState;u           state|=ExitState;f           break;	         } $       if (state & UpdateRegionState)	         {IH           XSetFunction(display,windows->image.highlight_context,GXcopy);           switch (command_type)u           {d             case UndoCommand:              case RedoCommand: 
             {lO               (void) XMagickCommand(display,resource_info,windows,command_type,                  image);                break;
             }m             default:
             {u               /*F                 Region of interest is relative to image configuration.               */?               handler=SetMonitorHandler((MonitorHandler) NULL);e!               crop_info=roi_info;                x=0;               y=0;&               width=(*image)->columns;$               height=(*image)->rows;@               if (windows->image.crop_geometry != (char *) NULL)I                 (void) XParseGeometry(windows->image.crop_geometry,&x,&y,h"                   &width,&height);G               scale_factor=UpShift(width)/windows->image.ximage->width;                crop_info.x+=x;*>               crop_info.x=DownShift(crop_info.x*scale_factor);F               crop_info.width=DownShift(crop_info.width*scale_factor);I               scale_factor=UpShift(height)/windows->image.ximage->height;m               crop_info.y+=y; >               crop_info.y=DownShift(crop_info.y*scale_factor);H               crop_info.height=DownShift(crop_info.height*scale_factor);5               roi_image=CropImage(*image,&crop_info);;0               (void) SetMonitorHandler(handler);.               if (roi_image == (Image *) NULL)                 continue;b               /*K                 Apply image processing technique to the region of interest.h               */)               windows->image.orphan=True;_O               (void) XMagickCommand(display,resource_info,windows,command_type,                  &roi_image);?               handler=SetMonitorHandler((MonitorHandler) NULL);oB               (void) XMagickCommand(display,resource_info,windows,/                 SaveToUndoBufferCommand,image);i*               windows->image.orphan=False;A               CompositeImage(*image,ReplaceCompositeOp,roi_image,>)                 crop_info.x,crop_info.y);y&               DestroyImage(roi_image);0               (void) SetMonitorHandler(handler);               break;
             }d           }x*           if (command_type != InfoCommand)
             {cL               XConfigureImageColormap(display,resource_info,windows,*image);K               (void) XConfigureImage(display,resource_info,windows,*image);w
             }+0           XCheckRefreshWindows(display,windows);,           XInfoWidget(display,windows,text);J           XSetFunction(display,windows->image.highlight_context,GXinvert);&           state&=(~UpdateRegionState);	         }o4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);+       XScreenEvent(display,windows,&event); 3       if (event.xany.window == windows->command.id)n	         {            /*5             Select a command from the Command widget.            */H           XSetFunction(display,windows->image.highlight_context,GXcopy);#           command_type=NullCommand; >           id=XCommandWidget(display,windows,ApplyMenu,&event);           if (id >= 0)
             { 3               (void) strcpy(command,ApplyMenu[id]);d-               command_type=ApplyCommands[id];%"               if (id < ApplyMenus)                 {                    /*8                     Select a command from a pop-up menu.                   */L                   entry=XMenuWidget(display,windows,ApplyMenu[id],Menus[id],                     command); !                   if (entry >= 0)                      { >                       (void) strcpy(command,Menus[id][entry]);7                       command_type=Commands[id][entry];                      }                  } 
             } J           XSetFunction(display,windows->image.highlight_context,GXinvert);8           XHighlightRectangle(display,windows->image.id,>             windows->image.highlight_context,&highlight_info);*           if (command_type == HelpCommand)
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp); N               XSetFunction(display,windows->image.highlight_context,GXinvert);               continue;u
             }e*           if (command_type == QuitCommand)
             {e               /*                 Exit.e               */!               state|=EscapeState;t               state|=ExitState;                continue; 
             }o*           if (command_type != NullCommand)%             state|=UpdateRegionState;f           continue;i	         }t4       XHighlightRectangle(display,windows->image.id,:         windows->image.highlight_context,&highlight_info);       switch (event.type)        {a         case ButtonPress: 	         {            x=windows->image.x;a           y=windows->image.y;p.           if (event.xbutton.button != Button1)             break;8           if (event.xbutton.window != windows->image.id)             break;-           x=windows->image.x+event.xbutton.x; -           y=windows->image.y+event.xbutton.y;gK           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) && I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             {I3               roi_info.x=roi_info.x+roi_info.width; 4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             }:K           if ((x < (roi_info.x+RoiDelta)) && (x > (roi_info.x-RoiDelta)) && <               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             { 3               roi_info.x=roi_info.x+roi_info.width;I.               state|=UpdateConfigurationState;               break;
             }!;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) && ;               (x > (roi_info.x+roi_info.width-RoiDelta)) && I               (y < (roi_info.y+RoiDelta)) && (y > (roi_info.y-RoiDelta))) 
             { 4               roi_info.y=roi_info.y+roi_info.height;.               state|=UpdateConfigurationState;               break;
             } ;           if ((x < (roi_info.x+roi_info.width+RoiDelta)) &&g;               (x > (roi_info.x+roi_info.width-RoiDelta)) &&_<               (y < (roi_info.y+roi_info.height+RoiDelta)) &&:               (y > (roi_info.y+roi_info.height-RoiDelta)))
             {).               state|=UpdateConfigurationState;               break;
             }m	         }i         case ButtonRelease:e	         { 6           if (event.xbutton.window == windows->pan.id)E             if ((highlight_info.x != crop_info.x-windows->image.x) ||oC                 (highlight_info.y != crop_info.y-windows->image.y))n<               XHighlightRectangle(display,windows->image.id,B                 windows->image.highlight_context,&highlight_info);           break;	         }          case Expose:	         { 8           if (event.xexpose.window == windows->image.id))             if (event.xexpose.count == 0)t               {a1                 event.xexpose.x=highlight_info.x;a1                 event.xexpose.y=highlight_info.y;e9                 event.xexpose.width=highlight_info.width;d;                 event.xexpose.height=highlight_info.height; ?                 XRefreshWindow(display,&windows->image,&event);r               }e7           if (event.xexpose.window == windows->info.id)z)             if (event.xexpose.count == 0) 0               XInfoWidget(display,windows,text);           break;	         }          case KeyPress:	         {f           KeySym             key_symbol;G  5           if (event.xkey.window != windows->image.id)C             break;           /*(             Respond to a user key press.           */A           (void) XLookupString((XKeyEvent *) &event.xkey,command,rA             sizeof(command),&key_symbol,(XComposeStatus *) NULL);d           switch (key_symbol)            {z             case XK_Shift_L:             case XK_Shift_R:               break;             case XK_Escape:              case XK_F20:!               state|=EscapeState;C             case XK_Return:a
             {a               state|=ExitState;                break;
             }C             case XK_F1:e             case XK_Help:L
             { L               XSetFunction(display,windows->image.highlight_context,GXcopy);B               XTextViewWidget(display,resource_info,windows,False,A                 "Help Viewer - Region of Interest",ImageROIHelp);*N               XSetFunction(display,windows->image.highlight_context,GXinvert);               break;
             }              default:
             {hM               command_type=XImageWindowCommand(display,resource_info,windows, 3                 event.xkey.state,key_symbol,image); .               if (command_type != NullCommand))                 state|=UpdateRegionState;                break;
             }h           }            break;	         }          case KeyRelease:           break;         case MotionNotify:	         { 8           if (event.xbutton.window != windows->image.id)             break;           /*L             Map and unmap Info widget as text cursor crosses its boundaries.           */           x=event.xmotion.x;           y=event.xmotion.y;#           if (windows->info.mapped) 
             {h@               if ((x < (windows->info.x+windows->info.width)) &&?                   (y < (windows->info.y+windows->info.height))) O                 XWithdrawWindow(display,windows->info.id,windows->info.screen);p
             }p           else>             if ((x > (windows->info.x+windows->info.width)) ||=                 (y > (windows->info.y+windows->info.height))) 3               XMapWindow(display,windows->info.id);n           break;	         }          default:           break;       } +       if (state & UpdateConfigurationState) 	         {=(           XPutBackEvent(display,&event);:           XDefineCursor(display,windows->image.id,cursor);           break;	         },#     } while (!(state & ExitState));s!   } while (!(state & ExitState));h@   XSetFunction(display,windows->image.highlight_context,GXcopy);)   XSetCursorState(display,windows,False);*   if (state & EscapeState)     return(True);i   return(True);s }N   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %.O %                                                                             %hO %                                                                             %eO %   X R o t a t e I m a g e                                                   %lO %                                                                             % O %                                                                             %tO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%c %iG %  Function XRotateImage rotates the X image.  If the degrees parameterdL %  if zero, the rotation angle is computed from the slope of a line drawn by %  the user. %m- %  The format of the XRotateImage routine is:  %gE %    status=XRotateImage(display,resource_info,windows,degrees,image)  % + %  A description of each parameter follows:  %e@ %    o status: Function XRotateImage return True if the image isJ %      rotated.  False is returned is there is a memory shortage or if the %      image fails to rotate.i %wD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.* %g< %    o windows: Specifies a pointer to a XWindows structure. % D %    o degrees: Specifies the number of degrees to rotate the image. % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.e %s %y */O static unsigned int XRotateImage(Display *display,XResourceInfo *resource_info,r1   XWindows *windows,double degrees,Image **image)- {i
   static charo     *RotateMenu[]=     {        "Pixel Color",       "Direction",
       "Crop",g       "Sharpen",
       "Help",o       "Dismiss",       (char *) NULL>     };     static ModeType (     direction = HorizontalRotateCommand,     DirectionCommands[]=     {        HorizontalRotateCommand,       VerticalRotateCommandw     },     RotateCommands[]=      {a       RotateColorCommand,        RotateDirectionCommand,a       RotateCropCommand,       RotateSharpenCommand,m       RotateHelpCommand,       RotateDismissCommand     };     static unsigned inta     crop = False,e     pen_id = 0,      sharpen = True;      char     command[MaxTextExtent],      text[MaxTextExtent];     double     normalized_degrees;o     Image      *rotated_image;i     inte     id,      x,     y;     register int     i;     unsigned int     height,      rotations,
     width;     if (degrees == 0.0)_     {o       unsigned int         distance;n         unsigned longi         state;         XEvent         event;         XSegment         rotate_info;         /*         Map Command widget.X       */%       windows->command.name="Rotate";        windows->command.data=4;H       (void) XCommandWidget(display,windows,RotateMenu,(XEvent *) NULL);.       XMapRaised(display,windows->command.id);E       XClientMessage(display,windows->image.id,windows->im_protocols,X/         windows->im_update_widget,CurrentTime);        /*$         Wait for first button press.       */F       XSetFunction(display,windows->image.highlight_context,GXinvert);6       XQueryPosition(display,windows->image.id,&x,&y);       rotate_info.x1=x;        rotate_info.y1=y;        rotate_info.x2=x;D       rotate_info.y2=y;        state=DefaultState;i       do       {t1         XHighlightLine(display,windows->image.id, 9           windows->image.highlight_context,&rotate_info);,
         /*           Wait for next event.
         */-         XScreenEvent(display,windows,&event);t1         XHighlightLine(display,windows->image.id,,9           windows->image.highlight_context,&rotate_info); 5         if (event.xany.window == windows->command.id)            {a             /*7               Select a command from the Command widget.y             */A             id=XCommandWidget(display,windows,RotateMenu,&event);              if (id < 0)i               continue;sJ             XSetFunction(display,windows->image.highlight_context,GXcopy);'             switch (RotateCommands[id]))
             {t&               case RotateColorCommand:               {"                 char,                   *ColorMenu[MaxNumberPens];                   int                    pen_number;_                   XColor                   color;                   /*-                   Initialize menu selections.i                 */;                 for (i=0; i < (int) (MaxNumberPens-2); i++)C<                   ColorMenu[i]=resource_info->pen_colors[i];8                 ColorMenu[MaxNumberPens-2]="Browser...";9                 ColorMenu[MaxNumberPens-1]=(char *) NULL;                  /*:                   Select a pen color from the pop-up menu.                 */F                 pen_number=XMenuWidget(display,windows,RotateMenu[id],%                   ColorMenu,command); #                 if (pen_number < 0)f                   break;4                 if (pen_number == (MaxNumberPens-2))                   {w                     static charl9                       color_name[MaxTextExtent] = "gray";x                       /*7                       Select a pen color from a dialog.w                     */E                     resource_info->pen_colors[pen_number]=color_name; M                     XColorBrowserWidget(display,windows,"Select",color_name); ,                     if (*color_name == '\0')                       break;                   }                  /*                    Set pen color.                 */M                 (void) XParseColor(display,windows->image.map_info->colormap,d@                   resource_info->pen_colors[pen_number],&color);E                 XBestPixel(display,windows->image.map_info->colormap,aC                   (XColor *) NULL,(unsigned int) MaxColors,&color);mH                 windows->image.pixel_info->pen_colors[pen_number]=color;"                 pen_id=pen_number;                 break;               }a*               case RotateDirectionCommand:               {i                 static char                     *Directions[]=                   {d!                     "horizontal",i                     "vertical",w"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */>                 id=XMenuWidget(display,windows,RotateMenu[id],&                   Directions,command);                 if (id >= 0)2                   direction=DirectionCommands[id];                 break;               }n%               case RotateCropCommand:.               {r                 static charI                   *Options[]=o                   {r                     "false",                     "true",*"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */@                 crop=XMenuWidget(display,windows,RotateMenu[id],#                   Options,command);*                 break;               }R(               case RotateSharpenCommand:               {r                 static char                    *Options[]=/                   {-                     "false",                     "true",>"                     (char *) NULL,                   };                   /*8                   Select a command from the pop-up menu.                 */C                 sharpen=XMenuWidget(display,windows,RotateMenu[id],;#                   Options,command);s                 break;               }m%               case RotateHelpCommand:h               {wD                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);                 break;               } (               case RotateDismissCommand:               {_                 /*#                   Prematurely exit.p                 */#                 state|=EscapeState;m!                 state|=ExitState;                  break;               }>               default:                 break;
             }rL             XSetFunction(display,windows->image.highlight_context,GXinvert);             continue;s           }a         switch (event.type)k	         {o           case ButtonPress:*           {p0             if (event.xbutton.button != Button1)               break;:             if (event.xbutton.window != windows->image.id)               break;             /*               Exit loop.             */J             XSetFunction(display,windows->image.highlight_context,GXcopy);+             rotate_info.x1=event.xbutton.x;w+             rotate_info.y1=event.xbutton.y;i             state|=ExitState;L             break;           }a           case ButtonRelease:y             break;           case Expose:             break;           case KeyPress:           {m             char%               command[MaxTextExtent];(               KeySym               key_symbol;   7             if (event.xkey.window != windows->image.id)                break;             /**               Respond to a user key press.             */C             (void) XLookupString((XKeyEvent *) &event.xkey,command,qC               sizeof(command),&key_symbol,(XComposeStatus *) NULL);f             switch (key_symbol) 
             {r               case XK_Escape:p               case XK_F20:               {u                 /*#                   Prematurely exit.e                 */#                 state|=EscapeState;(!                 state|=ExitState;                  break;               }                case XK_F1:C               case XK_Help:,               { N                 XSetFunction(display,windows->image.highlight_context,GXcopy);D                 XTextViewWidget(display,resource_info,windows,False,B                   "Help Viewer - Image Rotation",ImageRotateHelp);P                 XSetFunction(display,windows->image.highlight_context,GXinvert);                 break;               }s               default:               { !                 XBell(display,0);*                 break;               }g
             }              break;           }            case MotionNotify:           {;+             rotate_info.x1=event.xmotion.x;n+             rotate_info.y1=event.xmotion.y;i           }h	         }t&         rotate_info.x2=rotate_info.x1;&         rotate_info.y2=rotate_info.y1;1         if (direction == HorizontalRotateCommand)_           rotate_info.x2+=32;i         else           rotate_info.y2-=32; %       } while (!(state & ExitState));-D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);_       if (state & EscapeState)         return(True);C       /*F         Draw line as pointer moves until the mouse button is released.       */       distance=0;iF       XSetFunction(display,windows->image.highlight_context,GXinvert);       state=DefaultState;h       do       {/         if (distance > 9)i           {e             /*2               Display info and draw rotation line.             */&             if (!windows->info.mapped)3               XMapWindow(display,windows->info.id);a(             (void) sprintf(text," %.2f",K               direction == VerticalRotateCommand ? degrees-90.0 : degrees);/.             XInfoWidget(display,windows,text);5             XHighlightLine(display,windows->image.id,v=               windows->image.highlight_context,&rotate_info);g           }          else#           if (windows->info.mapped) K             XWithdrawWindow(display,windows->info.id,windows->info.screen); 
         /*           Wait for next event.
         */-         XScreenEvent(display,windows,&event);m         if (distance > 9) 3           XHighlightLine(display,windows->image.id,g;             windows->image.highlight_context,&rotate_info);)         switch (event.type)h	         {            case ButtonPress:a             break;           case ButtonRelease:I           {r             /*2               User has committed to rotation line.             */+             rotate_info.x2=event.xbutton.x; +             rotate_info.y2=event.xbutton.y;,             state|=ExitState;o             break;           }1           case Expose:             break;           case MotionNotify:           {s+             rotate_info.x2=event.xmotion.x;i+             rotate_info.y2=event.xmotion.y;            }            default:             break;	         } 
         /*$           Check boundary conditions.
         */         if (rotate_info.x2 < 0)            rotate_info.x2=0;s         else4           if (rotate_info.x2 > windows->image.width)0             rotate_info.x2=windows->image.width;         if (rotate_info.y2 < 0)a           rotate_info.y2=0;          else5           if (rotate_info.y2 > windows->image.height) 1             rotate_info.y2=windows->image.height; 
         /*<           Compute rotation angle from the slope of the line.
         */         degrees=0.0;         distance=0P           ((rotate_info.x2-rotate_info.x1+1)*(rotate_info.x2-rotate_info.x1+1))+P           ((rotate_info.y2-rotate_info.y1+1)*(rotate_info.y2-rotate_info.y1+1));         if (distance > 9) C           degrees=RadiansToDegrees(-atan2((double) (rotate_info.y2- G             rotate_info.y1),(double) (rotate_info.x2-rotate_info.x1)));a%       } while (!(state & ExitState));9D       XSetFunction(display,windows->image.highlight_context,GXcopy);E       XWithdrawWindow(display,windows->info.id,windows->info.screen);g       if (distance <= 9)         return(True);      };)   if (direction == VerticalRotateCommand)      degrees-=90.0;   if (degrees == 0.0)      return(True);e   /*     Rotate image.f   */   normalized_degrees=degrees;t$   while (normalized_degrees < -45.0)     normalized_degrees+=360.0;;   for (rotations=0; normalized_degrees > 45.0; rotations++)      normalized_degrees-=90.0;     if (normalized_degrees != 0.0)L     (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   (*image)->border_color.red=dB     XDownScale(windows->image.pixel_info->pen_colors[pen_id].red);   (*image)->border_color.green=wD     XDownScale(windows->image.pixel_info->pen_colors[pen_id].green);   (*image)->border_color.blue=C     XDownScale(windows->image.pixel_info->pen_colors[pen_id].blue);o!   (*image)->border_color.index=0;,9   rotated_image=RotateImage(*image,degrees,crop,sharpen);,)   XSetCursorState(display,windows,False);w&   if (rotated_image == (Image *) NULL)     return(False);   DestroyImage(*image);"   *image=rotated_image;y4   if (windows->image.crop_geometry != (char *) NULL)     {)       /*         Rotate crop geometry.,       */O       (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);n       switch (rotations % 4)       {d         default:         case 0:i           break;         case 1:C	         {p           /*             Rotate 90 degrees.           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",C             height,width,(int) (*image)->columns-(int) height-y,x);x           break;	         }          case 2:r	         {t           /*             Rotate 180 degrees.l           */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",7             width,height,(int) width-x,(int) height-y);            break;	         }          case 3:m	         {,           /*             Rotate 270 degrees.            */D           (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",?             height,width,y,(int) (*image)->rows-(int) width-x);f           break;	         }n       },     }o   if (windows->image.orphan)     return(True);     if (normalized_degrees != 0.0)     {        /*         Update image colormap.       */<       windows->image.window_changes.width=(*image)->columns;:       windows->image.window_changes.height=(*image)->rows;8       if (windows->image.crop_geometry != (char *) NULL)	         {c           /*:             Obtain dimensions of image from crop geometry.           */C           (void) XParseGeometry(windows->image.crop_geometry,&x,&y,o             &width,&height);4           windows->image.window_changes.width=width;6           windows->image.window_changes.height=height;	         }mD       XConfigureImageColormap(display,resource_info,windows,*image);     }e   else9     if (((rotations % 4) == 1) || ((rotations % 4) == 3))x       {=J         windows->image.window_changes.width=windows->image.ximage->height;J         windows->image.window_changes.height=windows->image.ximage->width;       }i   /*     Update image configuration.e   */?   (void) XConfigureImage(display,resource_info,windows,*image);e   return(True);  }S u /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %sO %                                                                             % O %                                                                             %iO %   X S a v e I m a g e                                                       %CO %                                                                             %gO %                                                                             %SO %                                                                             %tO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 0 %  Function XSaveImage saves an image to a file. %l+ %  The format of the XSaveImage routine is:s %r; %    status=XSaveImage(display,resource_info,windows,image)= %0+ %  A description of each parameter follows:l %s> %    o status: Function XSaveImage return True if the image isJ %      written.  False is returned is there is a memory shortage or if the %      image fails to write. %)D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %aK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %eF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.e %  %  */M static unsigned int XSaveImage(Display *display,XResourceInfo *resource_info, "   XWindows *windows,Image **image) {a   char     filename[MaxTextExtent];     ImageInfoe     *image_info;     int*     status;r     /*      Request file name from user.   */5   if (resource_info->write_filename != (char *) NULL) :     (void) strcpy(filename,resource_info->write_filename);   else     { 
       char)         working_directory[MaxTextExtent];          register chare         *p;n  8       p=(*image)->filename+Extent((*image)->filename)-1;H       while ((p > (*image)->filename) && (*(p-1) != *BasenameSeparator))         p--;        (void) strcpy(filename,p);:       (void) strcpy(working_directory,(*image)->filename);3       working_directory[p-(*image)->filename]='\0'; "       if (p != (*image)->filename)(         (void) chdir(working_directory);     } 6   XFileBrowserWidget(display,windows,"Save",filename);   if (*filename == '\0')     return(True);I   if (IsAccessible(filename))o     {g       /*@         File exists-- seek user's permission before overwriting.       */B       status=XConfirmWidget(display,windows,"Overwrite",filename);       if (status <= 0)         return(True);i     }s'   image_info=resource_info->image_info;m/   (void) strcpy(image_info->filename,filename);(0   SetImageInfo(resource_info->image_info,False);1   if ((strcmp(image_info->magick,"JPEG") == 0) ||t.       (strcmp(image_info->magick,"JPG") == 0))     {d
       char         quality[MaxTextExtent];          /*'         Request JPEG quality from user.o       */7       (void) sprintf(quality,"%u",image_info->quality);,H       status=XDialogWidget(display,windows,"Save","Enter JPEG quality:",         quality);p       if (*quality == '\0')a         return(True);f(       image_info->quality=atoi(quality);D       image_info->interlace=status ? PlaneInterlace : NoneInterlace;     } 0   if ((strcmp(image_info->magick,"EPS") == 0) ||/       (strcmp(image_info->magick,"PS") == 0) ||e.       (strcmp(image_info->magick,"PS2") == 0))     {t
       char          geometry[MaxTextExtent];         /*3         Request Postscript page geometry from user.s       */.       (void) sprintf(geometry,PSPageGeometry);,       if (image_info->page != (char *) NULL)1         (void) strcpy(geometry,image_info->page);dM       XListBrowserWidget(display,windows,&windows->widget,PageSizes,"Select",a5         "Select Postscript Page Geometry:",geometry);.       if (*geometry != '\0')6         image_info->page=PostscriptGeometry(geometry);     }w   /*     Write image.   */J   (void) XMagickCommand(display,resource_info,windows,ApplyCommand,image);(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);-   (void) strcpy((*image)->filename,filename);e'   status=WriteImage(image_info,*image);))   XSetCursorState(display,windows,False);oI   (void) XMagickCommand(display,resource_info,windows,UndoCommand,image); A   XClientMessage(display,windows->image.id,windows->im_protocols,/.     windows->im_update_signature,CurrentTime);   return(status);W }o d /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%_O %                                                                             %iO %                                                                             %rO %                                                                             %oO %   X S c r e e n E v e n t                                                   % O %                                                                             %rO %                                                                             % O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % J %  Function XScreenEvent handles global events associated with the Pan and %  Magnify windows.) %o. %  The format of the XScreenEvent function is: %a* %      XScreenEvent(display,windows,event) %"+ %  A description of each parameter follows:i %eL %    o display: Specifies a pointer to the Display structure;  returned from %      XOpenDisplay. %;< %    o windows: Specifies a pointer to a XWindows structure. %g< %    o event: Specifies a pointer to a X11 XEvent structure. %s %: */  @ static int XPredicate(Display *display,XEvent *event,char *data) {l   register XWindowse
     *windows;i     windows=(XWindows *) data;'   if ((event->type == ClientMessage) &&)3       (event->xclient.window == windows->image.id))      return(False);   return(True);g }o  J static void XScreenEvent(Display *display,XWindows *windows,XEvent *event) {k   MonitorHandler     handler;     register int     x,     y;  6   XIfEvent(display,event,XPredicate,(char *) windows);0   if (event->xany.window == windows->command.id)     return;,   switch (event->type)   {i     case ButtonPress:r     case ButtonRelease:g     {a/       if ((event->xbutton.button == Button3) &&v,           (event->xbutton.state & Mod1Mask))	         {)           /*+             Convert Alt-Button3 to Button2.            */(           event->xbutton.button=Button2;,           event->xbutton.state&=(~Mod1Mask);	         } 8       if (event->xbutton.window == windows->backdrop.id)	         { F           XSetInputFocus(display,event->xbutton.window,RevertToParent,!             event->xbutton.time);(           break;	         } 3       if (event->xbutton.window == windows->pan.id)=	         { +           XPanImage(display,windows,event);s           break;	         },5       if (event->xbutton.window == windows->image.id)s-         if (event->xbutton.button == Button2)a           {n             /*%               Update magnified image.e             */             x=event->xbutton.x;_             y=event->xbutton.y;a             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1;n2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;e2             windows->magnify.y=windows->image.y+y;)             if (!windows->magnify.mapped)s6               XMapRaised(display,windows->magnify.id);=             handler=SetMonitorHandler((MonitorHandler) NULL); /             XMakeMagnifyImage(display,windows);,.             (void) SetMonitorHandler(handler);-             if (event->type == ButtonRelease) M               XWithdrawWindow(display,windows->info.id,windows->info.screen);;             break;           }s       break;     }n     case ClientMessage:a     {        /*.         If client window delete message, exit.       */?       if (event->xclient.message_type != windows->wm_protocols)          break;>       if (*event->xclient.data.l != windows->wm_delete_window)         break;7       if (event->xclient.window == windows->magnify.id)t	         {,O           XWithdrawWindow(display,windows->magnify.id,windows->magnify.screen);u           break;	         }r       break;     }e     case ConfigureNotify:I     {s:       if (event->xconfigure.window == windows->magnify.id)	         {d           unsigned int             magnify;             /*3             Magnify window has a new configuration.d           */9           windows->magnify.width=event->xconfigure.width;-;           windows->magnify.height=event->xconfigure.height;,'           if (!windows->magnify.mapped)i             break;           magnify=1;4           while (magnify <= event->xconfigure.width)             magnify<<=1;5           while (magnify <= event->xconfigure.height)u             magnify<<=1;           magnify>>=1;5           if ((magnify != event->xconfigure.width) || 4               (magnify != event->xconfigure.height))
             {                XWindowChanges                 window_changes;s  +               window_changes.width=magnify; ,               window_changes.height=magnify;?               XReconfigureWMWindow(display,windows->magnify.id, L                 windows->magnify.screen,CWWidth | CWHeight,&window_changes);               break;
             }v-           XMakeMagnifyImage(display,windows);            break;	         }>       break;     }g     case Expose:     {t5       if (event->xexpose.window == windows->image.id)p	         { 8           XRefreshWindow(display,&windows->image,event);           break;	         }v3       if (event->xexpose.window == windows->pan.id)m&         if (event->xexpose.count == 0)           {:/             XDrawPanRectangle(display,windows);e             break;           } 7       if (event->xexpose.window == windows->magnify.id)v&         if (event->xexpose.count == 0)           { /             XMakeMagnifyImage(display,windows);c             break;           })       break;     }      case KeyPress:     { 
       char         command[MaxTextExtent];i         KeySym         key_symbol;r  4       if (event->xkey.window != windows->magnify.id)         break;       /*$         Respond to a user key press.       */N       (void) XLookupString((XKeyEvent *) &event->xkey,command,sizeof(command),-         &key_symbol,(XComposeStatus *) NULL);eJ       XMagnifyWindowCommand(display,windows,event->xkey.state,key_symbol);       break;     }c     case MapNotify:)     { 4       if (event->xmap.window == windows->magnify.id)	         {a'           windows->magnify.mapped=True;"I           XWithdrawWindow(display,windows->info.id,windows->info.screen);)           break;	         }s1       if (event->xmap.window == windows->info.id) 	         {c$           windows->info.mapped=True;           break;	         }        break;     }      case MotionNotify:     {p>       while (XCheckMaskEvent(display,ButtonMotionMask,event));5       if (event->xmotion.window == windows->image.id) $         if (windows->magnify.mapped)           {)             /*%               Update magnified image.              */             x=event->xmotion.x;              y=event->xmotion.y;,             if (x < 0)               x=0;             else,               if (x >= windows->image.width))                 x=windows->image.width-1; 2             windows->magnify.x=windows->image.x+x;             if (y < 0)               y=0;             else,              if (y >= windows->image.height))                y=windows->image.height-1;r2             windows->magnify.y=windows->image.y+y;/             XMakeMagnifyImage(display,windows);r           }        break;     }s     case UnmapNotify:,     { 6       if (event->xunmap.window == windows->magnify.id)	         {h(           windows->magnify.mapped=False;           break;	         }_3       if (event->xunmap.window == windows->info.id)i	         {)%           windows->info.mapped=False;            break;	         }e       break;     },     default:       break;   }  }  i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %tO %                                                                             %vO %                                                                             %tO %   X S e t C r o p G e o m e t r y                                           % O %                                                                             %dO %                                                                             % O %                                                                             %)O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a % H %  Function XSetCropGeometry accepts a cropping geometry relative to theH %  Image window and translates it to a cropping geometry relative to the	 %  image.  %r1 %  The format of the XSetCropGeometry routine is:  %*6 %    XSetCropGeometry(display,windows,crop_info,image) %s+ %  A description of each parameter follows:e %sD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %n< %    o windows: Specifies a pointer to a XWindows structure. %cL %    o crop_info:  A pointer to a RectangleInfo that defines a region of the %      Image window to crop. %,7 %    o image: Specifies a pointer to a Image structure.n %w %o */@ static void XSetCropGeometry(Display *display,XWindows *windows,(   RectangleInfo *crop_info,Image *image) {e   char     text[MaxTextExtent];     intf     x,     y;     unsigned int     height,l
     width;     unsigned longd     scale_factor;t     if (windows->info.mapped))     {        /*+         Display info on cropping rectangle.        */L       (void) sprintf(text," %ux%u%+d%+d",crop_info->width,crop_info->height,#         crop_info->x,crop_info->y);o(       XInfoWidget(display,windows,text);     }    /*@     Cropping geometry is relative to any previous crop geometry.   */   x=0;   y=0;   width=image->columns;w   height=image->rows;i4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height);a   else     {u       /*&         Allocate crop geometry string.       */O       windows->image.crop_geometry=(char *) malloc(MaxTextExtent*sizeof(char));88       if (windows->image.crop_geometry == (char *) NULL)<         Error("Unable to crop X image",windows->image.name);     }    /*@     Define the crop geometry string from the cropping rectangle.   */;   scale_factor=UpShift(width)/windows->image.ximage->width;.   if (crop_info->x > 0)s,     x+=DownShift(crop_info->x*scale_factor);1   width=DownShift(crop_info->width*scale_factor);a   if (width == 0)2     width=1;=   scale_factor=UpShift(height)/windows->image.ximage->height;    if (crop_info->y > 0),,     y+=DownShift(crop_info->y*scale_factor);3   height=DownShift(crop_info->height*scale_factor);i   if (height == 0)
     height=1;;N   (void) sprintf(windows->image.crop_geometry,"%ux%u%+d%+d",width,height,x,y); };   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             % O %                                                                             %aO %                                                                             % O %   X T i l e I m a g e                                                       %tO %                                                                             %vO %                                                                             %rO %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %aE %  Function XTileImage loads or deletes a selected tile from a visualdG %  image directory.  The load or delete command is choosen from a menu.i %o+ %  The format of the XTileImage routine is:e %_F %    tiled_image=XTileImage(display,resource_info,windows,image,event) %h+ %  A description of each parameter follows:l %w@ %    o tiled_image:  XTileImage reads or deletes the tiled imageD %      and returns it.  A null image is returned if an error occurs. %/E %    o display: Specifies a connection to an X server;  returned fromd %      XOpenDisplay. %rK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %eE %    o image: Specifies a pointer to a Image structure; returned froma %      ReadImage.  % H %    o event: Specifies a pointer to a XEvent structure.  If it is NULL,% %      the entire image is refreshed.; %  %  */G static Image *XTileImage(Display *display,XResourceInfo *resource_info, /   XWindows *windows,Image *image,XEvent *event)t {c
   static char      *VerbMenu[]=     {=
       "Load", 
       "Next",u       "Former",t       "Delete",        "Update",v       (char *) NULL,     };     static ModeTypeh     TileCommands[]=      {e       TileLoadCommand,       TileNextCommand,       TileFormerCommand,       TileDeleteCommand,       TileUpdateCommandt     };     char     command[MaxTextExtent],n     filename[MaxTextExtent];     Imagee     *tiled_image;v     inth     id,      status,e	     tile,n     x,     y;     register char      *p,s     *q;i     register int     i;     unsigned int     height, 
     width;     unsigned longe     scale_factor;a     /*:     Tile image is relative to montage image configuration.   */   x=0;   y=0;   width=image->columns;;   height=image->rows;l4   if (windows->image.crop_geometry != (char *) NULL)M     (void) XParseGeometry(windows->image.crop_geometry,&x,&y,&width,&height); ;   scale_factor=UpShift(width)/windows->image.ximage->width; %   event->xbutton.x+=windows->image.x; >   event->xbutton.x=DownShift(event->xbutton.x*scale_factor)+x;=   scale_factor=UpShift(height)/windows->image.ximage->height;r%   event->xbutton.y+=windows->image.y;e>   event->xbutton.y=DownShift(event->xbutton.y*scale_factor)+y;   /*K     Determine size and location of each tile in the visual image directory.    */   x=0;   y=0;   width=image->columns;    height=image->rows;e=   (void) XParseGeometry(image->montage,&x,&y,&width,&height);,@   tile=((event->xbutton.y-y)/height)*((image->columns-x)/width)+     (event->xbutton.x-x)/width;s   if (tile < 0)      {        /*)         Button press is outside any tile.        */       XBell(display,0);"       return((Image *) NULL);s     }i   /*0     Determine file name from the tile directory.   */   p=image->directory; *   for (i=tile; (i != 0) && (*p != '\0'); )   {-     if (*p == '\n') 
       i--;     p++;   }    if (*p == '\0')      {        /*)         Button press is outside any tile.        */       XBell(display,0);w       return((Image *) NULL);n     }s   /**     Select a command from the pop-up menu.   */?   id=XMenuWidget(display,windows,"Tile Verb",VerbMenu,command);m
   if (id < 0)S     return((Image *) NULL);,   q=p;&   while ((*q != '\n') && (*q != '\0'))     q++;!   (void) strncpy(filename,p,q-p);p   filename[q-p]='\0';w   /**     Perform command for the selected tile.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   tiled_image=(Image *) NULL;i   switch (TileCommands[id])    {*     case TileLoadCommand:r     {e       /*         Load tile image.       */,       XCheckRefreshWindows(display,windows);>       (void) strcpy(resource_info->image_info->magick,"MIFF");B       (void) strcpy(resource_info->image_info->filename,filename);7       tiled_image=ReadImage(resource_info->image_info); E       XWithdrawWindow(display,windows->info.id,windows->info.screen);        break;     }      case TileNextCommand:n     {g       /*         Display next image.r       */E       XClientMessage(display,windows->image.id,windows->im_protocols, ,         windows->im_next_image,CurrentTime);       break;     };     case TileFormerCommand:e     {y       /*         Display former image.r       */E       XClientMessage(display,windows->image.id,windows->im_protocols, .         windows->im_former_image,CurrentTime);       break;     }b     case TileDeleteCommand:      {X       /*         Delete tile image.       */"       if (!IsAccessible(filename))	         {)O           XNoticeWidget(display,windows,"Image file does not exist:",filename);            break;	         }vK       status=XConfirmWidget(display,windows,"Really delete tile",filename);        if (status <= 0)         break;       status=remove(filename);       if (status != False)	         {;G           XNoticeWidget(display,windows,"Unable to delete image file:",a             filename);           break;	         }a     }      case TileUpdateCommand:a     { 	       int          x_offset,g         y_offset;e         register int
         j;         register RunlengthPacket         *r;w         /*$         Ensure all the images exist.       */"       if (!UncompressImage(image))         return((Image *) NULL); 
       tile=0;t/       for (p=image->directory; *p != '\0'; p++)w       {;         q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;'         (void) strncpy(filename,p,q-p);          filename[q-p]='\0';          p=q;#         if (IsAccessible(filename))            {C             tile++;              continue;e           } 
         /*/           Overwrite tile with background color.g
         */=         x_offset=width*(tile % ((image->columns-x)/width))+x;a<         y_offset=height*(tile/((image->columns-x)/width))+y;"         for (i=0; i < height; i++)	         { A           r=image->pixels+((y_offset+i)*image->columns+x_offset); #           for (j=0; j < width; j++)s"             *r++=(*image->pixels);	         }i         tile++;(       } 9       windows->image.window_changes.width=image->columns;,7       windows->image.window_changes.height=image->rows;iC       XConfigureImageColormap(display,resource_info,windows,image);eB       (void) XConfigureImage(display,resource_info,windows,image);       break;     }I     default:       break;   }s)   XSetCursorState(display,windows,False);    return(tiled_image); }e i /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %gO %                                                                             %lO %                                                                             % O %   X T r a n s l a t e I m a g e                                             %mO %                                                                             %dO %                                                                             %6O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e % G %  Function XTranslateImage translates the image within an Image window M %  by one pixel as specified by the key symbol.  If the image has a `montage' M %  string the translation is respect to the width and height contained withinX %  the string. %a0 %  The format of the XTranslateImage routine is: %S6 %    XTranslateImage(display,windows,image,key_symbol) %n+ %  A description of each parameter follows:r %oD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %a< %    o windows: Specifies a pointer to a XWindows structure. %tF %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.- %aM %    o key_symbol: Specifies a KeySym which indicates which side of the image. %      to trim.r %; %  */? static void XTranslateImage(Display *display,XWindows *windows, '   Image *image,const KeySym key_symbol)c {n   char     text[MaxTextExtent];     int      x,     y;     unsigned int
     x_offset,c
     y_offset;e     /*)     User specified a pan position offset.    */    x_offset=windows->image.width;!   y_offset=windows->image.height;e&   if (image->montage != (char *) NULL)D     (void) XParseGeometry(image->montage,&x,&y,&x_offset,&y_offset);   switch (key_symbol)"   {e     case XK_Home:p     case XK_KP_Home:     {f1       windows->image.x=windows->image.width >> 1; 2       windows->image.y=windows->image.height >> 1;       break;     }a     case XK_Left:,     case XK_KP_Left:     {m!       windows->image.x-=x_offset;(       break;     };     case XK_Next:s     case XK_Up:w     case XK_KP_Up:     {a!       windows->image.y-=y_offset;        break;     }_     case XK_Right:     case XK_KP_Right:a     {u!       windows->image.x+=x_offset;        break;     }t     case XK_Prior:     case XK_Down:i     case XK_KP_Down:     { !       windows->image.y+=y_offset;_       break;     })     default:
       return;a   }n   /*     Check boundary conditions.   */   if (windows->image.x < 0),     windows->image.x=0;a   elseO     if ((windows->image.x+windows->image.width) > windows->image.ximage->width) I       windows->image.x=windows->image.ximage->width-windows->image.width;x   if (windows->image.y < 0)M     windows->image.y=0;I   else2     if ((windows->image.y+windows->image.height) >'          windows->image.ximage->height)aK       windows->image.y=windows->image.ximage->height-windows->image.height;e   /*     Refresh Image window.    */;   (void) sprintf(text," %ux%u%+d%+d ",windows->image.width,e=     windows->image.height,windows->image.x,windows->image.y);($   XInfoWidget(display,windows,text);(   XCheckRefreshWindows(display,windows);%   XDrawPanRectangle(display,windows); :   XRefreshWindow(display,&windows->image,(XEvent *) NULL);A   XWithdrawWindow(display,windows->info.id,windows->info.screen);s }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %)O %                                                                             %(O %                                                                             %sO %   X T r i m I m a g e                                                       %wO %                                                                             %iO %                                                                             % O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %o= %  Function XTrimImage trims the edges from the Image window.  %e+ %  The format of the XTrimImage routine is:  % ; %    status=XTrimImage(display,resource_info,windows,image)e % + %  A description of each parameter follows:a %h? %    o status: Function XTrimImage returns True if the image is"J %      cropped.  False is returned is there is a memory shortage or if the! %      image fails to be cropped.d %uD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. %oK %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.; % < %    o windows: Specifies a pointer to a XWindows structure.< %    o windows: Specifies a pointer to a XWindows structure. %g7 %    o image: Specifies a pointer to a Image structure.  %  %  */M static unsigned int XTrimImage(Display *display,XResourceInfo *resource_info,i!   XWindows *windows,Image *image)g {d   RectangleInfo      trim_info;     register int     x,     y;     unsigned longi     background,m
     pixel;     /*     Trim edges from image.   */(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);   /*     Crop the left edge.    */2   background=XGetPixel(windows->image.ximage,0,0);/   trim_info.width=windows->image.ximage->width;t2   for (x=0; x < windows->image.ximage->width; x++)   {i5     for (y=0; y < windows->image.ximage->height; y++)      { 1       pixel=XGetPixel(windows->image.ximage,x,y);i       if (pixel != background)         break;     }u*     if (y < windows->image.ximage->height)       break;   }m   trim_info.x=x;2   if (trim_info.x == windows->image.ximage->width)     {u-       XSetCursorState(display,windows,False);e       return(False);     };   /*     Crop the right edge.   */O   background=XGetPixel(windows->image.ximage,windows->image.ximage->width-1,0);s4   for (x=windows->image.ximage->width-1; x > 0; x--)   { 5     for (y=0; y < windows->image.ximage->height; y++)d     {g1       pixel=XGetPixel(windows->image.ximage,x,y);>       if (pixel != background)         break;     } *     if (y < windows->image.ximage->height)       break;   }r"   trim_info.width=x-trim_info.x+1;   /*     Crop the top edge.   */2   background=XGetPixel(windows->image.ximage,0,0);1   trim_info.height=windows->image.ximage->height; 3   for (y=0; y < windows->image.ximage->height; y++)o   {t4     for (x=0; x < windows->image.ximage->width; x++)     {y1       pixel=XGetPixel(windows->image.ximage,x,y);i       if (pixel != background)         break;     }d)     if (x < windows->image.ximage->width)        break;   }    trim_info.y=y;   /*     Crop the bottom edge.    */P   background=XGetPixel(windows->image.ximage,0,windows->image.ximage->height-1);5   for (y=windows->image.ximage->height-1; y > 0; y--);   { 4     for (x=0; x < windows->image.ximage->width; x++)     { 1       pixel=XGetPixel(windows->image.ximage,x,y);e       if (pixel != background)         break;     }e)     if (x < windows->image.ximage->width)        break;   }=#   trim_info.height=y-trim_info.y+1;e2   if ((trim_info.width != windows->image.width) ||2       (trim_info.height != windows->image.height))     {p       /*F         Reconfigure Image window as defined by the trimming rectangle.       */9       XSetCropGeometry(display,windows,&trim_info,image); :       windows->image.window_changes.width=trim_info.width;<       windows->image.window_changes.height=trim_info.height;B       (void) XConfigureImage(display,resource_info,windows,image);     };)   XSetCursorState(display,windows,False);s   return(True);r }l m /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %nO %                                                                             %wO %                                                                             %eO %   X V i s u a l D i r e c t o r y I m a g e                                 %;O %                                                                             %eO %                                                                             %mO %                                                                             %iO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%; % C %  Function XVisualDirectoryImage creates a Visual Image Directory., %d6 %  The format of the XVisualDirectoryImage routine is: %oF %    loaded_image=XVisualDirectoryImage(display,resource_info,windows) %a+ %  A description of each parameter follows:x %tJ %    o loaded_image: Function XVisualDirectoryImage returns a visual imageK %      directory if it can be created successfully.  Otherwise a null image  %      is returned.m %iD %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. %d %- */5 static Image *XVisualDirectoryImage(Display *display, 1   XResourceInfo *resource_info,XWindows *windows)l {m. #define LoadImageText  "  Loading images...  "3 #define TileImageText  "  Scaling image tiles...  "r #define XClientName  "montage"     char     *commands[5],C     **filelist,s     *resource_value,     window_id[MaxTextExtent];s     Imagem     *image,      *montage_image,      *next_image;     ImageInfoe     local_info;,     into     number_files;a     MonitorHandler     handler;     register int     i;  
   static char #     filename[MaxTextExtent] = "\0",S#     filenames[MaxTextExtent] = "*";p     unsigned int
     backdrop;S     XMontageInfo
     vid_info;h     XResourceInfo[     background_resources,i     vid_resources;  
   XrmDatabaser     resource_database;     /*      Request file name from user.   */<   XFileBrowserWidget(display,windows,"Directory",filenames);   if (*filenames == '\0')i     return((Image *) NULL);    /*     Expand the filenames.*   */,   filelist=(char **) malloc(sizeof(char *));!   if (filelist == (char **) NULL)      {e7       Warning("Memory allocation error",(char *) NULL);m       return((Image *) NULL);e     }    number_files=1;i   filelist[0]=filenames;+   ExpandFilenames(&number_files,&filelist);"   if (number_files == 0)     {r5       Warning("No image files were found",filenames);,       return((Image *) NULL);i     },   /*/     Get any Visual Image Directory X resources.r   */5   resource_database=resource_info->resource_database;e!   vid_resources=(*resource_info);iH   vid_resources.background_color=XGetResourceInstance(resource_database,4     XClientName,"background",DefaultTileBackground);O   resource_value=XGetResourceClass(resource_database,XClientName,"borderWidth",      DefaultTileBorderwidth);2   vid_resources.border_width=atoi(resource_value);5   vid_resources.font=resource_info->image_info->font;vH   vid_resources.foreground_color=XGetResourceInstance(resource_database,4     XClientName,"foreground",DefaultTileForeground);F   vid_resources.image_geometry=XGetResourceInstance(resource_database,5     XClientName,"imageGeometry",DefaultTileGeometry);pC   vid_resources.matte_color=XGetResourceInstance(resource_database, /     XClientName,"mattecolor",DefaultTileMatte);d   /*#     Set image background resources.,   */(   background_resources=(*resource_info);+   background_resources.window_id=window_id;UK   (void) sprintf(background_resources.window_id,"0x%lx",windows->image.id);i%   background_resources.backdrop=True;e   /*/     Read each image and convert them to a tile.n   */>   backdrop=(windows->image.visual_info->class == TrueColor) ||6    (windows->image.visual_info->class == DirectColor);*   local_info=(*resource_info->image_info);   image=(Image *) NULL;d)   commands[0]=resource_info->client_name;e   commands[1]="-label";    commands[2]=DefaultTileLabel;y(   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);"   for (i=0; i < number_files; i++)   {>5     handler=SetMonitorHandler((MonitorHandler) NULL);i$     local_info.filename=filelist[i];     *local_info.magick='\0';)     if (local_info.size == (char *) NULL) 3       local_info.size=vid_resources.image_geometry;e&     next_image=ReadImage(&local_info);!     if (filelist[i] != filenames))!       free((char *) filelist[i]);C%     if (next_image != (Image *) NULL)g       {T:         MogrifyImages(&local_info,3,commands,&next_image);          next_image->matte=False;         if (backdrop)n           {dI             (void) XDisplayBackgroundImage(display,&background_resources,                next_image);2             XSetCursorState(display,windows,True);           } $         if (image == (Image *) NULL)           image=next_image;          else           {l#             image->next=next_image; (             image->next->previous=image;             image=image->next;           }        } &     (void) SetMonitorHandler(handler);2     ProgressMonitor(LoadImageText,i,number_files);   }n   free((char *) filelist);   if (image == (Image *) NULL)     { -       XSetCursorState(display,windows,False);D1       Warning("No images were loaded",filenames);n       return((Image *) NULL);,     };+   while (image->previous != (Image *) NULL)l     image=image->previous;   /*&     Create the Visual Image Directory.   */   XGetMontageInfo(&vid_info); ,   (void) strcpy(vid_info.filename,filename);?   montage_image=XMontageImages(&vid_resources,&vid_info,image);(   DestroyImages(image); )   XSetCursorState(display,windows,False);o&   if (montage_image == (Image *) NULL)     return(montage_image);A   XClientMessage(display,windows->image.id,windows->im_protocols, (     windows->im_next_image,CurrentTime);   return(montage_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %SO %                                                                             %;O %                                                                             %(O %   X W a r n i n g                                                           %1O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%l %iC %  Function XWarning displays a warning message in a Notice widget.  % ) %  The format of the XWarning routine is:% %%" %      XWarning(message,qualifier) % + %  A description of each parameter follows:  % G %    o message: Specifies the message to display before terminating the  %      program.  % 9 %    o qualifier: Specifies any qualifier to the message.  %  %  */? static void XWarning(const char *message,const char *qualifier)  {    char     text[MaxTextExtent];     if (message == (char *) NULL)      return;    (void) strcpy(text,message);   (void) strcat(text,":");0   XNoticeWidget(display,windows,text,qualifier); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %                                                                             %rO %    M a i n                                                                  %tO %                                                                             %eO %                                                                             %wO %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %d %  */ int main(int argc,char **argv) {i   char     *client_name,n     density[MaxTextExtent],h     *option,     *resource_value,     *server_name;      float      x_density,     y_density;     Imagea     *image,i     *next_image;     ImageInfol     image_info;D     into     status,d     x,     y;     register int     i,     j;     unsigned int     first_scene,     height,-     *image_marker,     image_number,o     last_scene, 
     scene,
     width;     unsigned longo
     state;     XResourceInfon     resource_info;  
   XrmDatabases     resource_database;     /*     Set defaults.p   */   ReadCommandlLine(argc,&argv);w    client_name=ClientName(*argv);   display=(Display *) NULL;i   first_scene=0;   image=(Image *) NULL;WF   image_marker=(unsigned int *) malloc((argc+1)*sizeof(unsigned int));,   if (image_marker == (unsigned int *) NULL)@     Error("Unable to display image","Memory allocation failed");   for (i=0; i <= argc; i++)i     image_marker[i]=argc;i   image_number=0;w   GetImageInfo(&image_info);   last_scene=0; '   resource_database=(XrmDatabase) NULL;    server_name=(char *) NULL;   state=DefaultState;f   /*8     Check for server name specified on the command line.   */   ExpandFilenames(&argc,&argv);n   for (i=1; i < argc; i++)   {e     /*)       Check command line for server name.)     */     option=argv[i];eH     if ((Extent(option) == 1) || ((*option != '-') && (*option != '+')))       continue;f(     if (strcmp("display",option+1) == 0)       {v
         /*%           User specified server name. 
         */         i++;         if (i == argc)A           Error("Missing server name on -display",(char *) NULL);          server_name=argv[i];         break;       }i(     if (strncmp("help",option+1,2) == 0)       Usage(client_name);    }    /*     Open X server connection..   */$   display=XOpenDisplay(server_name);"   if (display == (Display *) NULL)E     Error("Unable to connect to X server",XDisplayName(server_name));    /*$     Set our forgiving error handler.   */   XSetErrorHandler(XError);    /*/     Get user defaults from X resource database.    */>   resource_database=XGetResourceDatabase(display,client_name);A   XGetResourceInfo(resource_database,client_name,&resource_info);%)   resource_info.image_info=(&image_info); +   (void) strcpy(density,PSDensityGeometry); 7   (void) sscanf(density,"%fx%f",&x_density,&y_density); =   (void) XParseGeometry(PSPageGeometry,&x,&y,&width,&height); 7   (void) sprintf(density,"%f",Min(x_density,y_density)* J     (XDisplayHeight(display,XDefaultScreen(display))-40)/(double) height);   image_info.density= G     XGetResourceClass(resource_database,client_name,"density",density);    resource_value= I     XGetResourceClass(resource_database,client_name,"interlace","plane"); *   image_info.interlace=UndefinedInterlace;0   if (Latin1Compare("none",resource_value) == 0)'     image_info.interlace=NoneInterlace;%0   if (Latin1Compare("line",resource_value) == 0)'     image_info.interlace=LineInterlace;o1   if (Latin1Compare("plane",resource_value) == 0)e(     image_info.interlace=PlaneInterlace;5   if (Latin1Compare("partition",resource_value) == 0)s,     image_info.interlace=PartitionInterlace;1   if (image_info.interlace == UndefinedInterlace) :     Warning("Unrecognized interlace type",resource_value);B   image_info.page=XGetResourceClass(resource_database,client_name,"     "pageGeometry",(char *) NULL);   resource_value=:D     XGetResourceClass(resource_database,client_name,"quality","75");*   image_info.quality=atoi(resource_value);   resource_value= G     XGetResourceClass(resource_database,client_name,"verbose","False");_,   image_info.verbose=IsTrue(resource_value);   /*     Parse command line.i   */7   for (i=1; ((i <= argc) && !(state & ExitState)); i++)a   {      if (i < argc)        option=argv[i];      else       if (image_number != 0)         break;
       else!         if (isatty(STDIN_FILENO))s           option="logo:";          else           option="-";PG     if ((Extent(option) > 1) && ((*option == '-') || (*option == '+')))        switch (*(option+1))       {e         case 'b':r	         {c2           if (strncmp("backdrop",option+1,5) == 0)
             {w6               resource_info.backdrop=(*option == '-');               break;
             }p8           if ((strncmp("background",option+1,5) == 0) ||.               (strncmp("bg",option+1,2) == 0))
             { ;               resource_info.background_color=(char *) NULL; !               if (*option == '-')-                 {                    i++;                    if (i == argc)H                     Error("Missing color on -background",(char *) NULL);9                   resource_info.background_color=argv[i];y                 }                break;
             }a-           if (strcmp("border",option+1) == 0)a
             {a!               if (*option == '-')X                 {:                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -border",(char *) NULL);a                 }a               break;
             } 5           if (strncmp("bordercolor",option+1,7) == 0) 
             {87               resource_info.border_color=(char *) NULL;t!               if (*option == '-')0                 {                    i++;                    if (i == argc)I                     Error("Missing color on -bordercolor",(char *) NULL);%5                   resource_info.border_color=argv[i];                  }                break;
             } 5           if (strncmp("borderwidth",option+1,7) == 0) 
             { +               resource_info.border_width=0; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))I                     Error("Missing width on -borderwidth",(char *) NULL); ;                   resource_info.border_width=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }%         case 'c':%	         {%2           if (strncmp("colormap",option+1,6) == 0)
             {t5               resource_info.colormap=PrivateColormap; !               if (*option == '-')a                 {                    i++;                    if (i == argc)E                     Error("Missing type on -colormap",(char *) NULL); !                   option=argv[i];e;                   resource_info.colormap=UndefinedColormap;_;                   if (Latin1Compare("private",option) == 0) ;                     resource_info.colormap=PrivateColormap;r:                   if (Latin1Compare("shared",option) == 0):                     resource_info.colormap=SharedColormap;B                   if (resource_info.colormap == UndefinedColormap)G                     Error("Invalid colormap type on -colormap",option);*                 }s               break;
             } 0           if (strncmp("colors",option+1,7) == 0)
             {s,               resource_info.number_colors=0;!               if (*option == '-')g                 {e                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL);a<                   resource_info.number_colors=atoi(argv[i]);                 }s               break;
             }y4           if (strncmp("colorspace",option+1,7) == 0)
             {s5               resource_info.colorspace=RGBColorspace;%!               if (*option == '-')%                 {%                   i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; ?                   resource_info.colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0)                     { >                       resource_info.colorspace=GRAYColorspace;6                       resource_info.number_colors=256;1                       resource_info.tree_depth=8;                      } 8                   if (Latin1Compare("ohta",option) == 0)<                     resource_info.colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0)M;                     resource_info.colorspace=RGBColorspace;e?                   if (Latin1Compare("transparent",option) == 0)oC                     resource_info.colorspace=TransparentColorspace; 7                   if (Latin1Compare("xyz",option) == 0) ;                     resource_info.colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0)s=                     resource_info.colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) ;                     resource_info.colorspace=YIQColorspace;s9                   if (Latin1Compare("ypbpr",option) == 0)i=                     resource_info.colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0)t;                     resource_info.colorspace=YUVColorspace;dF                   if (resource_info.colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  },               break;
             } 1           if (strncmp("comment",option+1,4) == 0)t
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);E                 }                break;
             }e2           if (strncmp("compress",option+1,3) == 0)
             { 3               image_info.compression=NoCompression;x!               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL);n!                   option=argv[i];;D                   if (Latin1Compare("runlengthencoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression;d                   else9                     if (Latin1Compare("zip",option) == 0) <                       image_info.compression=ZipCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }c               break;
             }s2           if (strncmp("contrast",option+1,3) == 0)             break;.           if (strncmp("crop",option+1,2) == 0)
             { !               if (*option == '-')i                 {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -crop",(char *) NULL);d                 }                break;
             }a.           Error("Unrecognized option",option);           break;	         }n         case 'd':d	         {y/           if (strncmp("debug",option+1,3) == 0) 
             { 3               resource_info.debug=(*option == '-');d               break;
             }n/           if (strncmp("delay",option+1,3) == 0) 
             { $               resource_info.delay=0;!               if (*option == '-')X                 {a                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing seconds on -delay",(char *) NULL); 4                   resource_info.delay=atoi(argv[i]);                 }a               break;
             } 1           if (strncmp("density",option+1,3) == 0)=
             { /               image_info.density=(char *) NULL;p!               if (*option == '-'),                 {r                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];w                 },               break;
             }(3           if (strncmp("despeckle",option+1,3) == 0)y             break;.           if (strcmp("display",option+1) == 0)
             { (               server_name=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL);3&                   server_name=argv[i];                 } 4               resource_info.server_name=server_name;1               image_info.server_name=server_name;e               break;
             }n1           if (strncmp("dispose",option+1,5) == 0)g
             { /               image_info.dispose=(char *) NULL;n!               if (*option == '-')m                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing method on -dispose",(char *) NULL);A                   image_info.dispose=PostscriptGeometry(argv[i]);k                 }e               break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             {=4               resource_info.dither=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'e': 	         {).           if (strncmp("edge",option+1,2) == 0)
             { !               if (*option == '-')r                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing factor on -edge",(char *) NULL);r                 }                break;
             } 1           if (strncmp("enhance",option+1,2) == 0)e             break;.           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { .           if (strncmp("flip",option+1,3) == 0)             break;.           if (strncmp("flop",option+1,3) == 0)             break;.           if (strncmp("font",option+1,3) == 0)
             {a/               resource_info.font=(char *) NULL; !               if (*option == '-')C                 {w                   i++;                    if (i == argc)F                     Error("Missing font name on -font",(char *) NULL);-                   resource_info.font=argv[i];                  }(               break;
             }g8           if ((strncmp("foreground",option+1,3) == 0) ||.               (strncmp("fg",option+1,2) == 0))            {:              resource_info.foreground_color=(char *) NULL;               if (*option == '-')                {                  i++;w                  if (i == argc)mL                    Error("Missing foreground on -foreground",(char *) NULL);8                  resource_info.foreground_color=argv[i];                }               break;            }/           if (strncmp("frame",option+1,2) == 0) 
             { !               if (*option == '-')a                 {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     Error("Missing geometry on -frame",(char *) NULL);                 }r               break;
             }i.           Error("Unrecognized option",option);           break;	         }e         case 'g':e	         { /           if (strncmp("gamma",option+1,2) == 0);
             {&!               if (*option == '-')                  {r                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))C                     Error("Missing value on -gamma",(char *) NULL);                  }w               break;
             } 2           if (strncmp("geometry",option+1,2) == 0)
             {i9               resource_info.image_geometry=(char *) NULL;E!               if (*option == '-')v                 {o                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))I                     Error("Missing geometry on -geometry",(char *) NULL);p7                   resource_info.image_geometry=argv[i];                  }m               break;
             } .           Error("Unrecognized option",option);           break;	         }e         case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)             Usage(client_name);S.           Error("Unrecognized option",option);           break;	         }a         case 'i': 	         { 6           if (strncmp("iconGeometry",option+1,5) == 0)
             { 8               resource_info.icon_geometry=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))M                     Error("Missing geometry on -iconGeometry",(char *) NULL); 6                   resource_info.icon_geometry=argv[i];                 }                break;
             } 0           if (strncmp("iconic",option+1,5) == 0)
             { 4               resource_info.iconic=(*option == '-');               break;
             }(3           if (strncmp("immutable",option+1,5) == 0) 
             {o7               resource_info.immutable=(*option == '-');                break;
             }x3           if (strncmp("interlace",option+1,3) == 0) 
             {d1               image_info.interlace=NoneInterlace;M!               if (*option == '-')l                 {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace;y9                   if (Latin1Compare("plane",option) == 0)P8                     image_info.interlace=PlaneInterlace;=                   if (Latin1Compare("partition",option) == 0) <                     image_info.interlace=PartitionInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);y                 }                break;
             }x.           Error("Unrecognized option",option);           break;	         }          case 'l':a	         { /           if (strncmp("label",option+1,2) == 0).
             {y!               if (*option == '-')y                 {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }s               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm':*	         {e1           if (strncmp("magnify",option+1,3) == 0)i
             { &               resource_info.magnify=2;!               if (*option == '-')                  {>                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing level on -magnify",(char *) NULL); 6                   resource_info.magnify=atoi(argv[i]);                 }                break;
             } -           if (strncmp("map",option+1,3) == 0)s
             {a               argv[i]="+sans";3               resource_info.map_type=(char *) NULL;;!               if (*option == '-')a                 { "                   argv[i]="-sans";                   i++;                    if (i == argc)D                     Error("Missing map type on -map",(char *) NULL);1                   resource_info.map_type=argv[i];                  }                break;
             } ,           if (strcmp("matte",option+1) == 0)             break;4           if (strncmp("mattecolor",option+1,6) == 0)
             { 6               resource_info.matte_color=(char *) NULL;!               if (*option == '-')>                 {                    i++;                    if (i == argc)H                     Error("Missing color on -mattecolor",(char *) NULL);4                   resource_info.matte_color=argv[i];                 };               break;
             }i4           if (strncmp("monochrome",option+1,3) == 0)
             {i8               resource_info.monochrome=(*option == '-');+               if (resource_info.monochrome)                  { 0                   resource_info.number_colors=2;-                   resource_info.tree_depth=8;o:                   resource_info.colorspace=GRAYColorspace;                 }                break;
             }m.           Error("Unrecognized option",option);           break;	         }g         case 'n': 	         {i.           if (strncmp("name",option+1,2) == 0)
             { /               resource_info.name=(char *) NULL; !               if (*option == '-')o                 {                    i++;                    if (i == argc)A                     Error("Missing name on -name",(char *) NULL);a-                   resource_info.name=argv[i];i                 }u               break;
             } 0           if (strncmp("negate",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0)%
             {%;               image_info.quality=atoi(DefaultImageQuality);r!               if (*option == '-')e                 {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing quality on -quality",(char *) NULL);o3                   image_info.quality=atoi(argv[i]);                  }e               break;
             } .           Error("Unrecognized option",option);           break;	         }X         case 'r': 	         {c/           if (strncmp("raise",option+1,2) == 0)o
             {                i++;:               if ((i == argc) || !sscanf(argv[i],"%d",&x))E                 Error("Missing bevel width on -raise",(char *) NULL);                break;
             }o.           if (strncmp("roll",option+1,3) == 0)
             {c!               if (*option == '-')*                 {n                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -roll",(char *) NULL);e                 }                break;
             }e0           if (strncmp("rotate",option+1,3) == 0)
             {s!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))F                     Error("Missing degrees on -rotate",(char *) NULL);                 }m               break;
             }e.           Error("Unrecognized option",option);           break;	         }          case 's':n	         { 0           if (strncmp("sample",option+1,2) == 0)
             { !               if (*option == '-')i                 {(                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))G                     Error("Missing geometry on -sample",(char *) NULL);                  }i               break;
             }L/           if (strncmp("scene",option+1,3) == 0) 
             {                first_scene=0;               last_scene=0;[!               if (*option == '-')L                 {s                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);,                   first_scene=atoi(argv[i]);)                   last_scene=first_scene;_J                   (void) sscanf(argv[i],"%u-%u",&first_scene,&last_scene);                 }f               break;
             } 1           if (strncmp("segment",option+1,3) == 0)]
             { !               if (*option == '-')X                 {.                   i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))I                     Error("Missing threshold on -segment",(char *) NULL);0                 }                break;
             }c1           if (strncmp("sharpen",option+1,5) == 0),
             {|!               if (*option == '-')M                 {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))F                     Error("Missing factor on -sharpen",(char *) NULL);                 }=               break;
             }c7           if (strncmp("shared_memory",option+1,5) == 0) 
             { ?               resource_info.use_shared_memory=(*option == '-');a               break;
             } .           if (strncmp("size",option+1,2) == 0)
             {r,               image_info.size=(char *) NULL;!               if (*option == '-')                  {m                   i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -size",(char *) NULL);r*                   image_info.size=argv[i];                 }a               break;
             },.           Error("Unrecognized option",option);           break;	         }o         case 't':f	         {,3           if (strncmp("text_font",option+1,3) == 0)w
             {e4               resource_info.text_font=(char *) NULL;!               if (*option == '-')n                 {i                   i++;                    if (i == argc)K                     Error("Missing font name on -text_font",(char *) NULL); 2                   resource_info.text_font=argv[i];                 }>               break;
             }t1           if (strncmp("texture",option+1,5) == 0) 
             { /               image_info.texture=(char *) NULL; !               if (*option == '-')e                 {                    i++;                    if (i == argc)H                     Error("Missing filename on -texture",(char *) NULL);-                   image_info.texture=argv[i];                  }                break;
             }t/           if (strncmp("title",option+1,2) == 0))
             {p0               resource_info.title=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)C                     Error("Missing title on -title",(char *) NULL);r.                   resource_info.title=argv[i];                 }e               break;
             }r3           if (strncmp("treedepth",option+1,3) == 0) 
             {i)               resource_info.tree_depth=0;s!               if (*option == '-'))                 {u                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL);a9                   resource_info.tree_depth=atoi(argv[i]);                  }r               break;
             }a.           Error("Unrecognized option",option);           break;	         }l         case 'u':o	         {t0           if (strncmp("update",option+1,2) == 0)
             {t4               resource_info.update=(*option == '-');!               if (*option == '-')                  {m                   i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing seconds on -update",(char *) NULL);4                   resource_info.delay=atoi(argv[i]);                 }                break;
             } 4           if (strncmp("use_pixmap",option+1,2) == 0)
             { 8               resource_info.use_pixmap=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'v': 	         { 1           if (strncmp("verbose",option+1,2) == 0) 
             { 2               image_info.verbose=(*option == '-');               break;
             }%0           if (strncmp("visual",option+1,2) == 0)
             {o6               resource_info.visual_type=(char *) NULL;!               if (*option == '-')a                 {                    i++;                    if (i == argc)K                     Error("Missing visual class on -visual",(char *) NULL);n4                   resource_info.visual_type=argv[i];                 }s               break;
             }t.           Error("Unrecognized option",option);           break;	         }          case 'w':e	         {g-           if (strcmp("window",option+1) == 0)(
             {y4               resource_info.window_id=(char *) NULL;!               if (*option == '-')                  {n                   i++;                    if (i == argc)C                     Error("Missing id, name, or 'root' on -window",f%                       (char *) NULL);w2                   resource_info.window_id=argv[i];                 }g               break;
             }s6           if (strncmp("window_group",option+1,7) == 0)
             {w7               resource_info.window_group=(char *) NULL;l!               if (*option == '-')e                 {-                   i++;                    if (i == argc)I                     Error("Missing id, name, or 'root' on -window_group", %                       (char *) NULL);o5                   resource_info.window_group=argv[i];                  }                break;
             }o/           if (strncmp("write",option+1,2) == 0) 
             {d9               resource_info.write_filename=(char *) NULL;(!               if (*option == '-')-                 {h                   i++;                    if (i == argc)G                     Error("Missing file name on -write",(char *) NULL);o7                   resource_info.write_filename=argv[i];iA                   if (IsAccessible(resource_info.write_filename))                      {v                       char"                         answer[2];  =                       (void) fprintf(stderr,"Overwrite %s? ", 6                         resource_info.write_filename);B                       (void) fgets(answer,sizeof(answer)-1,stdin);B                       if (!((*answer == 'y') || (*answer == 'Y')))                          exit(1);                     }/                 }x               break;
             }y.           Error("Unrecognized option",option);           break;	         }          case '?':.	         {e           Usage(client_name);            break;	         };         default:	         {m.           Error("Unrecognized option",option);           break;	         }        }r     else<       for (scene=first_scene; scene <= last_scene ; scene++)       { 
         /*L           Option is a file name: begin by reading image from specified file.
         */2         (void) strcpy(image_info.filename,option);&         if (first_scene != last_scene)           {(             char&               filename[MaxTextExtent];               /*2               Form filename for multi-part images.             */?             (void) sprintf(filename,image_info.filename,scene);y:             if (strcmp(filename,image_info.filename) == 0)I               (void) sprintf(filename,"%s.%u",image_info.filename,scene); 8             (void) strcpy(image_info.filename,filename);           }n0         (void) strcpy(image_info.magick,"MIFF");9         image_info.server_name=resource_info.server_name; +         image_info.font=resource_info.font; /         image_info.dither=resource_info.dither;g7         image_info.monochrome=resource_info.monochrome;e%         image=ReadImage(&image_info);a$         if (image == (Image *) NULL)5           if ((i < (argc-1)) || (scene < last_scene))              continue;e           else
             {s               state|=ExitState;d               break;
             } 
         do	         {r           /*J             Transmogrify image as defined by the image processing options.           */"           resource_info.quantum=1;2           MogrifyImage(&image_info,i,argv,&image);(           if (first_scene != last_scene)             image->scene=scene;/           /*&             Display image to X server.           */7           if (resource_info.window_id != (char *) NULL)e
             {                /*6                 Display image to a specified X window.               */K               status=XDisplayBackgroundImage(display,&resource_info,image);                if (status)%)                 state|=RetainColorsState;%+               if (resource_info.delay == 0) !                 state|=ExitState; 
             }            else             do
             {                Image                  *loaded_image;                 /**                 Display image to X server.               */               loaded_image= N                 XDisplayImage(display,&resource_info,argv,argc,&image,&state);1               if (loaded_image == (Image *) NULL)                  break;P               while ((loaded_image != (Image *) NULL) && (!(state & ExitState)))               { ;                 if (loaded_image->montage != (char *) NULL)%                   {%                     /*G                       User selected a visual directory image (montage).I                     */)                     DestroyImages(image);t'                     image=loaded_image;a                     break;                   }(?                 MogrifyImage(&image_info,i,argv,&loaded_image);h.                 if (first_scene != last_scene)%                   image->scene=scene; J                 next_image=XDisplayImage(display,&resource_info,argv,argc,(                   &loaded_image,&state);*                 if (loaded_image != image).                   DestroyImages(loaded_image);(                 loaded_image=next_image;               }e+             } while (!(state & ExitState));p<           if (resource_info.write_filename != (char *) NULL)
             {n               /*                 Write image.               */J               (void) strcpy(image->filename,resource_info.write_filename);3               (void) WriteImage(&image_info,image);t
             }P!           if (image_info.verbose)o.             DescribeImage(image,stderr,False);           /*+             Proceed to next/previous image.d           */           next_image=image; '           if (state & FormerImageState)i5             for (j=0; j < resource_info.quantum; j++)p
             {c.               next_image=next_image->previous;/               if (next_image == (Image *) NULL)s                 break;
             }            else5             for (j=0; j < resource_info.quantum; j++) 
             { *               next_image=next_image->next;/               if (next_image == (Image *) NULL)v                 break;
             } +           if (next_image != (Image *) NULL)n             image=next_image;TI         } while ((next_image != (Image *) NULL) && !(state & ExitState));w
         /*           Free image resources. 
         */         DestroyImages(image);c(         if (!(state & FormerImageState)))           image_marker[i]=image_number++;d         else           {L             /*(               Proceed to previous image.             */!             for (i--; i > 0; i--)o6               if (image_marker[i] == (image_number-2))                 break;"             if (image_number != 0)               image_number--;a           }e         if (state & ExitState)           break;       }x     /*8       Determine if we should proceed to the first image.     */     if (i == (argc-1))       if (!(state & ExitState))r'         if (resource_info.confirm_exit)s           {>             /*#               Confirm program exit.a             */O             status=XConfirmWidget(display,windows,"Do you really want to exit",                client_name);              if (status <= 0)               {a                 i=0;                 image_number=0;;               }i           }p         else7           if (resource_info.window_id != (char *) NULL)i
             {p               i=0;               image_number=0;n
             }d   }i    if (state & RetainColorsState)N     XRetainWindowColors(display,XRootWindow(display,XDefaultScreen(display)));   XSync(display,False);n
   exit(0);   return(False); }t