 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                CCCC   OOO   M   M  BBBB   IIIII  N   N  EEEEE               % O %               C      O   O  MM MM  B   B    I    NN  N  E                   % O %               C      O   O  M M M  BBBB     I    N N N  EEE                 % O %               C      O   O  M   M  B   B    I    N  NN  E                   % O %                CCCC   OOO   M   N  BBBB   IIIII  N   N  EEEEE               % O %                                                                             % O %                                                                             % O %                        Digitally combine two images.                        % O %                                                                             % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                               January 1993                                  % O %                                                                             % O %                                                                             % O %  Copyright 1997 E. I. Dupont de Nemours and Company                         % O %                                                                             % O %  Permission to use, copy, modify, distribute, and sell this software and    % O %  its documentation for any purpose is hereby granted without fee,           % O %  provided that the above Copyright notice appear in all copies and that     % O %  both that Copyright notice and this permission notice appear in            % O %  supporting documentation, and that the name of E. I. Dupont de Nemours     % O %  and Company not be used in advertising or publicity pertaining to          % O %  distribution of the software without specific, written prior               % O %  permission.  E. I. Dupont de Nemours and Company makes no representations  % O %  about the suitability of this software for any purpose.  It is provided    % O %  "as is" without express or implied warranty.                               % O %                                                                             % O %  E. I. Dupont de Nemours and Company disclaims all warranties with regard   % O %  to this software, including all implied warranties of merchantability      % O %  and fitness, in no event shall E. I. Dupont de Nemours and Company be      % O %  liable for any special, indirect or consequential damages or any           % O %  damages whatsoever resulting from loss of use, data or profits, whether    % O %  in an action of contract, negligence or other tortious action, arising     % O %  out of or in connection with the use or performance of this software.      % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ! %  The combine program syntax is:  % ? %  Usage: combine [options ...] image composite [mask] combined  %  %  Where options include: = %    -blend value        blend the two images a given percent @ %    -colors value       preferred number of colors in the image+ %    -compose operator   composite operator H %    -colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV4 %    -comment string     annotate image with comment0 %    -compress type      RunlengthEncoded or ZipE %    -density geometry   vertical and horizontal density of the image L %    -displace geometry  shift image pixels as defined by a displacement map@ %    -display server     obtain image or font from this X server, %    -dispose method     GIF disposal methodG %    -dither             apply Floyd/Steinberg error diffusion to image 5 %    -font name          X11 font for displaying text @ %    -geometry geometry  perferred size or location of the image= %    -gravity direction  which direction to gravitate towards 8 %    -interlace type     None, Line, Plane, or Partition3 %    -label name         assign a label to an image A %    -matte              store matte channel if the image has one ; %    -monochrome         transform image to black and white 8 %    -negate              apply color inversion to imageA %    -page geometry      size and location of the Postscript page - %    -quality value      JPEG quality setting + %    -scene value        image scene number 2 %    -size geometry      width and height of imageJ %    -stereo             combine two images to form red-green stereo image@ %    -tile               repeat composite operation across image? %    -treedepth value    depth of the color classification tree C %    -verbose            print detailed information about the image  % D %  Change '-' to '+' in any option above to reverse its effect.  ForI %  example,  specify +matte to store the image without its matte channel.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "version.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U s a g e                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Procedure Usage displays the program usage; % & %  The format of the Usage routine is: %  %      Usage(client_name)  % J %    o client_name: a character string representing the name of the client %      program.  %  %  */* static void Usage(const char *client_name) {    char     **p;  
   static char      *options[]=      { A       "-blend value        blend the two images a given percent", D       "-colors value       preferred number of colors in the image",L       "-colorspace type    GRAY, OHTA, RGB, XYZ, YCbCr, YIQ, YPbPr, or YUV",8       "-comment string     annotate image with comment",/       "-compose operator   composite operator", 4       "-compress type      RunlengthEncoded or Zip",I       "-density geometry   vertical and horizontal density of the image", P       "-displace geometry  shift image pixels as defined by a displacement map",D       "-display server     obtain image or font from this X server",0       "-dispose method     GIF disposal method",K       "-dither             apply Floyd/Steinberg error diffusion to image", 9       "-font name          X11 font for displaying text", D       "-geometry geometry  perferred size or location of the image",A       "-gravity direction  which direction to gravitate towards", <       "-interlace type     None, Line, Plane, or Partition",7       "-label name         assign a label to an image", E       "-matte              store matte channel if the image has one", ?       "-monochrome         transform image to black and white", <       "-negate              apply color inversion to image",E       "-page geometry      size and location of the Postscript page", 1       "-quality value      JPEG quality setting", /       "-scene value        image scene number", 6       "-size geometry      width and height of image",N       "-stereo             combine two images to form red-green stereo image",D       "-tile               repeat composite operation across image",C       "-treedepth value    depth of the color classification tree", G       "-verbose            print detailed information about the image",        (char *) NULL      };  +   (void) printf("Version: %s\n\n",Version); L   (void) printf("Usage: %s [options ...] image composite [mask] combined\n",     client_name); .   (void) printf("\nWhere options include:\n");+   for (p=options; *p != (char *) NULL; p++)      (void) printf("  %s\n",*p);    (void) printf(M     "\nChange '-' to '+' in any option above to reverse its effect.  For\n");    (void) printf(O     "example,  specify +matte to store the image without an matte channel.\n"); 
   exit(1); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  M a i n                                                                    % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */ int main(int argc,char *argv[])  { + #define NotInitialized  (unsigned int) (~0)      char     *client_name,      *displacement_geometry,      *filename,     *geometry,     *option,     *write_filename;     CompositeOperator      compose;     double
     blend;     Image      *combined_image,     *composite_image,      *image,      *mask_image;     ImageInfo      image_info;      int      gravity,     x,     y;     register int     i;     unsigned int     colorspace,      stereo, 	     tile;      /*!     Initialize program variables.    */   ReadCommandlLine(argc,&argv);     client_name=ClientName(*argv);   if (argc < 4)      Usage(client_name);    /**     Read image and convert to MIFF format.   */   blend=0.0;   colorspace=RGBColorspace;    compose=ReplaceCompositeOp; !   composite_image=(Image *) NULL; &   displacement_geometry=(char *) NULL;   geometry=(char *) NULL;    gravity=NorthWestGravity;    GetImageInfo(&image_info);   image=(Image *) NULL;    mask_image=(Image *) NULL;   stereo=False; 
   tile=False;    write_filename=argv[argc-1];   /*     Check command syntax.    */   filename=(char *) NULL;    for (i=1; i < (argc-1); i++)   {      option=argv[i]; G     if ((Extent(option) < 2) || ((*option != '-') && (*option != '+')))        { 
         /*           Read input images.
         */         filename=argv[i]; 4         (void) strcpy(image_info.filename,filename);$         if (image == (Image *) NULL)           { )             image=ReadImage(&image_info); (             if (image == (Image *) NULL)               exit(1);             continue;            } )         if (mask_image != (Image *) NULL) ;           Error("input images already specified",filename); .         if (composite_image == (Image *) NULL)           { 3             composite_image=ReadImage(&image_info); 2             if (composite_image == (Image *) NULL)               exit(1);             continue;            } *         mask_image=ReadImage(&image_info);)         if (mask_image == (Image *) NULL)            exit(1);       }      else       switch(*(option+1))        {          case 'b': 	         { /           if (strncmp("blend",option+1,3) == 0) 
             {                blend=0.0;!               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))C                     Error("Missing value on -blend",(char *) NULL); &                   blend=atof(argv[i]);+                   compose=BlendCompositeOp;                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'c': 	         { 0           if (strncmp("colors",option+1,7) == 0)
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))E                     Error("Missing colors on -colors",(char *) NULL);                  }                break;
             } 4           if (strncmp("colorspace",option+1,7) == 0)
             { '               colorspace=RGBColorspace; !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing type on -colorspace",(char *) NULL); !                   option=argv[i]; 1                   colorspace=UndefinedColorspace; 8                   if (Latin1Compare("gray",option) == 0).                     colorspace=GRAYColorspace;8                   if (Latin1Compare("ohta",option) == 0).                     colorspace=OHTAColorspace;7                   if (Latin1Compare("rgb",option) == 0) -                     colorspace=RGBColorspace; ?                   if (Latin1Compare("transparent",option) == 0) 5                     colorspace=TransparentColorspace; 7                   if (Latin1Compare("xyz",option) == 0) -                     colorspace=XYZColorspace; 9                   if (Latin1Compare("ycbcr",option) == 0) /                     colorspace=YCbCrColorspace; 7                   if (Latin1Compare("yiq",option) == 0) -                     colorspace=YIQColorspace; 9                   if (Latin1Compare("ypbpr",option) == 0) /                     colorspace=YPbPrColorspace; 7                   if (Latin1Compare("yuv",option) == 0) -                     colorspace=YUVColorspace; 8                   if (colorspace == UndefinedColorspace)K                     Error("Invalid colorspace type on -colorspace",option);                  }                break;
             } 1           if (strncmp("comment",option+1,4) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)G                     Error("Missing comment on -comment",(char *) NULL);                  }                break;
             } 1           if (strncmp("compose",option+1,5) == 0) 
             { )               compose=ReplaceCompositeOp; !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     Error("Missing type on -compose",(char *) NULL);!                   option=argv[i]; /                   compose=UndefinedCompositeOp; 8                   if (Latin1Compare("over",option) == 0),                     compose=OverCompositeOp;6                   if (Latin1Compare("in",option) == 0)*                     compose=InCompositeOp;7                   if (Latin1Compare("out",option) == 0) +                     compose=OutCompositeOp; 8                   if (Latin1Compare("atop",option) == 0),                     compose=AtopCompositeOp;7                   if (Latin1Compare("xor",option) == 0) +                     compose=XorCompositeOp; 8                   if (Latin1Compare("plus",option) == 0),                     compose=PlusCompositeOp;9                   if (Latin1Compare("minus",option) == 0) -                     compose=MinusCompositeOp; 7                   if (Latin1Compare("add",option) == 0) +                     compose=AddCompositeOp; <                   if (Latin1Compare("subtract",option) == 0)0                     compose=SubtractCompositeOp;>                   if (Latin1Compare("difference",option) == 0)2                     compose=DifferenceCompositeOp;;                   if (Latin1Compare("bumpmap",option) == 0) /                     compose=BumpmapCompositeOp; ;                   if (Latin1Compare("replace",option) == 0) /                     compose=ReplaceCompositeOp; 6                   if (compose == UndefinedCompositeOp)E                     Error("Invalid compose type on -compose",option);                  }                break;
             } 2           if (strncmp("compress",option+1,3) == 0)
             { 3               image_info.compression=NoCompression; !               if (*option == '-')                  {                    i++;                    if (i == argc)E                     Error("Missing type on -compress",(char *) NULL); !                   option=argv[i]; D                   if (Latin1Compare("runlengthencoded",option) == 0)G                     image_info.compression=RunlengthEncodedCompression;                    else9                     if (Latin1Compare("zip",option) == 0) <                       image_info.compression=ZipCompression;                     elseL                       Error("Invalid compression type on -compress",option);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'd': 	         { 1           if (strncmp("density",option+1,3) == 0) 
             { /               image_info.density=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))H                     Error("Missing geometry on -density",(char *) NULL);-                   image_info.density=argv[i];                  }                break;
             } /           if (strcmp("displace",option+1) == 0) 
             { 2               displacement_geometry=(char *) NULL;!               if (*option == '-')                  {                    i++;H                   if ((i == argc) || !sscanf(argv[i],"%f",(float *) &x))I                     Error("Missing geometry on -displace",(char *) NULL); 0                   displacement_geometry=argv[i];.                   compose=DisplaceCompositeOp;                 }                break;
             } .           if (strcmp("display",option+1) == 0)
             { 3               image_info.server_name=(char *) NULL; !               if (*option == '-')                  {                    i++;                    if (i == argc)K                     Error("Missing server name on -display",(char *) NULL); 1                   image_info.server_name=argv[i];                  }                break;
             } 1           if (strncmp("dispose",option+1,5) == 0) 
             { /               image_info.dispose=(char *) NULL; !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))F                     Error("Missing method on -dispose",(char *) NULL);A                   image_info.dispose=PostscriptGeometry(argv[i]);                  }                break;
             } 0           if (strncmp("dither",option+1,3) == 0)
             { 1               image_info.dither=(*option == '-');                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'f': 	         { (           image_info.font=(char *) NULL;           if (*option == '-') 
             {                i++;               if (i == argc)B                 Error("Missing font name on -font",(char *) NULL);&               image_info.font=argv[i];
             }            break;	         }          case 'g': 	         { 2           if (strncmp("geometry",option+1,2) == 0)
             { %               geometry=(char *) NULL; !               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))I                     Error("Missing geometry on -geometry",(char *) NULL); #                   geometry=argv[i];                  }                break;
             } 1           if (strncmp("gravity",option+1,2) == 0) 
             { '               gravity=NorthWestGravity; !               if (*option == '-')                  {                    i++;                    if (i == argc)D                     Error("Missing type on -gravity",(char *) NULL);!                   option=argv[i];                    gravity=(-1); :                   if (Latin1Compare("Forget",option) == 0)*                     gravity=ForgetGravity;=                   if (Latin1Compare("NorthWest",option) == 0) -                     gravity=NorthWestGravity; 9                   if (Latin1Compare("North",option) == 0) )                     gravity=NorthGravity; =                   if (Latin1Compare("NorthEast",option) == 0) -                     gravity=NorthEastGravity; 8                   if (Latin1Compare("West",option) == 0)(                     gravity=WestGravity;:                   if (Latin1Compare("Center",option) == 0)*                     gravity=CenterGravity;8                   if (Latin1Compare("East",option) == 0)(                     gravity=EastGravity;=                   if (Latin1Compare("SouthWest",option) == 0) -                     gravity=SouthWestGravity; 9                   if (Latin1Compare("South",option) == 0) )                     gravity=SouthGravity; =                   if (Latin1Compare("SouthEast",option) == 0) -                     gravity=SouthEastGravity; :                   if (Latin1Compare("Static",option) == 0)*                     gravity=StaticGravity;&                   if (gravity == (-1))E                     Error("Invalid gravity type on -gravity",option);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'h': 	         { .           if (strncmp("help",option+1,2) == 0)
             { !               Usage(client_name);                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'i': 	         { 3           if (strncmp("interlace",option+1,3) == 0) 
             { 1               image_info.interlace=NoneInterlace; !               if (*option == '-')                  {                    i++;                    if (i == argc)F                     Error("Missing type on -interlace",(char *) NULL);!                   option=argv[i]; :                   image_info.interlace=UndefinedInterlace;8                   if (Latin1Compare("none",option) == 0)7                     image_info.interlace=NoneInterlace; 8                   if (Latin1Compare("line",option) == 0)7                     image_info.interlace=LineInterlace; 9                   if (Latin1Compare("plane",option) == 0) 8                     image_info.interlace=PlaneInterlace;=                   if (Latin1Compare("partition",option) == 0) <                     image_info.interlace=PartitionInterlace;A                   if (image_info.interlace == UndefinedInterlace) I                     Error("Invalid interlace type on -interlace",option);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'l': 	         { /           if (strncmp("label",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;                    if (i == argc)H                     Error("Missing label name on -label",(char *) NULL);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'm': 	         { /           if (strncmp("matte",option+1,5) == 0)              break;4           if (strncmp("monochrome",option+1,2) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'n': 	         { 0           if (strncmp("negate",option+1,3) == 0)             break;.           Error("Unrecognized option",option);           break;	         }          case 'p': 	         { .           if (strncmp("page",option+1,3) == 0)
             { ,               image_info.page=(char *) NULL;!               if (*option == '-')                  {                    i++;                    if (i == argc)J                     Error("Missing page geometry on -page",(char *) NULL);>                   image_info.page=PostscriptGeometry(argv[i]);                 }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'q': 	         { 1           if (strncmp("quality",option+1,2) == 0) 
             { ;               image_info.quality=atoi(DefaultImageQuality); !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing quality on -quality",(char *) NULL); 3                   image_info.quality=atoi(argv[i]);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 's': 	         { /           if (strncmp("scene",option+1,2) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))J                     Error("Missing scene number on -scene",(char *) NULL);                 }                break;
             } .           if (strncmp("size",option+1,2) == 0)
             { ,               image_info.size=(char *) NULL;!               if (*option == '-')                  {                    i++;:                   if ((i == argc) || !IsGeometry(argv[i]))E                     Error("Missing geometry on -size",(char *) NULL); *                   image_info.size=argv[i];                 }                break;
             } 0           if (strncmp("stereo",option+1,2) == 0)
             { &               stereo=(*option == '-');               break;
             } .           Error("Unrecognized option",option);           break;	         }          case 't': 	         { .           if (strncmp("tile",option+1,2) == 0)
             { $               tile=(*option == '-');               break;
             } .           Error("Unrecognized option",option);3           if (strncmp("treedepth",option+1,3) == 0) 
             { !               if (*option == '-')                  {                    i++;>                   if ((i == argc) || !sscanf(argv[i],"%d",&x))G                     Error("Missing depth on -treedepth",(char *) NULL);                  }                break;
             } .           Error("Unrecognized option",option);           break;	         }          case 'v': 	         { .           image_info.verbose=(*option == '-');           break;	         }          case '?': 	         {            Usage(client_name);            break;	         }          default:	         { .           Error("Unrecognized option",option);           break;	         }        }    } G   if ((image == (Image *) NULL) || (composite_image == (Image *) NULL))      Usage(client_name); #   if (mask_image != (Image *) NULL)      { H       CompositeImage(composite_image,AddMaskCompositeOp,mask_image,0,0);       DestroyImage(mask_image);      } "   if (compose == BlendCompositeOp)     {        register RunlengthPacket         *p;          unsigned short         index;         /*#         Create mattes for blending.        */       index=(unsigned short)B         (DownScale(MaxRGB)-(((int) DownScale(MaxRGB)*blend)/100));       image->class=DirectClass;        image->matte=True;       p=image->pixels;(       for (i=0; i < image->packets; i++)       {          p->index=index;          p++;       } 7       index=(unsigned short) (DownScale(MaxRGB)-index); )       composite_image->class=DirectClass; "       composite_image->matte=True;        p=composite_image->pixels;2       for (i=0; i < composite_image->packets; i++)       {          p->index=index;          p++;       }      } %   if (compose == DisplaceCompositeOp) 4     composite_image->geometry=displacement_geometry;   /*     Combine image.   */
   if (stereo) 6     combined_image=StereoImage(image,composite_image);   else
     if (tile)        { 
         /*#           Tile the composite image. 
         */<         for (y=0; y < image->rows; y+=composite_image->rows)D           for (x=0; x < image->columns; x+=composite_image->columns)>             CompositeImage(image,compose,composite_image,x,y);         combined_image=image;        }      else       {          unsigned int           size;   
         /*$           Digitally composite image.
         */         x=0;         y=0;&         if (geometry != (char *) NULL)<           (void) XParseGeometry(geometry,&x,&y,&size,&size);         switch (gravity)	         {             case NorthWestGravity:             break;           case NorthGravity:           { >             x+=(image->columns-composite_image->columns) >> 1;             break;           }             case NorthEastGravity:           { 7             x+=image->columns-composite_image->columns;              break;           }            case WestGravity:            { 8             y+=(image->rows-composite_image->rows) >> 1;             break;           }            case ForgetGravity:            {              char&               geometry[MaxTextExtent];               /*>               Stretch composite to the same size as the image.             */H             (void) sprintf(geometry,"%ux%u",image->columns,image->rows);D             TransformImage(&composite_image,(char *) NULL,geometry);             break;           }            case StaticGravity:            case CenterGravity:            default:           { >             x+=(image->columns-composite_image->columns) >> 1;8             y+=(image->rows-composite_image->rows) >> 1;             break;           }            case EastGravity:            { 7             x+=image->columns-composite_image->columns; 8             y+=(image->rows-composite_image->rows) >> 1;             break;           }             case SouthWestGravity:           { 1             y+=image->rows-composite_image->rows;              break;           }            case SouthGravity:           { >             x+=(image->columns-composite_image->columns) >> 1;1             y+=image->rows-composite_image->rows;              break;           }             case SouthEastGravity:           { 7             x+=image->columns-composite_image->columns; 1             y+=image->rows-composite_image->rows;              break;           } 	         } :         CompositeImage(image,compose,composite_image,x,y);         combined_image=image;        } '   if (combined_image == (Image *) NULL)      exit(1);   /*     Write image.   */9   (void) strcpy(combined_image->filename,write_filename);    /*B     Transmogrify image as defined by the image processing options.   */6   MogrifyImage(&image_info,argc,argv,&combined_image);0   (void) WriteImage(&image_info,combined_image);   if (image_info.verbose) /     DescribeImage(combined_image,stderr,False); 
   exit(0);   return(False); } 