'\" t
.TH XTDB l "October 22 1990" "X Version 11"
.SH NAME
xtdb \- X window system interface to the tdb debugger.
.SH SYNOPSIS
.B xtdb
[ \fI-toolkit option ... \fP] [\fI-xtdb option ... \fP] [\fI-tdb option ... \fP] [\fIobjfile\fP 
]
.SH DESCRIPTION
\fIXtdb\fP is a graphical user interface to the \fItdb\fP debugger under the
X Window System.  It provides visual feedback and mouse input for the
user to control program execution through breakpoints, to examine and
traverse the function call stack, to display values of
variables and data structures, and to browse source files and functions.
.LP
\fIXtdb\fP allows initial tdb commands stored in the file \fI.tdbinit\fP 
to be executed immediately after the symbolic information is 
read.  If \fI.tdbinit\fP does not exist in the current directory, the 
user's home directory is searched (\fI~/.tdbinit\fP).
.LP
\fIObjfile\fP is an object file produced by a compiler with the
appropriate option (-g) specified to produce symbol table
information for tdb.  If no \fIobjfile\fP is specified,
the \fBdebug\fP command can be used later to specify the program to be
debugged.
.LP
The name of the debugger invoked by \fIxtdb\fP is, by default, tdb, but
it can be overridden with the environment variable DEBUGGER. This is not
recommended since \fIxtdb\fP has been customised for \fItdb\fP(1) only.
.SH OPTIONS
\fIXtdb\fP accepts all of the standard X Toolkit command line options 
(see \fIX\fP(1)), and all the tdb options (see \fItdb\fP(1)), plus
the following xtdb specific options:
.IP -bigicon
Uses a 64x64 icon instead of the default 48x48 icon.
.SH SUBWINDOWS
\fIXtdb\fP consists of the following subwindows:
.IP "File Window" 20
Display the full pathname of the file displayed in the source window,
and the line number of the caret.
.IP "Source Window" 20
Display the contents of a source file.
.IP "Message Window" 20
Display the execution status and error messages of \fIxtdb\fP .
.IP "Command Window" 20
Provide a list of the common tdb commands which are invoked by simply
clicking the LEFT mouse button.
.IP "Dialogue Window" 20
Provide a typing interface to tdb.
.IP "Display Window" 20
Provide a window for displaying variables each time execution stops.
.LP
The relative sizes of the source window, command window, and the dialogue
window can be adjusted by dragging the grip (a small square near the
right edge of a horizontal border) with the LEFT mouse button down.
.SH SELECTION
Text selection in the source window is modified to make it easier to
select C expressions.  LEFT mouse button down selects a C expression by
highlighting it in reverse-video.  LEFT mouse button down also positions the
caret and updates the line label accordingly.
.LP
C expression selection is based on the resource \fIdelimiters\fP which
determines the set of characters that delimits a C expression.  (The
default word selection behavior in the Athena text widget selects a
word delimited by white spaces.)  Text selection adjustment is possible
by holding the LEFT mouse button down and dragging.
.LP
A LEFT mouse button click with the SHIFT button down prints the value
of the expression selected.
.LP
.SH SCROLLBAR
Pressing the LEFT mouse button scrolls the text forward, whereas
pressing the RIGHT mouse button scrolls the text backward.  The amount
of scrolling depends on the distance of the pointer button away from
the top of the scrollbar.  If the button is pressed at the top of the
scrollbar, only one line of text is scrolled.  If the button is pressed
at the bottom of the scrollbar, one screenful of text is scrolled.
.LP
Pressing the MIDDLE mouse button changes the thumb position of the
scrollbar.  Dragging the MIDDLE mouse button down moves the thumb along
and changes the text displayed.
.SH COMMAND BUTTONS
.SS "Execution Commands"
.IP "\fBrun\fP" 12
Begin program execution. This can only be called to run the process, once the
arguments are set up via the \fBrun\fP command.
.IP "\fBcont\fP"
Continue execution from where it stopped.
.IP "\fBstep\fP"
Execute one source line, stepping into a function if the source line
contains a function call.
.IP "\fBnext\fP"
Execute one source line, without stepping into any function call.
.LP
.SS "Breakpoint Commands"
.IP "\fBstop at\fP" 10
Stop program execution at the line selected.  To set a breakpoint in
the program, place the caret on the source line and click the \fBstop
at\fP button.  A stop sign will appear next to the source line.
.IP "\fBstop in\fP"
Stop program execution in the function selected.  To set a breakpoint
in a function, select the function name and click the \fBstop in\fP
button.  A stop sign will be placed near the first executable line of
the function.
.IP "\fBdelete\fP"
Remove the breakpoint on the source line selected or the breakpoint
number selected.
.IP "\fBstatus\fP"
Show the current breakpoints and traces.
.sp
.LP
.SS "Stack Commands"
.IP "\fBwhere\fP" 10
Show a stack trace of the functions called.
.IP "\fBup\fP"
Move up one level on the call stack.
.IP "\fBdown\fP"
Move down one level on the call stack.
.sp
.LP
.SS "Data Display Commands"
.IP "\fBprint\fP" 10
Print the value of a selected expression.
.IP "\fBprint *\fP"
Print the value of the object the selected expression is pointing to.
.IP "\fBdisplay\fP"
Display the value of a selected expression in the display window,
updating its value every time execution stops.
.IP "\fBundisplay\fP"
Stop displaying the value of the selected expression in the display
window.  If the selected expression is a constant, it refers to the
display number associated with an expression in the display window.
.IP "\fBdump\fP"
Print the names and values of local variables and parameters in the
current or selected function.
.sp
.LP
.SS "Miscellaneous Commands"
.IP "\fBfunc\fP"
Display a selected function on the source window, and change the scope
for variable name resolution to the selected function.  The file scope
is changed to the file containing the function.
.IP "\fBfile\fP"
Pop up a directory browser that allows the user to move up and down
in the directory tree, to select a text file to be displayed, or to select an
executable file to debug.  Directory entries are marked with a trailing slash
(`/') and executables with a trailing asterisk (`*').  Filenames beginning with
a dot (`.') or ending with a tilde (`~') are not listed in the menu.
.IP "\fBsearch\fP"
Pop up a search panel which allows both forward (>>) and reverse (<<)
search of text strings in the source file.  Hitting carriage return
after entering the search string will begin a forward search and pop
down the search panel.
.IP "\fBquit\fP"
Exit \fIxtdb\fP.
.SH COMMAND LINE COMMANDS
.IP "\fBrun\fP \fIparfile\fP proc\fIn\fP`\fIfname\fP{\fIx\fP}"
Run the debugger, using the given \fIparfile\fP, while watching the function
\fIfname\fP on  processor \fIn\fP. \fIx\fP is the number of the instance of
function \fIfname\fP on that processor. If a \fIcs_build\fP program is being
debugged, and a process from that needs to be watched, the process must have
the 'debug' option applied to it via the \fIcs_option\fP call and \fIxtdb\fP
must be told to run this rather than \fImrun\fP. This is done by setting the
\fBMRUN\fP environment variable to the name of the program to invoke.
.IP "\fBsh\fP command-line"
Pass the command line to  the  shell  for  execution. The \fBSHELL\fP
environment variable determines which shell is used.
.IP "\fBalias\fP \fInew-command-name character-sequence\fP"
Respond to \fInew-command-name\fP as though it were \fIcharacter-sequence\fP.
Special characters occurring in \fIcharacter-sequence\fP must be enclosed in
quotation marks. Alias substitution as with the  C-Shell (\fIcsh\fP(1)) also
occurs.
.IP "\fBhelp\fP [ command ]"
Display a synopsis of \fItdb\fP commands, or print a  short message explaining
\fIcommand\fP. 
.IP "\fBmake\fP"
Invoke \fImake\fP(1) with the name of the  program  as  its argument.   Any
arguments  set using \fBtdbenv makeargs\fP are also passed as arguments.
.IP "\fBsource\fP filename"
Read and execute \fItdb\fP commands from \fIfilename\fP. Useful when the
\fIfilename\fP has been created by redirecting an earlier \fIstatus\fP command.
.IP "\fBtdbenv\fP
\fBtdbenv case sensitive\fP | \fBinsensitive\fP
.br
\fBtdbenv makeargs\fP \fIstring\fP
.br
\fBtdbenv stringlen\fP \fInum\fP
.br
\fBtdbenv speed\fP \fIseconds\fP
.sp
Display \fItdb\fP attributes or set the named attribute:
.RS
.TP .85i
.B case
Controls whether upper- and lower-case characters are treated as different
values.  The default is
.BR sensitive .
.TP
.B makeargs
Sets arguments to pass to
.IR make (1).
The default is \fB"CC=cc \-g"\fR.
.TP
.B speed
Set the interval between execution during tracing.  The default is
0.5 seconds.
.TP 
.B stringlen
Controls the maximum number of characters printed for a ``char *''
variable in a C program.  The default is 512.
.RE
.
.TP 
.B kill
Stop debugging of the current program, but be ready to debug another.
.
.sp
.LP
.SS "Displaying C Data Structures"
\fIXtdb\fP provides some primitive support for graphically displaying C
structures and the ability of following pointers.  Pressing the RIGHT
mouse button on the \fBprint\fP (or \fBprint *\fP) command button
displays the value of the selected expression (or the value the
selected expression is pointing to) in a popup.  If the value is a
pointer or a structure containing pointers, the user can examine the
value of the object that pointer is pointing to by clicking the pointer
value.  This will create another popup that displays the object the
pointer points to.  Clicking the label of the popup pops down itself
and all of its descendants.
.SH X DEFAULTS
To change the default values of widget resources used in \fIxtdb\fP,
you need to reference the widgets by name or by class.  The widget
hierarchies for the main window, the file menu, the search dialog box,
and the popup data display used in xtdb are shown as follows, with the
name of the widget followed by the name of its class in parentheses:
.nf

Main window:
    toplevel (ToplevelShell)
      vpane (Paned)
	fileWindow (Form)
	  fileLabel (Label)
	  lineLabel (Label)
	sourceForm (Form)
	  sourceWindow (AsciiText)
	messageWindow (Label)
	commandWindow (Box)
	  run (Command)
	  cont (Command)
	  next (Command)
	  return (Command)
	  step (Command)
	  stop at (Command)
	  stop in (Command)
	  delete (Command)
	  where (Command)
	  up (Command)
	  down (Command)
	  print (Command)
	  print * (Command)
	  func (Command)
	  file (Command)
	  status (Command)
	  display (Command)
	  undisplay (Command)
	  dump (Command)
	  search (Command)
	  quit (Command)
	dialogWindow (AsciiText)
	displayWindow (AsciiText)
   
File menu:
    File Directory (TransientShell)
      popup (Paned)
	fileMenuLabel (Label)
	fileMenu (List)
	cancelButton (Command)

Search dialog box:
    Search (TransientShell)
      searchPopup (Dialog)
	<< (Command)
	>> (Command)
	DONE (Command)

Data display popup:
    Data Popup (TransientShell)
      popup (Form)
	label (Label)
	dataDpyWindow (AsciiText)
.fi
.LP
In addition to the standard X resources, \fIxtdb\fP uses the following
application-specific resources for user customization.  The value in
parentheses is the default value.
.IP \fBbell\fP
If True, the bell is on. (True)
.IP \fBdisplayWindow\fP
If True, the display window appears on start up. (False)
.IP \fBdelimiters\fP
The set of delimiters for word selection. (" !%^&*()+=~|;:{},/#<?\"\n\t")
.IP \fBprompt\fP
The prompt string used in xtdb. ("(xtdb) ")
.IP \fBstop_color\fP
Color of the stop sign. (Red)
.IP \fBarrow_color\fP
Color of the arrow sign. (Blue)
.IP \fBupdown_color\fP
Color of the updown sign. (Blue)
.IP \fBbomb_color\fP
Color of the bomb sign. (Red)
.IP \fBdataDpyMaxHeight\fP
Maximum height of the data display window. (300)
.IP \fBdataDpyMaxWidth\fP
Maximum width of the data display window. (600)
.LP
.sp
.SH ENVIRONMENT
.LP
.fi
Tdb checks the following environment variables
.IP "\fBDEBUGGER\fP"
For the name of the debugger invoked by \fIxtdb\fP. This is by default,
\fItdb\fP This is not recommended since \fIxtdb\fP has been customised for
\fItdb\fP(1) only. 
.IP "\fIEDITOR\fP"
for the name of the text editor to use with the \fBedit\fP command.
.IP "\fIMRUN\fP"
for the name of the program to run to boot the program, instead of
\fImrun\fP(1), for running \fICS-Build\fP programs.
.sp
.LP
.sp
.SH FILES
.TS
tab(:);
l l .
m.out:default object file
\&.tdbinit:local initial commands file
~/.tdbinit:user's initial commands file
.TE
.SH SEE ALSO
X(1), tdb(1), mcc, mf77
.SH LIMITATIONS
.sp
Xtdb and xdbx do not handle all the tdb/dbx commands properly.  Only a subset
of the commands is supported:
.sp
.TS
center tab(:);
l l l l l l l .
run:stop at:where:print:list:display:return
cont:stop in:up:dump:/:undisplay
next:delete:down:func:?
step:status:use:file:quit
alias:help:kill:make:sh:source:tdbenv
.TE
.sp
.SH BUGS
This program is now Meiko CSTOOLS \fItdb\fP(1) specific. The more general
version, xdbx is not.
The \fBrun\fP command now takes an extra argument (compared to standard
\fIdbx\fB(1), the name of the \fIparfile\fB or program to debug.
.sp
.SH COPYRIGHT
Copyright 1989 The University of Texas at Austin
.br
Copyright 1990 Microelectronics and Computer Technology Corporation
.br
.SH AUTHOR
Po Cheung
.br
David Beckett (Additions for tdb) djb1@ukc.ac.uk
