// colorlib.h
// This is the class which will take care of keeping track of the
// colorlist which will be read in from a file.

#ifndef __COLORLIB_H
#define __COLORLIB_H

#include <X11/Intrinsic.h>

#include "types.h"

class Colorlib {
	int count;
	int size;
	colorstruct *thecolors;

	void grow(void);
	int findindex(colorstruct &acolor);

public:
	Colorlib();
	~Colorlib();

	// Add the element 'acolor' to 'thecolors'
	void add(colorstruct &acolor);
	
	// Delete the element 'acolor' from 'thecolors'
	void del(colorstruct &acolor);
	
	// Return a count of the number of elements in 'thecolors'
	int cursize(void) { return count; }

	// Given 'index' into 'thecolors', and an element 'R', 'G', or
	// 'B' return the red, green or blue value, respectively
	int getcolorvalue(int index, int element);

	// Given 'index' into 'thecolors' return a string containing
	// the 'name' of that color
	String getcolorname(int index);

	// Return an array of Strings pointing to the color names.
	String* getcolornamearray(void);

	// Sort 'thecolors' alphabetically according to their 'name's
	void sort(void);

	// Print out all of 'thecolors' and their red, green and blue values
	void print(void);
	};

#endif

