// colorlib.c
// This is the class which will take care of keeping track of the
// colorlist which will be read in from a file.

#include <iostream.h>
#include <stdlib.h>

#include "colorlib.h"

Colorlib::Colorlib() {
	size = 4;
	count = 0;
	thecolors = new colorstruct[size];
	}

Colorlib::~Colorlib() {
	delete [] thecolors;
	}

void Colorlib::grow(void) {
	int newsize = size * 2;
	colorstruct *newcolors = new colorstruct[newsize];

	for (int i=0; i<size; i++) 
		newcolors[i] = thecolors[i];

	delete [] thecolors;

	size = newsize;
	thecolors = newcolors;
	}

int Colorlib::findindex(colorstruct &acolor) {
	int i;
	for (i=0; i<count; i++)
		if (!(strcmp(this->thecolors[i].name, acolor.name)))
			break;

	return i;
	}

void Colorlib::add(colorstruct &acolor) {
	int i = findindex(acolor);

	if (i == count) {
		if (count == size)
			grow();
		count++;
		this->thecolors[i] = *new colorstruct(acolor);
		}
	}

void Colorlib::del(colorstruct &acolor) {
	int i = findindex(acolor);

	if (i != count) {
		count--;
		if (count > 0) 
			this->thecolors[i].name = this->thecolors[count].name;
		}
	}

int Colorlib::getcolorvalue(int index, int element) {
	switch (element) {
		case R: return this->thecolors[index].red;   break;
		case G: return this->thecolors[index].green; break;
		case B:	return this->thecolors[index].blue;  break;
		}
	
	return 0; // Make the compiler happy. We would never call this with element not in {R, G, B}
	}

String Colorlib::getcolorname(int index) {
	return this->thecolors[index].name;
	}

String *Colorlib::getcolornamearray(void) {
	String *names = new String[count];

	for (int i=0; i<count; i++) {
		names[i] = (String)malloc(strlen(this->thecolors[i].name));
		strcpy(names[i], this->thecolors[i].name);
		}

	return names;
	}

int colorstructcompare(colorstruct *a, colorstruct *b) {
    return strcmp(a->name, b->name);
    }

void Colorlib::sort(void) {
	qsort(this->thecolors, count, sizeof(colorstruct), colorstructcompare);
	}

void Colorlib::print(void) {
	for (int i=0; i<count; i++) 
		cerr << this->thecolors[i].name << " -> R" 
			 << this->thecolors[i].red << " G" 
			 << this->thecolors[i].green << " B" 
			 << this->thecolors[i].blue << "\n";
	}

