/*
** types.h
*/

/*
** Copyright 1999 by Todd Allen.  All Rights Reserved.  Permission to use,
** copy, modify, distribute, and sell this software and its documentation for
** any purpose is hereby granted without fee, provided that the above
** copyright notice appear in all copies and that both the copyright notice
** and this permission notice appear in supporting documentation.
**
** No representations are made about the suitability of this software for any
** purpose.  It is provided ``as is'' without express or implied warranty,
** including but not limited to the warranties of merchantability, fitness
** for a particular purpose, and noninfringement.  In no event shall Todd
** Allen be liable for any claim, damages, or other liability, whether in
** action of contract, tort, or otherwise, arising from, out of, or in
** connection with this software.
*/

#ifndef __TYPES_H
#define __TYPES_H

#ifdef DEBUG_ALL
#define DEBUG_MACHINES
#define DEBUG_COMMAND
#define DEBUG_STATE
#define DEBUG_EXEC
#define DEBUG_EXEC_OUTPUT
#define DEBUG_TIMEOUT
#define DEBUG_PENDING
#define DEBUG_RETRY
#endif

#include "x_util.h"
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/xpm.h>
#include <X11/Xmu/Converters.h>
#include <sys/time.h>

typedef enum {
   Up,
   Down,
   WasDown,
} State;
#define NUM_STATES 3

#define NOT_RUNNING  (0)

extern  struct timeval  end_of_time;

typedef struct Machine   Machine;
typedef Machine*         Grid;
typedef struct XPingRec  XPingRec;
typedef struct Cmd       Cmd;
typedef Machine**        Heap;

struct Machine {
   XPingRec*       xping;
   String          name;
   Widget          button;
   Widget          label;
   Widget          light;
   State           state;
   int             retries;
   Boolean         check_requested;
   int             pending;
   pid_t           pid;  
   struct timeval  last_info;
};

struct Cmd {
   String   str;
   Boolean  present;
   String*  args;
   int      arg_num;
};

struct XPingRec {
   /*
   ** Resources
   */
   String          machine_str;
   XpmIcon         icons[NUM_STATES];
   Cmd             ping_command;
   Cmd             button2_command;
   Cmd             button3_command;
   Boolean         regular;
   int             delay;
   int             num_retries;
   String          bitmap_position;
   Boolean         history_warning;
   Boolean         auto_depress;
   int             max_parallel;
   
   /*
   ** Internal State
   */
   XtAppContext    context;
   XtJustify       text_justify;
   Boolean         bitmap_left;
   Grid            machines;
   int             numrows;
   int             numcolumns;
   int             nummachines;
   int             num_parallel;
   Heap            pending;
   int             num_pending;
   int             num_states;
   Dimension       light_height;
   Dimension       light_width;
   XpmIcon         padded_icons[NUM_STATES];
   Boolean         shape;
   struct timeval  next_check;
   XtIntervalId    next_timeout;
};

#endif
