/*
** Copyright 1999 by Todd Allen.  All Rights Reserved.  Permission to use,
** copy, modify, distribute, and sell this software and its documentation for
** any purpose is hereby granted without fee, provided that the above
** copyright notice appear in all copies and that both the copyright notice
** and this permission notice appear in supporting documentation.
**
** No representations are made about the suitability of this software for any
** purpose.  It is provided ``as is'' without express or implied warranty,
** including but not limited to the warranties of merchantability, fitness
** for a particular purpose, and noninfringement.  In no event shall Todd
** Allen be liable for any claim, damages, or other liability, whether in
** action of contract, tort, or otherwise, arising from, out of, or in
** connection with this software.
*/

#include "timemath.h"
#include "diags.h"
#include <errno.h>
#include <limits.h>

extern  
long   
difftimevalms (struct timeval  time1,
               struct timeval  time0)
{
   long  diffsec  = time1.tv_sec  - time0.tv_sec;
   long  diffusec = time1.tv_usec - time0.tv_usec;
   long  result   = diffsec * 1000 + diffusec / 1000;

   if (diffsec > INT_MAX / 1000)                  return INT_MAX;
   if (diffsec < INT_MIN / 1000)                  return INT_MIN;
   if (diffsec+1 > INT_MAX / 1000 && result <= 0) return INT_MAX;
   if (diffsec-1 < INT_MIN / 1000 && result >= 0) return INT_MIN;

   return result;
}

extern
struct timeval
addmstotimeval(struct timeval  time,
               long            ms)
{
   struct timeval  result;

   result.tv_sec  = time.tv_sec  + (ms/1000);
   result.tv_usec = time.tv_usec + (ms%1000)*1000;
   if (result.tv_usec > 999999) {
      result.tv_sec  += 1;
      result.tv_usec -= 1000000;
   }

   return result;
}


extern
struct timeval
gettime(void)
{
   struct timeval  result;
   int             status;

   status = gettimeofday(&result, NULL);
   if (status == -1) {
      fatal(static_format("gettimeofday() failed; errno = %d", errno));
   }

   return result;
}
