/*
** Copyright 1999 by Todd Allen.  All Rights Reserved.  Permission to use,
** copy, modify, distribute, and sell this software and its documentation for
** any purpose is hereby granted without fee, provided that the above
** copyright notice appear in all copies and that both the copyright notice
** and this permission notice appear in supporting documentation.
**
** No representations are made about the suitability of this software for any
** purpose.  It is provided ``as is'' without express or implied warranty,
** including but not limited to the warranties of merchantability, fitness
** for a particular purpose, and noninfringement.  In no event shall Todd
** Allen be liable for any claim, damages, or other liability, whether in
** action of contract, tort, or otherwise, arising from, out of, or in
** connection with this software.
*/

#include "diags.h"
#include <stdarg.h>
#include <stdio.h>
#include <X11/Intrinsic.h>

        String    program;

static  char      format_buffer[2048];

extern  
String    
static_format (String  form,
               ...)
{
   va_list  ap;

   va_start(ap, form);
   vsprintf(format_buffer, form, ap);
   va_end(ap);

   return format_buffer;
}

extern  
void
warning (String  msg)
{
   XtWarning(msg);
}

extern  
void
error (String  msg)
{
   XtWarning(msg);
}

extern  
void
fatal (String  msg)
{
   XtWarning(msg);
   exit(1);
}

extern
void
panic (String  msg)
{
   XtWarning(msg);
   exit(2);
}

extern  
void      
assertion_fail (int     line,
                String  file)
{
   panic(static_format("assertion failure at file %s, line %d", file, line));
}
