/* $XConsortium: TransparentLabel.c,v 1.97 94/04/17 20:12:12 kaleb Exp $ */

/***********************************************************

Copyright (c) 1987, 1988, 1994  X Consortium

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of the X Consortium shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from the X Consortium.


Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

Modifications to use the SHAPE extension Copyright 1999 Todd Allen.

******************************************************************/

/*
 * TransparentLabel.c - TransparentLabel widget
 */

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <X11/Xos.h>
#include <X11/extensions/shape.h>
#include <X11/XawXpm/XawInit.h>
#include <X11/XawXpm/TransparentLabelP.h>
#include <X11/XawXpm/CommandP.h>
#include <X11/XawXpm/Xpm.h>
#include <X11/Xmu/Converters.h>
#include <X11/Xmu/Drawing.h>
#include <stdio.h>
#include <ctype.h>

/* needed for abs() */
#ifndef X_NOT_STDC_ENV
#include <stdlib.h>
#else
int abs();
#endif

#define MULTI_LINE_LABEL 32767

#ifdef CRAY
#define WORD64
#endif

/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

/* Private Data */

static void ClassInitialize();
static void Destroy();
static void Initialize();
static void Redisplay();
static Boolean SetValues();

TransparentLabelClassRec transparentLabelClassRec = {
   {
/* core_class fields */ 
      /* superclass               */      (WidgetClass) &labelClassRec,
      /* class_name               */      "TransparentLabel",
      /* widget_size              */      sizeof(TransparentLabelRec),
      /* class_initialize         */      ClassInitialize,
      /* class_part_initialize    */      NULL,
      /* class_inited             */      FALSE,
      /* initialize               */      Initialize,
      /* initialize_hook          */      NULL,
      /* realize                  */      XtInheritRealize,
      /* actions                  */      NULL,
      /* num_actions              */      0,
      /* resources                */      NULL,
      /* num_resources            */      0,
      /* xrm_class                */      NULLQUARK,
      /* compress_motion          */      TRUE,
      /* compress_exposure        */      TRUE,
      /* compress_enterleave      */      TRUE,
      /* visible_interest         */      FALSE,
      /* destroy                  */      Destroy,
      /* resize                   */      XtInheritResize,
      /* expose                   */      Redisplay,
      /* set_values               */      NULL,
      /* set_values_hook          */      SetValues,
      /* set_values_almost        */      XtInheritSetValuesAlmost,
      /* get_values_hook          */      NULL,
      /* accept_focus             */      NULL,
      /* version                  */      XtVersion,
      /* callback_private         */      NULL,
      /* tm_table                 */      NULL,
      /* query_geometry           */      XtInheritQueryGeometry,
      /* display_accelerator      */      XtInheritDisplayAccelerator,
      /* extension                */      NULL
   },
/* Simple class fields initialization */
   {
      /* change_sensitive         */      XtInheritChangeSensitive
   },
/* ThreeD class fields initialization */
   {
      /* shadowdraw               */      XtInheritXaw3dShadowDraw
   },
/* Label class fields initialization */
   {
      /* ignore                   */      0
   },
/* TransparentLabel class fields initialization */
   {
      /* ignore                   */      0
   }
};
WidgetClass transparentLabelWidgetClass = (WidgetClass)&transparentLabelClassRec;
/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void ClassInitialize()
{
   XawInitializeWidgetSet();
}

#ifndef WORD64

#define TXT16 XChar2b

#else

#define TXT16 char

#define XTextWidth16 _XawLabelWidth16
#define XDrawString16 _XawLabelDraw16

#endif /* WORD64 */

/* ARGSUSED */
static void Initialize(request, new, args, num_args)
   Widget request, new;
   ArgList args;
   Cardinal *num_args;
{
   TransparentLabelWidget lw = (TransparentLabelWidget) new;
   lw->transparentLabel.mask = (Pixmap)NULL;
}

/* ARGSUSED */
static void Redisplay(gw, event, region)
   Widget gw;
   XEvent *event;
   Region region;
{
   extern WidgetClass commandWidgetClass;
   GC gc, bgc;    
   TransparentLabelWidget w = (TransparentLabelWidget) gw;
   TransparentLabelWidgetClass lwclass 
      = (TransparentLabelWidgetClass) XtClass (gw);
   Position y = w->label.label_y;
   Position x = w->label.label_x;
   Boolean draw_mask = False;
   
   /* 
    * Don't draw shadows if command is going to redraw them.
    * The shadow draw method is region aware, but since 99% of
    * all labels don't have shadows, we'll check for a shadow
    * before we incur the function call overhead.
    */
   if (!XtIsSubclass (gw, commandWidgetClass) && w->threeD.shadow_width > 0)
   {
      (*lwclass->threeD_class.shadowdraw) (gw, event, region, True);
   }
   if(XtIsSubclass (gw, commandWidgetClass) && ((CommandWidget)w)->command.set)
   {
      y += w->threeD.shadow_width/2;
      x += w->threeD.shadow_width/2;
      if(w->threeD.shadow_width == 1) 
      {
         y++;
         x++;
      }
   }
   /*
    * now we'll see if we need to draw the rest of the label
    */
   if (region != NULL) {
      int x = w->label.label_x;
      unsigned int width = w->label.label_width;
      if (w->label.lbm_width) {
         if (w->label.label_x > (x = w->label.internal_width))
            width += w->label.label_x - x;
      }
      if (XRectInRegion(region, x, w->label.label_y,
                        width, w->label.label_height) == RectangleOut) {
         return;
      }
   }

   gc = XtIsSensitive(gw) ? w->label.normal_GC : w->label.gray_GC;
   bgc = XtIsSensitive(gw) ? w->label.text_GC : w->label.normal_GC;
#ifdef notdef
   if (region != NULL)
      XSetRegion(XtDisplay(gw), gc, region);
#endif /*notdef*/

   if (w->label.pixmap == None) {
      int len = w->label.label_len;
      char *label = w->label.label;
      Position ksy = w->label.label_y;
        
      y += w->label.font->max_bounds.ascent;

      if (w->transparentLabel.mask == (Pixmap)NULL) {
         XGCValues       values;
         unsigned char*  full_bitmap;

         full_bitmap = XtCalloc(((w->core.width+7)/8) * w->core.height,
                                sizeof(unsigned char));
         w->transparentLabel.mask 
            = XCreatePixmapFromBitmapData(/* display => */ XtDisplay(gw),
                                          /* d       => */ XtWindow(gw),
                                          /* data    => */ full_bitmap,
                                          /* width   => */ w->core.width,
                                          /* height  => */ w->core.height,
                                          /* fg      => */ 1,
                                          /* bg      => */ 0,
                                          /* depth   => */ 1);
         XtFree(full_bitmap);

         values.foreground = 1;
         values.background = 0;
         values.font       = w->label.font->fid;
         w->transparentLabel.mask_GC 
            = XCreateGC(/* display   => */ XtDisplay(gw),
                        /* d         => */ w->transparentLabel.mask,
                        /* valuemask => */ GCForeground | GCBackground | GCFont,
                        /* values    => */ &values);
         draw_mask = True;
      }

      /* display left bitmap */
      if (w->label.left_bitmap && w->label.lbm_width != 0) {
         int  x = (int) w->label.internal_width + w->threeD.shadow_width;
         int  y = (int) w->label.internal_height 
                      + w->threeD.shadow_width
                      + w->label.lbm_y;

         XCopyPlane (XtDisplay(gw), w->label.left_bitmap, XtWindow(gw), gc,
                     0, 0, w->label.lbm_width, w->label.lbm_height, x, y,
                     (unsigned long) 1L);
         if (draw_mask) {
            XFillRectangle(XtDisplay(gw),
                           w->transparentLabel.mask,
                           w->transparentLabel.mask_GC,
                           x, y, w->label.lbm_width, w->label.lbm_height);
         }
      }
      if ( w->simple.international == True ) {

         XFontSetExtents *ext = XExtentsOfFontSet(w->label.fontset);
         
         ksy += abs(ext->max_ink_extent.y);

         if (len == MULTI_LINE_LABEL) {
            char *nl;
            while ((nl = index(label, '\n')) != NULL) {
               XmbDrawString(XtDisplay(w), 
                             XtWindow(w), 
                             w->label.fontset, 
                             gc,
                             x, ksy, label, (int)(nl - label));
               if (draw_mask) {
                  XmbDrawString(XtDisplay(w), 
                                w->transparentLabel.mask, 
                                w->label.fontset, 
                                w->transparentLabel.mask_GC,
                                x, ksy, label, (int)(nl - label));
               }
               ksy += ext->max_ink_extent.height;
               label = nl + 1;
            }
            len = strlen(label);
         }
         if (len) {
            XmbDrawString(XtDisplay(w), 
                          XtWindow(w), 
                          w->label.fontset, 
                          gc,
                          x, ksy, label, len);
            if (draw_mask) {
               XmbDrawString(XtDisplay(w), 
                             w->transparentLabel.mask, 
                             w->label.fontset, 
                             w->transparentLabel.mask_GC,
                             x, ksy, label, len);
            }
         }

      } else { /*international false, so use R5 routine */

         if (len == MULTI_LINE_LABEL) {
            char *nl;
            while ((nl = index(label, '\n')) != NULL) {
               if (w->label.encoding) {
                  XDrawString16(XtDisplay(gw), XtWindow(gw), gc,
                                x, y, (TXT16*)label, (int)(nl - label)/2);
                  if (draw_mask) {
                     XDrawString16(XtDisplay(gw), 
                                   w->transparentLabel.mask, 
                                   w->transparentLabel.mask_GC,
                                   x, y, (TXT16*)label, (int)(nl - label)/2);
                  }
               } else {
                  XDrawString(XtDisplay(gw), XtWindow(gw), gc,
                              x, y, label, (int)(nl - label));
                  if (draw_mask) {
                     XDrawString(XtDisplay(gw),
                                 w->transparentLabel.mask, 
                                 w->transparentLabel.mask_GC,
                                 x, y, label, (int)(nl - label));
                  }
               }
               y += w->label.font->max_bounds.ascent + 
                    w->label.font->max_bounds.descent;
               label = nl + 1;
            }
            len = strlen(label);
         }
         if (len) {
            if (w->label.encoding) {
               XDrawString16(XtDisplay(gw), XtWindow(gw), gc,
                             w->label.label_x, y, (TXT16*)label, len/2);
               if (draw_mask) {
                  XDrawString16(XtDisplay(gw), 
                                w->transparentLabel.mask, 
                                w->transparentLabel.mask_GC,
                                w->label.label_x, y, (TXT16*)label, len/2);
               }
            } else {
               if(!(XtIsSensitive(gw)) || w->label.drawtb) {
                  XDrawString(XtDisplay(gw), XtWindow(gw),bgc ,
                              x+1, y, label, len);
                  XDrawString(XtDisplay(gw), XtWindow(gw),bgc ,
                              x, y+1, label, len);
                  if (draw_mask) {
                     XDrawString(XtDisplay(gw), 
                                 w->transparentLabel.mask, 
                                 w->transparentLabel.mask_GC,
                                 x+1, y, label, len);
                     XDrawString(XtDisplay(gw), 
                                 w->transparentLabel.mask, 
                                 w->transparentLabel.mask_GC,
                                 x, y+1, label, len);
                  }
               }
               if(w->label.drawtb && XtIsSensitive(gw)) /* Draw the text border */
               {
                  XDrawString(XtDisplay(gw), XtWindow(gw), bgc,
                              x-1, y, label, len);
                  XDrawString(XtDisplay(gw), XtWindow(gw), bgc,
                              x, y-1, label, len);
                  if (draw_mask) {
                     XDrawString(XtDisplay(gw), 
                                 w->transparentLabel.mask, 
                                 w->transparentLabel.mask_GC,
                                 x-1, y, label, len);
                     XDrawString(XtDisplay(gw), 
                                 w->transparentLabel.mask, 
                                 w->transparentLabel.mask_GC,
                                 x, y-1, label, len);
                  }
               }

               XDrawString(XtDisplay(gw), XtWindow(gw), gc,
                           x, y, label, len);
               if (draw_mask) {
                  XDrawString(XtDisplay(gw), 
                              w->transparentLabel.mask, 
                              w->transparentLabel.mask_GC,
                              x, y, label, len);
               }
            }
         }
         
      } /*endif international*/
      
      if (draw_mask) {
         XShapeCombineMask(/* dpy      => */ XtDisplay(gw),
                           /* dest     => */ XtWindow(gw),
                           /* destKind => */ ShapeBounding,
                           /* xOff     => */ 0,
                           /* yOff     => */ 0,
                           /* pixmap   => */ w->transparentLabel.mask,
                           /* op       => */ ShapeSet);
      }
   } else if (w->label.label_len == 1) { /* depth */
      XCopyPlane(XtDisplay(gw), w->label.pixmap, XtWindow(gw), gc,
                 0, 0, w->label.label_width, w->label.label_height,
                 x, y, 1L);
   } else {
      XCopyArea(XtDisplay(gw), w->label.pixmap, XtWindow(gw), gc,
                0, 0, w->label.label_width, w->label.label_height,
                x, y);
   }

#ifdef notdef
   if (region != NULL)
      XSetClipMask(XtDisplay(gw), gc, (Pixmap)None);
#endif /* notdef */
}

static Boolean SetValues(current, request, new, args, num_args)
   Widget current, request, new;
   ArgList args;
   Cardinal *num_args;
{
   TransparentLabelWidget curlw = (TransparentLabelWidget) current;
   TransparentLabelWidget reqlw = (TransparentLabelWidget) request;
   TransparentLabelWidget newlw = (TransparentLabelWidget) new;

   if (curlw->label.label != newlw->label.label
       || curlw->label.left_bitmap != newlw->label.left_bitmap
       || curlw->label.encoding != newlw->label.encoding
       || (curlw->label.fontset != newlw->label.fontset
           && curlw->simple.international)
       || curlw->label.font != newlw->label.font
       || curlw->label.justify != newlw->label.justify) {
      if (curlw->transparentLabel.mask != (Pixmap)NULL) {
         XFreePixmap(XtDisplay(current), newlw->transparentLabel.mask);
         XFreeGC(XtDisplay(current), newlw->transparentLabel.mask_GC);
         curlw->transparentLabel.mask = (Pixmap)NULL;
         newlw->transparentLabel.mask = (Pixmap)NULL;
      }
      return True;
   } else {
      return False;
   }
}

static void Destroy(w)
    Widget w;
{
   TransparentLabelWidget lw = (TransparentLabelWidget)w;

   if (lw->transparentLabel.mask != (Pixmap)NULL) {
      XFreePixmap(XtDisplay(w), lw->transparentLabel.mask);
      XFreeGC(XtDisplay(w), lw->transparentLabel.mask_GC);
      lw->transparentLabel.mask = (Pixmap)NULL;
   }
}
