/*
* $KK: CompositeThreeD.h,v 0.3 92/11/04 xx:xx:xx keithley Exp $
*/

/***********************************************************
Copyright 1987, 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.
Copyright 1992 by Kaleb Keithley

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital, MIT, or Kaleb
Keithley not be used in advertising or publicity pertaining to distribution 
of the software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

Modifications of the ThreeD widget class for use in the Composite widget
hierarchy Copyright 1999 Todd Allen.

******************************************************************/

#ifndef _XawCompositeThreeD_h
#define _XawCompositeThreeD_h

/***********************************************************************
 *
 * CompositeThreeD Widget
 *
 ***********************************************************************/

#include <X11/Xmu/Converters.h>
#include <X11/XawXpm/ThreeD.h>

/* Parameters:

 Name                 Class              RepType         Default Value
 ----                 -----              -------         -------------
 shadowWidth	      ShadowWidth          Dimension     2
 topShadowPixel       TopShadowPixel       Pixel         dynamic
 bottomShadowPixel    BottomShadowPixel    Pixel         dynamic
 topShadowContrast    TopShadowContrast    Int           20
 bottomShadowContrast BottomShadowContrast Int           40
 userData             UserData             XtPointer     NULL
 beNiceToColormap     BeNiceToColormap     Boolean       False
 invertBorder         InvertBorder         Boolean       False

*/

typedef struct _CompositeThreeDRec *CompositeThreeDWidget;
typedef struct _CompositeThreeDClassRec *CompositeThreeDWidgetClass;

extern WidgetClass compositeThreeDWidgetClass;

_XFUNCPROTOBEGIN

extern void Xaw3dComputeTopShadowRGB (
#if NeedFunctionPrototypes
    Widget 		/* new */,
    XColor*		/* xcol_out */
#endif
);

extern void Xaw3dComputeBottomShadowRGB (
#if NeedFunctionPrototypes
    Widget		/* new */,
    XColor*		/* xcol_out */
#endif
);

_XFUNCPROTOEND

#endif /* _XawCompositeThreeD_h */
